# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class DetectionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def detection_list_degradation_events(self, **kwargs):  # noqa: E501
        """ListDegradationEvents  # noqa: E501

        List out degradation events for a given firewall. This is a beta feature, do not build on top of this.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detection_list_degradation_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str first_page_req_firewall_id: Required field specifying the firewall ID.
        :param list[str] first_page_req_category_ids: If not specified, return all degradation events across categories.
        :param datetime first_page_req_time_filter_start_time:
        :param datetime first_page_req_time_filter_end_time:
        :param str page_token:
        :param str page_size:
        :return: RimeListDegradationEventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.detection_list_degradation_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.detection_list_degradation_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def detection_list_degradation_events_with_http_info(self, **kwargs):  # noqa: E501
        """ListDegradationEvents  # noqa: E501

        List out degradation events for a given firewall. This is a beta feature, do not build on top of this.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.detection_list_degradation_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str first_page_req_firewall_id: Required field specifying the firewall ID.
        :param list[str] first_page_req_category_ids: If not specified, return all degradation events across categories.
        :param datetime first_page_req_time_filter_start_time:
        :param datetime first_page_req_time_filter_end_time:
        :param str page_token:
        :param str page_size:
        :return: RimeListDegradationEventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['first_page_req_firewall_id', 'first_page_req_category_ids', 'first_page_req_time_filter_start_time', 'first_page_req_time_filter_end_time', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method detection_list_degradation_events" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_page_req_firewall_id' in params:
            query_params.append(('firstPageReq.firewallId', params['first_page_req_firewall_id']))  # noqa: E501
        if 'first_page_req_category_ids' in params:
            query_params.append(('firstPageReq.categoryIds', params['first_page_req_category_ids']))  # noqa: E501
            collection_formats['firstPageReq.categoryIds'] = 'multi'  # noqa: E501
        if 'first_page_req_time_filter_start_time' in params:
            query_params.append(('firstPageReq.timeFilter.startTime', params['first_page_req_time_filter_start_time']))  # noqa: E501
        if 'first_page_req_time_filter_end_time' in params:
            query_params.append(('firstPageReq.timeFilter.endTime', params['first_page_req_time_filter_end_time']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/degradation-events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListDegradationEventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
