# Copyright © 2007-2017 Red Hat, Inc. and others.
#
# This file is part of Bodhi.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""Define Bodhi's Exceptions."""


class BodhiException(Exception):
    """Used to express a variety of errors in the codebase."""


class RepodataException(Exception):
    """Raised when a repository's repodata is not valid or is missing."""


class LockedUpdateException(Exception):
    """Raised when something attempts to operate on a locked update."""


class ExternalCallException(Exception):
    """Raised when a call to an external service fails."""
