# MihkelMagic_Electrical

This is script to automate the analysis of electrical cell data. 

#  Installation

Run the following command:
pip install MihkelMagic_Electrical

# How to mihkelBayesian

## Optimizing hyperparameters

In order to optimize 2 hyperparameters you need to: 

>from mihkelBayesian import optimize

>min_val, min_hyperparameters = optimize.run(evaluateFunction, functionConstants, n_iterations,bounds) 

evaluateFunction - a string of the same name as the function you wish to evaluate in functions.py. 
functionConstans - a list of constants you wish to apply to the evaluateFunction
n_iterations - how many measurements of the function the optimizer is allower to make
bounds - (1 x 2) shape numpy array that limits the searchspace in the form of [[x1min,x1max],[x2min,x2max]]
min_val - the smallest function value 
min_hyperparameters - hyperparameter pair corresponding to that value. 

(Eg. run("rosenbrock",[1,10],300,np.array([[0,10],[-20,40]])))

## Choosing the function to evaluate

Open functions.py to see all currently available functions. Each function takes an array XY that is automatically generated by the optimizer and a list of function constants that the function uses. Use one of the pre-existing functions or write your own function that the optimizer will call upon. Custom function can be analytical, machine learning etc. 


## Testing

Pytest is used to test the code. All tests are located in the 'tests' folder.To run the tests, execute:

> pytest

# Notes

You can vary the hyperparameters of the optimizer in order to get better results.

More than 500 no_iterations takes long time to compute. Often no more than 300 iterations are needed. 

One run with 500 iterations takes about 4 minutes if the function evaluation is instantaneous.