# arthur-client.api-bindings
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The `arthur_client.api_bindings` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.1.0
- Generator version: 7.9.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3, < 3.0.0
* python-dateutil >= 2.8.2
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with arthur-client.api-bindings,
you can run the following:

```python

import arthur_client.api_bindings
from arthur_client.api_bindings.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = arthur_client.api_bindings.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
with arthur_client.api_bindings.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = arthur_client.api_bindings.AlertRulesV1Api(api_client)
    alert_rule_id = 'alert_rule_id_example' # str | 

    try:
        # Delete Alert Rule By Id
        api_instance.delete_alert_rule(alert_rule_id)
    except ApiException as e:
        print("Exception when calling AlertRulesV1Api->delete_alert_rule: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlertRulesV1Api* | [**delete_alert_rule**](arthur_client/api_bindings/docs/AlertRulesV1Api.md#delete_alert_rule) | **DELETE** /api/v1/alert_rules/{alert_rule_id} | Delete Alert Rule By Id
*AlertRulesV1Api* | [**get_alert_rule**](arthur_client/api_bindings/docs/AlertRulesV1Api.md#get_alert_rule) | **GET** /api/v1/alert_rules/{alert_rule_id} | Get Alert Rule By Id
*AlertRulesV1Api* | [**get_model_alert_rules**](arthur_client/api_bindings/docs/AlertRulesV1Api.md#get_model_alert_rules) | **GET** /api/v1/models/{model_id}/alert_rules | Get Model Alert Rules
*AlertRulesV1Api* | [**patch_alert_rule**](arthur_client/api_bindings/docs/AlertRulesV1Api.md#patch_alert_rule) | **PATCH** /api/v1/alert_rules/{alert_rule_id} | Update Model Alert Rule
*AlertRulesV1Api* | [**post_alert_rule_query_validation**](arthur_client/api_bindings/docs/AlertRulesV1Api.md#post_alert_rule_query_validation) | **POST** /api/v1/models/{model_id}/alert_rule_query_validation | Validate A Model Alert Rule Query
*AlertRulesV1Api* | [**post_model_alert_rule**](arthur_client/api_bindings/docs/AlertRulesV1Api.md#post_model_alert_rule) | **POST** /api/v1/models/{model_id}/alert_rules | Create Model Alert Rule
*AlertsV1Api* | [**get_alert**](arthur_client/api_bindings/docs/AlertsV1Api.md#get_alert) | **GET** /api/v1/alerts/{alert_id} | Get Alert By Id
*AlertsV1Api* | [**get_model_alerts**](arthur_client/api_bindings/docs/AlertsV1Api.md#get_model_alerts) | **GET** /api/v1/models/{model_id}/alerts | Get Model Alerts
*AlertsV1Api* | [**post_model_alerts**](arthur_client/api_bindings/docs/AlertsV1Api.md#post_model_alerts) | **POST** /api/v1/models/{model_id}/alerts | Create Model Alerts
*AuthorizationV1Api* | [**check_permissions**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#check_permissions) | **POST** /api/v1/permissions/check | Check Permissions
*AuthorizationV1Api* | [**delete_role_binding**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#delete_role_binding) | **DELETE** /api/v1/role_bindings/{role_binding_id} | Delete Role Binding.
*AuthorizationV1Api* | [**list_group_role_bindings**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#list_group_role_bindings) | **GET** /api/v1/groups/{group_id}/role_bindings | Get Group Role Bindings.
*AuthorizationV1Api* | [**list_org_role_bindings**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#list_org_role_bindings) | **GET** /api/v1/organization/role_bindings | List Organization Role Bindings.
*AuthorizationV1Api* | [**list_permissions_library**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#list_permissions_library) | **GET** /api/v1/permissions | List Permissions
*AuthorizationV1Api* | [**list_project_role_bindings**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#list_project_role_bindings) | **GET** /api/v1/projects/{project_id}/role_bindings | List Project Role Bindings.
*AuthorizationV1Api* | [**list_roles**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#list_roles) | **GET** /api/v1/organization/roles | List Roles
*AuthorizationV1Api* | [**list_user_role_bindings**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#list_user_role_bindings) | **GET** /api/v1/users/{user_id}/role_bindings | Get User Role Bindings.
*AuthorizationV1Api* | [**list_workspace_role_bindings**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#list_workspace_role_bindings) | **GET** /api/v1/workspaces/{workspace_id}/role_bindings | List Workspace Role Bindings.
*AuthorizationV1Api* | [**post_org_role_binding**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#post_org_role_binding) | **POST** /api/v1/organization/role_bindings | Post Organization Role Binding.
*AuthorizationV1Api* | [**post_project_role_binding**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#post_project_role_binding) | **POST** /api/v1/projects/{project_id}/role_bindings | Post Project Role Binding
*AuthorizationV1Api* | [**post_workspace_role_binding**](arthur_client/api_bindings/docs/AuthorizationV1Api.md#post_workspace_role_binding) | **POST** /api/v1/workspaces/{workspace_id}/role_bindings | Post Workspace Role Binding.
*ConnectorSchemasV1Api* | [**get_connector_schema_by_type**](arthur_client/api_bindings/docs/ConnectorSchemasV1Api.md#get_connector_schema_by_type) | **GET** /api/v1/connector_schemas/{connector_type} | Get Connector Schema By Type
*ConnectorSchemasV1Api* | [**get_connector_types**](arthur_client/api_bindings/docs/ConnectorSchemasV1Api.md#get_connector_types) | **GET** /api/v1/connector_schemas/connector_types | Get Available Connector Types
*ConnectorsV1Api* | [**delete_connector**](arthur_client/api_bindings/docs/ConnectorsV1Api.md#delete_connector) | **DELETE** /api/v1/connectors/{connector_id} | Delete Connector
*ConnectorsV1Api* | [**get_connector**](arthur_client/api_bindings/docs/ConnectorsV1Api.md#get_connector) | **GET** /api/v1/connectors/{connector_id} | Get Connector
*ConnectorsV1Api* | [**get_connectors**](arthur_client/api_bindings/docs/ConnectorsV1Api.md#get_connectors) | **GET** /api/v1/projects/{project_id}/connectors | List Connectors
*ConnectorsV1Api* | [**get_sensitive_connector**](arthur_client/api_bindings/docs/ConnectorsV1Api.md#get_sensitive_connector) | **GET** /api/v1/connectors/{connector_id}/sensitive | Get Sensitive Connector
*ConnectorsV1Api* | [**patch_connector**](arthur_client/api_bindings/docs/ConnectorsV1Api.md#patch_connector) | **PATCH** /api/v1/connectors/{connector_id} | Update Connector
*ConnectorsV1Api* | [**post_connector**](arthur_client/api_bindings/docs/ConnectorsV1Api.md#post_connector) | **POST** /api/v1/projects/{project_id}/connectors | Create Connector
*ConnectorsV1Api* | [**put_connector_check_results**](arthur_client/api_bindings/docs/ConnectorsV1Api.md#put_connector_check_results) | **PUT** /api/v1/connectors/{connector_id}/check_results | Persist Connector Check Results
*CustomAggregationsV1Api* | [**delete_custom_aggregation**](arthur_client/api_bindings/docs/CustomAggregationsV1Api.md#delete_custom_aggregation) | **DELETE** /api/v1/custom_aggregations/{custom_aggregation_id} | Delete Custom Aggregation.
*CustomAggregationsV1Api* | [**get_custom_aggregation**](arthur_client/api_bindings/docs/CustomAggregationsV1Api.md#get_custom_aggregation) | **GET** /api/v1/custom_aggregations/{custom_aggregation_id} | Get Custom Aggregation By Id.
*CustomAggregationsV1Api* | [**get_custom_aggregations_for_workspace**](arthur_client/api_bindings/docs/CustomAggregationsV1Api.md#get_custom_aggregations_for_workspace) | **GET** /api/v1/workspaces/{workspace_id}/custom_aggregations | Get Custom Aggregation.
*CustomAggregationsV1Api* | [**patch_custom_aggregation**](arthur_client/api_bindings/docs/CustomAggregationsV1Api.md#patch_custom_aggregation) | **PATCH** /api/v1/custom_aggregations/{custom_aggregation_id} | Patch Custom Aggregation
*CustomAggregationsV1Api* | [**post_custom_aggregation**](arthur_client/api_bindings/docs/CustomAggregationsV1Api.md#post_custom_aggregation) | **POST** /api/v1/workspaces/{workspace_id}/custom_aggregations | Post Custom Aggregation.
*CustomAggregationsV1Api* | [**put_custom_aggregation**](arthur_client/api_bindings/docs/CustomAggregationsV1Api.md#put_custom_aggregation) | **PUT** /api/v1/custom_aggregations/{custom_aggregation_id} | Update Custom Aggregation By Id.
*CustomAggregationsV1Api* | [**validate_custom_aggregation**](arthur_client/api_bindings/docs/CustomAggregationsV1Api.md#validate_custom_aggregation) | **POST** /api/v1/workspaces/{workspace_id}/validate_custom_aggregation | Validate A Custom Aggregation Before Creation.
*DataPlaneAssociationsV1Api* | [**delete_data_plane_association**](arthur_client/api_bindings/docs/DataPlaneAssociationsV1Api.md#delete_data_plane_association) | **DELETE** /api/v1/data_plane_associations/{data_plane_association_id} | Delete Data Plane Association By Id
*DataPlaneAssociationsV1Api* | [**get_data_plane_project_associations**](arthur_client/api_bindings/docs/DataPlaneAssociationsV1Api.md#get_data_plane_project_associations) | **GET** /api/v1/data_planes/{data_plane_id}/associations | List Projects Associated With The Data Plane
*DataPlaneAssociationsV1Api* | [**get_project_data_plane_associations**](arthur_client/api_bindings/docs/DataPlaneAssociationsV1Api.md#get_project_data_plane_associations) | **GET** /api/v1/projects/{project_id}/data_plane_associations | List Data Plane Associations For Project.
*DataPlaneAssociationsV1Api* | [**get_workspace_data_plane_associations**](arthur_client/api_bindings/docs/DataPlaneAssociationsV1Api.md#get_workspace_data_plane_associations) | **GET** /api/v1/workspaces/{workspace_id}/data_plane_associations | List Data Plane Associations For Workspace.
*DataPlaneAssociationsV1Api* | [**post_data_plane_association**](arthur_client/api_bindings/docs/DataPlaneAssociationsV1Api.md#post_data_plane_association) | **POST** /api/v1/workspaces/{workspace_id}/data_plane_associations | Post Data Plane Association.
*DataPlanesV1Api* | [**delete_data_plane**](arthur_client/api_bindings/docs/DataPlanesV1Api.md#delete_data_plane) | **DELETE** /api/v1/data_planes/{data_plane_id} | Delete Data Plane By Id
*DataPlanesV1Api* | [**get_data_plane**](arthur_client/api_bindings/docs/DataPlanesV1Api.md#get_data_plane) | **GET** /api/v1/data_planes/{data_plane_id} | Get Data Plane By Id
*DataPlanesV1Api* | [**get_data_planes**](arthur_client/api_bindings/docs/DataPlanesV1Api.md#get_data_planes) | **GET** /api/v1/workspaces/{workspace_id}/data_planes | Get Data Planes.
*DataPlanesV1Api* | [**patch_data_plane**](arthur_client/api_bindings/docs/DataPlanesV1Api.md#patch_data_plane) | **PATCH** /api/v1/data_planes/{data_plane_id} | Update Data Plane
*DataPlanesV1Api* | [**post_data_plane**](arthur_client/api_bindings/docs/DataPlanesV1Api.md#post_data_plane) | **POST** /api/v1/workspaces/{workspace_id}/data_planes | Post Data Plane.
*DataPlanesV1Api* | [**post_data_plane_cred_set**](arthur_client/api_bindings/docs/DataPlanesV1Api.md#post_data_plane_cred_set) | **POST** /api/v1/data_planes/{data_plane_id}/credential_set | Regenerate Data Plane Credential Set.
*DataRetrievalV1Api* | [**delete_available_data_retrieval_data**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#delete_available_data_retrieval_data) | **DELETE** /api/v1/available_dataset/{available_dataset_id}/data_retrieval/{operation_id} | Delete Retrieved Data
*DataRetrievalV1Api* | [**delete_data_retrieval_data**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#delete_data_retrieval_data) | **DELETE** /api/v1/datasets/{dataset_id}/data_retrieval/{operation_id} | Delete Retrieved Data
*DataRetrievalV1Api* | [**get_available_data_retrieval_data**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#get_available_data_retrieval_data) | **GET** /api/v1/available_dataset/{available_dataset_id}/data_retrieval/{operation_id} | Gets Raw Data Operation Data
*DataRetrievalV1Api* | [**get_data_retrieval_data**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#get_data_retrieval_data) | **GET** /api/v1/datasets/{dataset_id}/data_retrieval/{operation_id} | Gets Raw Data Operation Data
*DataRetrievalV1Api* | [**post_available_data_retrieval_operation**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#post_available_data_retrieval_operation) | **POST** /api/v1/available_dataset/{available_dataset_id}/data_retrieval | Create Raw Data Operation
*DataRetrievalV1Api* | [**post_data_retrieval_operation**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#post_data_retrieval_operation) | **POST** /api/v1/datasets/{dataset_id}/data_retrieval | Create Raw Data Operation
*DataRetrievalV1Api* | [**put_available_data_retrieval_data**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#put_available_data_retrieval_data) | **PUT** /api/v1/available_dataset/{available_dataset_id}/data_retrieval/{operation_id} | Put Retrieved Data
*DataRetrievalV1Api* | [**put_data_retrieval_data**](arthur_client/api_bindings/docs/DataRetrievalV1Api.md#put_data_retrieval_data) | **PUT** /api/v1/datasets/{dataset_id}/data_retrieval/{operation_id} | Put Retrieved Data
*DatasetsV1Api* | [**delete_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#delete_dataset) | **DELETE** /api/v1/datasets/{dataset_id} | Delete Dataset
*DatasetsV1Api* | [**get_available_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#get_available_dataset) | **GET** /api/v1/available_datasets/{available_dataset_id} | Get Available Dataset By Id
*DatasetsV1Api* | [**get_connector_available_datasets**](arthur_client/api_bindings/docs/DatasetsV1Api.md#get_connector_available_datasets) | **GET** /api/v1/connectors/{connector_id}/available_datasets | Get Available Datasets By Connector Id
*DatasetsV1Api* | [**get_connector_datasets**](arthur_client/api_bindings/docs/DatasetsV1Api.md#get_connector_datasets) | **GET** /api/v1/connectors/{connector_id}/datasets | Get Datasets By Connector Id
*DatasetsV1Api* | [**get_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#get_dataset) | **GET** /api/v1/datasets/{dataset_id} | Get Dataset By Id
*DatasetsV1Api* | [**get_datasets**](arthur_client/api_bindings/docs/DatasetsV1Api.md#get_datasets) | **GET** /api/v1/projects/{project_id}/datasets | Get Datasets
*DatasetsV1Api* | [**get_datasets_in_workspace**](arthur_client/api_bindings/docs/DatasetsV1Api.md#get_datasets_in_workspace) | **GET** /api/v1/workspaces/{workspace_id}/datasets | Get Workspace Datasets.
*DatasetsV1Api* | [**patch_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#patch_dataset) | **PATCH** /api/v1/datasets/{dataset_id} | Update Dataset
*DatasetsV1Api* | [**post_available_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#post_available_dataset) | **POST** /api/v1/connectors/{connector_id}/available_datasets | Create Single Available Dataset
*DatasetsV1Api* | [**post_connector_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#post_connector_dataset) | **POST** /api/v1/connectors/{connector_id}/datasets | Create Connector Dataset
*DatasetsV1Api* | [**post_project_available_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#post_project_available_dataset) | **POST** /api/v1/projects/{project_id}/available_datasets | Create Project Available Dataset
*DatasetsV1Api* | [**post_project_dataset**](arthur_client/api_bindings/docs/DatasetsV1Api.md#post_project_dataset) | **POST** /api/v1/projects/{project_id}/datasets | Create Project Dataset
*DatasetsV1Api* | [**put_available_dataset_schema**](arthur_client/api_bindings/docs/DatasetsV1Api.md#put_available_dataset_schema) | **PUT** /api/v1/available_datasets/{available_dataset_id}/schema | Update Available Dataset Schema
*DatasetsV1Api* | [**put_connector_available_datasets**](arthur_client/api_bindings/docs/DatasetsV1Api.md#put_connector_available_datasets) | **PUT** /api/v1/connectors/{connector_id}/available_datasets | Overwrite Connector Available Datasets
*DatasetsV1Api* | [**put_dataset_schema**](arthur_client/api_bindings/docs/DatasetsV1Api.md#put_dataset_schema) | **PUT** /api/v1/datasets/{dataset_id}/schema | Update Dataset Schema
*FeatureFlagsV1Api* | [**get_feature_flags**](arthur_client/api_bindings/docs/FeatureFlagsV1Api.md#get_feature_flags) | **GET** /api/v1/feature-flags | Get Feature Flags.
*GroupsV1Api* | [**assign_users_to_group**](arthur_client/api_bindings/docs/GroupsV1Api.md#assign_users_to_group) | **POST** /api/v1/groups/{group_id}/users | Assign User To Group
*GroupsV1Api* | [**delete_group**](arthur_client/api_bindings/docs/GroupsV1Api.md#delete_group) | **DELETE** /api/v1/groups/{group_id} | Delete Group
*GroupsV1Api* | [**get_group**](arthur_client/api_bindings/docs/GroupsV1Api.md#get_group) | **GET** /api/v1/groups/{group_id} | Get Group
*GroupsV1Api* | [**get_group_users**](arthur_client/api_bindings/docs/GroupsV1Api.md#get_group_users) | **GET** /api/v1/groups/{group_id}/users | Get Group Users
*GroupsV1Api* | [**get_groups**](arthur_client/api_bindings/docs/GroupsV1Api.md#get_groups) | **GET** /api/v1/organization/groups | List Groups
*GroupsV1Api* | [**patch_group**](arthur_client/api_bindings/docs/GroupsV1Api.md#patch_group) | **PATCH** /api/v1/groups/{group_id} | Update Group
*GroupsV1Api* | [**post_group**](arthur_client/api_bindings/docs/GroupsV1Api.md#post_group) | **POST** /api/v1/organization/groups | Create Group
*GroupsV1Api* | [**remove_users_from_group**](arthur_client/api_bindings/docs/GroupsV1Api.md#remove_users_from_group) | **DELETE** /api/v1/groups/{group_id}/users | Remove Users From Group In Bulk
*GroupsV1Api* | [**search_group_memberships**](arthur_client/api_bindings/docs/GroupsV1Api.md#search_group_memberships) | **GET** /api/v1/organization/group_memberships | Search Group Memberships
*JobsV1Api* | [**get_job**](arthur_client/api_bindings/docs/JobsV1Api.md#get_job) | **GET** /api/v1/jobs/{job_id} | Get Job By Id
*JobsV1Api* | [**get_job_errors**](arthur_client/api_bindings/docs/JobsV1Api.md#get_job_errors) | **GET** /api/v1/jobs/{job_id}/runs/{job_run_id}/errors | Get Job Errors
*JobsV1Api* | [**get_job_logs**](arthur_client/api_bindings/docs/JobsV1Api.md#get_job_logs) | **GET** /api/v1/jobs/{job_id}/runs/{job_run_id}/logs | Get Job Logs
*JobsV1Api* | [**get_job_runs**](arthur_client/api_bindings/docs/JobsV1Api.md#get_job_runs) | **GET** /api/v1/jobs/{job_id}/runs | Get Job Runs
*JobsV1Api* | [**get_jobs**](arthur_client/api_bindings/docs/JobsV1Api.md#get_jobs) | **GET** /api/v1/projects/{project_id}/jobs | List Jobs
*JobsV1Api* | [**post_dequeue_job**](arthur_client/api_bindings/docs/JobsV1Api.md#post_dequeue_job) | **POST** /api/v1/data_planes/{data_plane_id}/jobs/next | Dequeue Job
*JobsV1Api* | [**post_job_errors**](arthur_client/api_bindings/docs/JobsV1Api.md#post_job_errors) | **POST** /api/v1/jobs/{job_id}/runs/{job_run_id}/errors | Append To Job Errors
*JobsV1Api* | [**post_job_logs**](arthur_client/api_bindings/docs/JobsV1Api.md#post_job_logs) | **POST** /api/v1/jobs/{job_id}/runs/{job_run_id}/logs | Append To Job Logs
*JobsV1Api* | [**post_submit_jobs_batch**](arthur_client/api_bindings/docs/JobsV1Api.md#post_submit_jobs_batch) | **POST** /api/v1/projects/{project_id}/jobs | Submit Jobs Batch
*JobsV1Api* | [**put_job_state**](arthur_client/api_bindings/docs/JobsV1Api.md#put_job_state) | **PUT** /api/v1/jobs/{job_id}/state | Update Job State
*JobsV1Api* | [**update_job**](arthur_client/api_bindings/docs/JobsV1Api.md#update_job) | **PATCH** /api/v1/jobs/{job_id} | Update Job By Id
*MetricFunctionsV1Api* | [**get_metric_functions_aggregations**](arthur_client/api_bindings/docs/MetricFunctionsV1Api.md#get_metric_functions_aggregations) | **GET** /api/v1/metric_functions/aggregations | Get Aggregations Catalog
*MetricsV1Api* | [**get_model_metrics_versions**](arthur_client/api_bindings/docs/MetricsV1Api.md#get_model_metrics_versions) | **GET** /api/v1/models/{model_id}/metrics/versions | Get Metric Versions
*MetricsV1Api* | [**post_model_metrics_by_version**](arthur_client/api_bindings/docs/MetricsV1Api.md#post_model_metrics_by_version) | **POST** /api/v1/models/{model_id}/metrics/versions/{metric_version_num} | Upload Metrics For Version
*MetricsV1Api* | [**post_model_metrics_query**](arthur_client/api_bindings/docs/MetricsV1Api.md#post_model_metrics_query) | **POST** /api/v1/models/{model_id}/metrics/query | Query Model Metrics
*MetricsV1Api* | [**post_model_metrics_version**](arthur_client/api_bindings/docs/MetricsV1Api.md#post_model_metrics_version) | **POST** /api/v1/models/{model_id}/metrics/versions | Create A Metric Version
*ModelsV1Api* | [**delete_model**](arthur_client/api_bindings/docs/ModelsV1Api.md#delete_model) | **DELETE** /api/v1/models/{model_id} | Delete Model By Id
*ModelsV1Api* | [**delete_model_metrics_schedule**](arthur_client/api_bindings/docs/ModelsV1Api.md#delete_model_metrics_schedule) | **DELETE** /api/v1/models/{model_id}/schedule | Delete Model Metrics Schedule
*ModelsV1Api* | [**generate_metrics_spec**](arthur_client/api_bindings/docs/ModelsV1Api.md#generate_metrics_spec) | **POST** /api/v1/projects/{project_id}/generate_metrics_spec | Generates A Metrics Spec.
*ModelsV1Api* | [**get_model**](arthur_client/api_bindings/docs/ModelsV1Api.md#get_model) | **GET** /api/v1/models/{model_id} | Get Model By Id
*ModelsV1Api* | [**get_models**](arthur_client/api_bindings/docs/ModelsV1Api.md#get_models) | **GET** /api/v1/projects/{project_id}/models | List Models
*ModelsV1Api* | [**patch_model**](arthur_client/api_bindings/docs/ModelsV1Api.md#patch_model) | **PATCH** /api/v1/models/{model_id} | Update Model
*ModelsV1Api* | [**post_model**](arthur_client/api_bindings/docs/ModelsV1Api.md#post_model) | **POST** /api/v1/projects/{project_id}/models | Create Model
*ModelsV1Api* | [**put_model_metric_config**](arthur_client/api_bindings/docs/ModelsV1Api.md#put_model_metric_config) | **PUT** /api/v1/models/{model_id}/metric_config | Update Model Metric Configuration By Model Id
*ModelsV1Api* | [**put_model_metrics_schedule**](arthur_client/api_bindings/docs/ModelsV1Api.md#put_model_metrics_schedule) | **PUT** /api/v1/models/{model_id}/schedule | Update Model Metrics Schedule
*OAuthV1Api* | [**get_openid_configuration**](arthur_client/api_bindings/docs/OAuthV1Api.md#get_openid_configuration) | **GET** /api/v1/auth/oidc/.well-known/openid-configuration | Get Openid Configuration Metadata
*OrganizationsV1Api* | [**delete_organization**](arthur_client/api_bindings/docs/OrganizationsV1Api.md#delete_organization) | **DELETE** /api/v1/organization | Delete Organization.
*OrganizationsV1Api* | [**get_users_organization**](arthur_client/api_bindings/docs/OrganizationsV1Api.md#get_users_organization) | **GET** /api/v1/organization | Get Users Organization.
*OrganizationsV1Api* | [**patch_organization**](arthur_client/api_bindings/docs/OrganizationsV1Api.md#patch_organization) | **PATCH** /api/v1/organization | Patch Organization.
*ProjectsV1Api* | [**delete_project**](arthur_client/api_bindings/docs/ProjectsV1Api.md#delete_project) | **DELETE** /api/v1/projects/{project_id} | Delete Project.
*ProjectsV1Api* | [**get_project**](arthur_client/api_bindings/docs/ProjectsV1Api.md#get_project) | **GET** /api/v1/projects/{project_id} | Get Project
*ProjectsV1Api* | [**get_projects**](arthur_client/api_bindings/docs/ProjectsV1Api.md#get_projects) | **GET** /api/v1/workspaces/{workspace_id}/projects | Get Projects.
*ProjectsV1Api* | [**patch_project**](arthur_client/api_bindings/docs/ProjectsV1Api.md#patch_project) | **PATCH** /api/v1/projects/{project_id} | Patch Project.
*ProjectsV1Api* | [**post_project**](arthur_client/api_bindings/docs/ProjectsV1Api.md#post_project) | **POST** /api/v1/workspaces/{workspace_id}/projects | Post Project.
*RegistrationV1Api* | [**post_sign_up_user**](arthur_client/api_bindings/docs/RegistrationV1Api.md#post_sign_up_user) | **POST** /api/v1/sign-up | Sign Up New User.
*RolesV1Api* | [**get_role**](arthur_client/api_bindings/docs/RolesV1Api.md#get_role) | **GET** /api/v1/roles/{role_id} | Get Role.
*TasksV1Api* | [**delete_connection_info**](arthur_client/api_bindings/docs/TasksV1Api.md#delete_connection_info) | **DELETE** /api/v1/models/{model_id}/task/connection_info | Delete Connection Info.
*TasksV1Api* | [**delete_task**](arthur_client/api_bindings/docs/TasksV1Api.md#delete_task) | **DELETE** /api/v1/models/{model_id}/task | Delete A Task
*TasksV1Api* | [**get_task_connection_info**](arthur_client/api_bindings/docs/TasksV1Api.md#get_task_connection_info) | **GET** /api/v1/models/{model_id}/task/connection_info | Get Task Connection Info
*TasksV1Api* | [**get_task_state_cache**](arthur_client/api_bindings/docs/TasksV1Api.md#get_task_state_cache) | **GET** /api/v1/models/{model_id}/task | Get Cached Task State
*TasksV1Api* | [**patch_task**](arthur_client/api_bindings/docs/TasksV1Api.md#patch_task) | **PATCH** /api/v1/models/{model_id}/task | Update A Task
*TasksV1Api* | [**post_regenerate_validation_key**](arthur_client/api_bindings/docs/TasksV1Api.md#post_regenerate_validation_key) | **POST** /api/v1/models/{model_id}/task/regenerate_validation_key | Regenerate Task Validation Key
*TasksV1Api* | [**project_create_model_link_task**](arthur_client/api_bindings/docs/TasksV1Api.md#project_create_model_link_task) | **POST** /api/v1/projects/{project_id}/link_task | Link An Existing Task To A New Model.
*TasksV1Api* | [**project_create_model_task**](arthur_client/api_bindings/docs/TasksV1Api.md#project_create_model_task) | **POST** /api/v1/projects/{project_id}/tasks | Create A Task.
*TasksV1Api* | [**put_task_connection_info**](arthur_client/api_bindings/docs/TasksV1Api.md#put_task_connection_info) | **PUT** /api/v1/models/{model_id}/task/connection_info | Upload Task State
*TasksV1Api* | [**put_task_state_cache**](arthur_client/api_bindings/docs/TasksV1Api.md#put_task_state_cache) | **PUT** /api/v1/models/{model_id}/task/cache | Upload Task State
*TasksV1Api* | [**sync_task**](arthur_client/api_bindings/docs/TasksV1Api.md#sync_task) | **POST** /api/v1/models/{model_id}/task/sync | Sync A Task
*UpsolveV1Api* | [**post_tenant**](arthur_client/api_bindings/docs/UpsolveV1Api.md#post_tenant) | **POST** /api/v1/upsolve-ai/tenant/token | Retrieve Jwt For Upsolve Ai Dashboards
*UsersV1Api* | [**accept_my_invites**](arthur_client/api_bindings/docs/UsersV1Api.md#accept_my_invites) | **POST** /api/v1/users/me/accept-invite | Accept User Invitations
*UsersV1Api* | [**delete_user**](arthur_client/api_bindings/docs/UsersV1Api.md#delete_user) | **DELETE** /api/v1/users/{user_id} | Delete User
*UsersV1Api* | [**get_organization_users**](arthur_client/api_bindings/docs/UsersV1Api.md#get_organization_users) | **GET** /api/v1/organization/users | Get Users In An Organization.
*UsersV1Api* | [**get_users_me**](arthur_client/api_bindings/docs/UsersV1Api.md#get_users_me) | **GET** /api/v1/users/me | Get User Metadata
*UsersV1Api* | [**patch_service_account_user**](arthur_client/api_bindings/docs/UsersV1Api.md#patch_service_account_user) | **PATCH** /api/v1/users/{user_id}/service_account | Patch Service Account User.
*UsersV1Api* | [**patch_user**](arthur_client/api_bindings/docs/UsersV1Api.md#patch_user) | **PATCH** /api/v1/users/{user_id} | Patch User.
*UsersV1Api* | [**post_organization_service_account**](arthur_client/api_bindings/docs/UsersV1Api.md#post_organization_service_account) | **POST** /api/v1/organization/service_accounts | Create Service Account
*UsersV1Api* | [**post_organization_user**](arthur_client/api_bindings/docs/UsersV1Api.md#post_organization_user) | **POST** /api/v1/organization/users | Create User
*UsersV1Api* | [**post_organization_user_invite**](arthur_client/api_bindings/docs/UsersV1Api.md#post_organization_user_invite) | **POST** /api/v1/organization/users/invite-user | Create User Via Email Invite
*UsersV1Api* | [**post_user_creds**](arthur_client/api_bindings/docs/UsersV1Api.md#post_user_creds) | **POST** /api/v1/users/{user_id}/credentials | Regenerate User Credentials.
*WebhooksV1Api* | [**delete_webhook**](arthur_client/api_bindings/docs/WebhooksV1Api.md#delete_webhook) | **DELETE** /api/v1/webhooks/{webhook_id} | Delete Webhook.
*WebhooksV1Api* | [**get_webhook**](arthur_client/api_bindings/docs/WebhooksV1Api.md#get_webhook) | **GET** /api/v1/webhooks/{webhook_id} | Get Webhook.
*WebhooksV1Api* | [**get_workspace_webhooks**](arthur_client/api_bindings/docs/WebhooksV1Api.md#get_workspace_webhooks) | **GET** /api/v1/workspaces/{workspace_id}/webhooks | Get Webhooks.
*WebhooksV1Api* | [**patch_webhook**](arthur_client/api_bindings/docs/WebhooksV1Api.md#patch_webhook) | **PATCH** /api/v1/webhooks/{webhook_id} | Patch Webhook.
*WebhooksV1Api* | [**post_test_webhook**](arthur_client/api_bindings/docs/WebhooksV1Api.md#post_test_webhook) | **POST** /api/v1/workspaces/{workspace_id}/webhooks/test | Post Test Webhook.
*WebhooksV1Api* | [**post_webhook**](arthur_client/api_bindings/docs/WebhooksV1Api.md#post_webhook) | **POST** /api/v1/workspaces/{workspace_id}/webhooks | Post Webhook.
*WorkspacesV1Api* | [**delete_workspace**](arthur_client/api_bindings/docs/WorkspacesV1Api.md#delete_workspace) | **DELETE** /api/v1/workspaces/{workspace_id} | Delete Workspace.
*WorkspacesV1Api* | [**get_workspace**](arthur_client/api_bindings/docs/WorkspacesV1Api.md#get_workspace) | **GET** /api/v1/workspaces/{workspace_id} | Get Workspace.
*WorkspacesV1Api* | [**get_workspaces**](arthur_client/api_bindings/docs/WorkspacesV1Api.md#get_workspaces) | **GET** /api/v1/organization/workspaces | Get Workspaces.
*WorkspacesV1Api* | [**patch_workspace**](arthur_client/api_bindings/docs/WorkspacesV1Api.md#patch_workspace) | **PATCH** /api/v1/workspaces/{workspace_id} | Patch Workspace.
*WorkspacesV1Api* | [**post_workspace**](arthur_client/api_bindings/docs/WorkspacesV1Api.md#post_workspace) | **POST** /api/v1/organization/workspaces | Post Workspace.
*WorkspacesV1Api* | [**workspace_get_statistics**](arthur_client/api_bindings/docs/WorkspacesV1Api.md#workspace_get_statistics) | **GET** /api/v1/workspaces/{workspace_id}/statistics | Get Workspace Statistics
*DefaultApi* | [**health_check_api_health_get**](arthur_client/api_bindings/docs/DefaultApi.md#health_check_api_health_get) | **GET** /api/health | Health Check


## Documentation For Models

 - [AggregationKind](arthur_client/api_bindings/docs/AggregationKind.md)
 - [AggregationMetricType](arthur_client/api_bindings/docs/AggregationMetricType.md)
 - [AggregationSpec](arthur_client/api_bindings/docs/AggregationSpec.md)
 - [AggregationSpecSchema](arthur_client/api_bindings/docs/AggregationSpecSchema.md)
 - [AggregationSpecSchemaInitArgsInner](arthur_client/api_bindings/docs/AggregationSpecSchemaInitArgsInner.md)
 - [Alert](arthur_client/api_bindings/docs/Alert.md)
 - [AlertBound](arthur_client/api_bindings/docs/AlertBound.md)
 - [AlertCheckJobSpec](arthur_client/api_bindings/docs/AlertCheckJobSpec.md)
 - [AlertRule](arthur_client/api_bindings/docs/AlertRule.md)
 - [AlertRuleInterval](arthur_client/api_bindings/docs/AlertRuleInterval.md)
 - [AlertRuleNotificationWebhook](arthur_client/api_bindings/docs/AlertRuleNotificationWebhook.md)
 - [AlertRuleSQLValidationResp](arthur_client/api_bindings/docs/AlertRuleSQLValidationResp.md)
 - [AlertRuleSort](arthur_client/api_bindings/docs/AlertRuleSort.md)
 - [AlertSort](arthur_client/api_bindings/docs/AlertSort.md)
 - [AlertWebhookCalled](arthur_client/api_bindings/docs/AlertWebhookCalled.md)
 - [AvailableDataset](arthur_client/api_bindings/docs/AvailableDataset.md)
 - [AvailableDatasetsSort](arthur_client/api_bindings/docs/AvailableDatasetsSort.md)
 - [BadRequestError](arthur_client/api_bindings/docs/BadRequestError.md)
 - [BaseColumnParameterSchema](arthur_client/api_bindings/docs/BaseColumnParameterSchema.md)
 - [BaseColumnParameterSchemaAllowedColumnTypesInner](arthur_client/api_bindings/docs/BaseColumnParameterSchemaAllowedColumnTypesInner.md)
 - [BaseDatasetParameterSchema](arthur_client/api_bindings/docs/BaseDatasetParameterSchema.md)
 - [BaseLiteralParameterSchema](arthur_client/api_bindings/docs/BaseLiteralParameterSchema.md)
 - [BaseReportedAggregation](arthur_client/api_bindings/docs/BaseReportedAggregation.md)
 - [BaseRole](arthur_client/api_bindings/docs/BaseRole.md)
 - [BoundMember](arthur_client/api_bindings/docs/BoundMember.md)
 - [BoundMemberKind](arthur_client/api_bindings/docs/BoundMemberKind.md)
 - [BoundResource](arthur_client/api_bindings/docs/BoundResource.md)
 - [BoundResourceKind](arthur_client/api_bindings/docs/BoundResourceKind.md)
 - [BoundRole](arthur_client/api_bindings/docs/BoundRole.md)
 - [Config](arthur_client/api_bindings/docs/Config.md)
 - [ConflictError](arthur_client/api_bindings/docs/ConflictError.md)
 - [ConnectorCheckJobSpec](arthur_client/api_bindings/docs/ConnectorCheckJobSpec.md)
 - [ConnectorCheckOutcome](arthur_client/api_bindings/docs/ConnectorCheckOutcome.md)
 - [ConnectorCheckResult](arthur_client/api_bindings/docs/ConnectorCheckResult.md)
 - [ConnectorFieldDataType](arthur_client/api_bindings/docs/ConnectorFieldDataType.md)
 - [ConnectorPaginationOptions](arthur_client/api_bindings/docs/ConnectorPaginationOptions.md)
 - [ConnectorSpec](arthur_client/api_bindings/docs/ConnectorSpec.md)
 - [ConnectorSpecField](arthur_client/api_bindings/docs/ConnectorSpecField.md)
 - [ConnectorSpecFieldWithMetadata](arthur_client/api_bindings/docs/ConnectorSpecFieldWithMetadata.md)
 - [ConnectorSpecSchema](arthur_client/api_bindings/docs/ConnectorSpecSchema.md)
 - [ConnectorSpecSchemaField](arthur_client/api_bindings/docs/ConnectorSpecSchemaField.md)
 - [ConnectorType](arthur_client/api_bindings/docs/ConnectorType.md)
 - [ConnectorsSort](arthur_client/api_bindings/docs/ConnectorsSort.md)
 - [CreateModelLinkTaskJobSpec](arthur_client/api_bindings/docs/CreateModelLinkTaskJobSpec.md)
 - [CreateModelTaskJobSpec](arthur_client/api_bindings/docs/CreateModelTaskJobSpec.md)
 - [CreatedAlerts](arthur_client/api_bindings/docs/CreatedAlerts.md)
 - [Credentials](arthur_client/api_bindings/docs/Credentials.md)
 - [CustomAggregationSpecSchema](arthur_client/api_bindings/docs/CustomAggregationSpecSchema.md)
 - [CustomAggregationVersionSpecSchema](arthur_client/api_bindings/docs/CustomAggregationVersionSpecSchema.md)
 - [CustomAggregationVersionSpecSchemaAggregateArgsInner](arthur_client/api_bindings/docs/CustomAggregationVersionSpecSchemaAggregateArgsInner.md)
 - [DType](arthur_client/api_bindings/docs/DType.md)
 - [DataPlane](arthur_client/api_bindings/docs/DataPlane.md)
 - [DataPlaneAssociation](arthur_client/api_bindings/docs/DataPlaneAssociation.md)
 - [DataPlaneAssociationSort](arthur_client/api_bindings/docs/DataPlaneAssociationSort.md)
 - [DataPlaneCapabilities](arthur_client/api_bindings/docs/DataPlaneCapabilities.md)
 - [DataPlaneSort](arthur_client/api_bindings/docs/DataPlaneSort.md)
 - [DataResultFilter](arthur_client/api_bindings/docs/DataResultFilter.md)
 - [DataResultFilterOp](arthur_client/api_bindings/docs/DataResultFilterOp.md)
 - [DataRetrievalData](arthur_client/api_bindings/docs/DataRetrievalData.md)
 - [DataRetrievalOperation](arthur_client/api_bindings/docs/DataRetrievalOperation.md)
 - [DataRetrievalStatus](arthur_client/api_bindings/docs/DataRetrievalStatus.md)
 - [Dataset](arthur_client/api_bindings/docs/Dataset.md)
 - [DatasetColumn](arthur_client/api_bindings/docs/DatasetColumn.md)
 - [DatasetConnector](arthur_client/api_bindings/docs/DatasetConnector.md)
 - [DatasetJoinKind](arthur_client/api_bindings/docs/DatasetJoinKind.md)
 - [DatasetJoinSpec](arthur_client/api_bindings/docs/DatasetJoinSpec.md)
 - [DatasetListType](arthur_client/api_bindings/docs/DatasetListType.md)
 - [DatasetLocator](arthur_client/api_bindings/docs/DatasetLocator.md)
 - [DatasetLocatorField](arthur_client/api_bindings/docs/DatasetLocatorField.md)
 - [DatasetLocatorFieldDataType](arthur_client/api_bindings/docs/DatasetLocatorFieldDataType.md)
 - [DatasetLocatorSchema](arthur_client/api_bindings/docs/DatasetLocatorSchema.md)
 - [DatasetLocatorSchemaField](arthur_client/api_bindings/docs/DatasetLocatorSchemaField.md)
 - [DatasetObjectType](arthur_client/api_bindings/docs/DatasetObjectType.md)
 - [DatasetReference](arthur_client/api_bindings/docs/DatasetReference.md)
 - [DatasetScalarType](arthur_client/api_bindings/docs/DatasetScalarType.md)
 - [DatasetSchema](arthur_client/api_bindings/docs/DatasetSchema.md)
 - [DatasetsSort](arthur_client/api_bindings/docs/DatasetsSort.md)
 - [Definition](arthur_client/api_bindings/docs/Definition.md)
 - [DeleteGroupMembership](arthur_client/api_bindings/docs/DeleteGroupMembership.md)
 - [DeleteModelTaskJobSpec](arthur_client/api_bindings/docs/DeleteModelTaskJobSpec.md)
 - [Dimension](arthur_client/api_bindings/docs/Dimension.md)
 - [ExampleConfig](arthur_client/api_bindings/docs/ExampleConfig.md)
 - [ExamplesConfig](arthur_client/api_bindings/docs/ExamplesConfig.md)
 - [ExtendedRole](arthur_client/api_bindings/docs/ExtendedRole.md)
 - [FetchDataJobSpec](arthur_client/api_bindings/docs/FetchDataJobSpec.md)
 - [FetchModelTaskJobSpec](arthur_client/api_bindings/docs/FetchModelTaskJobSpec.md)
 - [GenerateMetricsSpecRequest](arthur_client/api_bindings/docs/GenerateMetricsSpecRequest.md)
 - [Group](arthur_client/api_bindings/docs/Group.md)
 - [GroupMembership](arthur_client/api_bindings/docs/GroupMembership.md)
 - [GroupSort](arthur_client/api_bindings/docs/GroupSort.md)
 - [HTTPValidationError](arthur_client/api_bindings/docs/HTTPValidationError.md)
 - [HealthStatus](arthur_client/api_bindings/docs/HealthStatus.md)
 - [InfinitePagination](arthur_client/api_bindings/docs/InfinitePagination.md)
 - [InfiniteResourceListAlert](arthur_client/api_bindings/docs/InfiniteResourceListAlert.md)
 - [InfiniteResourceListJob](arthur_client/api_bindings/docs/InfiniteResourceListJob.md)
 - [InternalServerError](arthur_client/api_bindings/docs/InternalServerError.md)
 - [IntervalUnit](arthur_client/api_bindings/docs/IntervalUnit.md)
 - [InviteNewUser](arthur_client/api_bindings/docs/InviteNewUser.md)
 - [Items](arthur_client/api_bindings/docs/Items.md)
 - [Items1](arthur_client/api_bindings/docs/Items1.md)
 - [Job](arthur_client/api_bindings/docs/Job.md)
 - [JobDequeueParameters](arthur_client/api_bindings/docs/JobDequeueParameters.md)
 - [JobError](arthur_client/api_bindings/docs/JobError.md)
 - [JobErrors](arthur_client/api_bindings/docs/JobErrors.md)
 - [JobKind](arthur_client/api_bindings/docs/JobKind.md)
 - [JobLog](arthur_client/api_bindings/docs/JobLog.md)
 - [JobLogLevel](arthur_client/api_bindings/docs/JobLogLevel.md)
 - [JobLogs](arthur_client/api_bindings/docs/JobLogs.md)
 - [JobPriority](arthur_client/api_bindings/docs/JobPriority.md)
 - [JobRun](arthur_client/api_bindings/docs/JobRun.md)
 - [JobSpec](arthur_client/api_bindings/docs/JobSpec.md)
 - [JobState](arthur_client/api_bindings/docs/JobState.md)
 - [JobTrigger](arthur_client/api_bindings/docs/JobTrigger.md)
 - [JobsBatch](arthur_client/api_bindings/docs/JobsBatch.md)
 - [JobsSort](arthur_client/api_bindings/docs/JobsSort.md)
 - [JoinedDataset](arthur_client/api_bindings/docs/JoinedDataset.md)
 - [KeywordsConfig](arthur_client/api_bindings/docs/KeywordsConfig.md)
 - [ListDatasetsJobSpec](arthur_client/api_bindings/docs/ListDatasetsJobSpec.md)
 - [ListType](arthur_client/api_bindings/docs/ListType.md)
 - [MetricResponse](arthur_client/api_bindings/docs/MetricResponse.md)
 - [MetricType](arthur_client/api_bindings/docs/MetricType.md)
 - [MetricsArgSpec](arthur_client/api_bindings/docs/MetricsArgSpec.md)
 - [MetricsCalculationJobSpec](arthur_client/api_bindings/docs/MetricsCalculationJobSpec.md)
 - [MetricsColumnListParameterSchema](arthur_client/api_bindings/docs/MetricsColumnListParameterSchema.md)
 - [MetricsColumnParameterSchema](arthur_client/api_bindings/docs/MetricsColumnParameterSchema.md)
 - [MetricsDatasetParameterSchema](arthur_client/api_bindings/docs/MetricsDatasetParameterSchema.md)
 - [MetricsLiteralParameterSchema](arthur_client/api_bindings/docs/MetricsLiteralParameterSchema.md)
 - [MetricsQueryResult](arthur_client/api_bindings/docs/MetricsQueryResult.md)
 - [MetricsResultFilterOp](arthur_client/api_bindings/docs/MetricsResultFilterOp.md)
 - [MetricsUpload](arthur_client/api_bindings/docs/MetricsUpload.md)
 - [MetricsUploadMetricsInner](arthur_client/api_bindings/docs/MetricsUploadMetricsInner.md)
 - [MetricsUploadResult](arthur_client/api_bindings/docs/MetricsUploadResult.md)
 - [MetricsVersion](arthur_client/api_bindings/docs/MetricsVersion.md)
 - [MetricsVersionsSort](arthur_client/api_bindings/docs/MetricsVersionsSort.md)
 - [Model](arthur_client/api_bindings/docs/Model.md)
 - [ModelMetricSpec](arthur_client/api_bindings/docs/ModelMetricSpec.md)
 - [ModelMetricsSchedule](arthur_client/api_bindings/docs/ModelMetricsSchedule.md)
 - [ModelProblemType](arthur_client/api_bindings/docs/ModelProblemType.md)
 - [ModelsSort](arthur_client/api_bindings/docs/ModelsSort.md)
 - [NewMetricRequest](arthur_client/api_bindings/docs/NewMetricRequest.md)
 - [NewRuleRequest](arthur_client/api_bindings/docs/NewRuleRequest.md)
 - [NotFoundError](arthur_client/api_bindings/docs/NotFoundError.md)
 - [NumericMetric](arthur_client/api_bindings/docs/NumericMetric.md)
 - [NumericPoint](arthur_client/api_bindings/docs/NumericPoint.md)
 - [NumericTimeSeries](arthur_client/api_bindings/docs/NumericTimeSeries.md)
 - [ObjectType](arthur_client/api_bindings/docs/ObjectType.md)
 - [ObjectValue](arthur_client/api_bindings/docs/ObjectValue.md)
 - [Organization](arthur_client/api_bindings/docs/Organization.md)
 - [PIIConfig](arthur_client/api_bindings/docs/PIIConfig.md)
 - [Pagination](arthur_client/api_bindings/docs/Pagination.md)
 - [PatchAlertRule](arthur_client/api_bindings/docs/PatchAlertRule.md)
 - [PatchConnectorSpec](arthur_client/api_bindings/docs/PatchConnectorSpec.md)
 - [PatchCustomAggregationSpecSchema](arthur_client/api_bindings/docs/PatchCustomAggregationSpecSchema.md)
 - [PatchDataPlane](arthur_client/api_bindings/docs/PatchDataPlane.md)
 - [PatchDataPlaneCapabilities](arthur_client/api_bindings/docs/PatchDataPlaneCapabilities.md)
 - [PatchDataset](arthur_client/api_bindings/docs/PatchDataset.md)
 - [PatchDatasetLocator](arthur_client/api_bindings/docs/PatchDatasetLocator.md)
 - [PatchGroup](arthur_client/api_bindings/docs/PatchGroup.md)
 - [PatchJob](arthur_client/api_bindings/docs/PatchJob.md)
 - [PatchModel](arthur_client/api_bindings/docs/PatchModel.md)
 - [PatchOrganization](arthur_client/api_bindings/docs/PatchOrganization.md)
 - [PatchProject](arthur_client/api_bindings/docs/PatchProject.md)
 - [PatchServiceAccountUser](arthur_client/api_bindings/docs/PatchServiceAccountUser.md)
 - [PatchTaskRequest](arthur_client/api_bindings/docs/PatchTaskRequest.md)
 - [PatchUser](arthur_client/api_bindings/docs/PatchUser.md)
 - [PatchWebhook](arthur_client/api_bindings/docs/PatchWebhook.md)
 - [PatchWorkspace](arthur_client/api_bindings/docs/PatchWorkspace.md)
 - [Permission](arthur_client/api_bindings/docs/Permission.md)
 - [PermissionName](arthur_client/api_bindings/docs/PermissionName.md)
 - [PermissionRequestItem](arthur_client/api_bindings/docs/PermissionRequestItem.md)
 - [PermissionResponseItem](arthur_client/api_bindings/docs/PermissionResponseItem.md)
 - [PermissionsRequest](arthur_client/api_bindings/docs/PermissionsRequest.md)
 - [PermissionsResponse](arthur_client/api_bindings/docs/PermissionsResponse.md)
 - [PostAlert](arthur_client/api_bindings/docs/PostAlert.md)
 - [PostAlertRule](arthur_client/api_bindings/docs/PostAlertRule.md)
 - [PostAlerts](arthur_client/api_bindings/docs/PostAlerts.md)
 - [PostConnectorSpec](arthur_client/api_bindings/docs/PostConnectorSpec.md)
 - [PostCustomAggregationSpecSchema](arthur_client/api_bindings/docs/PostCustomAggregationSpecSchema.md)
 - [PostDataPlane](arthur_client/api_bindings/docs/PostDataPlane.md)
 - [PostDataPlaneAssociation](arthur_client/api_bindings/docs/PostDataPlaneAssociation.md)
 - [PostDataRetrievalOperation](arthur_client/api_bindings/docs/PostDataRetrievalOperation.md)
 - [PostDataset](arthur_client/api_bindings/docs/PostDataset.md)
 - [PostDatasetJoinSpec](arthur_client/api_bindings/docs/PostDatasetJoinSpec.md)
 - [PostEndUser](arthur_client/api_bindings/docs/PostEndUser.md)
 - [PostGlobalRoleBinding](arthur_client/api_bindings/docs/PostGlobalRoleBinding.md)
 - [PostGroup](arthur_client/api_bindings/docs/PostGroup.md)
 - [PostGroupMembership](arthur_client/api_bindings/docs/PostGroupMembership.md)
 - [PostJob](arthur_client/api_bindings/docs/PostJob.md)
 - [PostJobBatch](arthur_client/api_bindings/docs/PostJobBatch.md)
 - [PostJobKind](arthur_client/api_bindings/docs/PostJobKind.md)
 - [PostJobSpec](arthur_client/api_bindings/docs/PostJobSpec.md)
 - [PostLinkTaskRequest](arthur_client/api_bindings/docs/PostLinkTaskRequest.md)
 - [PostMetricsQuery](arthur_client/api_bindings/docs/PostMetricsQuery.md)
 - [PostMetricsQueryResultFilter](arthur_client/api_bindings/docs/PostMetricsQueryResultFilter.md)
 - [PostMetricsQueryResultFilterAndGroup](arthur_client/api_bindings/docs/PostMetricsQueryResultFilterAndGroup.md)
 - [PostMetricsQueryResultFilterAndGroupAndInner](arthur_client/api_bindings/docs/PostMetricsQueryResultFilterAndGroupAndInner.md)
 - [PostMetricsQueryResultFilterOrGroup](arthur_client/api_bindings/docs/PostMetricsQueryResultFilterOrGroup.md)
 - [PostMetricsQueryResultFilterOrGroupOrInner](arthur_client/api_bindings/docs/PostMetricsQueryResultFilterOrGroupOrInner.md)
 - [PostMetricsQueryTimeRange](arthur_client/api_bindings/docs/PostMetricsQueryTimeRange.md)
 - [PostMetricsVersions](arthur_client/api_bindings/docs/PostMetricsVersions.md)
 - [PostModel](arthur_client/api_bindings/docs/PostModel.md)
 - [PostProject](arthur_client/api_bindings/docs/PostProject.md)
 - [PostRoleBinding](arthur_client/api_bindings/docs/PostRoleBinding.md)
 - [PostServiceAccount](arthur_client/api_bindings/docs/PostServiceAccount.md)
 - [PostTaskRequest](arthur_client/api_bindings/docs/PostTaskRequest.md)
 - [PostTaskValidationAPIKey](arthur_client/api_bindings/docs/PostTaskValidationAPIKey.md)
 - [PostUpsolveTenant](arthur_client/api_bindings/docs/PostUpsolveTenant.md)
 - [PostWebhook](arthur_client/api_bindings/docs/PostWebhook.md)
 - [PostWorkspace](arthur_client/api_bindings/docs/PostWorkspace.md)
 - [Project](arthur_client/api_bindings/docs/Project.md)
 - [ProjectBoundResourceMetadata](arthur_client/api_bindings/docs/ProjectBoundResourceMetadata.md)
 - [ProjectSort](arthur_client/api_bindings/docs/ProjectSort.md)
 - [PutAvailableDataset](arthur_client/api_bindings/docs/PutAvailableDataset.md)
 - [PutAvailableDatasets](arthur_client/api_bindings/docs/PutAvailableDatasets.md)
 - [PutCustomAggregationSpecSchema](arthur_client/api_bindings/docs/PutCustomAggregationSpecSchema.md)
 - [PutDatasetSchema](arthur_client/api_bindings/docs/PutDatasetSchema.md)
 - [PutJobState](arthur_client/api_bindings/docs/PutJobState.md)
 - [PutModelMetricSpec](arthur_client/api_bindings/docs/PutModelMetricSpec.md)
 - [PutModelMetricsSchedule](arthur_client/api_bindings/docs/PutModelMetricsSchedule.md)
 - [PutRetrievedData](arthur_client/api_bindings/docs/PutRetrievedData.md)
 - [PutTaskConnectionInfo](arthur_client/api_bindings/docs/PutTaskConnectionInfo.md)
 - [PutTaskStateCacheRequest](arthur_client/api_bindings/docs/PutTaskStateCacheRequest.md)
 - [RegenerateTaskValidationKeyJobSpec](arthur_client/api_bindings/docs/RegenerateTaskValidationKeyJobSpec.md)
 - [RegexConfig](arthur_client/api_bindings/docs/RegexConfig.md)
 - [RegisterUser](arthur_client/api_bindings/docs/RegisterUser.md)
 - [RelevanceMetricConfig](arthur_client/api_bindings/docs/RelevanceMetricConfig.md)
 - [ReportedCustomAggregation](arthur_client/api_bindings/docs/ReportedCustomAggregation.md)
 - [ResourceKind](arthur_client/api_bindings/docs/ResourceKind.md)
 - [ResourceListAggregationSpecSchema](arthur_client/api_bindings/docs/ResourceListAggregationSpecSchema.md)
 - [ResourceListAlertRule](arthur_client/api_bindings/docs/ResourceListAlertRule.md)
 - [ResourceListAvailableDataset](arthur_client/api_bindings/docs/ResourceListAvailableDataset.md)
 - [ResourceListConnectorSpec](arthur_client/api_bindings/docs/ResourceListConnectorSpec.md)
 - [ResourceListConnectorType](arthur_client/api_bindings/docs/ResourceListConnectorType.md)
 - [ResourceListCustomAggregationSpecSchema](arthur_client/api_bindings/docs/ResourceListCustomAggregationSpecSchema.md)
 - [ResourceListDataPlane](arthur_client/api_bindings/docs/ResourceListDataPlane.md)
 - [ResourceListDataPlaneAssociation](arthur_client/api_bindings/docs/ResourceListDataPlaneAssociation.md)
 - [ResourceListDataset](arthur_client/api_bindings/docs/ResourceListDataset.md)
 - [ResourceListGroup](arthur_client/api_bindings/docs/ResourceListGroup.md)
 - [ResourceListGroupMembership](arthur_client/api_bindings/docs/ResourceListGroupMembership.md)
 - [ResourceListJobError](arthur_client/api_bindings/docs/ResourceListJobError.md)
 - [ResourceListJobLog](arthur_client/api_bindings/docs/ResourceListJobLog.md)
 - [ResourceListJobRun](arthur_client/api_bindings/docs/ResourceListJobRun.md)
 - [ResourceListMetricsVersion](arthur_client/api_bindings/docs/ResourceListMetricsVersion.md)
 - [ResourceListModel](arthur_client/api_bindings/docs/ResourceListModel.md)
 - [ResourceListPermission](arthur_client/api_bindings/docs/ResourceListPermission.md)
 - [ResourceListProject](arthur_client/api_bindings/docs/ResourceListProject.md)
 - [ResourceListRole](arthur_client/api_bindings/docs/ResourceListRole.md)
 - [ResourceListRoleBinding](arthur_client/api_bindings/docs/ResourceListRoleBinding.md)
 - [ResourceListUser](arthur_client/api_bindings/docs/ResourceListUser.md)
 - [ResourceListWebhook](arthur_client/api_bindings/docs/ResourceListWebhook.md)
 - [ResourceListWorkspace](arthur_client/api_bindings/docs/ResourceListWorkspace.md)
 - [ResultFilter](arthur_client/api_bindings/docs/ResultFilter.md)
 - [Role](arthur_client/api_bindings/docs/Role.md)
 - [RoleBinding](arthur_client/api_bindings/docs/RoleBinding.md)
 - [RoleSort](arthur_client/api_bindings/docs/RoleSort.md)
 - [RuleResponse](arthur_client/api_bindings/docs/RuleResponse.md)
 - [RuleScope](arthur_client/api_bindings/docs/RuleScope.md)
 - [RuleType](arthur_client/api_bindings/docs/RuleType.md)
 - [ScalarType](arthur_client/api_bindings/docs/ScalarType.md)
 - [ScheduleJobsJobSpec](arthur_client/api_bindings/docs/ScheduleJobsJobSpec.md)
 - [SchemaInspectionJobSpec](arthur_client/api_bindings/docs/SchemaInspectionJobSpec.md)
 - [ScopeSchemaTag](arthur_client/api_bindings/docs/ScopeSchemaTag.md)
 - [SensitiveDataPlane](arthur_client/api_bindings/docs/SensitiveDataPlane.md)
 - [SensitiveUser](arthur_client/api_bindings/docs/SensitiveUser.md)
 - [ServiceAccountCredentials](arthur_client/api_bindings/docs/ServiceAccountCredentials.md)
 - [SketchMetric](arthur_client/api_bindings/docs/SketchMetric.md)
 - [SketchPoint](arthur_client/api_bindings/docs/SketchPoint.md)
 - [SketchTimeSeries](arthur_client/api_bindings/docs/SketchTimeSeries.md)
 - [SortOrder](arthur_client/api_bindings/docs/SortOrder.md)
 - [TaskConnectionInfo](arthur_client/api_bindings/docs/TaskConnectionInfo.md)
 - [TaskMutationResponse](arthur_client/api_bindings/docs/TaskMutationResponse.md)
 - [TaskReadResponse](arthur_client/api_bindings/docs/TaskReadResponse.md)
 - [TaskResponse](arthur_client/api_bindings/docs/TaskResponse.md)
 - [TaskType](arthur_client/api_bindings/docs/TaskType.md)
 - [TaskValidationAPIKey](arthur_client/api_bindings/docs/TaskValidationAPIKey.md)
 - [TaskValidationKeyRegenerationResponse](arthur_client/api_bindings/docs/TaskValidationKeyRegenerationResponse.md)
 - [ToxicityConfig](arthur_client/api_bindings/docs/ToxicityConfig.md)
 - [UpdateModelTaskRulesJobSpec](arthur_client/api_bindings/docs/UpdateModelTaskRulesJobSpec.md)
 - [UpsolveToken](arthur_client/api_bindings/docs/UpsolveToken.md)
 - [User](arthur_client/api_bindings/docs/User.md)
 - [UserCredentials](arthur_client/api_bindings/docs/UserCredentials.md)
 - [UserServiceAccountCredentials](arthur_client/api_bindings/docs/UserServiceAccountCredentials.md)
 - [UserSort](arthur_client/api_bindings/docs/UserSort.md)
 - [UserType](arthur_client/api_bindings/docs/UserType.md)
 - [ValidateAlertRuleQueryReq](arthur_client/api_bindings/docs/ValidateAlertRuleQueryReq.md)
 - [ValidationError](arthur_client/api_bindings/docs/ValidationError.md)
 - [ValidationErrorLocInner](arthur_client/api_bindings/docs/ValidationErrorLocInner.md)
 - [ValidationOutcome](arthur_client/api_bindings/docs/ValidationOutcome.md)
 - [ValidationResult](arthur_client/api_bindings/docs/ValidationResult.md)
 - [ValidationResults](arthur_client/api_bindings/docs/ValidationResults.md)
 - [Webhook](arthur_client/api_bindings/docs/Webhook.md)
 - [WebhookResponse](arthur_client/api_bindings/docs/WebhookResponse.md)
 - [WebhookResult](arthur_client/api_bindings/docs/WebhookResult.md)
 - [WebhookSort](arthur_client/api_bindings/docs/WebhookSort.md)
 - [Workspace](arthur_client/api_bindings/docs/Workspace.md)
 - [WorkspaceSort](arthur_client/api_bindings/docs/WorkspaceSort.md)
 - [WorkspaceStatistics](arthur_client/api_bindings/docs/WorkspaceStatistics.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2AuthorizationCode"></a>
### OAuth2AuthorizationCode

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: http://localhost:8080/realms/arthur/protocol/openid-connect/auth
- **Scopes**: N/A


## Author




