"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedInstanceRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
class ManagedInstanceRole extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        var managedPolicies = props.managedPolicies === undefined ? [] : props.managedPolicies;
        let domainJoinEnabled = props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true;
        let ssmManagementEnabled = props.ssmManagementEnabled === undefined ||
            props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true ||
            props.ssmManagementEnabled === true;
        if (ssmManagementEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        }
        ;
        if (domainJoinEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'));
        }
        ;
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
            managedPolicies,
        });
        this.instanceProfile = new aws_cdk_lib_1.aws_iam.CfnInstanceProfile(this, 'instanceProfile', {
            roles: [role.roleName],
        });
    }
}
exports.ManagedInstanceRole = ManagedInstanceRole;
_a = JSII_RTTI_SYMBOL_1;
ManagedInstanceRole[_a] = { fqn: "@renovosolutions/cdk-library-managed-instance-role.ManagedInstanceRole", version: "2.1.38" };
//# sourceMappingURL=data:application/json;base64,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