(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"));
	else if(typeof define === 'function' && define.amd)
		define(["react"], factory);
	else if(typeof exports === 'object')
		exports["dazzler_core"] = factory(require("react"));
	else
		root["dazzler_core"] = factory(root["React"]);
})(self, function(__WEBPACK_EXTERNAL_MODULE_react__) {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/commons/js/casing.js":
/*!**********************************!*\
  !*** ./src/commons/js/casing.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "camelToSnakeCase": () => (/* binding */ camelToSnakeCase),
/* harmony export */   "snakeToCamelCase": () => (/* binding */ snakeToCamelCase),
/* harmony export */   "camelToSpinal": () => (/* binding */ camelToSpinal),
/* harmony export */   "transformKeys": () => (/* binding */ transformKeys)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/last.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/slice.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/toPairs.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


function camelToSnakeCase(s) {
  return s.split('').map(function (c, i) {
    return c.charCodeAt(0) > 96 ? c : i > 0 ? "_".concat(c.toLowerCase()) : c.toLowerCase();
  }).reduce(function (p, n) {
    return p + n;
  });
}
function snakeToCamelCase(s) {
  return s.split('').reduce(function (a, e) {
    return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.default)(a) === '_' ? (0,ramda__WEBPACK_IMPORTED_MODULE_1__.default)(0, a.length - 1, a) + e.toUpperCase() : a + e;
  }, '');
}
function camelToSpinal(s) {
  return s.split('').map(function (c, i) {
    return c.charCodeAt(0) > 96 ? c : i > 0 ? "-".concat(c.toLowerCase()) : c.toLowerCase();
  }).reduce(function (p, n) {
    return p + n;
  });
}
function transformKeys(obj, transform) {
  return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(obj).reduce(function (a, _ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        k = _ref2[0],
        v = _ref2[1];

    a[transform(k)] = v;
    return a;
  }, {});
}

/***/ }),

/***/ "./src/commons/js/index.js":
/*!*********************************!*\
  !*** ./src/commons/js/index.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "toTimestamp": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.toTimestamp),
/* harmony export */   "timestampProp": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.timestampProp),
/* harmony export */   "loadCss": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.loadCss),
/* harmony export */   "loadScript": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.loadScript),
/* harmony export */   "debounce": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.debounce),
/* harmony export */   "snakeToCamelCase": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.snakeToCamelCase),
/* harmony export */   "camelToSnakeCase": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.camelToSnakeCase),
/* harmony export */   "camelToSpinal": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.camelToSpinal),
/* harmony export */   "transformKeys": () => (/* reexport safe */ _casing__WEBPACK_IMPORTED_MODULE_2__.transformKeys),
/* harmony export */   "collectTruePropKeys": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.collectTruePropKeys),
/* harmony export */   "chunk": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.chunk),
/* harmony export */   "disableCss": () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_1__.disableCss)
/* harmony export */ });
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scss/index.scss */ "./src/commons/scss/index.scss");
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_scss_index_scss__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./src/commons/js/utils.js");
/* harmony import */ var _casing__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./casing */ "./src/commons/js/casing.js");





/***/ }),

/***/ "./src/commons/js/utils.js":
/*!*********************************!*\
  !*** ./src/commons/js/utils.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "toTimestamp": () => (/* binding */ toTimestamp),
/* harmony export */   "timestampProp": () => (/* binding */ timestampProp),
/* harmony export */   "loadScript": () => (/* binding */ loadScript),
/* harmony export */   "disableCss": () => (/* binding */ disableCss),
/* harmony export */   "loadCss": () => (/* binding */ loadCss),
/* harmony export */   "debounce": () => (/* binding */ debounce),
/* harmony export */   "collectTruePropKeys": () => (/* binding */ collectTruePropKeys),
/* harmony export */   "chunk": () => (/* binding */ chunk)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/toPairs.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/includes.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/pluck.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


function toTimestamp(date) {
  return parseInt((date.getTime() / 1000).toFixed(0));
}
var timestampProp = function timestampProp(prop_name, value) {
  var payload = {};
  payload[prop_name] = value;
  payload["".concat(prop_name, "_timestamp")] = toTimestamp(new Date());
  return payload;
};
function loadScript(uri) {
  var timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 3000;
  return new Promise(function (resolve, reject) {
    /* eslint-disable prefer-const */
    var timeoutId;

    var onload = function onload() {
      clearTimeout(timeoutId);
      resolve(uri);
    };

    var attributes = {
      src: uri,
      async: true
    };
    var element = document.createElement('script');
    Object.keys(attributes).forEach(function (k) {
      return element.setAttribute(k, attributes[k]);
    });
    element.onload = onload;
    timeoutId = setTimeout(function () {
      element.src = '';
      reject({
        error: "".concat(uri, " did not load after ").concat(timeout, "ms")
      });
    }, timeout);
    document.querySelector('body').appendChild(element);
  });
}
function disableCss(uri) {
  var element = document.getElementById("css-".concat(uri));

  if (element) {
    element.setAttribute('disabled', 'disabled');
    element.id = null;
  }
}
function loadCss(uri) {
  var timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 3000;
  return new Promise(function (resolve, reject) {
    /* eslint-disable prefer-const */
    var timeoutId;

    var onload = function onload() {
      clearTimeout(timeoutId);
      resolve(uri);
    };

    disableCss(uri);
    var attributes = {
      rel: 'stylesheet',
      type: 'text/css',
      href: uri,
      media: 'all',
      id: "css-".concat(uri)
    };
    var element = document.createElement('link');
    Object.keys(attributes).forEach(function (k) {
      return element.setAttribute(k, attributes[k]);
    });
    element.onload = onload;
    timeoutId = setTimeout(function () {
      element.href = '';
      reject({
        error: "".concat(uri, " did not load after ").concat(timeout, "ms")
      });
    }, timeout);
    document.querySelector('head').appendChild(element);
  });
}
function debounce(func, wait) {
  var timeout, lastCall;
  return function () {
    var _arguments = arguments,
        _this = this;

    var now = new Date();

    if (!lastCall) {
      lastCall = now;
    }

    var later = function later() {
      timeout = null;
      /* eslint-disable no-invalid-this */

      func.apply(_this, _arguments);
      lastCall = new Date();
    };

    clearTimeout(timeout);
    var diff = now - lastCall;

    if (diff >= wait) {
      /* eslint-disable no-invalid-this */
      func.apply(this, arguments);
      lastCall = now;
    } else {
      timeout = setTimeout(later, diff);
    }
  };
}
function collectTruePropKeys(obj, filterKeys) {
  var pairs = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.default)(obj);

  if (filterKeys) {
    pairs = pairs.filter(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          k = _ref2[0],
          _ = _ref2[1];

      return (0,ramda__WEBPACK_IMPORTED_MODULE_1__.default)(k, filterKeys);
    });
  }

  return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(0, pairs.filter(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        _ = _ref4[0],
        v = _ref4[1];

    return v;
  }));
}
function chunk(arr, n) {
  return arr.map(function (item, index) {
    return index % n === 0 ? arr.slice(index, index + n) : null;
  }).filter(function (item) {
    return item;
  });
}

/***/ }),

/***/ "./src/core/js/components/Button.jsx":
/*!*******************************************!*\
  !*** ./src/core/js/components/Button.jsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Button)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }





/**
 * A button to click on!
 *
 * :CSS:
 *
 *     - ``dazzler-core-button``
 *     - ``bordered``
 *     - ``rounded``
 *     - ``circle``
 *     - ``primary``
 *     - ``danger``
 *     - ``warning``
 *     - ``success``
 *     - ``tiny``
 *     - ``small``
 *     - ``medium``
 *     - ``large``
 *     - ``x-large``
 *     - ``xx-large``
 *
 * @example
 *
 *     from dazzler.system import Page, Trigger
 *     from dazzler.components import core
 *
 *     button = core.Button('Click me', identity='btn')
 *
 *     page = Page(
 *         __name__,
 *         core.Container([button, core.Container(identity="output")])
 *     )
 *
 *     @page.binding(Trigger('btn', 'clicks'))
 *     async def on_click(ctx):
 *         await ctx.set_aspect('output', f'Clicked {ctx.trigger.value}')
 */

var Button = /*#__PURE__*/function (_React$Component) {
  _inherits(Button, _React$Component);

  var _super = _createSuper(Button);

  function Button() {
    _classCallCheck(this, Button);

    return _super.apply(this, arguments);
  }

  _createClass(Button, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return !(this.props.clicks < nextProps.clicks);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          label = _this$props.label,
          identity = _this$props.identity,
          id = _this$props.id,
          class_name = _this$props.class_name,
          preset = _this$props.preset,
          style = _this$props.style,
          disabled = _this$props.disabled,
          size = _this$props.size;
      var css = (0,commons__WEBPACK_IMPORTED_MODULE_2__.collectTruePropKeys)(this.props, ['rounded', 'circle', 'bordered']);

      if (preset) {
        css.push(preset);
      } else {
        css.push('default');
      }

      if (size) {
        css.push(size);
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, [class_name])),
        id: id || identity,
        style: style,
        disabled: disabled,
        onClick: function onClick() {
          return _this.props.updateAspects({
            clicks: _this.props.clicks + 1
          });
        }
      }, label);
    }
  }]);

  return Button;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Button.defaultProps = {
  clicks: 0,
  bordered: true
};
Button.propTypes = {
  /**
   * Text or component to display.
   */
  label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),

  /**
   * The number of times the button was clicked.
   */
  clicks: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Class name to give the button.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object to give to the Button.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * DOM id, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Preset style colors to apply.
   */
  preset: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['primary', 'secondary', 'danger', 'warning', 'success']),

  /**
   * Disable the button.
   */
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Round the edges.
   */
  rounded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Circle button
   */
  circle: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add a border
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * The size of the button.
   */
  size: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['tiny', 'small', 'medium', 'large', 'larger', 'x-large', 'xx-large']),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/CheckList.jsx":
/*!**********************************************!*\
  !*** ./src/core/js/components/CheckList.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CheckList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * A list of labels with options, the values aspect get all selected options.
 */

var CheckList = /*#__PURE__*/function (_React$Component) {
  _inherits(CheckList, _React$Component);

  var _super = _createSuper(CheckList);

  function CheckList() {
    _classCallCheck(this, CheckList);

    return _super.apply(this, arguments);
  }

  _createClass(CheckList, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          options = _this$props.options,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          id = _this$props.id,
          labels_class_name = _this$props.labels_class_name,
          inputs_class_name = _this$props.inputs_class_name,
          style = _this$props.style,
          labels_style = _this$props.labels_style,
          options_style = _this$props.options_style;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        id: id || identity,
        style: style
      }, options.map(function (_ref) {
        var label = _ref.label,
            value = _ref.value,
            title = _ref.title,
            label_class_name = _ref.label_class_name,
            input_class_name = _ref.input_class_name;
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
          title: title,
          key: "".concat(identity, "-opt-").concat(value),
          className: label_class_name || labels_class_name,
          style: labels_style
        }, label, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
          type: "checkbox",
          className: input_class_name || inputs_class_name,
          style: options_style,
          onChange: function onChange(e) {
            return _this.props.updateAspects({
              values: e.target.checked ? (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(_this.props.values, [value]) : _this.props.values.filter(function (v) {
                return v !== value;
              })
            });
          }
        }));
      }));
    }
  }]);

  return CheckList;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


CheckList.defaultProps = {
  values: []
};
CheckList.propTypes = {
  /**
   * Items in the checklist with labels, values and elements attributes.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    label_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    input_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Checked values
   */
  values: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)])),

  /**
   * Style object of the container.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Class name of the container.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global class name to give to labels.
   */
  labels_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global labels style objects.
   */
  labels_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Global options class name.
   */
  options_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global style object of options.
   */
  options_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Html id of the component, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Container.jsx":
/*!**********************************************!*\
  !*** ./src/core/js/components/Container.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Container)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Virtual div
 *
 * :CSS:
 *
 *     - ``dazzler-core-container``.
 *     - ``scroll``
 *     - ``flex``
 *     - ``row``
 *     - ``column``
 *     - ``btn``
 *     - ``center``
 *     - ``hidden``
 */

var Container = /*#__PURE__*/function (_React$Component) {
  _inherits(Container, _React$Component);

  var _super = _createSuper(Container);

  function Container() {
    _classCallCheck(this, Container);

    return _super.apply(this, arguments);
  }

  _createClass(Container, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      // Ignore virtual n_clicks don't need a re-render of
      // the whole children.
      return !(this.props.clicks < nextProps.clicks);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          id = _this$props.id,
          class_name = _this$props.class_name,
          style = _this$props.style,
          children = _this$props.children,
          title = _this$props.title,
          identity = _this$props.identity,
          draggable = _this$props.draggable;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: id || identity,
        className: class_name,
        style: style,
        title: title,
        draggable: draggable,
        onClick: function onClick() {
          _this.props.updateAspects({
            clicks: _this.props.clicks + 1
          });
        }
      }, children);
    }
  }]);

  return Container;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Container.defaultProps = {
  clicks: 0
};
Container.propTypes = {
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  draggable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Number of times the container was clicked.
   */
  clicks: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/DataList.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/DataList.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A html datalist (select with autocomplete).
 */

var DataList = /*#__PURE__*/function (_React$Component) {
  _inherits(DataList, _React$Component);

  var _super = _createSuper(DataList);

  function DataList() {
    _classCallCheck(this, DataList);

    return _super.apply(this, arguments);
  }

  _createClass(DataList, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          class_name = _this$props.class_name,
          id = _this$props.id,
          identity = _this$props.identity,
          value = _this$props.value,
          options = _this$props.options,
          title = _this$props.title;
      var list_id = "datalist-".concat(identity);
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        id: id || identity,
        title: title
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
        list: list_id,
        onChange: function onChange(e) {
          var value = e.target.value;
          var data_value = options.reduce(function (data, option) {
            return option.label === value ? option.value : data;
          }, null);

          _this.props.updateAspects({
            value: value,
            data_value: data_value
          });
        },
        value: value
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("datalist", {
        id: list_id
      }, options.map(function (option) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
          value: option.label
        });
      })));
    }
  }]);

  return DataList;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


DataList.defaultProps = {};
DataList.propTypes = {
  /**
   * Options of the datalist.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Unique id for the component.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Value of the text input.
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * The value of the selected option if found.
   */
  data_value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),

  /**
   * Tooltip.
   */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Dropdown.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/Dropdown.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/is.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/includes.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/without.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/filter.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/any.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/values.js");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




var OptionType = {
  label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)]).isRequired,
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};

var DropdownOption = function DropdownOption(props) {
  var label = props.label,
      value = props.value,
      _onClick = props.onClick,
      style = props.style,
      class_name = props.class_name,
      selected = props.selected;
  var className = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var css = ['dropdown-item'];

    if (class_name) {
      css.push(class_name);
    }

    if (selected) {
      css.push('selected');
    }

    return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', css);
  }, [class_name, selected]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: className,
    onClick: function onClick(e) {
      e.stopPropagation();

      _onClick({
        value: value,
        label: label
      });
    },
    style: style
  }, label);
};

DropdownOption.propTypes = _objectSpread(_objectSpread({}, OptionType), {}, {
  onClick: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func),
  selected: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
});

var SelectedItem = function SelectedItem(props) {
  var option = props.option,
      onRemove = props.onRemove;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "drop-selected-item"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "selected-label"
  }, option.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "selected-remover",
    onClick: function onClick(e) {
      e.stopPropagation();
      onRemove(option);
    }
  }, "\u2716"));
};
/**
 * A dropdown to select options from a list.
 *
 * :CSS:
 *
 *     - ``dazzler-core-dropdown``
 *     - ``drop-toggle``
 *     - ``drop-symbol``
 *     - ``drop-container``
 *     - ``drop-item``
 *     - ``drop-selected-item``
 *     - ``selected``
 *     - ``selected-items``
 *     - ``selected-label``
 *     - ``selected-remover``
 *     - ``no-results``
 *     - ``search-content``
 *     - ``dropdown-search-input``
 *     - ``drop-controls``
 *
 * @example
 *
 *      from dazzler.components.core import Dropdown
 *
 *      dropdown = Dropdown(
 *          {'label': 'Option 1', 'value': 1},
            {'label': 'Option 2', 'value': 2}
 *      )
 *
 */


var Dropdown = function Dropdown(props) {
  var options = props.options,
      class_name = props.class_name,
      style = props.style,
      identity = props.identity,
      updateAspects = props.updateAspects,
      toggle_symbol = props.toggle_symbol,
      opened = props.opened,
      multi = props.multi,
      value = props.value,
      searchable = props.searchable,
      search_value = props.search_value,
      search_props = props.search_props,
      search_label = props.search_label,
      search_backend = props.search_backend,
      filtered_options = props.filtered_options,
      no_results_label = props.no_results_label,
      scrollable = props.scrollable,
      scroll_max_size = props.scroll_max_size;
  var mainRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var containerRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var toggleRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var inputRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var searchContentRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var symbolRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var selectedRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null); // Keep them items with labels

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(function () {
    if (value) {
      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, value)) {
        return [{
          value: value,
          label: value
        }];
      }

      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Array, value)) {
        return value;
      }

      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Object, value)) {
        return [value];
      }
    }

    return [];
  }),
      _useState2 = _slicedToArray(_useState, 2),
      selectedItems = _useState2[0],
      setSelectedItems = _useState2[1];

  var containerStyle = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var s = {};
    if (!opened) return s; // TODO orient top or bottom.

    var _toggleRef$current$ge = toggleRef.current.getBoundingClientRect(),
        height = _toggleRef$current$ge.height,
        width = _toggleRef$current$ge.width,
        top = _toggleRef$current$ge.top;

    s.top = "".concat(height, "px");
    s.width = "".concat(width - 1, "px");

    if (scrollable) {
      if (scroll_max_size) {
        s.maxHeight = scroll_max_size;
      } else {
        s.maxHeight = window.innerHeight - top - height - 24;
      }
    }

    return s;
  }, [opened, selectedItems, scrollable, scroll_max_size]);
  var containerCss = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var css = ['drop-container'];

    if (opened) {
      css.push('opened');
    }

    if (scrollable) {
      css.push('scrollable');
    }

    return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', css);
  }, [opened, scrollable]);

  var onItemClick = function onItemClick(option) {
    var itemValue = option.value;
    var payload = {
      opened: false
    };

    if (multi) {
      if ((0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(itemValue, value || [])) {
        payload.value = (0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)([itemValue], value);
        setSelectedItems((0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)([option], selectedItems));
      } else {
        payload.value = (0,ramda__WEBPACK_IMPORTED_MODULE_6__.default)(value || [], [itemValue]);
        setSelectedItems((0,ramda__WEBPACK_IMPORTED_MODULE_6__.default)(selectedItems, [option]));
      }
    } else {
      if (value === itemValue) {
        payload.value = null;
        setSelectedItems((0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)([option], selectedItems));
      } else {
        payload.value = itemValue;
        setSelectedItems([option]);
      }
    }

    updateAspects(payload);
  }; // Search filtering


  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (search_backend) {
      return;
    }

    if (!search_value) {
      updateAspects({
        filtered_options: null
      });
      return;
    }

    var matcher = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(search_value);
    updateAspects({
      filtered_options: (0,ramda__WEBPACK_IMPORTED_MODULE_7__.default)(function (option) {
        if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, option)) {
          return matcher(option);
        }

        if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Object, option)) {
          var isOk = false;

          if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(Object, option.value)) {
            if (search_props && search_props.length) {
              // noinspection JSUnusedLocalSymbols
              isOk = search_props.reduce(function (acc, prop) {
                if (acc) {
                  return acc;
                }

                return matcher(option.value[prop]);
              }, false);
            } else {
              isOk = (0,ramda__WEBPACK_IMPORTED_MODULE_8__.default)(matcher, (0,ramda__WEBPACK_IMPORTED_MODULE_9__.default)(option.value));
            }
          } else if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, option.value)) {
            isOk = matcher(option.value);
          }

          if (search_label) {
            isOk = isOk || matcher(option.label);
          }

          return isOk;
        }

        return false;
      }, options)
    });
  }, [search_value, search_backend, options, search_props, search_label]);
  var onSearch = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (e) {
    var payload = {
      search_value: e.target.value
    };

    if (!opened) {
      payload.opened = true;
    }

    updateAspects(payload);
  }, [updateAspects, opened]);
  var optionsContent = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var opts = filtered_options ? filtered_options : options;

    if (opts.length === 0) {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "no-results"
      }, no_results_label);
    }

    return opts.map(function (option, i) {
      var selected;
      var key = "".concat(identity, "-").concat(i);

      if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(String, option)) {
        selected = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(value, option);
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DropdownOption, {
          label: option,
          value: option,
          key: key,
          selected: selected,
          onClick: onItemClick
        });
      }

      selected = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(value, option.value);
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DropdownOption, _extends({}, option, {
        key: key,
        selected: selected,
        onClick: onItemClick
      }));
    });
  }, [options, filtered_options, value, selectedItems]);
  var onToggle = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
    var open = !opened;
    updateAspects({
      opened: open
    });
    event.stopPropagation();

    if (open) {
      if (searchable) {
        inputRef.current.focus();
      }

      var autoClose = function autoClose() {
        updateAspects({
          opened: false
        });
        document.removeEventListener('click', autoClose);
      };

      document.addEventListener('click', autoClose);
    }
  }, [opened, inputRef]);
  var searchWidth = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    if (!searchContentRef.current) {
      return 9;
    }

    var toggleWidth = toggleRef.current.getBoundingClientRect().width;
    var searchWidth = searchContentRef.current.getBoundingClientRect().width + 9;
    var symbolWidth = symbolRef.current.getBoundingClientRect().width;
    var maxWidth = toggleWidth - symbolWidth - 16;

    if (searchWidth < maxWidth) {
      return searchWidth;
    }

    return maxWidth;
  }, [search_value, selectedItems, filtered_options]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: class_name,
    style: style,
    id: identity,
    ref: mainRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "drop-toggle",
    onClick: onToggle,
    ref: toggleRef
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "drop-controls"
  }, searchable && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "search-content",
    ref: searchContentRef
  }, search_value), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
    value: search_value,
    onChange: onSearch,
    className: "dropdown-search-input",
    ref: inputRef,
    style: {
      width: searchWidth
    }
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: "selected-items",
    ref: selectedRef
  }, multi || searchable ? selectedItems.map(function (item, i) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SelectedItem, {
      option: item,
      onRemove: onItemClick,
      key: "".concat(identity, "-selected-").concat(i)
    });
  }) : selectedItems.length ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DropdownOption, _extends({}, selectedItems[0], {
    selected: true,
    onClick: onToggle
  })) : null)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", {
    className: "drop-symbol",
    ref: symbolRef
  }, toggle_symbol)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: containerCss,
    ref: containerRef,
    style: containerStyle
  }, optionsContent));
};

Dropdown.defaultProps = {
  toggle_symbol: '⏷',
  opened: false,
  filtered_options: null,
  search_value: '',
  no_results_label: 'No results!'
};
Dropdown.propTypes = {
  /**
   * List of options to choose/search from.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape(OptionType), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)])).isRequired,

  /**
   * Currently selected value(s).
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)]),

  /**
   * Allow multiple values to be chosen, the value become a list of values.
   */
  multi: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * If true, render an input
   */
  searchable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Value entered by user to search options.
   */
  search_value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Keys to filter on searching the options.
   *
   * - Leave empty for all props.
   * - Valid values types to search on are strings & arrays.
   * - Nested prop access with dot notation.
   */
  search_props: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)),

  /**
   * Search the label along with the value.
   */
  search_label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Do not perform any search on the options from the frontend and instead
   * relies on binding the ``search_value`` to filter and set the
   * ``filtered_options`` aspect.
   */
  search_backend: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Array of options that are filtered, set from backend with search
   */
  filtered_options: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array),

  /**
   * Is the dropdown currently open ?
   */
  opened: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Label to use when no search results are available.
   */
  no_results_label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Unicode character used as the toggle button.
   */
  toggle_symbol: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Make the menu scrollable.
   */
  scrollable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  scroll_max_size: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dropdown);

/***/ }),

/***/ "./src/core/js/components/Form.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Form.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Form)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A form element with auto fields.
 *
 * :CSS:
 *
 *     - ``dazzler-core-form``
 *     - ``form-header``
 *     - ``form-body``
 *     - ``form-field``
 *     - ``field-error``
 *     - ``form-label``
 *     - ``form-input``
 *     - ``form-footer``
 *     - ``form-submit``
 */

var Form = /*#__PURE__*/function (_React$Component) {
  _inherits(Form, _React$Component);

  var _super = _createSuper(Form);

  function Form() {
    _classCallCheck(this, Form);

    return _super.apply(this, arguments);
  }

  _createClass(Form, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          style = _this$props.style,
          action = _this$props.action,
          method = _this$props.method,
          target = _this$props.target,
          auto_complete = _this$props.auto_complete,
          name = _this$props.name,
          header = _this$props.header,
          fields = _this$props.fields,
          body = _this$props.body,
          footer = _this$props.footer,
          errors = _this$props.errors,
          include_submit = _this$props.include_submit,
          submit_label = _this$props.submit_label;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", {
        id: identity,
        className: class_name,
        style: style,
        action: action,
        method: method,
        target: target,
        autoComplete: auto_complete,
        name: name
      }, header && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "form-header"
      }, header), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "form-body"
      }, fields && fields.map(function (_ref) {
        var label = _ref.label,
            type = _ref.type,
            name = _ref.name,
            component = _ref.component,
            value = _ref.value;
        var error = errors[name];
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: 'form-field' + (error ? ' field-error' : ''),
          key: "form-".concat(identity, "-").concat(name)
        }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
          className: "form-label"
        }, label), component || /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
          name: name,
          type: type,
          className: 'form-input',
          value: value
        }), error && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: "form-error"
        }, error));
      }), body), footer && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "form-footer"
      }, footer), include_submit && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", {
        type: "submit",
        className: "form-submit"
      }, submit_label));
    }
  }]);

  return Form;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Form.defaultProps = {
  include_submit: true,
  submit_label: 'Submit',
  errors: {}
};
Form.propTypes = {
  /**
   * Fields of the form, either provide a component or a type for the input.
   */
  fields: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),
    type: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    component: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any)
  })),

  /**
   * Render on top of the form (CSS: form-header)
   */
  header: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Render in the middle of the form, after the fields. (CSS: form-body)
   */
  body: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Render at the bottom of the form (CSS: form-footer)
   */
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Url to submit the form.
   */
  action: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Http method to submit the form.
   */
  method: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['get', 'post']),

  /**
   * How will the response display.
   */
  target: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['_blank', '_self', '_parent', '_top']),

  /**
   * Name of the form.
   */
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Specifies auto complete for the form.
   */
  auto_complete: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['on', 'off']),

  /**
   * How the data is encode before submit.
   */
  enctype: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['application/x-www-form-urlencoded', 'multipart/form-data', 'text/plain']),

  /**
   * Character encoding for submission.
   */
  accept_charset: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Specify the form should be validated on submission.
   */
  no_validate: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * CSS class of the form element.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the form element.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Errors to show with the fields. Keys are name.
   */
  errors: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Include a submit button on the form.
   */
  include_submit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Label of the submit button.
   */
  submit_label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Grid.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Grid.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Grid)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Render a list in a grid with a number of ``columns``.
 *
 * :CSS:
 *
 *     - ``dazzler-core-grid``
 *     - ``grid-row``
 *     - ``grid-cell``
 *
 * @example
 *
 *     from dazzler.components import core
 *
 *     grid = core.Grid([1, 2, 3, 4], 2)
 */

var Grid = /*#__PURE__*/function (_React$Component) {
  _inherits(Grid, _React$Component);

  var _super = _createSuper(Grid);

  function Grid() {
    _classCallCheck(this, Grid);

    return _super.apply(this, arguments);
  }

  _createClass(Grid, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          children = _this$props.children,
          columns = _this$props.columns;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: identity,
        className: class_name
      }, (0,commons__WEBPACK_IMPORTED_MODULE_2__.chunk)(children, columns).map(function (row, y) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          key: "".concat(identity, "-row-").concat(y),
          className: 'grid-row'
        }, row.map(function (cell, x) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
            key: "".concat(identity, "-cell-").concat(y, "-").concat(x),
            className: 'grid-cell'
          }, cell);
        }));
      }));
    }
  }]);

  return Grid;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Grid.defaultProps = {};
Grid.propTypes = {
  /**
   * Children to render in a grid.
   */
  children: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)).isRequired,

  /**
   * Number of columns
   */
  columns: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Html.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Html.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Html)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/type.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/map.js");
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }






function prepareType(obj) {
  switch ((0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(obj)) {
    case 'String':
    case 'Number':
    case 'Boolean':
    case 'Null':
      return obj;

    case 'Array':
      return obj.map(prepareType).filter(function (e) {
        return (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(e) !== 'Undefined';
      });

    case 'Object':
      return (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(prepareObject, obj);

    default:
      return;
  }
}

function prepareObject(obj) {
  var payload = {};

  for (var k in obj) {
    // noinspection JSUnfilteredForInLoop
    if (!k.startsWith('_')) {
      // noinspection JSUnfilteredForInLoop
      payload[(0,commons__WEBPACK_IMPORTED_MODULE_2__.camelToSnakeCase)(k)] = prepareType(obj[k]);
    }
  }

  return payload;
}
/**
 * Html tag wrapper, give any props as ``attributes``.
 * Listen to events with the readonly event aspect containing the
 * latest event fired.
 */


var Html = /*#__PURE__*/function (_React$Component) {
  _inherits(Html, _React$Component);

  var _super = _createSuper(Html);

  function Html(props) {
    var _this;

    _classCallCheck(this, Html);

    _this = _super.call(this, props);
    _this.onEvent = _this.onEvent.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Html, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      if (this.props.events) {
        this.props.events.forEach(function (e) {
          _this2.element.addEventListener(e, _this2.onEvent);
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var _this3 = this;

      if (this.props.events) {
        this.props.events.forEach(function (e) {
          _this3.element.removeEventListener(e, _this3.onEvent);
        });
      }
    }
  }, {
    key: "onEvent",
    value: function onEvent(e) {
      this.props.updateAspects({
        event: _objectSpread({
          name: e.name
        }, prepareObject(e))
      });
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      // Ignore virtual event don't need a re-render of
      // the whole children.
      return !(this.props.event !== nextProps.event);
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;

      var _this$props = this.props,
          tag = _this$props.tag,
          id = _this$props.id,
          class_name = _this$props.class_name,
          attributes = _this$props.attributes,
          identity = _this$props.identity,
          children = _this$props.children;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement(tag, _objectSpread(_objectSpread({
        id: id || identity,
        className: class_name,
        children: children
      }, attributes), {}, {
        ref: function ref(r) {
          return _this4.element = r;
        }
      }));
    }
  }]);

  return Html;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Html.defaultProps = {};
Html.propTypes = {
  /**
   * Tag name of the component.
   */
  tag: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * Children of the html tag.
   */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Id of the element in DOM.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Class of the element.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Any other html attributes relevant to the html tag
   */
  attributes: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Events to subscribe.
   */
  events: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array),

  /**
   * Last event fired.
   */
  event: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Image.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Image.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Image)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }





/**
 * An image.
 *
 * :CSS:
 *
 *     - ``dazzler-core-image``
 *     - ``bordered``
 *     - ``padded``
 *     - ``rounded``
 *     - ``centered``
 */

var Image = /*#__PURE__*/function (_React$Component) {
  _inherits(Image, _React$Component);

  var _super = _createSuper(Image);

  function Image() {
    _classCallCheck(this, Image);

    return _super.apply(this, arguments);
  }

  _createClass(Image, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return !(this.props.clicks < nextProps.clicks);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          class_name = _this$props.class_name,
          style = _this$props.style,
          identity = _this$props.identity,
          alt = _this$props.alt,
          src = _this$props.src,
          caption = _this$props.caption,
          height = _this$props.height,
          width = _this$props.width,
          cross_origin = _this$props.cross_origin,
          decoding = _this$props.decoding,
          caption_class_name = _this$props.caption_class_name,
          caption_style = _this$props.caption_style,
          link = _this$props.link,
          link_class_name = _this$props.link_class_name,
          link_style = _this$props.link_style,
          figure_class_name = _this$props.figure_class_name,
          figure_style = _this$props.figure_style;
      var css = (0,commons__WEBPACK_IMPORTED_MODULE_2__.collectTruePropKeys)(this.props, ['rounded', 'bordered', 'circle', 'flexible', 'centered', 'padded']);
      var content = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", {
        alt: alt,
        src: src,
        height: height,
        width: width,
        crossOrigin: cross_origin,
        decoding: decoding,
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, [class_name])),
        style: style,
        id: identity,
        onClick: function onClick() {
          return _this.props.updateAspects({
            clicks: _this.props.clicks + 1
          });
        }
      });

      if (link) {
        var linkCss = ['dazzler-core-image-link'];

        if (link_class_name) {
          linkCss.push(link_class_name);
        }

        content = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
          href: link,
          style: link_style,
          className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, linkCss))
        }, content);
      }

      if (caption) {
        var figCss = ['dazzler-core-figure'];
        var capCss = ['dazzler-core-caption'];

        if (figure_class_name) {
          figCss.push(figure_class_name);
        }

        if (caption_class_name) {
          capCss.push(caption_class_name);
        }

        content = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figure", {
          style: figure_style,
          className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, figCss))
        }, content, caption && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("figcaption", {
          className: (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(' ', (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(css, capCss)),
          style: caption_style
        }, caption));
      }

      return content;
    }
  }]);

  return Image;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Image.defaultProps = {
  clicks: 0
};
Image.propTypes = {
  /**
   * The source url of the image.
   */
  src: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * Alt img attribute to show when the browser cannot display the image.
   */
  alt: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * Height in pixel
   */
  height: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Width in pixel
   */
  width: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Link to another page when the image is clicked.
   */
  link: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Text to include beneath the image.
   */
  caption: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Fetch the image with CORS.
   */
  cross_origin: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['anonymous', 'use-credentials']),

  /**
   * Decoding hint for the browser
   */
  decoding: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['sync', 'async', 'auto']),

  /**
   * Preload the image before mount.
   */
  preload: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Times the image was clicked on.
   */
  clicks: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * CSS class to give to root element, (Scoped: dazzler-core-image)
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the root element.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Add bordered style class
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add rounded style class
   */
  rounded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add centered style class for the image to
   * appear in the horizontal middle
   */
  centered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Take up the whole size of the parent container.
   */
  flexible: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Image is a circle
   */
  circle: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add a little padding around the image.
   */
  padded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Style to give to the caption of the image.
   */
  caption_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * CSS class to give to the caption of the image.
   */
  caption_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class to give to figure if caption is provided.
   */
  figure_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object to give to figure if caption is provided.
   */
  figure_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * CSS class to give to the link element.
   */
  link_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object to give to the link.
   */
  link_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Input.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Input.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Input)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/omit.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Html input wrapper.
 */

var Input = /*#__PURE__*/function (_React$Component) {
  _inherits(Input, _React$Component);

  var _super = _createSuper(Input);

  function Input() {
    _classCallCheck(this, Input);

    return _super.apply(this, arguments);
  }

  _createClass(Input, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          id = _this$props.id,
          class_name = _this$props.class_name,
          identity = _this$props.identity,
          type = _this$props.type,
          auto_complete = _this$props.auto_complete,
          auto_focus = _this$props.auto_focus,
          auto_save = _this$props.auto_save,
          auto_correct = _this$props.auto_correct,
          min_length = _this$props.min_length,
          max_length = _this$props.max_length;
      var omitted = ['class_name', 'id', 'identity', 'auto_complete', 'auto_focus', 'auto_save', 'auto_correct', 'min_length', 'updateAspects', 'n_blur', 'n_submit', '_name', '_package'];

      if (type === 'reset') {
        omitted.push('value');
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", _extends({
        id: id || identity,
        className: class_name,
        autoComplete: auto_complete,
        autoFocus: auto_focus,
        autoSave: auto_save,
        autoCorrect: auto_correct,
        minLength: min_length,
        maxLength: max_length
      }, (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(omitted, this.props), {
        onChange: function onChange(e) {
          var payload = {};

          switch (_this.props.type) {
            case 'number':
              payload.value = Number(e.target.value);
              break;

            case 'checkbox':
              payload.checked = e.target.checked;
              break;

            default:
              payload.value = e.target.value;
          }

          _this.props.updateAspects(payload);
        },
        onBlur: function onBlur() {
          return _this.props.updateAspects({
            n_blur: _this.props.n_blur + 1
          });
        },
        onKeyUp: function onKeyUp(e) {
          if (e.key === 'Enter') {
            _this.props.updateAspects({
              n_submit: _this.props.n_submit + 1
            });
          }
        }
      }));
    }
  }]);

  return Input;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Input.defaultProps = {
  value: '',
  n_blur: 0,
  n_submit: 0,
  checked: false
};
Input.propTypes = {
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
  type: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['hidden', 'text', 'number', 'search', 'tel', 'password', 'range', 'email', 'url', 'submit', 'checkbox', 'reset']),
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  pattern: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  auto_complete: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  auto_focus: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  auto_save: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  auto_correct: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  n_blur: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  n_submit: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  min: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  min_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  max_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  max: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
  step: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
  multiple: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  checked: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Interval.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/Interval.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Interval)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Update ``times`` aspect every interval to trigger a binding.
 */

var Interval = /*#__PURE__*/function (_React$Component) {
  _inherits(Interval, _React$Component);

  var _super = _createSuper(Interval);

  function Interval(props) {
    var _this;

    _classCallCheck(this, Interval);

    _this = _super.call(this, props);
    _this.state = {
      intervalId: null
    };
    _this.loop = _this.loop.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Interval, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      this.startLoop();
    }
  }, {
    key: "startLoop",
    value: function startLoop() {
      var timeout = this.props.timeout;
      var intervalId = window.setInterval(this.loop, timeout);
      this.setState({
        intervalId: intervalId
      });
    }
  }, {
    key: "loop",
    value: function loop() {
      if (this.props.active) {
        this.props.updateAspects({
          times: this.props.times + 1
        });
      } else {
        window.clearInterval(this.state.intervalId);
        this.setState({
          intervalId: null
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.state.intervalId) {
        window.clearInterval(this.state.intervalId);
        this.setState({
          intervalId: null
        });
      }
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      if (nextProps.active && !this.props.active) {
        this.startLoop();
      }
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return Interval;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Interval.defaultProps = {
  timeout: 1000,
  times: 0,
  active: true
};
Interval.propTypes = {
  /**
   * The delay between each time.
   */
  timeout: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Number of times the interval was fired.
   */
  times: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Enable/disable the interval loop.
   */
  active: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Link.jsx":
/*!*****************************************!*\
  !*** ./src/core/js/components/Link.jsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Link)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Link to external url or other dazzler page by name.
 *
 * :CSS: ``dazzler-core-link``
 */

var Link = /*#__PURE__*/function (_React$Component) {
  _inherits(Link, _React$Component);

  var _super = _createSuper(Link);

  function Link() {
    _classCallCheck(this, Link);

    return _super.apply(this, arguments);
  }

  _createClass(Link, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          class_name = _this$props.class_name,
          href = _this$props.href,
          children = _this$props.children,
          style = _this$props.style,
          page_name = _this$props.page_name,
          identity = _this$props.identity;
      var url = href;

      if (page_name) {
        url = "".concat(window.dazzler_base_url, "/dazzler/link?page=").concat(encodeURIComponent(page_name));
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", {
        id: id || identity,
        href: url,
        className: class_name,
        style: style
      }, children || page_name || url);
    }
  }]);

  return Link;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Link.defaultProps = {};
Link.propTypes = {
  /**
   * The link destination.
   */
  href: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Text/Component to show as link.
   */
  children: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Id of the html element, othewise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class of the <a> element
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of root <a> element
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Hovered description
   */
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Name of the page to redirect to if the href is not set.
   */
  page_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/ListBox.jsx":
/*!********************************************!*\
  !*** ./src/core/js/components/ListBox.jsx ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/isNil.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/concat.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/slice.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/insert.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/remove.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/mergeAll.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }




/**
 * A component where you can ``add`` items to instead of rendering
 * the whole list again. With an optional max size.
 *
 * :CSS:
 *
 *     - ``dazzler-core-list-box``
 *     - ``vertical``
 *     - ``horizontal``
 *     - ``scrollable``
 *
 * :example:
 *
 * .. literalinclude:: ../../tests/components/pages/list_box.py
 */

var ListBox = function ListBox(_ref) {
  var items = _ref.items,
      max_length = _ref.max_length,
      append = _ref.append,
      prepend = _ref.prepend,
      concat = _ref.concat,
      insert = _ref.insert,
      delete_index = _ref.delete_index,
      scrollable = _ref.scrollable,
      direction = _ref.direction,
      size = _ref.size,
      keep_scroll = _ref.keep_scroll,
      class_name = _ref.class_name,
      style = _ref.style,
      identity = _ref.identity,
      updateAspects = _ref.updateAspects;
  var root = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      toScroll = _useState2[0],
      setToScroll = _useState2[1]; // Operation handlers


  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(append)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(items, [append]);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(1, arr.length, arr);
      }

      updateAspects({
        append: null,
        items: arr
      });

      if (scrollable && keep_scroll) {
        setToScroll(true);
      }
    }
  }, [append, max_length, scrollable, keep_scroll]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(prepend)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)([prepend], items);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(0, arr.length - 1, arr);
      }

      updateAspects({
        prepend: null,
        items: arr
      });
    }
  }, [prepend, max_length, scrollable, keep_scroll]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(concat)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(items, concat);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(arr.length - max_length, arr.length, arr);
      }

      updateAspects({
        concat: null,
        items: arr
      });
    }
  }, [concat]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(insert)) {
      var arr = (0,ramda__WEBPACK_IMPORTED_MODULE_5__.default)(insert.index, insert.item, items);

      if (max_length && arr.length > max_length) {
        arr = (0,ramda__WEBPACK_IMPORTED_MODULE_4__.default)(0, arr.length - 1, arr);
      }

      updateAspects({
        insert: null,
        items: arr
      });
    }
  }, [insert]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!(0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(delete_index)) {
      updateAspects({
        delete_index: null,
        items: (0,ramda__WEBPACK_IMPORTED_MODULE_6__.default)(delete_index, 1, items)
      });
    }
  }, [delete_index]); // Update scrolling.

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (toScroll) {
      if (direction === 'vertical') {
        root.current.scrollTop = root.current.scrollHeight;
      } else {
        root.current.scrollLeft = root.current.scrollWidth;
      }

      setToScroll(false);
    }
  }, [toScroll]); // Render

  var internalStyle = {};
  var css = [class_name, direction];

  if (scrollable) {
    css.push('scrollable');

    if (direction === 'vertical') {
      internalStyle.height = "".concat(size, "px");
    } else {
      internalStyle.width = "".concat(size, "px");
    }
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    className: (0,ramda__WEBPACK_IMPORTED_MODULE_7__.default)(' ', css),
    style: (0,ramda__WEBPACK_IMPORTED_MODULE_8__.default)([style, internalStyle]),
    id: identity,
    ref: root
  }, items);
};

ListBox.defaultProps = {
  items: [],
  direction: 'vertical'
};
ListBox.propTypes = {
  /**
   * List of items to render.
   */
  items: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)).isRequired,

  /**
   * Maximum amount of items in the list, extra items will be popped off.
   */
  max_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Add an item to the end of the list.
   */
  append: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Add an item to the start of the list.
   */
  prepend: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Concatenate another list with the current items.
   */
  concat: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)),

  /**
   * Insert an item at an index position.
   */
  insert: prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    /**
     * Index to insert the item at.
     */
    index: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

    /**
     * Item to insert.
     */
    item: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)
  }),

  /**
   * Delete the item at the index.
   */
  delete_index: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Wether the list box container is scrollable.
   */
  scrollable: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * In which direction the items will be inserted.
   */
  direction: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['vertical', 'horizontal']),

  /**
   * Must be set for the scrollable aspect to work.
   * Height or width in pixels depending on the direction aspect.
   */
  size: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Keep the last appended item in view if scrolling is enabled.
   */
  keep_scroll: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ListBox);

/***/ }),

/***/ "./src/core/js/components/Modal.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Modal.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Modal)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A modal overlay the page with a darkened background.
 *
 * :CSS:
 *
 *     - ``dazzler-core-modal``
 *     - ``modal-overlay``
 *     - ``modal-active``
 *     - ``modal-content``
 *     - ``modal-header``
 *     - ``modal-closer``
 *     - ``modal-body``
 *     - ``modal-footer``
 */

var Modal = /*#__PURE__*/function (_React$Component) {
  _inherits(Modal, _React$Component);

  var _super = _createSuper(Modal);

  function Modal() {
    _classCallCheck(this, Modal);

    return _super.apply(this, arguments);
  }

  _createClass(Modal, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          style = _this$props.style,
          active = _this$props.active,
          body = _this$props.body,
          header = _this$props.header,
          footer = _this$props.footer,
          close_button = _this$props.close_button;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        style: style,
        id: identity
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-overlay".concat(active ? ' modal-active' : ''),
        onClick: function onClick(e) {
          _this.props.updateAspects({
            active: false
          });

          e.stopPropagation();
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-content",
        onClick: function onClick(e) {
          return e.stopPropagation();
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-header"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, header), close_button && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-closer",
        onClick: function onClick() {
          return _this.props.updateAspects({
            active: false
          });
        }
      }, "X")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-body"
      }, body), footer && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "modal-footer"
      }, footer))));
    }
  }]);

  return Modal;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Modal.defaultProps = {
  close_button: true
};
Modal.propTypes = {
  /**
   * Main content of the modal. (css: modal-body)
   */
  body: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node.isRequired),

  /**
   * Appear before the body. (css: modal-header)
   */
  header: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Appear after the body. (css: modal-footer)
   */
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Activate the modal.
   */
  active: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Include a close button in the top right corner of the header.
   */
  close_button: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * CSS class of the modal.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of outer container.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/ProgressBar.jsx":
/*!************************************************!*\
  !*** ./src/core/js/components/ProgressBar.jsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ProgressBar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Simple progress bar support by all browsers.
 *
 * :CSS:
 *
 *     - ``dazzler-core-progress-bar``
 *     - ``progress``
 *     - ``high``
 *     - ``low``
 *     - ``optimum``
 *     - ``striped``
 *     - ``rounded``
 */

var ProgressBar = /*#__PURE__*/function (_React$Component) {
  _inherits(ProgressBar, _React$Component);

  var _super = _createSuper(ProgressBar);

  function ProgressBar() {
    _classCallCheck(this, ProgressBar);

    return _super.apply(this, arguments);
  }

  _createClass(ProgressBar, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          identity = _this$props.identity,
          id = _this$props.id,
          class_name = _this$props.class_name,
          style = _this$props.style,
          value = _this$props.value,
          minimum = _this$props.minimum,
          maximum = _this$props.maximum,
          optimum = _this$props.optimum,
          high = _this$props.high,
          low = _this$props.low,
          striped = _this$props.striped,
          rounded = _this$props.rounded,
          progress_class_name = _this$props.progress_class_name,
          progress_text = _this$props.progress_text;
      var outerClasses = [class_name];
      var innerClasses = ['progress'];

      if (progress_class_name) {
        innerClasses.push(progress_class_name);
      }

      if (high && value >= high) {
        innerClasses.push('high');
      } else if (optimum && value >= optimum) {
        innerClasses.push('optimum');
      } else if (low && value <= low) {
        innerClasses.push('low');
      }

      if (striped) {
        innerClasses.push('striped');
      }

      if (rounded) {
        innerClasses.push('rounded');
        outerClasses.push('rounded');
      }

      var total = maximum - minimum;
      var width = value / total * 100;
      var text = '';

      if (progress_text === 'percent') {
        text = "".concat(width.toFixed(0), " %");
      }

      if (progress_text === 'value') {
        text = "".concat(value, " / ").concat(maximum);
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: id || identity,
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', outerClasses),
        ref: function ref(r) {
          return _this.progress = r;
        },
        style: style,
        onClick: function onClick(e) {
          var x = e.pageX - _this.progress.offsetLeft;
          var y = e.pageY - _this.progress.offsetTop;
          var clicked = x * maximum / _this.progress.offsetWidth;

          _this.props.updateAspects({
            click: {
              x: x,
              y: y,
              value: clicked,
              timestamp: e.timeStamp
            }
          });
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', innerClasses),
        style: {
          width: "".concat(width, "%")
        }
      }, text));
    }
  }]);

  return ProgressBar;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


ProgressBar.defaultProps = {
  value: 0,
  minimum: 0,
  maximum: 100
};
ProgressBar.propTypes = {
  /**
   * The current numeric value. This must be between the minimum and maximum values (min attribute and max attribute) if they are specified. If unspecified or malformed, the value is 0. If specified, but not within the range given by the min attribute and max attribute, the value is equal to the nearest end of the range.
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The lower numeric bound of the measured range. This must be less than the maximum value (max attribute), if specified. If unspecified, the minimum value is 0
   */
  minimum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The upper numeric bound of the measured range. This must be greater than the minimum value (min attribute), if specified. If unspecified, the maximum value is 1.
   */
  maximum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The upper numeric bound of the low end of the measured range. This must be greater than the minimum value (min attribute), and it also must be less than the high value and maximum value (high attribute and max attribute, respectively), if any are specified. If unspecified, or if less than the minimum value, the low value is equal to the minimum value.
   */
  low: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * The lower numeric bound of the high end of the measured range. This must be less than the maximum value (max attribute), and it also must be greater than the low value and minimum value (low attribute and min attribute, respectively), if any are specified. If unspecified, or if greater than the maximum value, the high value is equal to the maximum value.
   */
  high: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * This attribute indicates the optimal numeric value. It must be within the range (as defined by the min attribute and max attribute). When used with the low attribute and high attribute, it gives an indication where along the range is considered preferable. For example, if it is between the min attribute and the low attribute, then the lower range is considered preferred.
   */
  optimum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Id for this component, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class of the outer container.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * CSS class of the inner progress container.
   */
  progress_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style of the component.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Set to show the value on the progress bar.
   */
  progress_text: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['percent', 'value']),

  /**
   * Readonly click event with the value.
   */
  click: prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
    x: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
    y: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),
    timestamp: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)
  }),

  /**
   * Use striped style.
   */
  striped: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Use the rounded style
   */
  rounded: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/RadioList.jsx":
/*!**********************************************!*\
  !*** ./src/core/js/components/RadioList.jsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RadioList)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A radio button list where only a single value can be selected.
 */

var RadioList = /*#__PURE__*/function (_React$Component) {
  _inherits(RadioList, _React$Component);

  var _super = _createSuper(RadioList);

  function RadioList() {
    _classCallCheck(this, RadioList);

    return _super.apply(this, arguments);
  }

  _createClass(RadioList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          value = _this$props.value,
          options = _this$props.options;

      if (value === undefined) {
        this.props.updateAspects({
          value: options[0].value
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props2 = this.props,
          identity = _this$props2.identity,
          id = _this$props2.id,
          options = _this$props2.options,
          class_name = _this$props2.class_name,
          labels_class_name = _this$props2.labels_class_name,
          labels_style = _this$props2.labels_style,
          options_class_name = _this$props2.options_class_name,
          options_style = _this$props2.options_style;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: id || identity,
        className: class_name
      }, options.map(function (_ref) {
        var value = _ref.value,
            label = _ref.label,
            title = _ref.title,
            label_class_name = _ref.label_class_name,
            input_class_name = _ref.input_class_name;
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("label", {
          key: "".concat(identity, "-opt-").concat(value),
          className: label_class_name || labels_class_name,
          style: labels_style
        }, label, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", {
          name: identity,
          type: "radio",
          title: title,
          checked: value === _this.props.value,
          className: input_class_name || options_class_name,
          style: options_style,
          onChange: function onChange() {
            _this.props.updateAspects({
              value: value
            });
          }
        }));
      }));
    }
  }]);

  return RadioList;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


RadioList.defaultProps = {};
RadioList.propTypes = {
  /**
   * Items in the radio list with labels, values and elements attributes.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),
    title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    label_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
    input_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Selected radio button.
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number)]),

  /**
   * Style object of the container.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Class name of the container.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global class name to give to labels.
   */
  labels_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global labels style objects.
   */
  labels_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Global options class name.
   */
  options_class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Global style object of options.
   */
  options_style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Html id of the component, otherwise the identity is used.
   */
  id: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Select.jsx":
/*!*******************************************!*\
  !*** ./src/core/js/components/Select.jsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Select)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * A select
 */

var Select = /*#__PURE__*/function (_React$Component) {
  _inherits(Select, _React$Component);

  var _super = _createSuper(Select);

  function Select() {
    _classCallCheck(this, Select);

    return _super.apply(this, arguments);
  }

  _createClass(Select, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          options = _this$props.options,
          identity = _this$props.identity,
          multi = _this$props.multi,
          class_name = _this$props.class_name,
          placeholder = _this$props.placeholder,
          name = _this$props.name,
          disabled = _this$props.disabled;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", {
        className: class_name,
        id: identity,
        name: name,
        value: this.props.value,
        multiple: multi,
        disabled: disabled,
        placeholder: placeholder,
        onChange: function onChange(e) {
          var value;

          if (multi) {
            var opts = e.target.options;
            value = [];

            for (var i = 0, l = opts.length; i < l; i++) {
              if (opts[i].selected) {
                value.push(options[i].value);
              }
            }
          } else {
            value = options[e.target.selectedIndex].value;
          }

          _this.props.updateAspects({
            value: value
          });
        }
      }, options.map(function (_ref) {
        var value = _ref.value,
            label = _ref.label;
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", {
          key: "".concat(identity, "-option-").concat(value),
          className: '.dazzler-core-option',
          value: value
        }, label);
      }));
    }
  }]);

  return Select;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Select.defaultProps = {};
Select.propTypes = {
  /**
   * Option of the select.
   */
  options: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().shape({
    value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)]),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
  })).isRequired,

  /**
   * Controls wether multiple options can be selected.
   */
  multi: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Value of the selected option(s)
   */
  value: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().number), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)]))]),

  /**
   * Size of the options to use instead of
   */
  size: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * CSS class of the Select
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Placeholder text when the input has no value.
   */
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * name of the html input that will be created with the current value
   */
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Disable the component.
   */
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Slider.jsx":
/*!*******************************************!*\
  !*** ./src/core/js/components/Slider.jsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Slider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons */ "./src/commons/js/index.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * A slider with a caret contained within a min and max value.
 *
 * :CSS:
 *
 *     - ``dazzler-core-slider``
 *     - ``slider-area``: The outer div of the slider.
 *     - ``slider-handle``: The drag handle
 *     - ``slider-spacer``: The space that is before the handle.
 *
 * :Example:
 *
 * .. literalinclude:: ../../tests/components/pages/slider.py
 *     :lines: 5-43
 */

var Slider = /*#__PURE__*/function (_React$Component) {
  _inherits(Slider, _React$Component);

  var _super = _createSuper(Slider);

  function Slider(props) {
    var _this;

    _classCallCheck(this, Slider);

    _this = _super.call(this, props);
    _this.onDragStart = _this.onDragStart.bind(_assertThisInitialized(_this));
    _this.onDragEnd = _this.onDragEnd.bind(_assertThisInitialized(_this));
    _this.handleDrag = (0,commons__WEBPACK_IMPORTED_MODULE_2__.debounce)(_this.handleDrag, _this.props.debounce);
    _this.onDragOver = _this.onDragOver.bind(_assertThisInitialized(_this));
    _this.state = {
      dragging: false
    };
    _this.dragX = 0;
    return _this;
  }

  _createClass(Slider, [{
    key: "onDragStart",
    value: function onDragStart(e) {
      this.setState({
        dragging: true
      });
      e.nativeEvent.dataTransfer.setData('application/node type', this._draggable); // Put a event listener on document dragover for the time of the
      // drag, hate on you IE and Firefox.
      // Needs to be document otherwise you can only drag over anchor.

      document.addEventListener('dragover', this.onDragOver);
    }
  }, {
    key: "handleDrag",
    value: function handleDrag(pageX) {
      // Some basic math, get the position of the x relative to the root.
      // The percentage is the x / width of the root
      // then the value is equal to  minimum + percent * range width
      var _this$props = this.props,
          minimum = _this$props.minimum,
          maximum = _this$props.maximum,
          round = _this$props.round;
      var x = pageX - this._root.offsetLeft;
      var percentage = x / this._root.offsetWidth;
      var width = maximum - minimum;
      var value = minimum + percentage * width;

      if (value > maximum) {
        value = maximum;
      }

      if (value < minimum) {
        value = minimum;
      }

      if (round === 'ceil') {
        value = Math.ceil(value);
      } else if (round === 'floor') {
        value = Math.floor(value);
      }

      this.props.updateAspects({
        value: value
      });
    }
  }, {
    key: "onDragEnd",
    value: function onDragEnd() {
      this.setState({
        dragging: false
      });
      document.removeEventListener('dragover', this.onDragOver); // Handle the last event, otherwise can't get the max/min values.

      this.handleDrag(this.dragX);
    }
  }, {
    key: "onDragOver",
    value: function onDragOver(e) {
      this.handleDrag(e.pageX);
      this.dragX = e.pageX;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          class_name = _this$props2.class_name,
          identity = _this$props2.identity,
          minimum = _this$props2.minimum,
          maximum = _this$props2.maximum,
          value = _this$props2.value,
          style = _this$props2.style;
      var dragging = this.state.dragging;
      var total = maximum - minimum;
      var width = (value - minimum) / total * 100;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: class_name,
        id: identity,
        style: style
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "slider-area",
        ref: function ref(r) {
          return _this2._root = r;
        }
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "slider-spacer",
        style: {
          width: "".concat(width, "%")
        }
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "slider-handle".concat(dragging ? ' dragged' : ''),
        draggable: true,
        onDragStart: this.onDragStart,
        onDragEnd: this.onDragEnd,
        ref: function ref(r) {
          return _this2._draggable = r;
        }
      })));
    }
  }]);

  return Slider;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Slider.defaultProps = {
  value: 0,
  debounce: 50
};
Slider.propTypes = {
  /**
   * Minimum (leftmost) value of the slider.
   */
  minimum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /**
   * Maximum (rightmost) value of the slider.
   */
  maximum: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number.isRequired),

  /**
   * Current value
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Round the value
   */
  round: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['ceil', 'floor']),

  /**
   * Time in milliseconds to wait before updating the value.
   */
  debounce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * CSS classes to use. (Scope: dazzler-core-slider)
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the root div.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Store.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Store.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Store)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



/**
 * Store data in the browser memory. Data last until the page is refreshed.
 */

var Store = /*#__PURE__*/function (_React$Component) {
  _inherits(Store, _React$Component);

  var _super = _createSuper(Store);

  function Store() {
    _classCallCheck(this, Store);

    return _super.apply(this, arguments);
  }

  _createClass(Store, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState, nextContext) {
      return false;
    }
  }, {
    key: "render",
    value: function render() {
      return null;
    }
  }]);

  return Store;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Store.defaultProps = {};
Store.propTypes = {
  /**
   * Stored data.
   */
  data: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().any),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/Table.jsx":
/*!******************************************!*\
  !*** ./src/core/js/components/Table.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Table)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Display data in a tabular manner (Non interactive).
 *
 * :CSS:
 *
 *     - ``dazzler-core-table``
 *     - ``table-head``
 *     - ``table-heading``
 *     - ``table-body``
 *     - ``table-row``
 *     - ``table-cell``
 *     - ``table-footer``
 *
 * :Example:
 *
 * .. literalinclude:: ../../tests/components/pages/table.py
 *     :lines: 5-22
 */

var Table = /*#__PURE__*/function (_React$Component) {
  _inherits(Table, _React$Component);

  var _super = _createSuper(Table);

  function Table() {
    _classCallCheck(this, Table);

    return _super.apply(this, arguments);
  }

  _createClass(Table, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          identity = _this$props.identity,
          class_name = _this$props.class_name,
          headers = _this$props.headers,
          rows = _this$props.rows,
          footer = _this$props.footer,
          style = _this$props.style,
          caption = _this$props.caption,
          include_row_number = _this$props.include_row_number,
          row_number_start = _this$props.row_number_start,
          default_table = _this$props.default_table,
          collapsed = _this$props.collapsed,
          centered = _this$props.centered,
          bordered = _this$props.bordered,
          size = _this$props.size;
      var c = [class_name];

      if (default_table) {
        c.push('default-table');
      }

      if (collapsed) {
        c.push('collapsed');
      }

      if (centered) {
        c.push('centered');
      }

      if (bordered) {
        c.push('bordered');
      }

      if (size) {
        c.push(size);
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("table", {
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', c),
        id: identity,
        style: style
      }, caption && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("caption", {
        className: 'table-title'
      }, caption), headers && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("thead", {
        className: "table-head"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tr", null, include_row_number && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", {
        className: 'table-heading row-num'
      }), headers.map(function (header, i) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", {
          key: "".concat(identity, "-header-").concat(i),
          className: 'table-heading'
        }, header);
      }, headers))), rows && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tbody", {
        className: 'table-body'
      }, rows.map(function (row, i) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tr", {
          key: "".concat(identity, "-row-").concat(i),
          className: 'table-row'
        }, include_row_number && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", {
          className: 'table-cell row-num'
        }, row_number_start + i), row.map(function (cell, j) {
          return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("td", {
            key: "".concat(identity, "-cell-").concat(j, "x").concat(i),
            className: 'table-cell'
          }, cell);
        }));
      })), footer && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tfoot", {
        className: "table-footer"
      }, footer));
    }
  }]);

  return Table;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


Table.defaultProps = {
  default_table: true,
  collapsed: true
};
Table.propTypes = {
  /**
   * Rows of data or components to display.
   */
  rows: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node))),

  /**
   * Title of the table
   */
  caption: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Table headings
   */
  headers: prop_types__WEBPACK_IMPORTED_MODULE_1___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)),

  /**
   * CSS class of the table.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style of the table element.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Content of tfoot element (.table-footer)
   */
  footer: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().node),

  /**
   * Each row start with the row number.
   */
  include_row_number: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * The start of the row number, useful if paged.
   */
  row_number_start: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Apply default style.
   */
  default_table: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Collapse the borders of the table.
   */
  collapsed: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Center the cell
   */
  centered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Put a border around elements
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * The size of the table.
   */
  size: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['tiny', 'small', 'medium', 'large', 'larger', 'x-large', 'xx-large']),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/TextArea.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/TextArea.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextArea)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/join.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Html Textarea wrapper.
 *
 * :CSS:
 *
 *     - ``dazzler-core-text-area``
 *     - ``autosize``
 */

var TextArea = /*#__PURE__*/function (_React$Component) {
  _inherits(TextArea, _React$Component);

  var _super = _createSuper(TextArea);

  function TextArea() {
    _classCallCheck(this, TextArea);

    return _super.apply(this, arguments);
  }

  _createClass(TextArea, [{
    key: "resize",
    value: function resize() {
      this.elem.style.height = 'auto';
      this.elem.style.height = "".concat(this.elem.scrollHeight, "px");
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.autosize) {
        this.resize();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          value = _this$props.value,
          identity = _this$props.identity,
          cols = _this$props.cols,
          rows = _this$props.rows,
          name = _this$props.name,
          required = _this$props.required,
          class_name = _this$props.class_name,
          style = _this$props.style,
          autosize = _this$props.autosize;
      var css = [class_name];

      if (autosize) {
        css.push('autosize');
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", {
        name: name,
        id: identity,
        cols: cols,
        rows: rows,
        value: value,
        required: required,
        ref: function ref(r) {
          return _this.elem = r;
        },
        className: (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(' ', css),
        style: _objectSpread({}, style),
        onChange: function onChange(e) {
          _this.props.updateAspects({
            value: e.target.value
          });

          if (autosize) {
            _this.resize();
          }
        }
      });
    }
  }]);

  return TextArea;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


TextArea.defaultProps = {};
TextArea.propTypes = {
  /**
   * Current value of the textarea
   */
  value: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Name of the element for forms.
   */
  name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Number of columns.
   */
  cols: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Number of rows.
   */
  rows: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Is it required in a form.
   */
  required: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Is it disabled ?
   */
  disabled: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Hint when no value is entered.
   */
  placeholder: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Max length of the value.
   */
  max_length: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().number),

  /**
   * Auto size the
   */
  autosize: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./src/core/js/components/ViewPort.jsx":
/*!*********************************************!*\
  !*** ./src/core/js/components/ViewPort.jsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ViewPort)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/keys.js");
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ramda */ "./node_modules/ramda/es/toPairs.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




/**
 * Activate a view with key.
 *
 * Standalone or tabbed.
 *
 * :CSS:
 *
 *     - ``dazzler-core-view-port``
 *     - ``view-content``
 *     - ``dazzler-tab``
 *     - ``dazzler-tabs``
 *     - ``tab-active``
 */

var ViewPort = /*#__PURE__*/function (_React$Component) {
  _inherits(ViewPort, _React$Component);

  var _super = _createSuper(ViewPort);

  function ViewPort() {
    _classCallCheck(this, ViewPort);

    return _super.apply(this, arguments);
  }

  _createClass(ViewPort, [{
    key: "render",
    value: function render() {
      var _this = this;

      var _this$props = this.props,
          active = _this$props.active,
          views = _this$props.views,
          class_name = _this$props.class_name,
          style = _this$props.style,
          identity = _this$props.identity,
          tabbed = _this$props.tabbed,
          tab_labels = _this$props.tab_labels,
          vertical_tabs = _this$props.vertical_tabs,
          rounded_tabs = _this$props.rounded_tabs,
          bordered = _this$props.bordered;
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        id: identity,
        className: class_name,
        style: style
      }, tabbed && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "dazzler-tabs".concat(vertical_tabs ? ' vertical' : '').concat(rounded_tabs ? ' rounded' : '')
      }, (0,ramda__WEBPACK_IMPORTED_MODULE_2__.default)(views).map(function (k) {
        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: "dazzler-tab".concat(k === active ? ' tab-active' : '').concat(rounded_tabs ? ' rounded' : ''),
          key: "".concat(identity, "-tab-").concat(k),
          onClick: function onClick() {
            return _this.props.updateAspects({
              active: k
            });
          }
        }, tab_labels[k] || k);
      }), rounded_tabs && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "filler"
      })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
        className: "view-content".concat(bordered ? ' bordered' : '').concat(rounded_tabs ? ' rounded' : '')
      }, (0,ramda__WEBPACK_IMPORTED_MODULE_3__.default)(views).map(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            k = _ref2[0],
            v = _ref2[1];

        return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
          className: k === active ? 'dazzler-view' : 'dazzler-view hidden',
          key: "".concat(identity, "-view-").concat(k)
        }, v);
      })));
    }
  }]);

  return ViewPort;
}((react__WEBPACK_IMPORTED_MODULE_0___default().Component));


ViewPort.defaultProps = {};
ViewPort.propTypes = {
  /**
   * The view that is active.
   */
  active: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string.isRequired),

  /**
   * A dictionary of components to render with the active key.
   */
  views: prop_types__WEBPACK_IMPORTED_MODULE_1___default().objectOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().node)).isRequired,

  /**
   * The class name of the outer div.
   */
  class_name: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Style object of the outer div.
   */
  style: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object),

  /**
   * Incorporate tabs before the views.
   */
  tabbed: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Labels for the tabs otherwise the tab keys will be used.
   */
  tab_labels: prop_types__WEBPACK_IMPORTED_MODULE_1___default().objectOf((prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)),

  /**
   * Make the tabs vertical aligned.
   */
  vertical_tabs: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Round tab style
   */
  rounded_tabs: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   * Add a border around the viewport content (CSS bordered).
   */
  bordered: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),

  /**
   *  Unique id for this component
   */
  identity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),

  /**
   * Update aspects on the backend.
   */
  updateAspects: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};

/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/commons/scss/index.scss":
/*!************************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/commons/scss/index.scss ***!
  \************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/core/scss/index.scss":
/*!*********************************************************************************************************************************************************************!*\
  !*** ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/core/scss/index.scss ***!
  \*********************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/object-assign/index.js":
/*!*********************************************!*\
  !*** ./node_modules/object-assign/index.js ***!
  \*********************************************/
/***/ ((module) => {

"use strict";
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/


/* eslint-disable no-unused-vars */
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
	if (val === null || val === undefined) {
		throw new TypeError('Object.assign cannot be called with null or undefined');
	}

	return Object(val);
}

function shouldUseNative() {
	try {
		if (!Object.assign) {
			return false;
		}

		// Detect buggy property enumeration order in older V8 versions.

		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
		test1[5] = 'de';
		if (Object.getOwnPropertyNames(test1)[0] === '5') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test2 = {};
		for (var i = 0; i < 10; i++) {
			test2['_' + String.fromCharCode(i)] = i;
		}
		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
			return test2[n];
		});
		if (order2.join('') !== '0123456789') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test3 = {};
		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
			test3[letter] = letter;
		});
		if (Object.keys(Object.assign({}, test3)).join('') !==
				'abcdefghijklmnopqrst') {
			return false;
		}

		return true;
	} catch (err) {
		// We don't expect any of the above to throw, but better to be safe.
		return false;
	}
}

module.exports = shouldUseNative() ? Object.assign : function (target, source) {
	var from;
	var to = toObject(target);
	var symbols;

	for (var s = 1; s < arguments.length; s++) {
		from = Object(arguments[s]);

		for (var key in from) {
			if (hasOwnProperty.call(from, key)) {
				to[key] = from[key];
			}
		}

		if (getOwnPropertySymbols) {
			symbols = getOwnPropertySymbols(from);
			for (var i = 0; i < symbols.length; i++) {
				if (propIsEnumerable.call(from, symbols[i])) {
					to[symbols[i]] = from[symbols[i]];
				}
			}
		}
	}

	return to;
};


/***/ }),

/***/ "./node_modules/prop-types/checkPropTypes.js":
/*!***************************************************!*\
  !*** ./node_modules/prop-types/checkPropTypes.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var printWarning = function() {};

if (true) {
  var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "./node_modules/prop-types/lib/ReactPropTypesSecret.js");
  var loggedTypeFailures = {};
  var has = Function.call.bind(Object.prototype.hasOwnProperty);

  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if (true) {
    for (var typeSpecName in typeSpecs) {
      if (has(typeSpecs, typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          if (typeof typeSpecs[typeSpecName] !== 'function') {
            var err = Error(
              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'
            );
            err.name = 'Invariant Violation';
            throw err;
          }
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
        } catch (ex) {
          error = ex;
        }
        if (error && !(error instanceof Error)) {
          printWarning(
            (componentName || 'React class') + ': type specification of ' +
            location + ' `' + typeSpecName + '` is invalid; the type checker ' +
            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
            'You may have forgotten to pass an argument to the type checker ' +
            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
            'shape all require an argument).'
          );
        }
        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;

          var stack = getStack ? getStack() : '';

          printWarning(
            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
          );
        }
      }
    }
  }
}

/**
 * Resets warning cache when testing.
 *
 * @private
 */
checkPropTypes.resetWarningCache = function() {
  if (true) {
    loggedTypeFailures = {};
  }
}

module.exports = checkPropTypes;


/***/ }),

/***/ "./node_modules/prop-types/factoryWithTypeCheckers.js":
/*!************************************************************!*\
  !*** ./node_modules/prop-types/factoryWithTypeCheckers.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactIs = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");
var assign = __webpack_require__(/*! object-assign */ "./node_modules/object-assign/index.js");

var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "./node_modules/prop-types/lib/ReactPropTypesSecret.js");
var checkPropTypes = __webpack_require__(/*! ./checkPropTypes */ "./node_modules/prop-types/checkPropTypes.js");

var has = Function.call.bind(Object.prototype.hasOwnProperty);
var printWarning = function() {};

if (true) {
  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

function emptyFunctionThatReturnsNull() {
  return null;
}

module.exports = function(isValidElement, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    elementType: createElementTypeTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker,
    exact: createStrictShapeTypeChecker,
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (true) {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          var err = new Error(
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
          err.name = 'Invariant Violation';
          throw err;
        } else if ( true && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            printWarning(
              'You are manually calling a React.PropTypes validation ' +
              'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunctionThatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!ReactIs.isValidElementType(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      if (true) {
        if (arguments.length > 1) {
          printWarning(
            'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
            'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
          );
        } else {
          printWarning('Invalid argument supplied to oneOf, expected an array.');
        }
      }
      return emptyFunctionThatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
        var type = getPreciseType(value);
        if (type === 'symbol') {
          return String(value);
        }
        return value;
      });
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (has(propValue, key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
       true ? printWarning('Invalid argument supplied to oneOfType, expected an instance of array.') : 0;
      return emptyFunctionThatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        printWarning(
          'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
          'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
        );
        return emptyFunctionThatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createStrictShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      // We need to check all keys in case some are required but missing from
      // props.
      var allKeys = assign({}, props[propName], shapeTypes);
      for (var key in allKeys) {
        var checker = shapeTypes[key];
        if (!checker) {
          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
            '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
            '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
          );
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);
        if (error) {
          return error;
        }
      }
      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // falsy value can't be a Symbol
    if (!propValue) {
      return false;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes;
  ReactPropTypes.resetWarningCache = checkPropTypes.resetWarningCache;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ "./node_modules/prop-types/index.js":
/*!******************************************!*\
  !*** ./node_modules/prop-types/index.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (true) {
  var ReactIs = __webpack_require__(/*! react-is */ "./node_modules/react-is/index.js");

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = __webpack_require__(/*! ./factoryWithTypeCheckers */ "./node_modules/prop-types/factoryWithTypeCheckers.js")(ReactIs.isElement, throwOnDirectAccess);
} else {}


/***/ }),

/***/ "./node_modules/prop-types/lib/ReactPropTypesSecret.js":
/*!*************************************************************!*\
  !*** ./node_modules/prop-types/lib/ReactPropTypesSecret.js ***!
  \*************************************************************/
/***/ ((module) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ "./node_modules/ramda/es/any.js":
/*!**************************************!*\
  !*** ./node_modules/ramda/es/any.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_dispatchable.js */ "./node_modules/ramda/es/internal/_dispatchable.js");
/* harmony import */ var _internal_xany_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_xany.js */ "./node_modules/ramda/es/internal/_xany.js");




/**
 * Returns `true` if at least one of the elements of the list match the predicate,
 * `false` otherwise.
 *
 * Dispatches to the `any` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig (a -> Boolean) -> [a] -> Boolean
 * @param {Function} fn The predicate function.
 * @param {Array} list The array to consider.
 * @return {Boolean} `true` if the predicate is satisfied by at least one element, `false`
 *         otherwise.
 * @see R.all, R.none, R.transduce
 * @example
 *
 *      const lessThan0 = R.flip(R.lt)(0);
 *      const lessThan2 = R.flip(R.lt)(2);
 *      R.any(lessThan0)([1, 2]); //=> false
 *      R.any(lessThan2)([1, 2]); //=> true
 */
var any = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__.default)(['any'], _internal_xany_js__WEBPACK_IMPORTED_MODULE_2__.default, function any(fn, list) {
  var idx = 0;
  while (idx < list.length) {
    if (fn(list[idx])) {
      return true;
    }
    idx += 1;
  }
  return false;
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (any);

/***/ }),

/***/ "./node_modules/ramda/es/bind.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/bind.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_arity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_arity.js */ "./node_modules/ramda/es/internal/_arity.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");



/**
 * Creates a function that is bound to a context.
 * Note: `R.bind` does not provide the additional argument-binding capabilities of
 * [Function.prototype.bind](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).
 *
 * @func
 * @memberOf R
 * @since v0.6.0
 * @category Function
 * @category Object
 * @sig (* -> *) -> {*} -> (* -> *)
 * @param {Function} fn The function to bind to context
 * @param {Object} thisObj The context to bind `fn` to
 * @return {Function} A function that will execute in the context of `thisObj`.
 * @see R.partial
 * @example
 *
 *      const log = R.bind(console.log, console);
 *      R.pipe(R.assoc('a', 2), R.tap(log), R.assoc('a', 3))({a: 1}); //=> {a: 3}
 *      // logs {a: 2}
 * @symb R.bind(f, o)(a, b) = f.call(o, a, b)
 */
var bind = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function bind(fn, thisObj) {
  return (0,_internal_arity_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn.length, function () {
    return fn.apply(thisObj, arguments);
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (bind);

/***/ }),

/***/ "./node_modules/ramda/es/concat.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/concat.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");
/* harmony import */ var _internal_isFunction_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./internal/_isFunction.js */ "./node_modules/ramda/es/internal/_isFunction.js");
/* harmony import */ var _internal_isString_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_isString.js */ "./node_modules/ramda/es/internal/_isString.js");
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toString.js */ "./node_modules/ramda/es/toString.js");






/**
 * Returns the result of concatenating the given lists or strings.
 *
 * Note: `R.concat` expects both arguments to be of the same type,
 * unlike the native `Array.prototype.concat` method. It will throw
 * an error if you `concat` an Array with a non-Array value.
 *
 * Dispatches to the `concat` method of the first argument, if present.
 * Can also concatenate two members of a [fantasy-land
 * compatible semigroup](https://github.com/fantasyland/fantasy-land#semigroup).
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig [a] -> [a] -> [a]
 * @sig String -> String -> String
 * @param {Array|String} firstList The first list
 * @param {Array|String} secondList The second list
 * @return {Array|String} A list consisting of the elements of `firstList` followed by the elements of
 * `secondList`.
 *
 * @example
 *
 *      R.concat('ABC', 'DEF'); // 'ABCDEF'
 *      R.concat([4, 5, 6], [1, 2, 3]); //=> [4, 5, 6, 1, 2, 3]
 *      R.concat([], []); //=> []
 */
var concat = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function concat(a, b) {
  if ((0,_internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__.default)(a)) {
    if ((0,_internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__.default)(b)) {
      return a.concat(b);
    }
    throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_2__.default)(b) + ' is not an array');
  }
  if ((0,_internal_isString_js__WEBPACK_IMPORTED_MODULE_3__.default)(a)) {
    if ((0,_internal_isString_js__WEBPACK_IMPORTED_MODULE_3__.default)(b)) {
      return a + b;
    }
    throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_2__.default)(b) + ' is not a string');
  }
  if (a != null && (0,_internal_isFunction_js__WEBPACK_IMPORTED_MODULE_4__.default)(a['fantasy-land/concat'])) {
    return a['fantasy-land/concat'](b);
  }
  if (a != null && (0,_internal_isFunction_js__WEBPACK_IMPORTED_MODULE_4__.default)(a.concat)) {
    return a.concat(b);
  }
  throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_2__.default)(a) + ' does not have a method named "concat" or "fantasy-land/concat"');
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (concat);

/***/ }),

/***/ "./node_modules/ramda/es/curryN.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/curryN.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_arity_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_arity.js */ "./node_modules/ramda/es/internal/_arity.js");
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_curryN_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_curryN.js */ "./node_modules/ramda/es/internal/_curryN.js");





/**
 * Returns a curried equivalent of the provided function, with the specified
 * arity. The curried function has two unusual capabilities. First, its
 * arguments needn't be provided one at a time. If `g` is `R.curryN(3, f)`, the
 * following are equivalent:
 *
 *   - `g(1)(2)(3)`
 *   - `g(1)(2, 3)`
 *   - `g(1, 2)(3)`
 *   - `g(1, 2, 3)`
 *
 * Secondly, the special placeholder value [`R.__`](#__) may be used to specify
 * "gaps", allowing partial application of any combination of arguments,
 * regardless of their positions. If `g` is as above and `_` is [`R.__`](#__),
 * the following are equivalent:
 *
 *   - `g(1, 2, 3)`
 *   - `g(_, 2, 3)(1)`
 *   - `g(_, _, 3)(1)(2)`
 *   - `g(_, _, 3)(1, 2)`
 *   - `g(_, 2)(1)(3)`
 *   - `g(_, 2)(1, 3)`
 *   - `g(_, 2)(_, 3)(1)`
 *
 * @func
 * @memberOf R
 * @since v0.5.0
 * @category Function
 * @sig Number -> (* -> a) -> (* -> a)
 * @param {Number} length The arity for the returned function.
 * @param {Function} fn The function to curry.
 * @return {Function} A new, curried function.
 * @see R.curry
 * @example
 *
 *      const sumArgs = (...args) => R.sum(args);
 *
 *      const curriedAddFourNumbers = R.curryN(4, sumArgs);
 *      const f = curriedAddFourNumbers(1, 2);
 *      const g = f(3);
 *      g(4); //=> 10
 */
var curryN = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function curryN(length, fn) {
  if (length === 1) {
    return (0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn);
  }
  return (0,_internal_arity_js__WEBPACK_IMPORTED_MODULE_2__.default)(length, (0,_internal_curryN_js__WEBPACK_IMPORTED_MODULE_3__.default)(length, [], fn));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (curryN);

/***/ }),

/***/ "./node_modules/ramda/es/equals.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/equals.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_equals_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_equals.js */ "./node_modules/ramda/es/internal/_equals.js");



/**
 * Returns `true` if its arguments are equivalent, `false` otherwise. Handles
 * cyclical data structures.
 *
 * Dispatches symmetrically to the `equals` methods of both arguments, if
 * present.
 *
 * @func
 * @memberOf R
 * @since v0.15.0
 * @category Relation
 * @sig a -> b -> Boolean
 * @param {*} a
 * @param {*} b
 * @return {Boolean}
 * @example
 *
 *      R.equals(1, 1); //=> true
 *      R.equals(1, '1'); //=> false
 *      R.equals([1, 2, 3], [1, 2, 3]); //=> true
 *
 *      const a = {}; a.v = a;
 *      const b = {}; b.v = b;
 *      R.equals(a, b); //=> true
 */
var equals = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function equals(a, b) {
  return (0,_internal_equals_js__WEBPACK_IMPORTED_MODULE_1__.default)(a, b, [], []);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (equals);

/***/ }),

/***/ "./node_modules/ramda/es/filter.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/filter.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_dispatchable.js */ "./node_modules/ramda/es/internal/_dispatchable.js");
/* harmony import */ var _internal_filter_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./internal/_filter.js */ "./node_modules/ramda/es/internal/_filter.js");
/* harmony import */ var _internal_isObject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_isObject.js */ "./node_modules/ramda/es/internal/_isObject.js");
/* harmony import */ var _internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./internal/_reduce.js */ "./node_modules/ramda/es/internal/_reduce.js");
/* harmony import */ var _internal_xfilter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_xfilter.js */ "./node_modules/ramda/es/internal/_xfilter.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./keys.js */ "./node_modules/ramda/es/keys.js");








/**
 * Takes a predicate and a `Filterable`, and returns a new filterable of the
 * same type containing the members of the given filterable which satisfy the
 * given predicate. Filterable objects include plain objects or any object
 * that has a filter method such as `Array`.
 *
 * Dispatches to the `filter` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Filterable f => (a -> Boolean) -> f a -> f a
 * @param {Function} pred
 * @param {Array} filterable
 * @return {Array} Filterable
 * @see R.reject, R.transduce, R.addIndex
 * @example
 *
 *      const isEven = n => n % 2 === 0;
 *
 *      R.filter(isEven, [1, 2, 3, 4]); //=> [2, 4]
 *
 *      R.filter(isEven, {a: 1, b: 2, c: 3, d: 4}); //=> {b: 2, d: 4}
 */
var filter = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__.default)(['filter'], _internal_xfilter_js__WEBPACK_IMPORTED_MODULE_2__.default, function (pred, filterable) {
  return (0,_internal_isObject_js__WEBPACK_IMPORTED_MODULE_3__.default)(filterable) ? (0,_internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__.default)(function (acc, key) {
    if (pred(filterable[key])) {
      acc[key] = filterable[key];
    }
    return acc;
  }, {}, (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(filterable)) :
  // else
  (0,_internal_filter_js__WEBPACK_IMPORTED_MODULE_6__.default)(pred, filterable);
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (filter);

/***/ }),

/***/ "./node_modules/ramda/es/flip.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/flip.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _curryN_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./curryN.js */ "./node_modules/ramda/es/curryN.js");



/**
 * Returns a new function much like the supplied one, except that the first two
 * arguments' order is reversed.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Function
 * @sig ((a, b, c, ...) -> z) -> (b -> a -> c -> ... -> z)
 * @param {Function} fn The function to invoke with its first two parameters reversed.
 * @return {*} The result of invoking `fn` with its first two parameters' order reversed.
 * @example
 *
 *      const mergeThree = (a, b, c) => [].concat(a, b, c);
 *
 *      mergeThree(1, 2, 3); //=> [1, 2, 3]
 *
 *      R.flip(mergeThree)(1, 2, 3); //=> [2, 1, 3]
 * @symb R.flip(f)(a, b, c) = f(b, a, c)
 */
var flip = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function flip(fn) {
  return (0,_curryN_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn.length, function (a, b) {
    var args = Array.prototype.slice.call(arguments, 0);
    args[0] = b;
    args[1] = a;
    return fn.apply(this, args);
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (flip);

/***/ }),

/***/ "./node_modules/ramda/es/includes.js":
/*!*******************************************!*\
  !*** ./node_modules/ramda/es/includes.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_includes_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_includes.js */ "./node_modules/ramda/es/internal/_includes.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");



/**
 * Returns `true` if the specified value is equal, in [`R.equals`](#equals)
 * terms, to at least one element of the given list; `false` otherwise.
 * Works also with strings.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig a -> [a] -> Boolean
 * @param {Object} a The item to compare against.
 * @param {Array} list The array to consider.
 * @return {Boolean} `true` if an equivalent item is in the list, `false` otherwise.
 * @see R.any
 * @example
 *
 *      R.includes(3, [1, 2, 3]); //=> true
 *      R.includes(4, [1, 2, 3]); //=> false
 *      R.includes({ name: 'Fred' }, [{ name: 'Fred' }]); //=> true
 *      R.includes([42], [[42]]); //=> true
 *      R.includes('ba', 'banana'); //=>true
 */
var includes = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(_internal_includes_js__WEBPACK_IMPORTED_MODULE_1__.default);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (includes);

/***/ }),

/***/ "./node_modules/ramda/es/insert.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/insert.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry3.js */ "./node_modules/ramda/es/internal/_curry3.js");


/**
 * Inserts the supplied element into the list, at the specified `index`. _Note that

 * this is not destructive_: it returns a copy of the list with the changes.
 * <small>No lists have been harmed in the application of this function.</small>
 *
 * @func
 * @memberOf R
 * @since v0.2.2
 * @category List
 * @sig Number -> a -> [a] -> [a]
 * @param {Number} index The position to insert the element
 * @param {*} elt The element to insert into the Array
 * @param {Array} list The list to insert into
 * @return {Array} A new Array with `elt` inserted at `index`.
 * @example
 *
 *      R.insert(2, 'x', [1,2,3,4]); //=> [1,2,'x',3,4]
 */
var insert = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__.default)(function insert(idx, elt, list) {
  idx = idx < list.length && idx >= 0 ? idx : list.length;
  var result = Array.prototype.slice.call(list, 0);
  result.splice(idx, 0, elt);
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (insert);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_arity.js":
/*!**************************************************!*\
  !*** ./node_modules/ramda/es/internal/_arity.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _arity)
/* harmony export */ });
function _arity(n, fn) {
  /* eslint-disable no-unused-vars */
  switch (n) {
    case 0:
      return function () {
        return fn.apply(this, arguments);
      };
    case 1:
      return function (a0) {
        return fn.apply(this, arguments);
      };
    case 2:
      return function (a0, a1) {
        return fn.apply(this, arguments);
      };
    case 3:
      return function (a0, a1, a2) {
        return fn.apply(this, arguments);
      };
    case 4:
      return function (a0, a1, a2, a3) {
        return fn.apply(this, arguments);
      };
    case 5:
      return function (a0, a1, a2, a3, a4) {
        return fn.apply(this, arguments);
      };
    case 6:
      return function (a0, a1, a2, a3, a4, a5) {
        return fn.apply(this, arguments);
      };
    case 7:
      return function (a0, a1, a2, a3, a4, a5, a6) {
        return fn.apply(this, arguments);
      };
    case 8:
      return function (a0, a1, a2, a3, a4, a5, a6, a7) {
        return fn.apply(this, arguments);
      };
    case 9:
      return function (a0, a1, a2, a3, a4, a5, a6, a7, a8) {
        return fn.apply(this, arguments);
      };
    case 10:
      return function (a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) {
        return fn.apply(this, arguments);
      };
    default:
      throw new Error('First argument to _arity must be a non-negative integer no greater than ten');
  }
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_arrayFromIterator.js":
/*!**************************************************************!*\
  !*** ./node_modules/ramda/es/internal/_arrayFromIterator.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _arrayFromIterator)
/* harmony export */ });
function _arrayFromIterator(iter) {
  var list = [];
  var next;
  while (!(next = iter.next()).done) {
    list.push(next.value);
  }
  return list;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_checkForMethod.js":
/*!***********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_checkForMethod.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _checkForMethod)
/* harmony export */ });
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");


/**
 * This checks whether a function has a [methodname] function. If it isn't an
 * array it will execute that function otherwise it will default to the ramda
 * implementation.
 *
 * @private
 * @param {Function} fn ramda implemtation
 * @param {String} methodname property to check for a custom implementation
 * @return {Object} Whatever the return value of the method is.
 */
function _checkForMethod(methodname, fn) {
  return function () {
    var length = arguments.length;
    if (length === 0) {
      return fn();
    }
    var obj = arguments[length - 1];
    return (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__.default)(obj) || typeof obj[methodname] !== 'function' ? fn.apply(this, arguments) : obj[methodname].apply(obj, Array.prototype.slice.call(arguments, 0, length - 1));
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_complement.js":
/*!*******************************************************!*\
  !*** ./node_modules/ramda/es/internal/_complement.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _complement)
/* harmony export */ });
function _complement(f) {
  return function () {
    return !f.apply(this, arguments);
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curry1.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curry1.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry1)
/* harmony export */ });
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");


/**
 * Optimized internal one-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry1(fn) {
  return function f1(a) {
    if (arguments.length === 0 || (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a)) {
      return f1;
    } else {
      return fn.apply(this, arguments);
    }
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curry2.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curry2.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry2)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");



/**
 * Optimized internal two-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry2(fn) {
  return function f2(a, b) {
    switch (arguments.length) {
      case 0:
        return f2;
      case 1:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? f2 : (0,_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b) {
          return fn(a, _b);
        });
      default:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? f2 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a) {
          return fn(_a, b);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b) {
          return fn(a, _b);
        }) : fn(a, b);
    }
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curry3.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curry3.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry3)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");




/**
 * Optimized internal three-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry3(fn) {
  return function f3(a, b, c) {
    switch (arguments.length) {
      case 0:
        return f3;
      case 1:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? f3 : (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b, _c) {
          return fn(a, _b, _c);
        });
      case 2:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? f3 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a, _c) {
          return fn(_a, b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b, _c) {
          return fn(a, _b, _c);
        }) : (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_c) {
          return fn(a, b, _c);
        });
      default:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? f3 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a, _b) {
          return fn(_a, _b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_a, _c) {
          return fn(_a, b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (_b, _c) {
          return fn(a, _b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(a) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_a) {
          return fn(_a, b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(b) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_b) {
          return fn(a, _b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(c) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__.default)(function (_c) {
          return fn(a, b, _c);
        }) : fn(a, b, c);
    }
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_curryN.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_curryN.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curryN)
/* harmony export */ });
/* harmony import */ var _arity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arity.js */ "./node_modules/ramda/es/internal/_arity.js");
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPlaceholder.js */ "./node_modules/ramda/es/internal/_isPlaceholder.js");



/**
 * Internal curryN function.
 *
 * @private
 * @category Function
 * @param {Number} length The arity of the curried function.
 * @param {Array} received An array of arguments received thus far.
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curryN(length, received, fn) {
  return function () {
    var combined = [];
    var argsIdx = 0;
    var left = length;
    var combinedIdx = 0;
    while (combinedIdx < received.length || argsIdx < arguments.length) {
      var result;
      if (combinedIdx < received.length && (!(0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(received[combinedIdx]) || argsIdx >= arguments.length)) {
        result = received[combinedIdx];
      } else {
        result = arguments[argsIdx];
        argsIdx += 1;
      }
      combined[combinedIdx] = result;
      if (!(0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__.default)(result)) {
        left -= 1;
      }
      combinedIdx += 1;
    }
    return left <= 0 ? fn.apply(this, combined) : (0,_arity_js__WEBPACK_IMPORTED_MODULE_1__.default)(left, _curryN(length, combined, fn));
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_dispatchable.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_dispatchable.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _dispatchable)
/* harmony export */ });
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");
/* harmony import */ var _isTransformer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isTransformer.js */ "./node_modules/ramda/es/internal/_isTransformer.js");



/**
 * Returns a function that dispatches with different strategies based on the
 * object in list position (last argument). If it is an array, executes [fn].
 * Otherwise, if it has a function with one of the given method names, it will
 * execute that function (functor case). Otherwise, if it is a transformer,
 * uses transducer [xf] to return a new transformer (transducer case).
 * Otherwise, it will default to executing [fn].
 *
 * @private
 * @param {Array} methodNames properties to check for a custom implementation
 * @param {Function} xf transducer to initialize if object is transformer
 * @param {Function} fn default ramda implementation
 * @return {Function} A function that dispatches on object in list position
 */
function _dispatchable(methodNames, xf, fn) {
  return function () {
    if (arguments.length === 0) {
      return fn();
    }
    var args = Array.prototype.slice.call(arguments, 0);
    var obj = args.pop();
    if (!(0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__.default)(obj)) {
      var idx = 0;
      while (idx < methodNames.length) {
        if (typeof obj[methodNames[idx]] === 'function') {
          return obj[methodNames[idx]].apply(obj, args);
        }
        idx += 1;
      }
      if ((0,_isTransformer_js__WEBPACK_IMPORTED_MODULE_1__.default)(obj)) {
        var transducer = xf.apply(null, args);
        return transducer(obj);
      }
    }
    return fn.apply(this, arguments);
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_equals.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_equals.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _equals)
/* harmony export */ });
/* harmony import */ var _arrayFromIterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_arrayFromIterator.js */ "./node_modules/ramda/es/internal/_arrayFromIterator.js");
/* harmony import */ var _includesWith_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_includesWith.js */ "./node_modules/ramda/es/internal/_includesWith.js");
/* harmony import */ var _functionName_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_functionName.js */ "./node_modules/ramda/es/internal/_functionName.js");
/* harmony import */ var _has_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_has.js */ "./node_modules/ramda/es/internal/_has.js");
/* harmony import */ var _objectIs_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_objectIs.js */ "./node_modules/ramda/es/internal/_objectIs.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../keys.js */ "./node_modules/ramda/es/keys.js");
/* harmony import */ var _type_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../type.js */ "./node_modules/ramda/es/type.js");








/**
 * private _uniqContentEquals function.
 * That function is checking equality of 2 iterator contents with 2 assumptions
 * - iterators lengths are the same
 * - iterators values are unique
 *
 * false-positive result will be returned for comparision of, e.g.
 * - [1,2,3] and [1,2,3,4]
 * - [1,1,1] and [1,2,3]
 * */

function _uniqContentEquals(aIterator, bIterator, stackA, stackB) {
  var a = (0,_arrayFromIterator_js__WEBPACK_IMPORTED_MODULE_0__.default)(aIterator);
  var b = (0,_arrayFromIterator_js__WEBPACK_IMPORTED_MODULE_0__.default)(bIterator);

  function eq(_a, _b) {
    return _equals(_a, _b, stackA.slice(), stackB.slice());
  }

  // if *a* array contains any element that is not included in *b*
  return !(0,_includesWith_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (b, aItem) {
    return !(0,_includesWith_js__WEBPACK_IMPORTED_MODULE_1__.default)(eq, aItem, b);
  }, b, a);
}

function _equals(a, b, stackA, stackB) {
  if ((0,_objectIs_js__WEBPACK_IMPORTED_MODULE_2__.default)(a, b)) {
    return true;
  }

  var typeA = (0,_type_js__WEBPACK_IMPORTED_MODULE_3__.default)(a);

  if (typeA !== (0,_type_js__WEBPACK_IMPORTED_MODULE_3__.default)(b)) {
    return false;
  }

  if (a == null || b == null) {
    return false;
  }

  if (typeof a['fantasy-land/equals'] === 'function' || typeof b['fantasy-land/equals'] === 'function') {
    return typeof a['fantasy-land/equals'] === 'function' && a['fantasy-land/equals'](b) && typeof b['fantasy-land/equals'] === 'function' && b['fantasy-land/equals'](a);
  }

  if (typeof a.equals === 'function' || typeof b.equals === 'function') {
    return typeof a.equals === 'function' && a.equals(b) && typeof b.equals === 'function' && b.equals(a);
  }

  switch (typeA) {
    case 'Arguments':
    case 'Array':
    case 'Object':
      if (typeof a.constructor === 'function' && (0,_functionName_js__WEBPACK_IMPORTED_MODULE_4__.default)(a.constructor) === 'Promise') {
        return a === b;
      }
      break;
    case 'Boolean':
    case 'Number':
    case 'String':
      if (!(typeof a === typeof b && (0,_objectIs_js__WEBPACK_IMPORTED_MODULE_2__.default)(a.valueOf(), b.valueOf()))) {
        return false;
      }
      break;
    case 'Date':
      if (!(0,_objectIs_js__WEBPACK_IMPORTED_MODULE_2__.default)(a.valueOf(), b.valueOf())) {
        return false;
      }
      break;
    case 'Error':
      return a.name === b.name && a.message === b.message;
    case 'RegExp':
      if (!(a.source === b.source && a.global === b.global && a.ignoreCase === b.ignoreCase && a.multiline === b.multiline && a.sticky === b.sticky && a.unicode === b.unicode)) {
        return false;
      }
      break;
  }

  var idx = stackA.length - 1;
  while (idx >= 0) {
    if (stackA[idx] === a) {
      return stackB[idx] === b;
    }
    idx -= 1;
  }

  switch (typeA) {
    case 'Map':
      if (a.size !== b.size) {
        return false;
      }

      return _uniqContentEquals(a.entries(), b.entries(), stackA.concat([a]), stackB.concat([b]));
    case 'Set':
      if (a.size !== b.size) {
        return false;
      }

      return _uniqContentEquals(a.values(), b.values(), stackA.concat([a]), stackB.concat([b]));
    case 'Arguments':
    case 'Array':
    case 'Object':
    case 'Boolean':
    case 'Number':
    case 'String':
    case 'Date':
    case 'Error':
    case 'RegExp':
    case 'Int8Array':
    case 'Uint8Array':
    case 'Uint8ClampedArray':
    case 'Int16Array':
    case 'Uint16Array':
    case 'Int32Array':
    case 'Uint32Array':
    case 'Float32Array':
    case 'Float64Array':
    case 'ArrayBuffer':
      break;
    default:
      // Values of other types are only equal if identical.
      return false;
  }

  var keysA = (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(a);
  if (keysA.length !== (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(b).length) {
    return false;
  }

  var extendedStackA = stackA.concat([a]);
  var extendedStackB = stackB.concat([b]);

  idx = keysA.length - 1;
  while (idx >= 0) {
    var key = keysA[idx];
    if (!((0,_has_js__WEBPACK_IMPORTED_MODULE_6__.default)(key, b) && _equals(b[key], a[key], extendedStackA, extendedStackB))) {
      return false;
    }
    idx -= 1;
  }
  return true;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_filter.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_filter.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _filter)
/* harmony export */ });
function _filter(fn, list) {
  var idx = 0;
  var len = list.length;
  var result = [];

  while (idx < len) {
    if (fn(list[idx])) {
      result[result.length] = list[idx];
    }
    idx += 1;
  }
  return result;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_functionName.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_functionName.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _functionName)
/* harmony export */ });
function _functionName(f) {
  // String(x => x) evaluates to "x => x", so the pattern may not match.
  var match = String(f).match(/^function (\w*)/);
  return match == null ? '' : match[1];
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_has.js":
/*!************************************************!*\
  !*** ./node_modules/ramda/es/internal/_has.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _has)
/* harmony export */ });
function _has(prop, obj) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_includes.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_includes.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _includes)
/* harmony export */ });
/* harmony import */ var _indexOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_indexOf.js */ "./node_modules/ramda/es/internal/_indexOf.js");


function _includes(a, list) {
  return (0,_indexOf_js__WEBPACK_IMPORTED_MODULE_0__.default)(list, a, 0) >= 0;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_includesWith.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_includesWith.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _includesWith)
/* harmony export */ });
function _includesWith(pred, x, list) {
  var idx = 0;
  var len = list.length;

  while (idx < len) {
    if (pred(x, list[idx])) {
      return true;
    }
    idx += 1;
  }
  return false;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_indexOf.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_indexOf.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _indexOf)
/* harmony export */ });
/* harmony import */ var _equals_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../equals.js */ "./node_modules/ramda/es/equals.js");


function _indexOf(list, a, idx) {
  var inf, item;
  // Array.prototype.indexOf doesn't exist below IE9
  if (typeof list.indexOf === 'function') {
    switch (typeof a) {
      case 'number':
        if (a === 0) {
          // manually crawl the list to distinguish between +0 and -0
          inf = 1 / a;
          while (idx < list.length) {
            item = list[idx];
            if (item === 0 && 1 / item === inf) {
              return idx;
            }
            idx += 1;
          }
          return -1;
        } else if (a !== a) {
          // NaN
          while (idx < list.length) {
            item = list[idx];
            if (typeof item === 'number' && item !== item) {
              return idx;
            }
            idx += 1;
          }
          return -1;
        }
        // non-zero numbers can utilise Set
        return list.indexOf(a, idx);

      // all these types can utilise Set
      case 'string':
      case 'boolean':
      case 'function':
      case 'undefined':
        return list.indexOf(a, idx);

      case 'object':
        if (a === null) {
          // null can utilise Set
          return list.indexOf(a, idx);
        }
    }
  }
  // anything else not covered above, defer to R.equals
  while (idx < list.length) {
    if ((0,_equals_js__WEBPACK_IMPORTED_MODULE_0__.default)(list[idx], a)) {
      return idx;
    }
    idx += 1;
  }
  return -1;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isArguments.js":
/*!********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isArguments.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _has_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_has.js */ "./node_modules/ramda/es/internal/_has.js");


var toString = Object.prototype.toString;
var _isArguments = /*#__PURE__*/function () {
  return toString.call(arguments) === '[object Arguments]' ? function _isArguments(x) {
    return toString.call(x) === '[object Arguments]';
  } : function _isArguments(x) {
    return (0,_has_js__WEBPACK_IMPORTED_MODULE_0__.default)('callee', x);
  };
}();

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_isArguments);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isArray.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isArray.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Tests whether or not an object is an array.
 *
 * @private
 * @param {*} val The object to test.
 * @return {Boolean} `true` if `val` is an array, `false` otherwise.
 * @example
 *
 *      _isArray([]); //=> true
 *      _isArray(null); //=> false
 *      _isArray({}); //=> false
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Array.isArray || function _isArray(val) {
  return val != null && val.length >= 0 && Object.prototype.toString.call(val) === '[object Array]';
});

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isArrayLike.js":
/*!********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isArrayLike.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isArray.js */ "./node_modules/ramda/es/internal/_isArray.js");
/* harmony import */ var _isString_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_isString.js */ "./node_modules/ramda/es/internal/_isString.js");




/**
 * Tests whether or not an object is similar to an array.
 *
 * @private
 * @category Type
 * @category List
 * @sig * -> Boolean
 * @param {*} x The object to test.
 * @return {Boolean} `true` if `x` has a numeric length property and extreme indices defined; `false` otherwise.
 * @example
 *
 *      _isArrayLike([]); //=> true
 *      _isArrayLike(true); //=> false
 *      _isArrayLike({}); //=> false
 *      _isArrayLike({length: 10}); //=> false
 *      _isArrayLike({0: 'zero', 9: 'nine', length: 10}); //=> true
 */
var _isArrayLike = /*#__PURE__*/(0,_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function isArrayLike(x) {
  if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__.default)(x)) {
    return true;
  }
  if (!x) {
    return false;
  }
  if (typeof x !== 'object') {
    return false;
  }
  if ((0,_isString_js__WEBPACK_IMPORTED_MODULE_2__.default)(x)) {
    return false;
  }
  if (x.nodeType === 1) {
    return !!x.length;
  }
  if (x.length === 0) {
    return true;
  }
  if (x.length > 0) {
    return x.hasOwnProperty(0) && x.hasOwnProperty(x.length - 1);
  }
  return false;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_isArrayLike);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isFunction.js":
/*!*******************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isFunction.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isFunction)
/* harmony export */ });
function _isFunction(x) {
  return Object.prototype.toString.call(x) === '[object Function]';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isObject.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isObject.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isObject)
/* harmony export */ });
function _isObject(x) {
  return Object.prototype.toString.call(x) === '[object Object]';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isPlaceholder.js":
/*!**********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isPlaceholder.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isPlaceholder)
/* harmony export */ });
function _isPlaceholder(a) {
       return a != null && typeof a === 'object' && a['@@functional/placeholder'] === true;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isString.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isString.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isString)
/* harmony export */ });
function _isString(x) {
  return Object.prototype.toString.call(x) === '[object String]';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_isTransformer.js":
/*!**********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_isTransformer.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isTransformer)
/* harmony export */ });
function _isTransformer(obj) {
  return obj != null && typeof obj['@@transducer/step'] === 'function';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_map.js":
/*!************************************************!*\
  !*** ./node_modules/ramda/es/internal/_map.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _map)
/* harmony export */ });
function _map(fn, functor) {
  var idx = 0;
  var len = functor.length;
  var result = Array(len);
  while (idx < len) {
    result[idx] = fn(functor[idx]);
    idx += 1;
  }
  return result;
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_objectAssign.js":
/*!*********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_objectAssign.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _has_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_has.js */ "./node_modules/ramda/es/internal/_has.js");


// Based on https://developer.mozilla.org/en/docs/Web/JavaScript/Reference/Global_Objects/Object/assign
function _objectAssign(target) {
  if (target == null) {
    throw new TypeError('Cannot convert undefined or null to object');
  }

  var output = Object(target);
  var idx = 1;
  var length = arguments.length;
  while (idx < length) {
    var source = arguments[idx];
    if (source != null) {
      for (var nextKey in source) {
        if ((0,_has_js__WEBPACK_IMPORTED_MODULE_0__.default)(nextKey, source)) {
          output[nextKey] = source[nextKey];
        }
      }
    }
    idx += 1;
  }
  return output;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (typeof Object.assign === 'function' ? Object.assign : _objectAssign);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_objectIs.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_objectIs.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Based on https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
function _objectIs(a, b) {
  // SameValue algorithm
  if (a === b) {
    // Steps 1-5, 7-10
    // Steps 6.b-6.e: +0 != -0
    return a !== 0 || 1 / a === 1 / b;
  } else {
    // Step 6.a: NaN == NaN
    return a !== a && b !== b;
  }
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (typeof Object.is === 'function' ? Object.is : _objectIs);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_quote.js":
/*!**************************************************!*\
  !*** ./node_modules/ramda/es/internal/_quote.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _quote)
/* harmony export */ });
function _quote(s) {
  var escaped = s.replace(/\\/g, '\\\\').replace(/[\b]/g, '\\b') // \b matches word boundary; [\b] matches backspace
  .replace(/\f/g, '\\f').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/\t/g, '\\t').replace(/\v/g, '\\v').replace(/\0/g, '\\0');

  return '"' + escaped.replace(/"/g, '\\"') + '"';
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_reduce.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_reduce.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _reduce)
/* harmony export */ });
/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_isArrayLike.js */ "./node_modules/ramda/es/internal/_isArrayLike.js");
/* harmony import */ var _xwrap_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_xwrap.js */ "./node_modules/ramda/es/internal/_xwrap.js");
/* harmony import */ var _bind_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../bind.js */ "./node_modules/ramda/es/bind.js");




function _arrayReduce(xf, acc, list) {
  var idx = 0;
  var len = list.length;
  while (idx < len) {
    acc = xf['@@transducer/step'](acc, list[idx]);
    if (acc && acc['@@transducer/reduced']) {
      acc = acc['@@transducer/value'];
      break;
    }
    idx += 1;
  }
  return xf['@@transducer/result'](acc);
}

function _iterableReduce(xf, acc, iter) {
  var step = iter.next();
  while (!step.done) {
    acc = xf['@@transducer/step'](acc, step.value);
    if (acc && acc['@@transducer/reduced']) {
      acc = acc['@@transducer/value'];
      break;
    }
    step = iter.next();
  }
  return xf['@@transducer/result'](acc);
}

function _methodReduce(xf, acc, obj, methodName) {
  return xf['@@transducer/result'](obj[methodName]((0,_bind_js__WEBPACK_IMPORTED_MODULE_0__.default)(xf['@@transducer/step'], xf), acc));
}

var symIterator = typeof Symbol !== 'undefined' ? Symbol.iterator : '@@iterator';

function _reduce(fn, acc, list) {
  if (typeof fn === 'function') {
    fn = (0,_xwrap_js__WEBPACK_IMPORTED_MODULE_1__.default)(fn);
  }
  if ((0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_2__.default)(list)) {
    return _arrayReduce(fn, acc, list);
  }
  if (typeof list['fantasy-land/reduce'] === 'function') {
    return _methodReduce(fn, acc, list, 'fantasy-land/reduce');
  }
  if (list[symIterator] != null) {
    return _iterableReduce(fn, acc, list[symIterator]());
  }
  if (typeof list.next === 'function') {
    return _iterableReduce(fn, acc, list);
  }
  if (typeof list.reduce === 'function') {
    return _methodReduce(fn, acc, list, 'reduce');
  }

  throw new TypeError('reduce: list must be array or iterable');
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_reduced.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_reduced.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _reduced)
/* harmony export */ });
function _reduced(x) {
  return x && x['@@transducer/reduced'] ? x : {
    '@@transducer/value': x,
    '@@transducer/reduced': true
  };
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_toISOString.js":
/*!********************************************************!*\
  !*** ./node_modules/ramda/es/internal/_toISOString.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Polyfill from <https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toISOString>.
 */
var pad = function pad(n) {
  return (n < 10 ? '0' : '') + n;
};

var _toISOString = typeof Date.prototype.toISOString === 'function' ? function _toISOString(d) {
  return d.toISOString();
} : function _toISOString(d) {
  return d.getUTCFullYear() + '-' + pad(d.getUTCMonth() + 1) + '-' + pad(d.getUTCDate()) + 'T' + pad(d.getUTCHours()) + ':' + pad(d.getUTCMinutes()) + ':' + pad(d.getUTCSeconds()) + '.' + (d.getUTCMilliseconds() / 1000).toFixed(3).slice(2, 5) + 'Z';
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_toISOString);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_toString.js":
/*!*****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_toString.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _toString)
/* harmony export */ });
/* harmony import */ var _includes_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_includes.js */ "./node_modules/ramda/es/internal/_includes.js");
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_map.js */ "./node_modules/ramda/es/internal/_map.js");
/* harmony import */ var _quote_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_quote.js */ "./node_modules/ramda/es/internal/_quote.js");
/* harmony import */ var _toISOString_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_toISOString.js */ "./node_modules/ramda/es/internal/_toISOString.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../keys.js */ "./node_modules/ramda/es/keys.js");
/* harmony import */ var _reject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../reject.js */ "./node_modules/ramda/es/reject.js");







function _toString(x, seen) {
  var recur = function recur(y) {
    var xs = seen.concat([x]);
    return (0,_includes_js__WEBPACK_IMPORTED_MODULE_0__.default)(y, xs) ? '<Circular>' : _toString(y, xs);
  };

  //  mapPairs :: (Object, [String]) -> [String]
  var mapPairs = function (obj, keys) {
    return (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)(function (k) {
      return (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__.default)(k) + ': ' + recur(obj[k]);
    }, keys.slice().sort());
  };

  switch (Object.prototype.toString.call(x)) {
    case '[object Arguments]':
      return '(function() { return arguments; }(' + (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)(recur, x).join(', ') + '))';
    case '[object Array]':
      return '[' + (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)(recur, x).concat(mapPairs(x, (0,_reject_js__WEBPACK_IMPORTED_MODULE_3__.default)(function (k) {
        return (/^\d+$/.test(k)
        );
      }, (0,_keys_js__WEBPACK_IMPORTED_MODULE_4__.default)(x)))).join(', ') + ']';
    case '[object Boolean]':
      return typeof x === 'object' ? 'new Boolean(' + recur(x.valueOf()) + ')' : x.toString();
    case '[object Date]':
      return 'new Date(' + (isNaN(x.valueOf()) ? recur(NaN) : (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__.default)((0,_toISOString_js__WEBPACK_IMPORTED_MODULE_5__.default)(x))) + ')';
    case '[object Null]':
      return 'null';
    case '[object Number]':
      return typeof x === 'object' ? 'new Number(' + recur(x.valueOf()) + ')' : 1 / x === -Infinity ? '-0' : x.toString(10);
    case '[object String]':
      return typeof x === 'object' ? 'new String(' + recur(x.valueOf()) + ')' : (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__.default)(x);
    case '[object Undefined]':
      return 'undefined';
    default:
      if (typeof x.toString === 'function') {
        var repr = x.toString();
        if (repr !== '[object Object]') {
          return repr;
        }
      }
      return '{' + mapPairs(x, (0,_keys_js__WEBPACK_IMPORTED_MODULE_4__.default)(x)).join(', ') + '}';
  }
}

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xany.js":
/*!*************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xany.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _reduced_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_reduced.js */ "./node_modules/ramda/es/internal/_reduced.js");
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_xfBase.js */ "./node_modules/ramda/es/internal/_xfBase.js");




var XAny = /*#__PURE__*/function () {
  function XAny(f, xf) {
    this.xf = xf;
    this.f = f;
    this.any = false;
  }
  XAny.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.init;
  XAny.prototype['@@transducer/result'] = function (result) {
    if (!this.any) {
      result = this.xf['@@transducer/step'](result, false);
    }
    return this.xf['@@transducer/result'](result);
  };
  XAny.prototype['@@transducer/step'] = function (result, input) {
    if (this.f(input)) {
      this.any = true;
      result = (0,_reduced_js__WEBPACK_IMPORTED_MODULE_1__.default)(this.xf['@@transducer/step'](result, true));
    }
    return result;
  };

  return XAny;
}();

var _xany = /*#__PURE__*/(0,_curry2_js__WEBPACK_IMPORTED_MODULE_2__.default)(function _xany(f, xf) {
  return new XAny(f, xf);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_xany);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xfBase.js":
/*!***************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xfBase.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  init: function () {
    return this.xf['@@transducer/init']();
  },
  result: function (result) {
    return this.xf['@@transducer/result'](result);
  }
});

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xfilter.js":
/*!****************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xfilter.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_xfBase.js */ "./node_modules/ramda/es/internal/_xfBase.js");



var XFilter = /*#__PURE__*/function () {
  function XFilter(f, xf) {
    this.xf = xf;
    this.f = f;
  }
  XFilter.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.init;
  XFilter.prototype['@@transducer/result'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.result;
  XFilter.prototype['@@transducer/step'] = function (result, input) {
    return this.f(input) ? this.xf['@@transducer/step'](result, input) : result;
  };

  return XFilter;
}();

var _xfilter = /*#__PURE__*/(0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function _xfilter(f, xf) {
  return new XFilter(f, xf);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_xfilter);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xmap.js":
/*!*************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xmap.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_xfBase.js */ "./node_modules/ramda/es/internal/_xfBase.js");



var XMap = /*#__PURE__*/function () {
  function XMap(f, xf) {
    this.xf = xf;
    this.f = f;
  }
  XMap.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.init;
  XMap.prototype['@@transducer/result'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__.default.result;
  XMap.prototype['@@transducer/step'] = function (result, input) {
    return this.xf['@@transducer/step'](result, this.f(input));
  };

  return XMap;
}();

var _xmap = /*#__PURE__*/(0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__.default)(function _xmap(f, xf) {
  return new XMap(f, xf);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_xmap);

/***/ }),

/***/ "./node_modules/ramda/es/internal/_xwrap.js":
/*!**************************************************!*\
  !*** ./node_modules/ramda/es/internal/_xwrap.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _xwrap)
/* harmony export */ });
var XWrap = /*#__PURE__*/function () {
  function XWrap(fn) {
    this.f = fn;
  }
  XWrap.prototype['@@transducer/init'] = function () {
    throw new Error('init not implemented on XWrap');
  };
  XWrap.prototype['@@transducer/result'] = function (acc) {
    return acc;
  };
  XWrap.prototype['@@transducer/step'] = function (acc, x) {
    return this.f(acc, x);
  };

  return XWrap;
}();

function _xwrap(fn) {
  return new XWrap(fn);
}

/***/ }),

/***/ "./node_modules/ramda/es/invoker.js":
/*!******************************************!*\
  !*** ./node_modules/ramda/es/invoker.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_isFunction_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_isFunction.js */ "./node_modules/ramda/es/internal/_isFunction.js");
/* harmony import */ var _curryN_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./curryN.js */ "./node_modules/ramda/es/curryN.js");
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./toString.js */ "./node_modules/ramda/es/toString.js");





/**
 * Turns a named method with a specified arity into a function that can be
 * called directly supplied with arguments and a target object.
 *
 * The returned function is curried and accepts `arity + 1` parameters where
 * the final parameter is the target object.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Function
 * @sig Number -> String -> (a -> b -> ... -> n -> Object -> *)
 * @param {Number} arity Number of arguments the returned function should take
 *        before the target object.
 * @param {String} method Name of the method to call.
 * @return {Function} A new curried function.
 * @see R.construct
 * @example
 *
 *      const sliceFrom = R.invoker(1, 'slice');
 *      sliceFrom(6, 'abcdefghijklm'); //=> 'ghijklm'
 *      const sliceFrom6 = R.invoker(2, 'slice')(6);
 *      sliceFrom6(8, 'abcdefghijklm'); //=> 'gh'
 * @symb R.invoker(0, 'method')(o) = o['method']()
 * @symb R.invoker(1, 'method')(a, o) = o['method'](a)
 * @symb R.invoker(2, 'method')(a, b, o) = o['method'](a, b)
 */
var invoker = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function invoker(arity, method) {
  return (0,_curryN_js__WEBPACK_IMPORTED_MODULE_1__.default)(arity + 1, function () {
    var target = arguments[arity];
    if (target != null && (0,_internal_isFunction_js__WEBPACK_IMPORTED_MODULE_2__.default)(target[method])) {
      return target[method].apply(target, Array.prototype.slice.call(arguments, 0, arity));
    }
    throw new TypeError((0,_toString_js__WEBPACK_IMPORTED_MODULE_3__.default)(target) + ' does not have a method named "' + method + '"');
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (invoker);

/***/ }),

/***/ "./node_modules/ramda/es/is.js":
/*!*************************************!*\
  !*** ./node_modules/ramda/es/is.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");


/**
 * See if an object (`val`) is an instance of the supplied constructor. This
 * function will check up the inheritance chain, if any.
 *
 * @func
 * @memberOf R
 * @since v0.3.0
 * @category Type
 * @sig (* -> {*}) -> a -> Boolean
 * @param {Object} ctor A constructor
 * @param {*} val The value to test
 * @return {Boolean}
 * @example
 *
 *      R.is(Object, {}); //=> true
 *      R.is(Number, 1); //=> true
 *      R.is(Object, 1); //=> false
 *      R.is(String, 's'); //=> true
 *      R.is(String, new String('')); //=> true
 *      R.is(Object, new String('')); //=> true
 *      R.is(Object, 's'); //=> false
 *      R.is(Number, {}); //=> false
 */
var is = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function is(Ctor, val) {
  return val != null && val.constructor === Ctor || val instanceof Ctor;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (is);

/***/ }),

/***/ "./node_modules/ramda/es/isNil.js":
/*!****************************************!*\
  !*** ./node_modules/ramda/es/isNil.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");


/**
 * Checks if the input value is `null` or `undefined`.
 *
 * @func
 * @memberOf R
 * @since v0.9.0
 * @category Type
 * @sig * -> Boolean
 * @param {*} x The value to test.
 * @return {Boolean} `true` if `x` is `undefined` or `null`, otherwise `false`.
 * @example
 *
 *      R.isNil(null); //=> true
 *      R.isNil(undefined); //=> true
 *      R.isNil(0); //=> false
 *      R.isNil([]); //=> false
 */
var isNil = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function isNil(x) {
  return x == null;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNil);

/***/ }),

/***/ "./node_modules/ramda/es/join.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/join.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _invoker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./invoker.js */ "./node_modules/ramda/es/invoker.js");


/**
 * Returns a string made by inserting the `separator` between each element and
 * concatenating all the elements into a single string.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig String -> [a] -> String
 * @param {Number|String} separator The string used to separate the elements.
 * @param {Array} xs The elements to join into a string.
 * @return {String} str The string made by concatenating `xs` with `separator`.
 * @see R.split
 * @example
 *
 *      const spacer = R.join(' ');
 *      spacer(['a', 2, 3.4]);   //=> 'a 2 3.4'
 *      R.join('|', [1, 2, 3]);    //=> '1|2|3'
 */
var join = /*#__PURE__*/(0,_invoker_js__WEBPACK_IMPORTED_MODULE_0__.default)(1, 'join');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (join);

/***/ }),

/***/ "./node_modules/ramda/es/keys.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/keys.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_has_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_has.js */ "./node_modules/ramda/es/internal/_has.js");
/* harmony import */ var _internal_isArguments_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_isArguments.js */ "./node_modules/ramda/es/internal/_isArguments.js");




// cover IE < 9 keys issues
var hasEnumBug = ! /*#__PURE__*/{ toString: null }.propertyIsEnumerable('toString');
var nonEnumerableProps = ['constructor', 'valueOf', 'isPrototypeOf', 'toString', 'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];
// Safari bug
var hasArgsEnumBug = /*#__PURE__*/function () {
  'use strict';

  return arguments.propertyIsEnumerable('length');
}();

var contains = function contains(list, item) {
  var idx = 0;
  while (idx < list.length) {
    if (list[idx] === item) {
      return true;
    }
    idx += 1;
  }
  return false;
};

/**
 * Returns a list containing the names of all the enumerable own properties of
 * the supplied object.
 * Note that the order of the output array is not guaranteed to be consistent
 * across different JS platforms.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig {k: v} -> [k]
 * @param {Object} obj The object to extract properties from
 * @return {Array} An array of the object's own properties.
 * @see R.keysIn, R.values
 * @example
 *
 *      R.keys({a: 1, b: 2, c: 3}); //=> ['a', 'b', 'c']
 */
var keys = typeof Object.keys === 'function' && !hasArgsEnumBug ? /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function keys(obj) {
  return Object(obj) !== obj ? [] : Object.keys(obj);
}) : /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function keys(obj) {
  if (Object(obj) !== obj) {
    return [];
  }
  var prop, nIdx;
  var ks = [];
  var checkArgsLength = hasArgsEnumBug && (0,_internal_isArguments_js__WEBPACK_IMPORTED_MODULE_1__.default)(obj);
  for (prop in obj) {
    if ((0,_internal_has_js__WEBPACK_IMPORTED_MODULE_2__.default)(prop, obj) && (!checkArgsLength || prop !== 'length')) {
      ks[ks.length] = prop;
    }
  }
  if (hasEnumBug) {
    nIdx = nonEnumerableProps.length - 1;
    while (nIdx >= 0) {
      prop = nonEnumerableProps[nIdx];
      if ((0,_internal_has_js__WEBPACK_IMPORTED_MODULE_2__.default)(prop, obj) && !contains(ks, prop)) {
        ks[ks.length] = prop;
      }
      nIdx -= 1;
    }
  }
  return ks;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (keys);

/***/ }),

/***/ "./node_modules/ramda/es/last.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/last.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _nth_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./nth.js */ "./node_modules/ramda/es/nth.js");


/**
 * Returns the last element of the given list or string.
 *
 * @func
 * @memberOf R
 * @since v0.1.4
 * @category List
 * @sig [a] -> a | Undefined
 * @sig String -> String
 * @param {*} list
 * @return {*}
 * @see R.init, R.head, R.tail
 * @example
 *
 *      R.last(['fi', 'fo', 'fum']); //=> 'fum'
 *      R.last([]); //=> undefined
 *
 *      R.last('abc'); //=> 'c'
 *      R.last(''); //=> ''
 */
var last = /*#__PURE__*/(0,_nth_js__WEBPACK_IMPORTED_MODULE_0__.default)(-1);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (last);

/***/ }),

/***/ "./node_modules/ramda/es/map.js":
/*!**************************************!*\
  !*** ./node_modules/ramda/es/map.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_dispatchable.js */ "./node_modules/ramda/es/internal/_dispatchable.js");
/* harmony import */ var _internal_map_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./internal/_map.js */ "./node_modules/ramda/es/internal/_map.js");
/* harmony import */ var _internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./internal/_reduce.js */ "./node_modules/ramda/es/internal/_reduce.js");
/* harmony import */ var _internal_xmap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_xmap.js */ "./node_modules/ramda/es/internal/_xmap.js");
/* harmony import */ var _curryN_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./curryN.js */ "./node_modules/ramda/es/curryN.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./keys.js */ "./node_modules/ramda/es/keys.js");








/**
 * Takes a function and
 * a [functor](https://github.com/fantasyland/fantasy-land#functor),
 * applies the function to each of the functor's values, and returns
 * a functor of the same shape.
 *
 * Ramda provides suitable `map` implementations for `Array` and `Object`,
 * so this function may be applied to `[1, 2, 3]` or `{x: 1, y: 2, z: 3}`.
 *
 * Dispatches to the `map` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * Also treats functions as functors and will compose them together.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Functor f => (a -> b) -> f a -> f b
 * @param {Function} fn The function to be called on every element of the input `list`.
 * @param {Array} list The list to be iterated over.
 * @return {Array} The new list.
 * @see R.transduce, R.addIndex
 * @example
 *
 *      const double = x => x * 2;
 *
 *      R.map(double, [1, 2, 3]); //=> [2, 4, 6]
 *
 *      R.map(double, {x: 1, y: 2, z: 3}); //=> {x: 2, y: 4, z: 6}
 * @symb R.map(f, [a, b]) = [f(a), f(b)]
 * @symb R.map(f, { x: a, y: b }) = { x: f(a), y: f(b) }
 * @symb R.map(f, functor_o) = functor_o.map(f)
 */
var map = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__.default)(['fantasy-land/map', 'map'], _internal_xmap_js__WEBPACK_IMPORTED_MODULE_2__.default, function map(fn, functor) {
  switch (Object.prototype.toString.call(functor)) {
    case '[object Function]':
      return (0,_curryN_js__WEBPACK_IMPORTED_MODULE_3__.default)(functor.length, function () {
        return fn.call(this, functor.apply(this, arguments));
      });
    case '[object Object]':
      return (0,_internal_reduce_js__WEBPACK_IMPORTED_MODULE_4__.default)(function (acc, key) {
        acc[key] = fn(functor[key]);
        return acc;
      }, {}, (0,_keys_js__WEBPACK_IMPORTED_MODULE_5__.default)(functor));
    default:
      return (0,_internal_map_js__WEBPACK_IMPORTED_MODULE_6__.default)(fn, functor);
  }
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (map);

/***/ }),

/***/ "./node_modules/ramda/es/mergeAll.js":
/*!*******************************************!*\
  !*** ./node_modules/ramda/es/mergeAll.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_objectAssign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_objectAssign.js */ "./node_modules/ramda/es/internal/_objectAssign.js");
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");



/**
 * Merges a list of objects together into one object.
 *
 * @func
 * @memberOf R
 * @since v0.10.0
 * @category List
 * @sig [{k: v}] -> {k: v}
 * @param {Array} list An array of objects
 * @return {Object} A merged object.
 * @see R.reduce
 * @example
 *
 *      R.mergeAll([{foo:1},{bar:2},{baz:3}]); //=> {foo:1,bar:2,baz:3}
 *      R.mergeAll([{foo:1},{foo:2},{bar:2}]); //=> {foo:2,bar:2}
 * @symb R.mergeAll([{ x: 1 }, { y: 2 }, { z: 3 }]) = { x: 1, y: 2, z: 3 }
 */
var mergeAll = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function mergeAll(list) {
  return _internal_objectAssign_js__WEBPACK_IMPORTED_MODULE_1__.default.apply(null, [{}].concat(list));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mergeAll);

/***/ }),

/***/ "./node_modules/ramda/es/nth.js":
/*!**************************************!*\
  !*** ./node_modules/ramda/es/nth.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _internal_isString_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_isString.js */ "./node_modules/ramda/es/internal/_isString.js");



/**
 * Returns the nth element of the given list or string. If n is negative the
 * element at index length + n is returned.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Number -> [a] -> a | Undefined
 * @sig Number -> String -> String
 * @param {Number} offset
 * @param {*} list
 * @return {*}
 * @example
 *
 *      const list = ['foo', 'bar', 'baz', 'quux'];
 *      R.nth(1, list); //=> 'bar'
 *      R.nth(-1, list); //=> 'quux'
 *      R.nth(-99, list); //=> undefined
 *
 *      R.nth(2, 'abc'); //=> 'c'
 *      R.nth(3, 'abc'); //=> ''
 * @symb R.nth(-1, [a, b, c]) = c
 * @symb R.nth(0, [a, b, c]) = a
 * @symb R.nth(1, [a, b, c]) = b
 */
var nth = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function nth(offset, list) {
  var idx = offset < 0 ? list.length + offset : offset;
  return (0,_internal_isString_js__WEBPACK_IMPORTED_MODULE_1__.default)(list) ? list.charAt(idx) : list[idx];
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (nth);

/***/ }),

/***/ "./node_modules/ramda/es/omit.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/omit.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");


/**
 * Returns a partial copy of an object omitting the keys specified.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig [String] -> {String: *} -> {String: *}
 * @param {Array} names an array of String property names to omit from the new object
 * @param {Object} obj The object to copy from
 * @return {Object} A new object with properties from `names` not on it.
 * @see R.pick
 * @example
 *
 *      R.omit(['a', 'd'], {a: 1, b: 2, c: 3, d: 4}); //=> {b: 2, c: 3}
 */
var omit = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function omit(names, obj) {
  var result = {};
  var index = {};
  var idx = 0;
  var len = names.length;

  while (idx < len) {
    index[names[idx]] = 1;
    idx += 1;
  }

  for (var prop in obj) {
    if (!index.hasOwnProperty(prop)) {
      result[prop] = obj[prop];
    }
  }
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (omit);

/***/ }),

/***/ "./node_modules/ramda/es/path.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/path.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");


/**
 * Retrieve the value at a given path.
 *
 * @func
 * @memberOf R
 * @since v0.2.0
 * @category Object
 * @typedefn Idx = String | Int
 * @sig [Idx] -> {a} -> a | Undefined
 * @param {Array} path The path to use.
 * @param {Object} obj The object to retrieve the nested property from.
 * @return {*} The data at `path`.
 * @see R.prop
 * @example
 *
 *      R.path(['a', 'b'], {a: {b: 2}}); //=> 2
 *      R.path(['a', 'b'], {c: {b: 2}}); //=> undefined
 */
var path = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function path(paths, obj) {
  var val = obj;
  var idx = 0;
  while (idx < paths.length) {
    if (val == null) {
      return;
    }
    val = val[paths[idx]];
    idx += 1;
  }
  return val;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (path);

/***/ }),

/***/ "./node_modules/ramda/es/pluck.js":
/*!****************************************!*\
  !*** ./node_modules/ramda/es/pluck.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./map.js */ "./node_modules/ramda/es/map.js");
/* harmony import */ var _prop_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./prop.js */ "./node_modules/ramda/es/prop.js");




/**
 * Returns a new list by plucking the same named property off all objects in
 * the list supplied.
 *
 * `pluck` will work on
 * any [functor](https://github.com/fantasyland/fantasy-land#functor) in
 * addition to arrays, as it is equivalent to `R.map(R.prop(k), f)`.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Functor f => k -> f {k: v} -> f v
 * @param {Number|String} key The key name to pluck off of each object.
 * @param {Array} f The array or functor to consider.
 * @return {Array} The list of values for the given key.
 * @see R.props
 * @example
 *
 *      var getAges = R.pluck('age');
 *      getAges([{name: 'fred', age: 29}, {name: 'wilma', age: 27}]); //=> [29, 27]
 *
 *      R.pluck(0, [[1, 2], [3, 4]]);               //=> [1, 3]
 *      R.pluck('val', {a: {val: 3}, b: {val: 5}}); //=> {a: 3, b: 5}
 * @symb R.pluck('x', [{x: 1, y: 2}, {x: 3, y: 4}, {x: 5, y: 6}]) = [1, 3, 5]
 * @symb R.pluck(0, [[1, 2], [3, 4], [5, 6]]) = [1, 3, 5]
 */
var pluck = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function pluck(p, list) {
  return (0,_map_js__WEBPACK_IMPORTED_MODULE_1__.default)((0,_prop_js__WEBPACK_IMPORTED_MODULE_2__.default)(p), list);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pluck);

/***/ }),

/***/ "./node_modules/ramda/es/prop.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/prop.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./path.js */ "./node_modules/ramda/es/path.js");



/**
 * Returns a function that when supplied an object returns the indicated
 * property of that object, if it exists.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig s -> {s: a} -> a | Undefined
 * @param {String} p The property name
 * @param {Object} obj The object to query
 * @return {*} The value at `obj.p`.
 * @see R.path
 * @example
 *
 *      R.prop('x', {x: 100}); //=> 100
 *      R.prop('x', {}); //=> undefined
 *      R.compose(R.inc, R.prop('x'))({ x: 3 }) //=> 4
 */

var prop = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function prop(p, obj) {
  return (0,_path_js__WEBPACK_IMPORTED_MODULE_1__.default)([p], obj);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (prop);

/***/ }),

/***/ "./node_modules/ramda/es/reject.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/reject.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_complement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./internal/_complement.js */ "./node_modules/ramda/es/internal/_complement.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filter.js */ "./node_modules/ramda/es/filter.js");




/**
 * The complement of [`filter`](#filter).
 *
 * Acts as a transducer if a transformer is given in list position. Filterable
 * objects include plain objects or any object that has a filter method such
 * as `Array`.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig Filterable f => (a -> Boolean) -> f a -> f a
 * @param {Function} pred
 * @param {Array} filterable
 * @return {Array}
 * @see R.filter, R.transduce, R.addIndex
 * @example
 *
 *      const isOdd = (n) => n % 2 === 1;
 *
 *      R.reject(isOdd, [1, 2, 3, 4]); //=> [2, 4]
 *
 *      R.reject(isOdd, {a: 1, b: 2, c: 3, d: 4}); //=> {b: 2, d: 4}
 */
var reject = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function reject(pred, filterable) {
  return (0,_filter_js__WEBPACK_IMPORTED_MODULE_1__.default)((0,_internal_complement_js__WEBPACK_IMPORTED_MODULE_2__.default)(pred), filterable);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reject);

/***/ }),

/***/ "./node_modules/ramda/es/remove.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/remove.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry3.js */ "./node_modules/ramda/es/internal/_curry3.js");


/**
 * Removes the sub-list of `list` starting at index `start` and containing
 * `count` elements. _Note that this is not destructive_: it returns a copy of
 * the list with the changes.
 * <small>No lists have been harmed in the application of this function.</small>
 *
 * @func
 * @memberOf R
 * @since v0.2.2
 * @category List
 * @sig Number -> Number -> [a] -> [a]
 * @param {Number} start The position to start removing elements
 * @param {Number} count The number of elements to remove
 * @param {Array} list The list to remove from
 * @return {Array} A new Array with `count` elements from `start` removed.
 * @see R.without
 * @example
 *
 *      R.remove(2, 3, [1,2,3,4,5,6,7,8]); //=> [1,2,6,7,8]
 */
var remove = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__.default)(function remove(start, count, list) {
  var result = Array.prototype.slice.call(list, 0);
  result.splice(start, count);
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (remove);

/***/ }),

/***/ "./node_modules/ramda/es/slice.js":
/*!****************************************!*\
  !*** ./node_modules/ramda/es/slice.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_checkForMethod_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_checkForMethod.js */ "./node_modules/ramda/es/internal/_checkForMethod.js");
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry3.js */ "./node_modules/ramda/es/internal/_curry3.js");



/**
 * Returns the elements of the given list or string (or object with a `slice`
 * method) from `fromIndex` (inclusive) to `toIndex` (exclusive).
 *
 * Dispatches to the `slice` method of the third argument, if present.
 *
 * @func
 * @memberOf R
 * @since v0.1.4
 * @category List
 * @sig Number -> Number -> [a] -> [a]
 * @sig Number -> Number -> String -> String
 * @param {Number} fromIndex The start index (inclusive).
 * @param {Number} toIndex The end index (exclusive).
 * @param {*} list
 * @return {*}
 * @example
 *
 *      R.slice(1, 3, ['a', 'b', 'c', 'd']);        //=> ['b', 'c']
 *      R.slice(1, Infinity, ['a', 'b', 'c', 'd']); //=> ['b', 'c', 'd']
 *      R.slice(0, -1, ['a', 'b', 'c', 'd']);       //=> ['a', 'b', 'c']
 *      R.slice(-3, -1, ['a', 'b', 'c', 'd']);      //=> ['b', 'c']
 *      R.slice(0, 3, 'ramda');                     //=> 'ram'
 */
var slice = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__.default)( /*#__PURE__*/(0,_internal_checkForMethod_js__WEBPACK_IMPORTED_MODULE_1__.default)('slice', function slice(fromIndex, toIndex, list) {
  return Array.prototype.slice.call(list, fromIndex, toIndex);
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (slice);

/***/ }),

/***/ "./node_modules/ramda/es/toPairs.js":
/*!******************************************!*\
  !*** ./node_modules/ramda/es/toPairs.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_has_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_has.js */ "./node_modules/ramda/es/internal/_has.js");



/**
 * Converts an object into an array of key, value arrays. Only the object's
 * own properties are used.
 * Note that the order of the output array is not guaranteed to be consistent
 * across different JS platforms.
 *
 * @func
 * @memberOf R
 * @since v0.4.0
 * @category Object
 * @sig {String: *} -> [[String,*]]
 * @param {Object} obj The object to extract from
 * @return {Array} An array of key, value arrays from the object's own properties.
 * @see R.fromPairs
 * @example
 *
 *      R.toPairs({a: 1, b: 2, c: 3}); //=> [['a', 1], ['b', 2], ['c', 3]]
 */
var toPairs = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function toPairs(obj) {
  var pairs = [];
  for (var prop in obj) {
    if ((0,_internal_has_js__WEBPACK_IMPORTED_MODULE_1__.default)(prop, obj)) {
      pairs[pairs.length] = [prop, obj[prop]];
    }
  }
  return pairs;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toPairs);

/***/ }),

/***/ "./node_modules/ramda/es/toString.js":
/*!*******************************************!*\
  !*** ./node_modules/ramda/es/toString.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _internal_toString_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./internal/_toString.js */ "./node_modules/ramda/es/internal/_toString.js");



/**
 * Returns the string representation of the given value. `eval`'ing the output
 * should result in a value equivalent to the input value. Many of the built-in
 * `toString` methods do not satisfy this requirement.
 *
 * If the given value is an `[object Object]` with a `toString` method other
 * than `Object.prototype.toString`, this method is invoked with no arguments
 * to produce the return value. This means user-defined constructor functions
 * can provide a suitable `toString` method. For example:
 *
 *     function Point(x, y) {
 *       this.x = x;
 *       this.y = y;
 *     }
 *
 *     Point.prototype.toString = function() {
 *       return 'new Point(' + this.x + ', ' + this.y + ')';
 *     };
 *
 *     R.toString(new Point(1, 2)); //=> 'new Point(1, 2)'
 *
 * @func
 * @memberOf R
 * @since v0.14.0
 * @category String
 * @sig * -> String
 * @param {*} val
 * @return {String}
 * @example
 *
 *      R.toString(42); //=> '42'
 *      R.toString('abc'); //=> '"abc"'
 *      R.toString([1, 2, 3]); //=> '[1, 2, 3]'
 *      R.toString({foo: 1, bar: 2, baz: 3}); //=> '{"bar": 2, "baz": 3, "foo": 1}'
 *      R.toString(new Date('2001-02-03T04:05:06Z')); //=> 'new Date("2001-02-03T04:05:06.000Z")'
 */
var toString = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function toString(val) {
  return (0,_internal_toString_js__WEBPACK_IMPORTED_MODULE_1__.default)(val, []);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toString);

/***/ }),

/***/ "./node_modules/ramda/es/type.js":
/*!***************************************!*\
  !*** ./node_modules/ramda/es/type.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");


/**
 * Gives a single-word string description of the (native) type of a value,
 * returning such answers as 'Object', 'Number', 'Array', or 'Null'. Does not
 * attempt to distinguish user Object types any further, reporting them all as
 * 'Object'.
 *
 * @func
 * @memberOf R
 * @since v0.8.0
 * @category Type
 * @sig (* -> {*}) -> String
 * @param {*} val The value to test
 * @return {String}
 * @example
 *
 *      R.type({}); //=> "Object"
 *      R.type(1); //=> "Number"
 *      R.type(false); //=> "Boolean"
 *      R.type('s'); //=> "String"
 *      R.type(null); //=> "Null"
 *      R.type([]); //=> "Array"
 *      R.type(/[A-z]/); //=> "RegExp"
 *      R.type(() => {}); //=> "Function"
 *      R.type(undefined); //=> "Undefined"
 */
var type = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function type(val) {
  return val === null ? 'Null' : val === undefined ? 'Undefined' : Object.prototype.toString.call(val).slice(8, -1);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (type);

/***/ }),

/***/ "./node_modules/ramda/es/values.js":
/*!*****************************************!*\
  !*** ./node_modules/ramda/es/values.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry1.js */ "./node_modules/ramda/es/internal/_curry1.js");
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keys.js */ "./node_modules/ramda/es/keys.js");



/**
 * Returns a list of all the enumerable own properties of the supplied object.
 * Note that the order of the output array is not guaranteed across different
 * JS platforms.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig {k: v} -> [v]
 * @param {Object} obj The object to extract values from
 * @return {Array} An array of the values of the object's own properties.
 * @see R.valuesIn, R.keys
 * @example
 *
 *      R.values({a: 1, b: 2, c: 3}); //=> [1, 2, 3]
 */
var values = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__.default)(function values(obj) {
  var props = (0,_keys_js__WEBPACK_IMPORTED_MODULE_1__.default)(obj);
  var len = props.length;
  var vals = [];
  var idx = 0;
  while (idx < len) {
    vals[idx] = obj[props[idx]];
    idx += 1;
  }
  return vals;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (values);

/***/ }),

/***/ "./node_modules/ramda/es/without.js":
/*!******************************************!*\
  !*** ./node_modules/ramda/es/without.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_includes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./internal/_includes.js */ "./node_modules/ramda/es/internal/_includes.js");
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/_curry2.js */ "./node_modules/ramda/es/internal/_curry2.js");
/* harmony import */ var _flip_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./flip.js */ "./node_modules/ramda/es/flip.js");
/* harmony import */ var _reject_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reject.js */ "./node_modules/ramda/es/reject.js");





/**
 * Returns a new list without values in the first argument.
 * [`R.equals`](#equals) is used to determine equality.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.19.0
 * @category List
 * @sig [a] -> [a] -> [a]
 * @param {Array} list1 The values to be removed from `list2`.
 * @param {Array} list2 The array to remove values from.
 * @return {Array} The new array without values in `list1`.
 * @see R.transduce, R.difference, R.remove
 * @example
 *
 *      R.without([1, 2], [1, 2, 1, 3, 4]); //=> [3, 4]
 */
var without = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__.default)(function (xs, list) {
  return (0,_reject_js__WEBPACK_IMPORTED_MODULE_1__.default)((0,_flip_js__WEBPACK_IMPORTED_MODULE_2__.default)(_internal_includes_js__WEBPACK_IMPORTED_MODULE_3__.default)(xs), list);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (without);

/***/ }),

/***/ "./node_modules/react-is/cjs/react-is.development.js":
/*!***********************************************************!*\
  !*** ./node_modules/react-is/cjs/react-is.development.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/** @license React v16.8.6
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */





if (true) {
  (function() {
'use strict';

Object.defineProperty(exports, "__esModule", ({ value: true }));

// The Symbol used to tag the ReactElement-like types. If there is no native Symbol
// nor polyfill, then a plain number is used for performance.
var hasSymbol = typeof Symbol === 'function' && Symbol.for;

var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace;
var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;

function isValidElementType(type) {
  return typeof type === 'string' || typeof type === 'function' ||
  // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE);
}

/**
 * Forked from fbjs/warning:
 * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
 *
 * Only change is we use console.warn instead of console.error,
 * and do nothing when 'console' is not supported.
 * This really simplifies the code.
 * ---
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */

var lowPriorityWarning = function () {};

{
  var printWarning = function (format) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var argIndex = 0;
    var message = 'Warning: ' + format.replace(/%s/g, function () {
      return args[argIndex++];
    });
    if (typeof console !== 'undefined') {
      console.warn(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };

  lowPriorityWarning = function (condition, format) {
    if (format === undefined) {
      throw new Error('`lowPriorityWarning(condition, format, ...args)` requires a warning ' + 'message argument');
    }
    if (!condition) {
      for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        args[_key2 - 2] = arguments[_key2];
      }

      printWarning.apply(undefined, [format].concat(args));
    }
  };
}

var lowPriorityWarning$1 = lowPriorityWarning;

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;
    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_ASYNC_MODE_TYPE:
          case REACT_CONCURRENT_MODE_TYPE:
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
            return type;
          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;
              default:
                return $$typeof;
            }
        }
      case REACT_LAZY_TYPE:
      case REACT_MEMO_TYPE:
      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
}

// AsyncMode is deprecated along with isAsyncMode
var AsyncMode = REACT_ASYNC_MODE_TYPE;
var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;

var hasWarnedAboutDeprecatedIsAsyncMode = false;

// AsyncMode should be deprecated
function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true;
      lowPriorityWarning$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
    }
  }
  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
}
function isConcurrentMode(object) {
  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}

exports.typeOf = typeOf;
exports.AsyncMode = AsyncMode;
exports.ConcurrentMode = ConcurrentMode;
exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.isValidElementType = isValidElementType;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
  })();
}


/***/ }),

/***/ "./node_modules/react-is/index.js":
/*!****************************************!*\
  !*** ./node_modules/react-is/index.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


if (false) {} else {
  module.exports = __webpack_require__(/*! ./cjs/react-is.development.js */ "./node_modules/react-is/cjs/react-is.development.js");
}


/***/ }),

/***/ "./src/commons/scss/index.scss":
/*!*************************************!*\
  !*** ./src/commons/scss/index.scss ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var content = __webpack_require__(/*! !!../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js!./index.scss */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/commons/scss/index.scss");

if(typeof content === 'string') content = [[module.id, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(/*! !../../../node_modules/style-loader/lib/addStyles.js */ "./node_modules/style-loader/lib/addStyles.js")(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),

/***/ "./src/core/scss/index.scss":
/*!**********************************!*\
  !*** ./src/core/scss/index.scss ***!
  \**********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var content = __webpack_require__(/*! !!../../../node_modules/mini-css-extract-plugin/dist/loader.js!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js!./index.scss */ "./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js!./src/core/scss/index.scss");

if(typeof content === 'string') content = [[module.id, content, '']];

var transform;
var insertInto;



var options = {"hmr":true}

options.transform = transform
options.insertInto = undefined;

var update = __webpack_require__(/*! !../../../node_modules/style-loader/lib/addStyles.js */ "./node_modules/style-loader/lib/addStyles.js")(content, options);

if(content.locals) module.exports = content.locals;

if(false) {}

/***/ }),

/***/ "./node_modules/style-loader/lib/addStyles.js":
/*!****************************************************!*\
  !*** ./node_modules/style-loader/lib/addStyles.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var stylesInDom = {};

var	memoize = function (fn) {
	var memo;

	return function () {
		if (typeof memo === "undefined") memo = fn.apply(this, arguments);
		return memo;
	};
};

var isOldIE = memoize(function () {
	// Test for IE <= 9 as proposed by Browserhacks
	// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
	// Tests for existence of standard globals is to allow style-loader
	// to operate correctly into non-standard environments
	// @see https://github.com/webpack-contrib/style-loader/issues/177
	return window && document && document.all && !window.atob;
});

var getTarget = function (target, parent) {
  if (parent){
    return parent.querySelector(target);
  }
  return document.querySelector(target);
};

var getElement = (function (fn) {
	var memo = {};

	return function(target, parent) {
                // If passing function in options, then use it for resolve "head" element.
                // Useful for Shadow Root style i.e
                // {
                //   insertInto: function () { return document.querySelector("#foo").shadowRoot }
                // }
                if (typeof target === 'function') {
                        return target();
                }
                if (typeof memo[target] === "undefined") {
			var styleTarget = getTarget.call(this, target, parent);
			// Special case to return head of iframe instead of iframe itself
			if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
				try {
					// This will throw an exception if access to iframe is blocked
					// due to cross-origin restrictions
					styleTarget = styleTarget.contentDocument.head;
				} catch(e) {
					styleTarget = null;
				}
			}
			memo[target] = styleTarget;
		}
		return memo[target]
	};
})();

var singleton = null;
var	singletonCounter = 0;
var	stylesInsertedAtTop = [];

var	fixUrls = __webpack_require__(/*! ./urls */ "./node_modules/style-loader/lib/urls.js");

module.exports = function(list, options) {
	if (typeof DEBUG !== "undefined" && DEBUG) {
		if (typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};

	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (!options.singleton && typeof options.singleton !== "boolean") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
        if (!options.insertInto) options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (!options.insertAt) options.insertAt = "bottom";

	var styles = listToStyles(list, options);

	addStylesToDom(styles, options);

	return function update (newList) {
		var mayRemove = [];

		for (var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];

			domStyle.refs--;
			mayRemove.push(domStyle);
		}

		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}

		for (var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];

			if(domStyle.refs === 0) {
				for (var j = 0; j < domStyle.parts.length; j++) domStyle.parts[j]();

				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom (styles, options) {
	for (var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];

		if(domStyle) {
			domStyle.refs++;

			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}

			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];

			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}

			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles (list, options) {
	var styles = [];
	var newStyles = {};

	for (var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};

		if(!newStyles[id]) styles.push(newStyles[id] = {id: id, parts: [part]});
		else newStyles[id].parts.push(part);
	}

	return styles;
}

function insertStyleElement (options, style) {
	var target = getElement(options.insertInto)

	if (!target) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}

	var lastStyleElementInsertedAtTop = stylesInsertedAtTop[stylesInsertedAtTop.length - 1];

	if (options.insertAt === "top") {
		if (!lastStyleElementInsertedAtTop) {
			target.insertBefore(style, target.firstChild);
		} else if (lastStyleElementInsertedAtTop.nextSibling) {
			target.insertBefore(style, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			target.appendChild(style);
		}
		stylesInsertedAtTop.push(style);
	} else if (options.insertAt === "bottom") {
		target.appendChild(style);
	} else if (typeof options.insertAt === "object" && options.insertAt.before) {
		var nextSibling = getElement(options.insertAt.before, target);
		target.insertBefore(style, nextSibling);
	} else {
		throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");
	}
}

function removeStyleElement (style) {
	if (style.parentNode === null) return false;
	style.parentNode.removeChild(style);

	var idx = stylesInsertedAtTop.indexOf(style);
	if(idx >= 0) {
		stylesInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement (options) {
	var style = document.createElement("style");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}

	if(options.attrs.nonce === undefined) {
		var nonce = getNonce();
		if (nonce) {
			options.attrs.nonce = nonce;
		}
	}

	addAttrs(style, options.attrs);
	insertStyleElement(options, style);

	return style;
}

function createLinkElement (options) {
	var link = document.createElement("link");

	if(options.attrs.type === undefined) {
		options.attrs.type = "text/css";
	}
	options.attrs.rel = "stylesheet";

	addAttrs(link, options.attrs);
	insertStyleElement(options, link);

	return link;
}

function addAttrs (el, attrs) {
	Object.keys(attrs).forEach(function (key) {
		el.setAttribute(key, attrs[key]);
	});
}

function getNonce() {
	if (false) {}

	return __webpack_require__.nc;
}

function addStyle (obj, options) {
	var style, update, remove, result;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    result = typeof options.transform === 'function'
		 ? options.transform(obj.css) 
		 : options.transform.default(obj.css);

	    if (result) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = result;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css.
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;

		style = singleton || (singleton = createStyleElement(options));

		update = applyToSingletonTag.bind(null, style, styleIndex, false);
		remove = applyToSingletonTag.bind(null, style, styleIndex, true);

	} else if (
		obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function"
	) {
		style = createLinkElement(options);
		update = updateLink.bind(null, style, options);
		remove = function () {
			removeStyleElement(style);

			if(style.href) URL.revokeObjectURL(style.href);
		};
	} else {
		style = createStyleElement(options);
		update = applyToTag.bind(null, style);
		remove = function () {
			removeStyleElement(style);
		};
	}

	update(obj);

	return function updateStyle (newObj) {
		if (newObj) {
			if (
				newObj.css === obj.css &&
				newObj.media === obj.media &&
				newObj.sourceMap === obj.sourceMap
			) {
				return;
			}

			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;

		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag (style, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (style.styleSheet) {
		style.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = style.childNodes;

		if (childNodes[index]) style.removeChild(childNodes[index]);

		if (childNodes.length) {
			style.insertBefore(cssNode, childNodes[index]);
		} else {
			style.appendChild(cssNode);
		}
	}
}

function applyToTag (style, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		style.setAttribute("media", media)
	}

	if(style.styleSheet) {
		style.styleSheet.cssText = css;
	} else {
		while(style.firstChild) {
			style.removeChild(style.firstChild);
		}

		style.appendChild(document.createTextNode(css));
	}
}

function updateLink (link, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/*
		If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
		and there is no publicPath defined then lets turn convertToAbsoluteUrls
		on by default.  Otherwise default to the convertToAbsoluteUrls option
		directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls) {
		css = fixUrls(css);
	}

	if (sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = link.href;

	link.href = URL.createObjectURL(blob);

	if(oldSrc) URL.revokeObjectURL(oldSrc);
}


/***/ }),

/***/ "./node_modules/style-loader/lib/urls.js":
/*!***********************************************!*\
  !*** ./node_modules/style-loader/lib/urls.js ***!
  \***********************************************/
/***/ ((module) => {


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
  // get current location
  var location = typeof window !== "undefined" && window.location;

  if (!location) {
    throw new Error("fixUrls requires window.location");
  }

	// blank or null?
	if (!css || typeof css !== "string") {
	  return css;
  }

  var baseUrl = location.protocol + "//" + location.host;
  var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
	This regular expression is just a way to recursively match brackets within
	a string.

	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
	   (  = Start a capturing group
	     (?:  = Start a non-capturing group
	         [^)(]  = Match anything that isn't a parentheses
	         |  = OR
	         \(  = Match a start parentheses
	             (?:  = Start another non-capturing groups
	                 [^)(]+  = Match anything that isn't a parentheses
	                 |  = OR
	                 \(  = Match a start parentheses
	                     [^)(]*  = Match anything that isn't a parentheses
	                 \)  = Match a end parentheses
	             )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
	 \)  = Match a close parens

	 /gi  = Get all matches, not the first.  Be case insensitive.
	 */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function(fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl
			.trim()
			.replace(/^"(.*)"$/, function(o, $1){ return $1; })
			.replace(/^'(.*)'$/, function(o, $1){ return $1; });

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(unquotedOrigUrl)) {
		  return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
		  	//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};


/***/ }),

/***/ "react":
/*!****************************************************************************************************!*\
  !*** external {"commonjs":"react","commonjs2":"react","amd":"react","umd":"react","root":"React"} ***!
  \****************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = __WEBPACK_EXTERNAL_MODULE_react__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!******************************!*\
  !*** ./src/core/js/index.js ***!
  \******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Container": () => (/* reexport safe */ _components_Container__WEBPACK_IMPORTED_MODULE_1__.default),
/* harmony export */   "DataList": () => (/* reexport safe */ _components_DataList__WEBPACK_IMPORTED_MODULE_2__.default),
/* harmony export */   "Html": () => (/* reexport safe */ _components_Html__WEBPACK_IMPORTED_MODULE_6__.default),
/* harmony export */   "Link": () => (/* reexport safe */ _components_Link__WEBPACK_IMPORTED_MODULE_10__.default),
/* harmony export */   "Input": () => (/* reexport safe */ _components_Input__WEBPACK_IMPORTED_MODULE_3__.default),
/* harmony export */   "Interval": () => (/* reexport safe */ _components_Interval__WEBPACK_IMPORTED_MODULE_4__.default),
/* harmony export */   "Store": () => (/* reexport safe */ _components_Store__WEBPACK_IMPORTED_MODULE_5__.default),
/* harmony export */   "Select": () => (/* reexport safe */ _components_Select__WEBPACK_IMPORTED_MODULE_7__.default),
/* harmony export */   "RadioList": () => (/* reexport safe */ _components_RadioList__WEBPACK_IMPORTED_MODULE_8__.default),
/* harmony export */   "CheckList": () => (/* reexport safe */ _components_CheckList__WEBPACK_IMPORTED_MODULE_9__.default),
/* harmony export */   "ProgressBar": () => (/* reexport safe */ _components_ProgressBar__WEBPACK_IMPORTED_MODULE_11__.default),
/* harmony export */   "ViewPort": () => (/* reexport safe */ _components_ViewPort__WEBPACK_IMPORTED_MODULE_12__.default),
/* harmony export */   "Button": () => (/* reexport safe */ _components_Button__WEBPACK_IMPORTED_MODULE_13__.default),
/* harmony export */   "Slider": () => (/* reexport safe */ _components_Slider__WEBPACK_IMPORTED_MODULE_14__.default),
/* harmony export */   "Image": () => (/* reexport safe */ _components_Image__WEBPACK_IMPORTED_MODULE_15__.default),
/* harmony export */   "Modal": () => (/* reexport safe */ _components_Modal__WEBPACK_IMPORTED_MODULE_16__.default),
/* harmony export */   "TextArea": () => (/* reexport safe */ _components_TextArea__WEBPACK_IMPORTED_MODULE_17__.default),
/* harmony export */   "Table": () => (/* reexport safe */ _components_Table__WEBPACK_IMPORTED_MODULE_18__.default),
/* harmony export */   "Grid": () => (/* reexport safe */ _components_Grid__WEBPACK_IMPORTED_MODULE_19__.default),
/* harmony export */   "Form": () => (/* reexport safe */ _components_Form__WEBPACK_IMPORTED_MODULE_20__.default),
/* harmony export */   "ListBox": () => (/* reexport safe */ _components_ListBox__WEBPACK_IMPORTED_MODULE_21__.default),
/* harmony export */   "Dropdown": () => (/* reexport safe */ _components_Dropdown__WEBPACK_IMPORTED_MODULE_22__.default)
/* harmony export */ });
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scss/index.scss */ "./src/core/scss/index.scss");
/* harmony import */ var _scss_index_scss__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_scss_index_scss__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_Container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/Container */ "./src/core/js/components/Container.jsx");
/* harmony import */ var _components_DataList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/DataList */ "./src/core/js/components/DataList.jsx");
/* harmony import */ var _components_Input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/Input */ "./src/core/js/components/Input.jsx");
/* harmony import */ var _components_Interval__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/Interval */ "./src/core/js/components/Interval.jsx");
/* harmony import */ var _components_Store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/Store */ "./src/core/js/components/Store.jsx");
/* harmony import */ var _components_Html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/Html */ "./src/core/js/components/Html.jsx");
/* harmony import */ var _components_Select__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/Select */ "./src/core/js/components/Select.jsx");
/* harmony import */ var _components_RadioList__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/RadioList */ "./src/core/js/components/RadioList.jsx");
/* harmony import */ var _components_CheckList__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/CheckList */ "./src/core/js/components/CheckList.jsx");
/* harmony import */ var _components_Link__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/Link */ "./src/core/js/components/Link.jsx");
/* harmony import */ var _components_ProgressBar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./components/ProgressBar */ "./src/core/js/components/ProgressBar.jsx");
/* harmony import */ var _components_ViewPort__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./components/ViewPort */ "./src/core/js/components/ViewPort.jsx");
/* harmony import */ var _components_Button__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./components/Button */ "./src/core/js/components/Button.jsx");
/* harmony import */ var _components_Slider__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./components/Slider */ "./src/core/js/components/Slider.jsx");
/* harmony import */ var _components_Image__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./components/Image */ "./src/core/js/components/Image.jsx");
/* harmony import */ var _components_Modal__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./components/Modal */ "./src/core/js/components/Modal.jsx");
/* harmony import */ var _components_TextArea__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./components/TextArea */ "./src/core/js/components/TextArea.jsx");
/* harmony import */ var _components_Table__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./components/Table */ "./src/core/js/components/Table.jsx");
/* harmony import */ var _components_Grid__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./components/Grid */ "./src/core/js/components/Grid.jsx");
/* harmony import */ var _components_Form__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./components/Form */ "./src/core/js/components/Form.jsx");
/* harmony import */ var _components_ListBox__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./components/ListBox */ "./src/core/js/components/ListBox.jsx");
/* harmony import */ var _components_Dropdown__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./components/Dropdown */ "./src/core/js/components/Dropdown.jsx");
























})();

/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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