"""Autogenerated file: DO NOT EDIT!"""
import typing  # noqa: F401
from dazzler.system import Component, Aspect, UNDEFINED  # noqa: F401


class Button(Component):
    """
    A button to click on!

    :CSS:

        - ``dazzler-core-button``
        - ``bordered``
        - ``rounded``
        - ``circle``
        - ``primary``
        - ``danger``
        - ``warning``
        - ``success``
        - ``tiny``
        - ``small``
        - ``medium``
        - ``large``
        - ``x-large``
        - ``xx-large``

    :Example:

    .. code-block:: python3

        from dazzler.system import Page, Trigger
        from dazzler.components import core

        button = core.Button('Click me', identity='btn')

        page = Page(
            __name__,
            core.Container([button, core.Container(identity="output")])
        )

        @page.binding(Trigger('btn', 'clicks'))
        async def on_click(ctx):
            await ctx.set_aspect('output', f'Clicked {ctx.trigger.value}')
    """
    _aspect_keys = []
    _children = []
    label = Aspect(required=True, children=True, docstring="Text or component to display.")  # noqa: E501
    clicks = Aspect(default=0, docstring="The number of times the button was clicked. (default=0)")  # noqa: E501
    class_name = Aspect(docstring="Class name to give the button.")
    style = Aspect(docstring="Style object to give to the Button.")
    id = Aspect(docstring="DOM id, otherwise the identity is used.")
    preset = Aspect(docstring="Preset style colors to apply. (Possible values: 'primary', 'secondary', 'danger', 'warning', 'success')")  # noqa: E501
    disabled = Aspect(docstring="Disable the button.")
    rounded = Aspect(docstring="Round the edges.")
    circle = Aspect(docstring="Circle button")
    bordered = Aspect(default=True, docstring="Add a border (default=True)")
    size = Aspect(docstring="The size of the button. (Possible values: 'tiny', 'small', 'medium', 'large', 'larger', 'x-large', 'xx-large')")  # noqa: E501

    def __init__(
            self,
            label: typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]],  # noqa: E501
            clicks: typing.Optional[typing.Union[float, int]] = 0,
            class_name: typing.Optional[str] = UNDEFINED,
            style: typing.Optional[typing.Dict] = UNDEFINED,
            id: typing.Optional[str] = UNDEFINED,
            preset: typing.Optional[typing.Any] = UNDEFINED,
            disabled: typing.Optional[bool] = UNDEFINED,
            rounded: typing.Optional[bool] = UNDEFINED,
            circle: typing.Optional[bool] = UNDEFINED,
            bordered: typing.Optional[bool] = True,
            size: typing.Optional[typing.Any] = UNDEFINED,
            identity: str = None
    ):
        """
        :param label: Text or component to display.
        :param clicks: The number of times the button was clicked.
            (default=0)
        :param class_name: Class name to give the button.
        :param style: Style object to give to the Button.
        :param id: DOM id, otherwise the identity is used.
        :param preset: Preset style colors to apply. (Possible values:
            'primary', 'secondary', 'danger', 'warning', 'success')
        :param disabled: Disable the button.
        :param rounded: Round the edges.
        :param circle: Circle button
        :param bordered: Add a border (default=True)
        :param size: The size of the button. (Possible values: 'tiny',
            'small', 'medium', 'large', 'larger', 'x-large', 'xx-large')
        """
        Component.__init__(self, locals(), identity)
