"""Autogenerated file: DO NOT EDIT!"""
import typing  # noqa: F401
from dazzler.system import Component, Aspect, UNDEFINED  # noqa: F401


class Form(Component):
    """
    A form element with auto fields.

    :CSS:

        - ``dazzler-core-form``
        - ``form-header``
        - ``form-body``
        - ``form-field``
        - ``field-error``
        - ``form-label``
        - ``form-input``
        - ``form-footer``
        - ``form-submit``
    """
    _aspect_keys = []
    _children = []
    fields = Aspect(children=True, docstring="Fields of the form, either provide a component or a type for the input.")  # noqa: E501
    header = Aspect(children=True, docstring="Render on top of the form (CSS: form-header)")  # noqa: E501
    body = Aspect(children=True, docstring="Render in the middle of the form, after the fields. (CSS: form-body)")  # noqa: E501
    footer = Aspect(children=True, docstring="Render at the bottom of the form (CSS: form-footer)")  # noqa: E501
    action = Aspect(docstring="Url to submit the form.")
    method = Aspect(docstring="Http method to submit the form. (Possible values: 'get', 'post')")  # noqa: E501
    target = Aspect(docstring="How will the response display. (Possible values: '_blank', '_self', '_parent', '_top')")  # noqa: E501
    name = Aspect(docstring="Name of the form.")
    auto_complete = Aspect(docstring="Specifies auto complete for the form. (Possible values: 'on', 'off')")  # noqa: E501
    enctype = Aspect(docstring="How the data is encode before submit. (Possible values: 'application/x-www-form-urlencoded', 'multipart/form-data', 'text/plain')")  # noqa: E501
    accept_charset = Aspect(docstring="Character encoding for submission.")
    no_validate = Aspect(docstring="Specify the form should be validated on submission.")  # noqa: E501
    class_name = Aspect(docstring="CSS class of the form element.")
    style = Aspect(docstring="Style object of the form element.")
    errors = Aspect(default=UNDEFINED, docstring="Errors to show with the fields. Keys are name. (default={})")  # noqa: E501
    include_submit = Aspect(default=True, docstring="Include a submit button on the form. (default=True)")  # noqa: E501
    submit_label = Aspect(default='Submit', docstring="Label of the submit button. (default='Submit')")  # noqa: E501

    def __init__(
            self,
            fields: typing.Optional[typing.List[typing.Dict[str, typing.Union[str, typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]], typing.Any]]]] = UNDEFINED,  # noqa: E501
            header: typing.Optional[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]] = UNDEFINED,  # noqa: E501
            body: typing.Optional[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]] = UNDEFINED,  # noqa: E501
            footer: typing.Optional[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]] = UNDEFINED,  # noqa: E501
            action: typing.Optional[str] = UNDEFINED,
            method: typing.Optional[typing.Any] = UNDEFINED,
            target: typing.Optional[typing.Any] = UNDEFINED,
            name: typing.Optional[str] = UNDEFINED,
            auto_complete: typing.Optional[typing.Any] = UNDEFINED,
            enctype: typing.Optional[typing.Any] = UNDEFINED,
            accept_charset: typing.Optional[str] = UNDEFINED,
            no_validate: typing.Optional[bool] = UNDEFINED,
            class_name: typing.Optional[str] = UNDEFINED,
            style: typing.Optional[typing.Dict] = UNDEFINED,
            errors: typing.Optional[typing.Dict] = UNDEFINED,
            include_submit: typing.Optional[bool] = True,
            submit_label: typing.Optional[str] = 'Submit',
            identity: str = None
    ):
        """
        :param fields: Fields of the form, either provide a component or a
            type for the input.
        :param header: Render on top of the form (CSS: form-header)
        :param body: Render in the middle of the form, after the fields.
            (CSS: form-body)
        :param footer: Render at the bottom of the form (CSS: form-footer)
        :param action: Url to submit the form.
        :param method: Http method to submit the form. (Possible values:
            'get', 'post')
        :param target: How will the response display. (Possible values:
            '_blank', '_self', '_parent', '_top')
        :param name: Name of the form.
        :param auto_complete: Specifies auto complete for the form.
            (Possible values: 'on', 'off')
        :param enctype: How the data is encode before submit. (Possible
            values: 'application/x-www-form-urlencoded', 'multipart/form-data',
            'text/plain')
        :param accept_charset: Character encoding for submission.
        :param no_validate: Specify the form should be validated on
            submission.
        :param class_name: CSS class of the form element.
        :param style: Style object of the form element.
        :param errors: Errors to show with the fields. Keys are name.
            (default={})
        :param include_submit: Include a submit button on the form.
            (default=True)
        :param submit_label: Label of the submit button. (default='Submit')
        """
        Component.__init__(self, locals(), identity)
