"""Autogenerated file: DO NOT EDIT!"""
import typing  # noqa: F401
from dazzler.system import Component, Aspect, UNDEFINED  # noqa: F401


class ListBox(Component):
    """
    A component where you can ``add`` items to instead of rendering
    the whole list again. With an optional max size.

    :CSS:

        - ``dazzler-core-list-box``
        - ``vertical``
        - ``horizontal``
        - ``scrollable``

    :example:

    .. literalinclude:: ../../tests/components/pages/list_box.py
    """
    _aspect_keys = []
    _children = []
    items = Aspect(default=UNDEFINED, children=True, docstring="List of items to render. (default=[])")  # noqa: E501
    max_length = Aspect(docstring="Maximum amount of items in the list, extra items will be popped off.")  # noqa: E501
    append = Aspect(children=True, docstring="Add an item to the end of the list.")  # noqa: E501
    prepend = Aspect(children=True, docstring="Add an item to the start of the list.")  # noqa: E501
    concat = Aspect(children=True, docstring="Concatenate another list with the current items.")  # noqa: E501
    insert = Aspect(children=True, docstring="Insert an item at an index position.")  # noqa: E501
    delete_index = Aspect(docstring="Delete the item at the index.")
    scrollable = Aspect(docstring="Wether the list box container is scrollable.")  # noqa: E501
    direction = Aspect(default="'vertical'", docstring="In which direction the items will be inserted. (Possible values: 'vertical', 'horizontal') (default="'vertical'")")  # noqa: E501
    size = Aspect(docstring="Must be set for the scrollable aspect to work.Height or width in pixels depending on the direction aspect.")  # noqa: E501
    keep_scroll = Aspect(docstring="Keep the last appended item in view if scrolling is enabled.")  # noqa: E501
    class_name = Aspect()
    style = Aspect()

    def __init__(
            self,
            items: typing.Optional[typing.List[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]]] = UNDEFINED,  # noqa: E501
            max_length: typing.Optional[typing.Union[float, int]] = UNDEFINED,
            append: typing.Optional[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]] = UNDEFINED,  # noqa: E501
            prepend: typing.Optional[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]] = UNDEFINED,  # noqa: E501
            concat: typing.Optional[typing.List[typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]]] = UNDEFINED,  # noqa: E501
            insert: typing.Optional[typing.Dict[str, typing.Union[typing.Union[float, int], typing.Union[str, int, float, Component, typing.List[typing.Union[str, int, float, Component]]]]]] = UNDEFINED,  # noqa: E501
            delete_index: typing.Optional[typing.Union[float, int]] = UNDEFINED,  # noqa: E501
            scrollable: typing.Optional[bool] = UNDEFINED,
            direction: typing.Optional[typing.Any] = "'vertical'",
            size: typing.Optional[typing.Union[float, int]] = UNDEFINED,
            keep_scroll: typing.Optional[bool] = UNDEFINED,
            class_name: typing.Optional[str] = UNDEFINED,
            style: typing.Optional[typing.Dict] = UNDEFINED,
            identity: str = None
    ):
        """
        :param items: List of items to render. (default=[])
        :param max_length: Maximum amount of items in the list, extra items
            will be popped off.
        :param append: Add an item to the end of the list.
        :param prepend: Add an item to the start of the list.
        :param concat: Concatenate another list with the current items.
        :param insert: Insert an item at an index position.
        :param delete_index: Delete the item at the index.
        :param scrollable: Wether the list box container is scrollable.
        :param direction: In which direction the items will be inserted.
            (Possible values: 'vertical', 'horizontal') (default="'vertical'")
        :param size: Must be set for the scrollable aspect to work. Height
            or width in pixels depending on the direction aspect.
        :param keep_scroll: Keep the last appended item in view if
            scrolling is enabled.
        :param class_name:
        :param style:
        """
        Component.__init__(self, locals(), identity)
