"""Autogenerated file: DO NOT EDIT!"""
import typing  # noqa: F401
from dazzler.system import Component, Aspect, UNDEFINED  # noqa: F401


class ProgressBar(Component):
    """
    Simple progress bar support by all browsers.

    :CSS:

        - ``dazzler-core-progress-bar``
        - ``progress``
        - ``high``
        - ``low``
        - ``optimum``
        - ``striped``
        - ``rounded``
    """
    _aspect_keys = []
    _children = []
    value = Aspect(default=0, docstring="The current numeric value. This must be between the minimum and maximum values (min attribute and max attribute) if they are specified. If unspecified or malformed, the value is 0. If specified, but not within the range given by the min attribute and max attribute, the value is equal to the nearest end of the range. (default=0)")  # noqa: E501
    minimum = Aspect(default=0, docstring="The lower numeric bound of the measured range. This must be less than the maximum value (max attribute), if specified. If unspecified, the minimum value is 0 (default=0)")  # noqa: E501
    maximum = Aspect(default=100, docstring="The upper numeric bound of the measured range. This must be greater than the minimum value (min attribute), if specified. If unspecified, the maximum value is 1. (default=100)")  # noqa: E501
    low = Aspect(docstring="The upper numeric bound of the low end of the measured range. This must be greater than the minimum value (min attribute), and it also must be less than the high value and maximum value (high attribute and max attribute, respectively), if any are specified. If unspecified, or if less than the minimum value, the low value is equal to the minimum value.")  # noqa: E501
    high = Aspect(docstring="The lower numeric bound of the high end of the measured range. This must be less than the maximum value (max attribute), and it also must be greater than the low value and minimum value (low attribute and min attribute, respectively), if any are specified. If unspecified, or if greater than the maximum value, the high value is equal to the maximum value.")  # noqa: E501
    optimum = Aspect(docstring="This attribute indicates the optimal numeric value. It must be within the range (as defined by the min attribute and max attribute). When used with the low attribute and high attribute, it gives an indication where along the range is considered preferable. For example, if it is between the min attribute and the low attribute, then the lower range is considered preferred.")  # noqa: E501
    id = Aspect(docstring="Id for this component, otherwise the identity is used.")  # noqa: E501
    class_name = Aspect(docstring="CSS class of the outer container.")
    progress_class_name = Aspect(docstring="CSS class of the inner progress container.")  # noqa: E501
    style = Aspect(docstring="Style of the component.")
    progress_text = Aspect(docstring="Set to show the value on the progress bar. (Possible values: 'percent', 'value')")  # noqa: E501
    click = Aspect(docstring="Readonly click event with the value.")
    striped = Aspect(docstring="Use striped style.")
    rounded = Aspect(docstring="Use the rounded style")

    def __init__(
            self,
            value: typing.Optional[typing.Union[float, int]] = 0,
            minimum: typing.Optional[typing.Union[float, int]] = 0,
            maximum: typing.Optional[typing.Union[float, int]] = 100,
            low: typing.Optional[typing.Union[float, int]] = UNDEFINED,
            high: typing.Optional[typing.Union[float, int]] = UNDEFINED,
            optimum: typing.Optional[typing.Union[float, int]] = UNDEFINED,
            id: typing.Optional[str] = UNDEFINED,
            class_name: typing.Optional[str] = UNDEFINED,
            progress_class_name: typing.Optional[str] = UNDEFINED,
            style: typing.Optional[typing.Dict] = UNDEFINED,
            progress_text: typing.Optional[typing.Any] = UNDEFINED,
            click: typing.Optional[typing.Dict[str, typing.Union[typing.Union[float, int]]]] = UNDEFINED,  # noqa: E501
            striped: typing.Optional[bool] = UNDEFINED,
            rounded: typing.Optional[bool] = UNDEFINED,
            identity: str = None
    ):
        """
        :param value: The current numeric value. This must be between the
            minimum and maximum values (min attribute and max attribute) if
            they are specified. If unspecified or malformed, the value is 0. If
            specified, but not within the range given by the min attribute and
            max attribute, the value is equal to the nearest end of the range.
            (default=0)
        :param minimum: The lower numeric bound of the measured range. This
            must be less than the maximum value (max attribute), if specified.
            If unspecified, the minimum value is 0 (default=0)
        :param maximum: The upper numeric bound of the measured range. This
            must be greater than the minimum value (min attribute), if
            specified. If unspecified, the maximum value is 1. (default=100)
        :param low: The upper numeric bound of the low end of the measured
            range. This must be greater than the minimum value (min attribute),
            and it also must be less than the high value and maximum value
            (high attribute and max attribute, respectively), if any are
            specified. If unspecified, or if less than the minimum value, the
            low value is equal to the minimum value.
        :param high: The lower numeric bound of the high end of the
            measured range. This must be less than the maximum value (max
            attribute), and it also must be greater than the low value and
            minimum value (low attribute and min attribute, respectively), if
            any are specified. If unspecified, or if greater than the maximum
            value, the high value is equal to the maximum value.
        :param optimum: This attribute indicates the optimal numeric value.
            It must be within the range (as defined by the min attribute and
            max attribute). When used with the low attribute and high
            attribute, it gives an indication where along the range is
            considered preferable. For example, if it is between the min
            attribute and the low attribute, then the lower range is considered
            preferred.
        :param id: Id for this component, otherwise the identity is used.
        :param class_name: CSS class of the outer container.
        :param progress_class_name: CSS class of the inner progress
            container.
        :param style: Style of the component.
        :param progress_text: Set to show the value on the progress bar.
            (Possible values: 'percent', 'value')
        :param click: Readonly click event with the value.
        :param striped: Use striped style.
        :param rounded: Use the rounded style
        """
        Component.__init__(self, locals(), identity)
