"""Autogenerated file: DO NOT EDIT!"""
import typing  # noqa: F401
from dazzler.system import Component, Aspect, UNDEFINED  # noqa: F401


class Slider(Component):
    """
    A slider with a caret contained within a min and max value.

    :CSS:

        - ``dazzler-core-slider``
        - ``slider-area``: The outer div of the slider.
        - ``slider-handle``: The drag handle
        - ``slider-spacer``: The space that is before the handle.

    :Example:

    .. literalinclude:: ../../tests/components/pages/slider.py
        :lines: 5-43
    """
    _aspect_keys = []
    _children = []
    minimum = Aspect(required=True, docstring="Minimum (leftmost) value of the slider.")  # noqa: E501
    maximum = Aspect(required=True, docstring="Maximum (rightmost) value of the slider.")  # noqa: E501
    value = Aspect(default=0, docstring="Current value (default=0)")
    round = Aspect(docstring="Round the value (Possible values: 'ceil', 'floor')")  # noqa: E501
    debounce = Aspect(default=50, docstring="Time in milliseconds to wait before updating the value. (default=50)")  # noqa: E501
    class_name = Aspect(docstring="CSS classes to use. (Scope: dazzler-core-slider)")  # noqa: E501
    style = Aspect(docstring="Style object of the root div.")

    def __init__(
            self,
            minimum: typing.Union[float, int],
            maximum: typing.Union[float, int],
            value: typing.Optional[typing.Union[float, int]] = 0,
            round: typing.Optional[typing.Any] = UNDEFINED,
            debounce: typing.Optional[typing.Union[float, int]] = 50,
            class_name: typing.Optional[str] = UNDEFINED,
            style: typing.Optional[typing.Dict] = UNDEFINED,
            identity: str = None
    ):
        """
        :param minimum: Minimum (leftmost) value of the slider.
        :param maximum: Maximum (rightmost) value of the slider.
        :param value: Current value (default=0)
        :param round: Round the value (Possible values: 'ceil', 'floor')
        :param debounce: Time in milliseconds to wait before updating the
            value. (default=50)
        :param class_name: CSS classes to use. (Scope: dazzler-core-slider)
        :param style: Style object of the root div.
        """
        Component.__init__(self, locals(), identity)
