"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format}
*/
class FileFormat extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FileFormatConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_file_format',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.33.1',
                providerVersionConstraint: ' ~> 0.25'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._allowDuplicate = config.allowDuplicate;
        this._binaryAsText = config.binaryAsText;
        this._binaryFormat = config.binaryFormat;
        this._comment = config.comment;
        this._compression = config.compression;
        this._database = config.database;
        this._dateFormat = config.dateFormat;
        this._disableAutoConvert = config.disableAutoConvert;
        this._disableSnowflakeData = config.disableSnowflakeData;
        this._emptyFieldAsNull = config.emptyFieldAsNull;
        this._enableOctal = config.enableOctal;
        this._encoding = config.encoding;
        this._errorOnColumnCountMismatch = config.errorOnColumnCountMismatch;
        this._escape = config.escape;
        this._escapeUnenclosedField = config.escapeUnenclosedField;
        this._fieldDelimiter = config.fieldDelimiter;
        this._fieldOptionallyEnclosedBy = config.fieldOptionallyEnclosedBy;
        this._fileExtension = config.fileExtension;
        this._formatType = config.formatType;
        this._ignoreUtf8Errors = config.ignoreUtf8Errors;
        this._name = config.name;
        this._nullIf = config.nullIf;
        this._preserveSpace = config.preserveSpace;
        this._recordDelimiter = config.recordDelimiter;
        this._replaceInvalidCharacters = config.replaceInvalidCharacters;
        this._schema = config.schema;
        this._skipBlankLines = config.skipBlankLines;
        this._skipByteOrderMark = config.skipByteOrderMark;
        this._skipHeader = config.skipHeader;
        this._stripNullValues = config.stripNullValues;
        this._stripOuterArray = config.stripOuterArray;
        this._stripOuterElement = config.stripOuterElement;
        this._timeFormat = config.timeFormat;
        this._timestampFormat = config.timestampFormat;
        this._trimSpace = config.trimSpace;
        this._validateUtf8 = config.validateUtf8;
    }
    get allowDuplicate() {
        return this.getBooleanAttribute('allow_duplicate');
    }
    set allowDuplicate(value) {
        this._allowDuplicate = value;
    }
    resetAllowDuplicate() {
        this._allowDuplicate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowDuplicateInput() {
        return this._allowDuplicate;
    }
    get binaryAsText() {
        return this.getBooleanAttribute('binary_as_text');
    }
    set binaryAsText(value) {
        this._binaryAsText = value;
    }
    resetBinaryAsText() {
        this._binaryAsText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAsTextInput() {
        return this._binaryAsText;
    }
    get binaryFormat() {
        return this.getStringAttribute('binary_format');
    }
    set binaryFormat(value) {
        this._binaryFormat = value;
    }
    resetBinaryFormat() {
        this._binaryFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryFormatInput() {
        return this._binaryFormat;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get compression() {
        return this.getStringAttribute('compression');
    }
    set compression(value) {
        this._compression = value;
    }
    resetCompression() {
        this._compression = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressionInput() {
        return this._compression;
    }
    get database() {
        return this.getStringAttribute('database');
    }
    set database(value) {
        this._database = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseInput() {
        return this._database;
    }
    get dateFormat() {
        return this.getStringAttribute('date_format');
    }
    set dateFormat(value) {
        this._dateFormat = value;
    }
    resetDateFormat() {
        this._dateFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dateFormatInput() {
        return this._dateFormat;
    }
    get disableAutoConvert() {
        return this.getBooleanAttribute('disable_auto_convert');
    }
    set disableAutoConvert(value) {
        this._disableAutoConvert = value;
    }
    resetDisableAutoConvert() {
        this._disableAutoConvert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableAutoConvertInput() {
        return this._disableAutoConvert;
    }
    get disableSnowflakeData() {
        return this.getBooleanAttribute('disable_snowflake_data');
    }
    set disableSnowflakeData(value) {
        this._disableSnowflakeData = value;
    }
    resetDisableSnowflakeData() {
        this._disableSnowflakeData = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableSnowflakeDataInput() {
        return this._disableSnowflakeData;
    }
    get emptyFieldAsNull() {
        return this.getBooleanAttribute('empty_field_as_null');
    }
    set emptyFieldAsNull(value) {
        this._emptyFieldAsNull = value;
    }
    resetEmptyFieldAsNull() {
        this._emptyFieldAsNull = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emptyFieldAsNullInput() {
        return this._emptyFieldAsNull;
    }
    get enableOctal() {
        return this.getBooleanAttribute('enable_octal');
    }
    set enableOctal(value) {
        this._enableOctal = value;
    }
    resetEnableOctal() {
        this._enableOctal = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableOctalInput() {
        return this._enableOctal;
    }
    get encoding() {
        return this.getStringAttribute('encoding');
    }
    set encoding(value) {
        this._encoding = value;
    }
    resetEncoding() {
        this._encoding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encodingInput() {
        return this._encoding;
    }
    get errorOnColumnCountMismatch() {
        return this.getBooleanAttribute('error_on_column_count_mismatch');
    }
    set errorOnColumnCountMismatch(value) {
        this._errorOnColumnCountMismatch = value;
    }
    resetErrorOnColumnCountMismatch() {
        this._errorOnColumnCountMismatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorOnColumnCountMismatchInput() {
        return this._errorOnColumnCountMismatch;
    }
    get escape() {
        return this.getStringAttribute('escape');
    }
    set escape(value) {
        this._escape = value;
    }
    resetEscape() {
        this._escape = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeInput() {
        return this._escape;
    }
    get escapeUnenclosedField() {
        return this.getStringAttribute('escape_unenclosed_field');
    }
    set escapeUnenclosedField(value) {
        this._escapeUnenclosedField = value;
    }
    resetEscapeUnenclosedField() {
        this._escapeUnenclosedField = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeUnenclosedFieldInput() {
        return this._escapeUnenclosedField;
    }
    get fieldDelimiter() {
        return this.getStringAttribute('field_delimiter');
    }
    set fieldDelimiter(value) {
        this._fieldDelimiter = value;
    }
    resetFieldDelimiter() {
        this._fieldDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldDelimiterInput() {
        return this._fieldDelimiter;
    }
    get fieldOptionallyEnclosedBy() {
        return this.getStringAttribute('field_optionally_enclosed_by');
    }
    set fieldOptionallyEnclosedBy(value) {
        this._fieldOptionallyEnclosedBy = value;
    }
    resetFieldOptionallyEnclosedBy() {
        this._fieldOptionallyEnclosedBy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldOptionallyEnclosedByInput() {
        return this._fieldOptionallyEnclosedBy;
    }
    get fileExtension() {
        return this.getStringAttribute('file_extension');
    }
    set fileExtension(value) {
        this._fileExtension = value;
    }
    resetFileExtension() {
        this._fileExtension = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileExtensionInput() {
        return this._fileExtension;
    }
    get formatType() {
        return this.getStringAttribute('format_type');
    }
    set formatType(value) {
        this._formatType = value;
    }
    // Temporarily expose input value. Use with caution.
    get formatTypeInput() {
        return this._formatType;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ignoreUtf8Errors() {
        return this.getBooleanAttribute('ignore_utf8_errors');
    }
    set ignoreUtf8Errors(value) {
        this._ignoreUtf8Errors = value;
    }
    resetIgnoreUtf8Errors() {
        this._ignoreUtf8Errors = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreUtf8ErrorsInput() {
        return this._ignoreUtf8Errors;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nullIf() {
        return this.getListAttribute('null_if');
    }
    set nullIf(value) {
        this._nullIf = value;
    }
    resetNullIf() {
        this._nullIf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nullIfInput() {
        return this._nullIf;
    }
    get preserveSpace() {
        return this.getBooleanAttribute('preserve_space');
    }
    set preserveSpace(value) {
        this._preserveSpace = value;
    }
    resetPreserveSpace() {
        this._preserveSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preserveSpaceInput() {
        return this._preserveSpace;
    }
    get recordDelimiter() {
        return this.getStringAttribute('record_delimiter');
    }
    set recordDelimiter(value) {
        this._recordDelimiter = value;
    }
    resetRecordDelimiter() {
        this._recordDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recordDelimiterInput() {
        return this._recordDelimiter;
    }
    get replaceInvalidCharacters() {
        return this.getBooleanAttribute('replace_invalid_characters');
    }
    set replaceInvalidCharacters(value) {
        this._replaceInvalidCharacters = value;
    }
    resetReplaceInvalidCharacters() {
        this._replaceInvalidCharacters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceInvalidCharactersInput() {
        return this._replaceInvalidCharacters;
    }
    get schema() {
        return this.getStringAttribute('schema');
    }
    set schema(value) {
        this._schema = value;
    }
    // Temporarily expose input value. Use with caution.
    get schemaInput() {
        return this._schema;
    }
    get skipBlankLines() {
        return this.getBooleanAttribute('skip_blank_lines');
    }
    set skipBlankLines(value) {
        this._skipBlankLines = value;
    }
    resetSkipBlankLines() {
        this._skipBlankLines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipBlankLinesInput() {
        return this._skipBlankLines;
    }
    get skipByteOrderMark() {
        return this.getBooleanAttribute('skip_byte_order_mark');
    }
    set skipByteOrderMark(value) {
        this._skipByteOrderMark = value;
    }
    resetSkipByteOrderMark() {
        this._skipByteOrderMark = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipByteOrderMarkInput() {
        return this._skipByteOrderMark;
    }
    get skipHeader() {
        return this.getNumberAttribute('skip_header');
    }
    set skipHeader(value) {
        this._skipHeader = value;
    }
    resetSkipHeader() {
        this._skipHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipHeaderInput() {
        return this._skipHeader;
    }
    get stripNullValues() {
        return this.getBooleanAttribute('strip_null_values');
    }
    set stripNullValues(value) {
        this._stripNullValues = value;
    }
    resetStripNullValues() {
        this._stripNullValues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripNullValuesInput() {
        return this._stripNullValues;
    }
    get stripOuterArray() {
        return this.getBooleanAttribute('strip_outer_array');
    }
    set stripOuterArray(value) {
        this._stripOuterArray = value;
    }
    resetStripOuterArray() {
        this._stripOuterArray = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterArrayInput() {
        return this._stripOuterArray;
    }
    get stripOuterElement() {
        return this.getBooleanAttribute('strip_outer_element');
    }
    set stripOuterElement(value) {
        this._stripOuterElement = value;
    }
    resetStripOuterElement() {
        this._stripOuterElement = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterElementInput() {
        return this._stripOuterElement;
    }
    get timeFormat() {
        return this.getStringAttribute('time_format');
    }
    set timeFormat(value) {
        this._timeFormat = value;
    }
    resetTimeFormat() {
        this._timeFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFormatInput() {
        return this._timeFormat;
    }
    get timestampFormat() {
        return this.getStringAttribute('timestamp_format');
    }
    set timestampFormat(value) {
        this._timestampFormat = value;
    }
    resetTimestampFormat() {
        this._timestampFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampFormatInput() {
        return this._timestampFormat;
    }
    get trimSpace() {
        return this.getBooleanAttribute('trim_space');
    }
    set trimSpace(value) {
        this._trimSpace = value;
    }
    resetTrimSpace() {
        this._trimSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trimSpaceInput() {
        return this._trimSpace;
    }
    get validateUtf8() {
        return this.getBooleanAttribute('validate_utf8');
    }
    set validateUtf8(value) {
        this._validateUtf8 = value;
    }
    resetValidateUtf8() {
        this._validateUtf8 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get validateUtf8Input() {
        return this._validateUtf8;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_duplicate: cdktf.booleanToTerraform(this._allowDuplicate),
            binary_as_text: cdktf.booleanToTerraform(this._binaryAsText),
            binary_format: cdktf.stringToTerraform(this._binaryFormat),
            comment: cdktf.stringToTerraform(this._comment),
            compression: cdktf.stringToTerraform(this._compression),
            database: cdktf.stringToTerraform(this._database),
            date_format: cdktf.stringToTerraform(this._dateFormat),
            disable_auto_convert: cdktf.booleanToTerraform(this._disableAutoConvert),
            disable_snowflake_data: cdktf.booleanToTerraform(this._disableSnowflakeData),
            empty_field_as_null: cdktf.booleanToTerraform(this._emptyFieldAsNull),
            enable_octal: cdktf.booleanToTerraform(this._enableOctal),
            encoding: cdktf.stringToTerraform(this._encoding),
            error_on_column_count_mismatch: cdktf.booleanToTerraform(this._errorOnColumnCountMismatch),
            escape: cdktf.stringToTerraform(this._escape),
            escape_unenclosed_field: cdktf.stringToTerraform(this._escapeUnenclosedField),
            field_delimiter: cdktf.stringToTerraform(this._fieldDelimiter),
            field_optionally_enclosed_by: cdktf.stringToTerraform(this._fieldOptionallyEnclosedBy),
            file_extension: cdktf.stringToTerraform(this._fileExtension),
            format_type: cdktf.stringToTerraform(this._formatType),
            ignore_utf8_errors: cdktf.booleanToTerraform(this._ignoreUtf8Errors),
            name: cdktf.stringToTerraform(this._name),
            null_if: cdktf.listMapper(cdktf.stringToTerraform)(this._nullIf),
            preserve_space: cdktf.booleanToTerraform(this._preserveSpace),
            record_delimiter: cdktf.stringToTerraform(this._recordDelimiter),
            replace_invalid_characters: cdktf.booleanToTerraform(this._replaceInvalidCharacters),
            schema: cdktf.stringToTerraform(this._schema),
            skip_blank_lines: cdktf.booleanToTerraform(this._skipBlankLines),
            skip_byte_order_mark: cdktf.booleanToTerraform(this._skipByteOrderMark),
            skip_header: cdktf.numberToTerraform(this._skipHeader),
            strip_null_values: cdktf.booleanToTerraform(this._stripNullValues),
            strip_outer_array: cdktf.booleanToTerraform(this._stripOuterArray),
            strip_outer_element: cdktf.booleanToTerraform(this._stripOuterElement),
            time_format: cdktf.stringToTerraform(this._timeFormat),
            timestamp_format: cdktf.stringToTerraform(this._timestampFormat),
            trim_space: cdktf.booleanToTerraform(this._trimSpace),
            validate_utf8: cdktf.booleanToTerraform(this._validateUtf8),
        };
    }
}
exports.FileFormat = FileFormat;
_a = JSII_RTTI_SYMBOL_1;
FileFormat[_a] = { fqn: "@cdktf/provider-snowflake.FileFormat", version: "0.1.67" };
// =================
// STATIC PROPERTIES
// =================
FileFormat.tfResourceType = "snowflake_file_format";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsZS1mb3JtYXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZmlsZS1mb3JtYXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFJQSwrQkFBK0I7QUErTi9COztFQUVFO0FBQ0YsTUFBYSxVQUFXLFNBQVEsS0FBSyxDQUFDLGlCQUFpQjtJQU9yRCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZDs7Ozs7O01BTUU7SUFDRixZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUF3QjtRQUN2RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLHVCQUF1QjtZQUM5QywwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLFdBQVc7Z0JBQ3pCLGVBQWUsRUFBRSxRQUFRO2dCQUN6Qix5QkFBeUIsRUFBRSxVQUFVO2FBQ3RDO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7UUFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQywyQkFBMkIsR0FBRyxNQUFNLENBQUMsMEJBQTBCLENBQUM7UUFDckUsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxNQUFNLENBQUMscUJBQXFCLENBQUM7UUFDM0QsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUM7UUFDN0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxNQUFNLENBQUMsd0JBQXdCLENBQUM7UUFDakUsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsTUFBTSxDQUFDLGlCQUFpQixDQUFDO1FBQ25ELElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsTUFBTSxDQUFDLGlCQUFpQixDQUFDO1FBQ25ELElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDbkMsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO0lBQzNDLENBQUM7SUFRRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBa0M7UUFDMUQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQWtDO1FBQ3hELElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBYTtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFrQztRQUM5RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFDTSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFDRCxJQUFXLG9CQUFvQixDQUFDLEtBQWtDO1FBQ2hFLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNNLHlCQUF5QjtRQUM5QixJQUFJLENBQUMscUJBQXFCLEdBQUcsU0FBUyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDekQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBa0M7UUFDNUQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxTQUFTLENBQUM7SUFDckMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFrQztRQUN2RCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLDBCQUEwQjtRQUNuQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7SUFDRCxJQUFXLDBCQUEwQixDQUFDLEtBQWtDO1FBQ3RFLElBQUksQ0FBQywyQkFBMkIsR0FBRyxLQUFLLENBQUM7SUFDM0MsQ0FBQztJQUNNLCtCQUErQjtRQUNwQyxJQUFJLENBQUMsMkJBQTJCLEdBQUcsU0FBUyxDQUFDO0lBQy9DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywrQkFBK0I7UUFDeEMsT0FBTyxJQUFJLENBQUMsMkJBQTJCLENBQUM7SUFDMUMsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBQ0QsSUFBVyxxQkFBcUIsQ0FBQyxLQUFhO1FBQzVDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7SUFDdEMsQ0FBQztJQUNNLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsU0FBUyxDQUFDO0lBQzFDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywwQkFBMEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUlELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakUsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBYTtRQUNoRCxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDTSw4QkFBOEI7UUFDbkMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLFNBQVMsQ0FBQztJQUM5QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsOEJBQThCO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQ0QsSUFBVyxhQUFhLENBQUMsS0FBYTtRQUNwQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWE7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFFRCx1REFBdUQ7SUFDdkQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBa0M7UUFDNUQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxTQUFTLENBQUM7SUFDckMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBZTtRQUMvQixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFrQztRQUN6RCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7SUFDRCxJQUFXLHdCQUF3QixDQUFDLEtBQWtDO1FBQ3BFLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUM7SUFDekMsQ0FBQztJQUNNLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsU0FBUyxDQUFDO0lBQzdDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw2QkFBNkI7UUFDdEMsT0FBTyxJQUFJLENBQUMseUJBQXlCLENBQUM7SUFDeEMsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWtDO1FBQzFELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFDTSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7SUFDbkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBa0M7UUFDN0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWtDO1FBQzNELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUNNLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO0lBQ3BDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUlELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxJQUFXLGVBQWUsQ0FBQyxLQUFrQztRQUMzRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQWtDO1FBQzdELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFDRCxJQUFXLGVBQWUsQ0FBQyxLQUFhO1FBQ3RDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUNNLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO0lBQ3BDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBa0M7UUFDckQsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQWtDO1FBQ3hELElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsZUFBZSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO1lBQy9ELGNBQWMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztZQUM1RCxhQUFhLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUM7WUFDMUQsT0FBTyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQy9DLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN2RCxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDakQsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELG9CQUFvQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7WUFDeEUsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztZQUM1RSxtQkFBbUIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ3JFLFlBQVksRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN6RCxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDakQsOEJBQThCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQywyQkFBMkIsQ0FBQztZQUMxRixNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDN0MsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztZQUM3RSxlQUFlLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDOUQsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQywwQkFBMEIsQ0FBQztZQUN0RixjQUFjLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDNUQsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7WUFDcEUsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLE9BQU8sRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDaEUsY0FBYyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1lBQzdELGdCQUFnQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7WUFDaEUsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztZQUNwRixNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDN0MsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDaEUsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztZQUN2RSxXQUFXLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7WUFDdEQsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztZQUNsRSxpQkFBaUIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1lBQ2xFLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUM7WUFDdEUsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELGdCQUFnQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7WUFDaEUsVUFBVSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO1lBQ3JELGFBQWEsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztTQUM1RCxDQUFDO0lBQ0osQ0FBQzs7QUE3cUJILGdDQThxQkM7OztBQTVxQkMsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyx5QkFBYyxHQUFHLHVCQUF1QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0XG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgRmlsZUZvcm1hdENvbmZpZyBleHRlbmRzIGNka3RmLlRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICAvKipcbiAgKiBCb29sZWFuIHRoYXQgc3BlY2lmaWVzIHRvIGFsbG93IGR1cGxpY2F0ZSBvYmplY3QgZmllbGQgbmFtZXMgKG9ubHkgdGhlIGxhc3Qgb25lIHdpbGwgYmUgcHJlc2VydmVkKS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNhbGxvd19kdXBsaWNhdGUgRmlsZUZvcm1hdCNhbGxvd19kdXBsaWNhdGV9XG4gICovXG4gIHJlYWRvbmx5IGFsbG93RHVwbGljYXRlPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBCb29sZWFuIHRoYXQgc3BlY2lmaWVzIHdoZXRoZXIgdG8gaW50ZXJwcmV0IGNvbHVtbnMgd2l0aCBubyBkZWZpbmVkIGxvZ2ljYWwgZGF0YSB0eXBlIGFzIFVURi04IHRleHQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjYmluYXJ5X2FzX3RleHQgRmlsZUZvcm1hdCNiaW5hcnlfYXNfdGV4dH1cbiAgKi9cbiAgcmVhZG9ubHkgYmluYXJ5QXNUZXh0PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEZWZpbmVzIHRoZSBlbmNvZGluZyBmb3JtYXQgZm9yIGJpbmFyeSBpbnB1dCBvciBvdXRwdXQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjYmluYXJ5X2Zvcm1hdCBGaWxlRm9ybWF0I2JpbmFyeV9mb3JtYXR9XG4gICovXG4gIHJlYWRvbmx5IGJpbmFyeUZvcm1hdD86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIGEgY29tbWVudCBmb3IgdGhlIGZpbGUgZm9ybWF0LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I2NvbW1lbnQgRmlsZUZvcm1hdCNjb21tZW50fVxuICAqL1xuICByZWFkb25seSBjb21tZW50Pzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIGN1cnJlbnQgY29tcHJlc3Npb24gYWxnb3JpdGhtIGZvciB0aGUgZGF0YSBmaWxlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I2NvbXByZXNzaW9uIEZpbGVGb3JtYXQjY29tcHJlc3Npb259XG4gICovXG4gIHJlYWRvbmx5IGNvbXByZXNzaW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgZGF0YWJhc2UgaW4gd2hpY2ggdG8gY3JlYXRlIHRoZSBmaWxlIGZvcm1hdC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNkYXRhYmFzZSBGaWxlRm9ybWF0I2RhdGFiYXNlfVxuICAqL1xuICByZWFkb25seSBkYXRhYmFzZTogc3RyaW5nO1xuICAvKipcbiAgKiBEZWZpbmVzIHRoZSBmb3JtYXQgb2YgZGF0ZSB2YWx1ZXMgaW4gdGhlIGRhdGEgZmlsZXMgKGRhdGEgbG9hZGluZykgb3IgdGFibGUgKGRhdGEgdW5sb2FkaW5nKS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNkYXRlX2Zvcm1hdCBGaWxlRm9ybWF0I2RhdGVfZm9ybWF0fVxuICAqL1xuICByZWFkb25seSBkYXRlRm9ybWF0Pzogc3RyaW5nO1xuICAvKipcbiAgKiBCb29sZWFuIHRoYXQgc3BlY2lmaWVzIHdoZXRoZXIgdGhlIFhNTCBwYXJzZXIgZGlzYWJsZXMgYXV0b21hdGljIGNvbnZlcnNpb24gb2YgbnVtZXJpYyBhbmQgQm9vbGVhbiB2YWx1ZXMgZnJvbSB0ZXh0IHRvIG5hdGl2ZSByZXByZXNlbnRhdGlvbi5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNkaXNhYmxlX2F1dG9fY29udmVydCBGaWxlRm9ybWF0I2Rpc2FibGVfYXV0b19jb252ZXJ0fVxuICAqL1xuICByZWFkb25seSBkaXNhYmxlQXV0b0NvbnZlcnQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEJvb2xlYW4gdGhhdCBzcGVjaWZpZXMgd2hldGhlciB0aGUgWE1MIHBhcnNlciBkaXNhYmxlcyByZWNvZ25pdGlvbiBvZiBTbm93Zmxha2Ugc2VtaS1zdHJ1Y3R1cmVkIGRhdGEgdGFncy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNkaXNhYmxlX3Nub3dmbGFrZV9kYXRhIEZpbGVGb3JtYXQjZGlzYWJsZV9zbm93Zmxha2VfZGF0YX1cbiAgKi9cbiAgcmVhZG9ubHkgZGlzYWJsZVNub3dmbGFrZURhdGE/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB3aGV0aGVyIHRvIGluc2VydCBTUUwgTlVMTCBmb3IgZW1wdHkgZmllbGRzIGluIGFuIGlucHV0IGZpbGUsIHdoaWNoIGFyZSByZXByZXNlbnRlZCBieSB0d28gc3VjY2Vzc2l2ZSBkZWxpbWl0ZXJzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I2VtcHR5X2ZpZWxkX2FzX251bGwgRmlsZUZvcm1hdCNlbXB0eV9maWVsZF9hc19udWxsfVxuICAqL1xuICByZWFkb25seSBlbXB0eUZpZWxkQXNOdWxsPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBCb29sZWFuIHRoYXQgZW5hYmxlcyBwYXJzaW5nIG9mIG9jdGFsIG51bWJlcnMuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjZW5hYmxlX29jdGFsIEZpbGVGb3JtYXQjZW5hYmxlX29jdGFsfVxuICAqL1xuICByZWFkb25seSBlbmFibGVPY3RhbD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogU3RyaW5nIChjb25zdGFudCkgdGhhdCBzcGVjaWZpZXMgdGhlIGNoYXJhY3RlciBzZXQgb2YgdGhlIHNvdXJjZSBkYXRhIHdoZW4gbG9hZGluZyBkYXRhIGludG8gYSB0YWJsZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNlbmNvZGluZyBGaWxlRm9ybWF0I2VuY29kaW5nfVxuICAqL1xuICByZWFkb25seSBlbmNvZGluZz86IHN0cmluZztcbiAgLyoqXG4gICogQm9vbGVhbiB0aGF0IHNwZWNpZmllcyB3aGV0aGVyIHRvIGdlbmVyYXRlIGEgcGFyc2luZyBlcnJvciBpZiB0aGUgbnVtYmVyIG9mIGRlbGltaXRlZCBjb2x1bW5zIChpLmUuIGZpZWxkcykgaW4gYW4gaW5wdXQgZmlsZSBkb2VzIG5vdCBtYXRjaCB0aGUgbnVtYmVyIG9mIGNvbHVtbnMgaW4gdGhlIGNvcnJlc3BvbmRpbmcgdGFibGUuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjZXJyb3Jfb25fY29sdW1uX2NvdW50X21pc21hdGNoIEZpbGVGb3JtYXQjZXJyb3Jfb25fY29sdW1uX2NvdW50X21pc21hdGNofVxuICAqL1xuICByZWFkb25seSBlcnJvck9uQ29sdW1uQ291bnRNaXNtYXRjaD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogU2luZ2xlIGNoYXJhY3RlciBzdHJpbmcgdXNlZCBhcyB0aGUgZXNjYXBlIGNoYXJhY3RlciBmb3IgZmllbGQgdmFsdWVzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I2VzY2FwZSBGaWxlRm9ybWF0I2VzY2FwZX1cbiAgKi9cbiAgcmVhZG9ubHkgZXNjYXBlPzogc3RyaW5nO1xuICAvKipcbiAgKiBTaW5nbGUgY2hhcmFjdGVyIHN0cmluZyB1c2VkIGFzIHRoZSBlc2NhcGUgY2hhcmFjdGVyIGZvciB1bmVuY2xvc2VkIGZpZWxkIHZhbHVlcyBvbmx5LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I2VzY2FwZV91bmVuY2xvc2VkX2ZpZWxkIEZpbGVGb3JtYXQjZXNjYXBlX3VuZW5jbG9zZWRfZmllbGR9XG4gICovXG4gIHJlYWRvbmx5IGVzY2FwZVVuZW5jbG9zZWRGaWVsZD86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIG9uZSBvciBtb3JlIHNpbmdsZWJ5dGUgb3IgbXVsdGlieXRlIGNoYXJhY3RlcnMgdGhhdCBzZXBhcmF0ZSBmaWVsZHMgaW4gYW4gaW5wdXQgZmlsZSAoZGF0YSBsb2FkaW5nKSBvciB1bmxvYWRlZCBmaWxlIChkYXRhIHVubG9hZGluZykuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjZmllbGRfZGVsaW1pdGVyIEZpbGVGb3JtYXQjZmllbGRfZGVsaW1pdGVyfVxuICAqL1xuICByZWFkb25seSBmaWVsZERlbGltaXRlcj86IHN0cmluZztcbiAgLyoqXG4gICogQ2hhcmFjdGVyIHVzZWQgdG8gZW5jbG9zZSBzdHJpbmdzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I2ZpZWxkX29wdGlvbmFsbHlfZW5jbG9zZWRfYnkgRmlsZUZvcm1hdCNmaWVsZF9vcHRpb25hbGx5X2VuY2xvc2VkX2J5fVxuICAqL1xuICByZWFkb25seSBmaWVsZE9wdGlvbmFsbHlFbmNsb3NlZEJ5Pzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIGV4dGVuc2lvbiBmb3IgZmlsZXMgdW5sb2FkZWQgdG8gYSBzdGFnZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNmaWxlX2V4dGVuc2lvbiBGaWxlRm9ybWF0I2ZpbGVfZXh0ZW5zaW9ufVxuICAqL1xuICByZWFkb25seSBmaWxlRXh0ZW5zaW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIGZvcm1hdCBvZiB0aGUgaW5wdXQgZmlsZXMgKGZvciBkYXRhIGxvYWRpbmcpIG9yIG91dHB1dCBmaWxlcyAoZm9yIGRhdGEgdW5sb2FkaW5nKS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNmb3JtYXRfdHlwZSBGaWxlRm9ybWF0I2Zvcm1hdF90eXBlfVxuICAqL1xuICByZWFkb25seSBmb3JtYXRUeXBlOiBzdHJpbmc7XG4gIC8qKlxuICAqIEJvb2xlYW4gdGhhdCBzcGVjaWZpZXMgd2hldGhlciBVVEYtOCBlbmNvZGluZyBlcnJvcnMgcHJvZHVjZSBlcnJvciBjb25kaXRpb25zLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I2lnbm9yZV91dGY4X2Vycm9ycyBGaWxlRm9ybWF0I2lnbm9yZV91dGY4X2Vycm9yc31cbiAgKi9cbiAgcmVhZG9ubHkgaWdub3JlVXRmOEVycm9ycz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSBpZGVudGlmaWVyIGZvciB0aGUgZmlsZSBmb3JtYXQ7IG11c3QgYmUgdW5pcXVlIGZvciB0aGUgZGF0YWJhc2UgYW5kIHNjaGVtYSBpbiB3aGljaCB0aGUgZmlsZSBmb3JtYXQgaXMgY3JlYXRlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNuYW1lIEZpbGVGb3JtYXQjbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAvKipcbiAgKiBTdHJpbmcgdXNlZCB0byBjb252ZXJ0IHRvIGFuZCBmcm9tIFNRTCBOVUxMLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I251bGxfaWYgRmlsZUZvcm1hdCNudWxsX2lmfVxuICAqL1xuICByZWFkb25seSBudWxsSWY/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogQm9vbGVhbiB0aGF0IHNwZWNpZmllcyB3aGV0aGVyIHRoZSBYTUwgcGFyc2VyIHByZXNlcnZlcyBsZWFkaW5nIGFuZCB0cmFpbGluZyBzcGFjZXMgaW4gZWxlbWVudCBjb250ZW50LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I3ByZXNlcnZlX3NwYWNlIEZpbGVGb3JtYXQjcHJlc2VydmVfc3BhY2V9XG4gICovXG4gIHJlYWRvbmx5IHByZXNlcnZlU3BhY2U/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFNwZWNpZmllcyBvbmUgb3IgbW9yZSBzaW5nbGVieXRlIG9yIG11bHRpYnl0ZSBjaGFyYWN0ZXJzIHRoYXQgc2VwYXJhdGUgcmVjb3JkcyBpbiBhbiBpbnB1dCBmaWxlIChkYXRhIGxvYWRpbmcpIG9yIHVubG9hZGVkIGZpbGUgKGRhdGEgdW5sb2FkaW5nKS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNyZWNvcmRfZGVsaW1pdGVyIEZpbGVGb3JtYXQjcmVjb3JkX2RlbGltaXRlcn1cbiAgKi9cbiAgcmVhZG9ubHkgcmVjb3JkRGVsaW1pdGVyPzogc3RyaW5nO1xuICAvKipcbiAgKiBCb29sZWFuIHRoYXQgc3BlY2lmaWVzIHdoZXRoZXIgdG8gcmVwbGFjZSBpbnZhbGlkIFVURi04IGNoYXJhY3RlcnMgd2l0aCB0aGUgVW5pY29kZSByZXBsYWNlbWVudCBjaGFyYWN0ZXIgKO+/vSkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjcmVwbGFjZV9pbnZhbGlkX2NoYXJhY3RlcnMgRmlsZUZvcm1hdCNyZXBsYWNlX2ludmFsaWRfY2hhcmFjdGVyc31cbiAgKi9cbiAgcmVhZG9ubHkgcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBUaGUgc2NoZW1hIGluIHdoaWNoIHRvIGNyZWF0ZSB0aGUgZmlsZSBmb3JtYXQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjc2NoZW1hIEZpbGVGb3JtYXQjc2NoZW1hfVxuICAqL1xuICByZWFkb25seSBzY2hlbWE6IHN0cmluZztcbiAgLyoqXG4gICogQm9vbGVhbiB0aGF0IHNwZWNpZmllcyB0byBza2lwIGFueSBibGFuayBsaW5lcyBlbmNvdW50ZXJlZCBpbiB0aGUgZGF0YSBmaWxlcy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNza2lwX2JsYW5rX2xpbmVzIEZpbGVGb3JtYXQjc2tpcF9ibGFua19saW5lc31cbiAgKi9cbiAgcmVhZG9ubHkgc2tpcEJsYW5rTGluZXM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEJvb2xlYW4gdGhhdCBzcGVjaWZpZXMgd2hldGhlciB0byBza2lwIHRoZSBCT00gKGJ5dGUgb3JkZXIgbWFyayksIGlmIHByZXNlbnQgaW4gYSBkYXRhIGZpbGUuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjc2tpcF9ieXRlX29yZGVyX21hcmsgRmlsZUZvcm1hdCNza2lwX2J5dGVfb3JkZXJfbWFya31cbiAgKi9cbiAgcmVhZG9ubHkgc2tpcEJ5dGVPcmRlck1hcms/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIE51bWJlciBvZiBsaW5lcyBhdCB0aGUgc3RhcnQgb2YgdGhlIGZpbGUgdG8gc2tpcC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCNza2lwX2hlYWRlciBGaWxlRm9ybWF0I3NraXBfaGVhZGVyfVxuICAqL1xuICByZWFkb25seSBza2lwSGVhZGVyPzogbnVtYmVyO1xuICAvKipcbiAgKiBCb29sZWFuIHRoYXQgaW5zdHJ1Y3RzIHRoZSBKU09OIHBhcnNlciB0byByZW1vdmUgb2JqZWN0IGZpZWxkcyBvciBhcnJheSBlbGVtZW50cyBjb250YWluaW5nIG51bGwgdmFsdWVzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I3N0cmlwX251bGxfdmFsdWVzIEZpbGVGb3JtYXQjc3RyaXBfbnVsbF92YWx1ZXN9XG4gICovXG4gIHJlYWRvbmx5IHN0cmlwTnVsbFZhbHVlcz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogQm9vbGVhbiB0aGF0IGluc3RydWN0cyB0aGUgSlNPTiBwYXJzZXIgdG8gcmVtb3ZlIG91dGVyIGJyYWNrZXRzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I3N0cmlwX291dGVyX2FycmF5IEZpbGVGb3JtYXQjc3RyaXBfb3V0ZXJfYXJyYXl9XG4gICovXG4gIHJlYWRvbmx5IHN0cmlwT3V0ZXJBcnJheT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogQm9vbGVhbiB0aGF0IHNwZWNpZmllcyB3aGV0aGVyIHRoZSBYTUwgcGFyc2VyIHN0cmlwcyBvdXQgdGhlIG91dGVyIFhNTCBlbGVtZW50LCBleHBvc2luZyAybmQgbGV2ZWwgZWxlbWVudHMgYXMgc2VwYXJhdGUgZG9jdW1lbnRzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I3N0cmlwX291dGVyX2VsZW1lbnQgRmlsZUZvcm1hdCNzdHJpcF9vdXRlcl9lbGVtZW50fVxuICAqL1xuICByZWFkb25seSBzdHJpcE91dGVyRWxlbWVudD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRGVmaW5lcyB0aGUgZm9ybWF0IG9mIHRpbWUgdmFsdWVzIGluIHRoZSBkYXRhIGZpbGVzIChkYXRhIGxvYWRpbmcpIG9yIHRhYmxlIChkYXRhIHVubG9hZGluZykuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3IvZmlsZV9mb3JtYXQjdGltZV9mb3JtYXQgRmlsZUZvcm1hdCN0aW1lX2Zvcm1hdH1cbiAgKi9cbiAgcmVhZG9ubHkgdGltZUZvcm1hdD86IHN0cmluZztcbiAgLyoqXG4gICogRGVmaW5lcyB0aGUgZm9ybWF0IG9mIHRpbWVzdGFtcCB2YWx1ZXMgaW4gdGhlIGRhdGEgZmlsZXMgKGRhdGEgbG9hZGluZykgb3IgdGFibGUgKGRhdGEgdW5sb2FkaW5nKS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCN0aW1lc3RhbXBfZm9ybWF0IEZpbGVGb3JtYXQjdGltZXN0YW1wX2Zvcm1hdH1cbiAgKi9cbiAgcmVhZG9ubHkgdGltZXN0YW1wRm9ybWF0Pzogc3RyaW5nO1xuICAvKipcbiAgKiBCb29sZWFuIHRoYXQgc3BlY2lmaWVzIHdoZXRoZXIgdG8gcmVtb3ZlIHdoaXRlIHNwYWNlIGZyb20gZmllbGRzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I3RyaW1fc3BhY2UgRmlsZUZvcm1hdCN0cmltX3NwYWNlfVxuICAqL1xuICByZWFkb25seSB0cmltU3BhY2U/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEJvb2xlYW4gdGhhdCBzcGVjaWZpZXMgd2hldGhlciB0byB2YWxpZGF0ZSBVVEYtOCBjaGFyYWN0ZXIgZW5jb2RpbmcgaW4gc3RyaW5nIGNvbHVtbiBkYXRhLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL2ZpbGVfZm9ybWF0I3ZhbGlkYXRlX3V0ZjggRmlsZUZvcm1hdCN2YWxpZGF0ZV91dGY4fVxuICAqL1xuICByZWFkb25seSB2YWxpZGF0ZVV0Zjg/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCBzbm93Zmxha2VfZmlsZV9mb3JtYXR9XG4qL1xuZXhwb3J0IGNsYXNzIEZpbGVGb3JtYXQgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwic25vd2ZsYWtlX2ZpbGVfZm9ybWF0XCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9maWxlX2Zvcm1hdCBzbm93Zmxha2VfZmlsZV9mb3JtYXR9IFJlc291cmNlXG4gICpcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpZCBUaGUgc2NvcGVkIGNvbnN0cnVjdCBJRC4gTXVzdCBiZSB1bmlxdWUgYW1vbmdzdCBzaWJsaW5ncyBpbiB0aGUgc2FtZSBzY29wZVxuICAqIEBwYXJhbSBvcHRpb25zIEZpbGVGb3JtYXRDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogRmlsZUZvcm1hdENvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnc25vd2ZsYWtlX2ZpbGVfZm9ybWF0JyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ3Nub3dmbGFrZScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzAuMzMuMScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICcgfj4gMC4yNSdcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX2FsbG93RHVwbGljYXRlID0gY29uZmlnLmFsbG93RHVwbGljYXRlO1xuICAgIHRoaXMuX2JpbmFyeUFzVGV4dCA9IGNvbmZpZy5iaW5hcnlBc1RleHQ7XG4gICAgdGhpcy5fYmluYXJ5Rm9ybWF0ID0gY29uZmlnLmJpbmFyeUZvcm1hdDtcbiAgICB0aGlzLl9jb21tZW50ID0gY29uZmlnLmNvbW1lbnQ7XG4gICAgdGhpcy5fY29tcHJlc3Npb24gPSBjb25maWcuY29tcHJlc3Npb247XG4gICAgdGhpcy5fZGF0YWJhc2UgPSBjb25maWcuZGF0YWJhc2U7XG4gICAgdGhpcy5fZGF0ZUZvcm1hdCA9IGNvbmZpZy5kYXRlRm9ybWF0O1xuICAgIHRoaXMuX2Rpc2FibGVBdXRvQ29udmVydCA9IGNvbmZpZy5kaXNhYmxlQXV0b0NvbnZlcnQ7XG4gICAgdGhpcy5fZGlzYWJsZVNub3dmbGFrZURhdGEgPSBjb25maWcuZGlzYWJsZVNub3dmbGFrZURhdGE7XG4gICAgdGhpcy5fZW1wdHlGaWVsZEFzTnVsbCA9IGNvbmZpZy5lbXB0eUZpZWxkQXNOdWxsO1xuICAgIHRoaXMuX2VuYWJsZU9jdGFsID0gY29uZmlnLmVuYWJsZU9jdGFsO1xuICAgIHRoaXMuX2VuY29kaW5nID0gY29uZmlnLmVuY29kaW5nO1xuICAgIHRoaXMuX2Vycm9yT25Db2x1bW5Db3VudE1pc21hdGNoID0gY29uZmlnLmVycm9yT25Db2x1bW5Db3VudE1pc21hdGNoO1xuICAgIHRoaXMuX2VzY2FwZSA9IGNvbmZpZy5lc2NhcGU7XG4gICAgdGhpcy5fZXNjYXBlVW5lbmNsb3NlZEZpZWxkID0gY29uZmlnLmVzY2FwZVVuZW5jbG9zZWRGaWVsZDtcbiAgICB0aGlzLl9maWVsZERlbGltaXRlciA9IGNvbmZpZy5maWVsZERlbGltaXRlcjtcbiAgICB0aGlzLl9maWVsZE9wdGlvbmFsbHlFbmNsb3NlZEJ5ID0gY29uZmlnLmZpZWxkT3B0aW9uYWxseUVuY2xvc2VkQnk7XG4gICAgdGhpcy5fZmlsZUV4dGVuc2lvbiA9IGNvbmZpZy5maWxlRXh0ZW5zaW9uO1xuICAgIHRoaXMuX2Zvcm1hdFR5cGUgPSBjb25maWcuZm9ybWF0VHlwZTtcbiAgICB0aGlzLl9pZ25vcmVVdGY4RXJyb3JzID0gY29uZmlnLmlnbm9yZVV0ZjhFcnJvcnM7XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX251bGxJZiA9IGNvbmZpZy5udWxsSWY7XG4gICAgdGhpcy5fcHJlc2VydmVTcGFjZSA9IGNvbmZpZy5wcmVzZXJ2ZVNwYWNlO1xuICAgIHRoaXMuX3JlY29yZERlbGltaXRlciA9IGNvbmZpZy5yZWNvcmREZWxpbWl0ZXI7XG4gICAgdGhpcy5fcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzID0gY29uZmlnLnJlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycztcbiAgICB0aGlzLl9zY2hlbWEgPSBjb25maWcuc2NoZW1hO1xuICAgIHRoaXMuX3NraXBCbGFua0xpbmVzID0gY29uZmlnLnNraXBCbGFua0xpbmVzO1xuICAgIHRoaXMuX3NraXBCeXRlT3JkZXJNYXJrID0gY29uZmlnLnNraXBCeXRlT3JkZXJNYXJrO1xuICAgIHRoaXMuX3NraXBIZWFkZXIgPSBjb25maWcuc2tpcEhlYWRlcjtcbiAgICB0aGlzLl9zdHJpcE51bGxWYWx1ZXMgPSBjb25maWcuc3RyaXBOdWxsVmFsdWVzO1xuICAgIHRoaXMuX3N0cmlwT3V0ZXJBcnJheSA9IGNvbmZpZy5zdHJpcE91dGVyQXJyYXk7XG4gICAgdGhpcy5fc3RyaXBPdXRlckVsZW1lbnQgPSBjb25maWcuc3RyaXBPdXRlckVsZW1lbnQ7XG4gICAgdGhpcy5fdGltZUZvcm1hdCA9IGNvbmZpZy50aW1lRm9ybWF0O1xuICAgIHRoaXMuX3RpbWVzdGFtcEZvcm1hdCA9IGNvbmZpZy50aW1lc3RhbXBGb3JtYXQ7XG4gICAgdGhpcy5fdHJpbVNwYWNlID0gY29uZmlnLnRyaW1TcGFjZTtcbiAgICB0aGlzLl92YWxpZGF0ZVV0ZjggPSBjb25maWcudmFsaWRhdGVVdGY4O1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBhbGxvd19kdXBsaWNhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWxsb3dEdXBsaWNhdGU/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGFsbG93RHVwbGljYXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2FsbG93X2R1cGxpY2F0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWxsb3dEdXBsaWNhdGUodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2FsbG93RHVwbGljYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWxsb3dEdXBsaWNhdGUoKSB7XG4gICAgdGhpcy5fYWxsb3dEdXBsaWNhdGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFsbG93RHVwbGljYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FsbG93RHVwbGljYXRlO1xuICB9XG5cbiAgLy8gYmluYXJ5X2FzX3RleHQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYmluYXJ5QXNUZXh0PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBiaW5hcnlBc1RleHQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnYmluYXJ5X2FzX3RleHQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGJpbmFyeUFzVGV4dCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fYmluYXJ5QXNUZXh0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QmluYXJ5QXNUZXh0KCkge1xuICAgIHRoaXMuX2JpbmFyeUFzVGV4dCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYmluYXJ5QXNUZXh0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2JpbmFyeUFzVGV4dDtcbiAgfVxuXG4gIC8vIGJpbmFyeV9mb3JtYXQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYmluYXJ5Rm9ybWF0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBiaW5hcnlGb3JtYXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdiaW5hcnlfZm9ybWF0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBiaW5hcnlGb3JtYXQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2JpbmFyeUZvcm1hdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJpbmFyeUZvcm1hdCgpIHtcbiAgICB0aGlzLl9iaW5hcnlGb3JtYXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJpbmFyeUZvcm1hdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9iaW5hcnlGb3JtYXQ7XG4gIH1cblxuICAvLyBjb21tZW50IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvbW1lbnQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNvbW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjb21tZW50Jyk7XG4gIH1cbiAgcHVibGljIHNldCBjb21tZW50KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jb21tZW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q29tbWVudCgpIHtcbiAgICB0aGlzLl9jb21tZW50ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjb21tZW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NvbW1lbnQ7XG4gIH1cblxuICAvLyBjb21wcmVzc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb21wcmVzc2lvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY29tcHJlc3Npb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjb21wcmVzc2lvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgY29tcHJlc3Npb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NvbXByZXNzaW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q29tcHJlc3Npb24oKSB7XG4gICAgdGhpcy5fY29tcHJlc3Npb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNvbXByZXNzaW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NvbXByZXNzaW9uO1xuICB9XG5cbiAgLy8gZGF0YWJhc2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfZGF0YWJhc2U/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRhdGFiYXNlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGF0YWJhc2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRhdGFiYXNlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kYXRhYmFzZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkYXRhYmFzZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kYXRhYmFzZTtcbiAgfVxuXG4gIC8vIGRhdGVfZm9ybWF0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RhdGVGb3JtYXQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRhdGVGb3JtYXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkYXRlX2Zvcm1hdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGF0ZUZvcm1hdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGF0ZUZvcm1hdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERhdGVGb3JtYXQoKSB7XG4gICAgdGhpcy5fZGF0ZUZvcm1hdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGF0ZUZvcm1hdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kYXRlRm9ybWF0O1xuICB9XG5cbiAgLy8gZGlzYWJsZV9hdXRvX2NvbnZlcnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGlzYWJsZUF1dG9Db252ZXJ0PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBkaXNhYmxlQXV0b0NvbnZlcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZGlzYWJsZV9hdXRvX2NvbnZlcnQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRpc2FibGVBdXRvQ29udmVydCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fZGlzYWJsZUF1dG9Db252ZXJ0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGlzYWJsZUF1dG9Db252ZXJ0KCkge1xuICAgIHRoaXMuX2Rpc2FibGVBdXRvQ29udmVydCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGlzYWJsZUF1dG9Db252ZXJ0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rpc2FibGVBdXRvQ29udmVydDtcbiAgfVxuXG4gIC8vIGRpc2FibGVfc25vd2ZsYWtlX2RhdGEgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGlzYWJsZVNub3dmbGFrZURhdGE/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRpc2FibGVTbm93Zmxha2VEYXRhKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2Rpc2FibGVfc25vd2ZsYWtlX2RhdGEnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRpc2FibGVTbm93Zmxha2VEYXRhKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9kaXNhYmxlU25vd2ZsYWtlRGF0YSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERpc2FibGVTbm93Zmxha2VEYXRhKCkge1xuICAgIHRoaXMuX2Rpc2FibGVTbm93Zmxha2VEYXRhID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkaXNhYmxlU25vd2ZsYWtlRGF0YUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kaXNhYmxlU25vd2ZsYWtlRGF0YTtcbiAgfVxuXG4gIC8vIGVtcHR5X2ZpZWxkX2FzX251bGwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW1wdHlGaWVsZEFzTnVsbD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZW1wdHlGaWVsZEFzTnVsbCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdlbXB0eV9maWVsZF9hc19udWxsJyk7XG4gIH1cbiAgcHVibGljIHNldCBlbXB0eUZpZWxkQXNOdWxsKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9lbXB0eUZpZWxkQXNOdWxsID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RW1wdHlGaWVsZEFzTnVsbCgpIHtcbiAgICB0aGlzLl9lbXB0eUZpZWxkQXNOdWxsID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBlbXB0eUZpZWxkQXNOdWxsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2VtcHR5RmllbGRBc051bGw7XG4gIH1cblxuICAvLyBlbmFibGVfb2N0YWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW5hYmxlT2N0YWw/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGVuYWJsZU9jdGFsKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2VuYWJsZV9vY3RhbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZW5hYmxlT2N0YWwodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2VuYWJsZU9jdGFsID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RW5hYmxlT2N0YWwoKSB7XG4gICAgdGhpcy5fZW5hYmxlT2N0YWwgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVuYWJsZU9jdGFsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2VuYWJsZU9jdGFsO1xuICB9XG5cbiAgLy8gZW5jb2RpbmcgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW5jb2Rpbmc/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGVuY29kaW5nKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZW5jb2RpbmcnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVuY29kaW5nKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9lbmNvZGluZyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVuY29kaW5nKCkge1xuICAgIHRoaXMuX2VuY29kaW5nID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBlbmNvZGluZ0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lbmNvZGluZztcbiAgfVxuXG4gIC8vIGVycm9yX29uX2NvbHVtbl9jb3VudF9taXNtYXRjaCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9lcnJvck9uQ29sdW1uQ291bnRNaXNtYXRjaD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZXJyb3JPbkNvbHVtbkNvdW50TWlzbWF0Y2goKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZXJyb3Jfb25fY29sdW1uX2NvdW50X21pc21hdGNoJyk7XG4gIH1cbiAgcHVibGljIHNldCBlcnJvck9uQ29sdW1uQ291bnRNaXNtYXRjaCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fZXJyb3JPbkNvbHVtbkNvdW50TWlzbWF0Y2ggPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFcnJvck9uQ29sdW1uQ291bnRNaXNtYXRjaCgpIHtcbiAgICB0aGlzLl9lcnJvck9uQ29sdW1uQ291bnRNaXNtYXRjaCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZXJyb3JPbkNvbHVtbkNvdW50TWlzbWF0Y2hJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZXJyb3JPbkNvbHVtbkNvdW50TWlzbWF0Y2g7XG4gIH1cblxuICAvLyBlc2NhcGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZXNjYXBlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBlc2NhcGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdlc2NhcGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVzY2FwZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZXNjYXBlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RXNjYXBlKCkge1xuICAgIHRoaXMuX2VzY2FwZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZXNjYXBlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2VzY2FwZTtcbiAgfVxuXG4gIC8vIGVzY2FwZV91bmVuY2xvc2VkX2ZpZWxkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VzY2FwZVVuZW5jbG9zZWRGaWVsZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZXNjYXBlVW5lbmNsb3NlZEZpZWxkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZXNjYXBlX3VuZW5jbG9zZWRfZmllbGQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGVzY2FwZVVuZW5jbG9zZWRGaWVsZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZXNjYXBlVW5lbmNsb3NlZEZpZWxkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RXNjYXBlVW5lbmNsb3NlZEZpZWxkKCkge1xuICAgIHRoaXMuX2VzY2FwZVVuZW5jbG9zZWRGaWVsZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZXNjYXBlVW5lbmNsb3NlZEZpZWxkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2VzY2FwZVVuZW5jbG9zZWRGaWVsZDtcbiAgfVxuXG4gIC8vIGZpZWxkX2RlbGltaXRlciAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9maWVsZERlbGltaXRlcj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZmllbGREZWxpbWl0ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdmaWVsZF9kZWxpbWl0ZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IGZpZWxkRGVsaW1pdGVyKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9maWVsZERlbGltaXRlciA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEZpZWxkRGVsaW1pdGVyKCkge1xuICAgIHRoaXMuX2ZpZWxkRGVsaW1pdGVyID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBmaWVsZERlbGltaXRlcklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9maWVsZERlbGltaXRlcjtcbiAgfVxuXG4gIC8vIGZpZWxkX29wdGlvbmFsbHlfZW5jbG9zZWRfYnkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZmllbGRPcHRpb25hbGx5RW5jbG9zZWRCeT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZmllbGRPcHRpb25hbGx5RW5jbG9zZWRCeSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2ZpZWxkX29wdGlvbmFsbHlfZW5jbG9zZWRfYnknKTtcbiAgfVxuICBwdWJsaWMgc2V0IGZpZWxkT3B0aW9uYWxseUVuY2xvc2VkQnkodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2ZpZWxkT3B0aW9uYWxseUVuY2xvc2VkQnkgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRGaWVsZE9wdGlvbmFsbHlFbmNsb3NlZEJ5KCkge1xuICAgIHRoaXMuX2ZpZWxkT3B0aW9uYWxseUVuY2xvc2VkQnkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGZpZWxkT3B0aW9uYWxseUVuY2xvc2VkQnlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZmllbGRPcHRpb25hbGx5RW5jbG9zZWRCeTtcbiAgfVxuXG4gIC8vIGZpbGVfZXh0ZW5zaW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2ZpbGVFeHRlbnNpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGZpbGVFeHRlbnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdmaWxlX2V4dGVuc2lvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZmlsZUV4dGVuc2lvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZmlsZUV4dGVuc2lvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEZpbGVFeHRlbnNpb24oKSB7XG4gICAgdGhpcy5fZmlsZUV4dGVuc2lvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZmlsZUV4dGVuc2lvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9maWxlRXh0ZW5zaW9uO1xuICB9XG5cbiAgLy8gZm9ybWF0X3R5cGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfZm9ybWF0VHlwZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZm9ybWF0VHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Zvcm1hdF90eXBlJyk7XG4gIH1cbiAgcHVibGljIHNldCBmb3JtYXRUeXBlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9mb3JtYXRUeXBlID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGZvcm1hdFR5cGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZm9ybWF0VHlwZTtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cblxuICAvLyBpZ25vcmVfdXRmOF9lcnJvcnMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaWdub3JlVXRmOEVycm9ycz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgaWdub3JlVXRmOEVycm9ycygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdpZ25vcmVfdXRmOF9lcnJvcnMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlnbm9yZVV0ZjhFcnJvcnModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2lnbm9yZVV0ZjhFcnJvcnMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZ25vcmVVdGY4RXJyb3JzKCkge1xuICAgIHRoaXMuX2lnbm9yZVV0ZjhFcnJvcnMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlnbm9yZVV0ZjhFcnJvcnNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWdub3JlVXRmOEVycm9ycztcbiAgfVxuXG4gIC8vIG5hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfbmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX25hbWUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9uYW1lO1xuICB9XG5cbiAgLy8gbnVsbF9pZiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9udWxsSWY/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgbnVsbElmKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ251bGxfaWYnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG51bGxJZih2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9udWxsSWYgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXROdWxsSWYoKSB7XG4gICAgdGhpcy5fbnVsbElmID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBudWxsSWZJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbnVsbElmO1xuICB9XG5cbiAgLy8gcHJlc2VydmVfc3BhY2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHJlc2VydmVTcGFjZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcHJlc2VydmVTcGFjZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdwcmVzZXJ2ZV9zcGFjZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJlc2VydmVTcGFjZSh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fcHJlc2VydmVTcGFjZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFByZXNlcnZlU3BhY2UoKSB7XG4gICAgdGhpcy5fcHJlc2VydmVTcGFjZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJlc2VydmVTcGFjZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcmVzZXJ2ZVNwYWNlO1xuICB9XG5cbiAgLy8gcmVjb3JkX2RlbGltaXRlciAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZWNvcmREZWxpbWl0ZXI/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlY29yZERlbGltaXRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlY29yZF9kZWxpbWl0ZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlY29yZERlbGltaXRlcih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVjb3JkRGVsaW1pdGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVjb3JkRGVsaW1pdGVyKCkge1xuICAgIHRoaXMuX3JlY29yZERlbGltaXRlciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVjb3JkRGVsaW1pdGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlY29yZERlbGltaXRlcjtcbiAgfVxuXG4gIC8vIHJlcGxhY2VfaW52YWxpZF9jaGFyYWN0ZXJzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3JlcGxhY2VfaW52YWxpZF9jaGFyYWN0ZXJzJyk7XG4gIH1cbiAgcHVibGljIHNldCByZXBsYWNlSW52YWxpZENoYXJhY3RlcnModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3JlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlcGxhY2VJbnZhbGlkQ2hhcmFjdGVycygpIHtcbiAgICB0aGlzLl9yZXBsYWNlSW52YWxpZENoYXJhY3RlcnMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcGxhY2VJbnZhbGlkQ2hhcmFjdGVyc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXBsYWNlSW52YWxpZENoYXJhY3RlcnM7XG4gIH1cblxuICAvLyBzY2hlbWEgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfc2NoZW1hPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBzY2hlbWEoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzY2hlbWEnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNjaGVtYSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc2NoZW1hID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNjaGVtYUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zY2hlbWE7XG4gIH1cblxuICAvLyBza2lwX2JsYW5rX2xpbmVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NraXBCbGFua0xpbmVzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBza2lwQmxhbmtMaW5lcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdza2lwX2JsYW5rX2xpbmVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBza2lwQmxhbmtMaW5lcyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fc2tpcEJsYW5rTGluZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTa2lwQmxhbmtMaW5lcygpIHtcbiAgICB0aGlzLl9za2lwQmxhbmtMaW5lcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc2tpcEJsYW5rTGluZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2tpcEJsYW5rTGluZXM7XG4gIH1cblxuICAvLyBza2lwX2J5dGVfb3JkZXJfbWFyayAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9za2lwQnl0ZU9yZGVyTWFyaz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgc2tpcEJ5dGVPcmRlck1hcmsoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc2tpcF9ieXRlX29yZGVyX21hcmsnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHNraXBCeXRlT3JkZXJNYXJrKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9za2lwQnl0ZU9yZGVyTWFyayA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNraXBCeXRlT3JkZXJNYXJrKCkge1xuICAgIHRoaXMuX3NraXBCeXRlT3JkZXJNYXJrID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBza2lwQnl0ZU9yZGVyTWFya0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9za2lwQnl0ZU9yZGVyTWFyaztcbiAgfVxuXG4gIC8vIHNraXBfaGVhZGVyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NraXBIZWFkZXI/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHNraXBIZWFkZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdza2lwX2hlYWRlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2tpcEhlYWRlcih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fc2tpcEhlYWRlciA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNraXBIZWFkZXIoKSB7XG4gICAgdGhpcy5fc2tpcEhlYWRlciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc2tpcEhlYWRlcklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9za2lwSGVhZGVyO1xuICB9XG5cbiAgLy8gc3RyaXBfbnVsbF92YWx1ZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3RyaXBOdWxsVmFsdWVzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBzdHJpcE51bGxWYWx1ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc3RyaXBfbnVsbF92YWx1ZXMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHN0cmlwTnVsbFZhbHVlcyh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fc3RyaXBOdWxsVmFsdWVzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U3RyaXBOdWxsVmFsdWVzKCkge1xuICAgIHRoaXMuX3N0cmlwTnVsbFZhbHVlcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RyaXBOdWxsVmFsdWVzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3N0cmlwTnVsbFZhbHVlcztcbiAgfVxuXG4gIC8vIHN0cmlwX291dGVyX2FycmF5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N0cmlwT3V0ZXJBcnJheT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgc3RyaXBPdXRlckFycmF5KCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3N0cmlwX291dGVyX2FycmF5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBzdHJpcE91dGVyQXJyYXkodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3N0cmlwT3V0ZXJBcnJheSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN0cmlwT3V0ZXJBcnJheSgpIHtcbiAgICB0aGlzLl9zdHJpcE91dGVyQXJyYXkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHN0cmlwT3V0ZXJBcnJheUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdHJpcE91dGVyQXJyYXk7XG4gIH1cblxuICAvLyBzdHJpcF9vdXRlcl9lbGVtZW50IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N0cmlwT3V0ZXJFbGVtZW50PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBzdHJpcE91dGVyRWxlbWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdzdHJpcF9vdXRlcl9lbGVtZW50Jyk7XG4gIH1cbiAgcHVibGljIHNldCBzdHJpcE91dGVyRWxlbWVudCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fc3RyaXBPdXRlckVsZW1lbnQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTdHJpcE91dGVyRWxlbWVudCgpIHtcbiAgICB0aGlzLl9zdHJpcE91dGVyRWxlbWVudCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RyaXBPdXRlckVsZW1lbnRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RyaXBPdXRlckVsZW1lbnQ7XG4gIH1cblxuICAvLyB0aW1lX2Zvcm1hdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aW1lRm9ybWF0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0aW1lRm9ybWF0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndGltZV9mb3JtYXQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRpbWVGb3JtYXQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3RpbWVGb3JtYXQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUaW1lRm9ybWF0KCkge1xuICAgIHRoaXMuX3RpbWVGb3JtYXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpbWVGb3JtYXRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZUZvcm1hdDtcbiAgfVxuXG4gIC8vIHRpbWVzdGFtcF9mb3JtYXQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGltZXN0YW1wRm9ybWF0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB0aW1lc3RhbXBGb3JtYXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0aW1lc3RhbXBfZm9ybWF0Jyk7XG4gIH1cbiAgcHVibGljIHNldCB0aW1lc3RhbXBGb3JtYXQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3RpbWVzdGFtcEZvcm1hdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRpbWVzdGFtcEZvcm1hdCgpIHtcbiAgICB0aGlzLl90aW1lc3RhbXBGb3JtYXQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpbWVzdGFtcEZvcm1hdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aW1lc3RhbXBGb3JtYXQ7XG4gIH1cblxuICAvLyB0cmltX3NwYWNlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RyaW1TcGFjZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgdHJpbVNwYWNlKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3RyaW1fc3BhY2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRyaW1TcGFjZSh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fdHJpbVNwYWNlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VHJpbVNwYWNlKCkge1xuICAgIHRoaXMuX3RyaW1TcGFjZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdHJpbVNwYWNlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RyaW1TcGFjZTtcbiAgfVxuXG4gIC8vIHZhbGlkYXRlX3V0ZjggLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdmFsaWRhdGVVdGY4PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCB2YWxpZGF0ZVV0ZjgoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgndmFsaWRhdGVfdXRmOCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgdmFsaWRhdGVVdGY4KHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl92YWxpZGF0ZVV0ZjggPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRWYWxpZGF0ZVV0ZjgoKSB7XG4gICAgdGhpcy5fdmFsaWRhdGVVdGY4ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB2YWxpZGF0ZVV0ZjhJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdmFsaWRhdGVVdGY4O1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBhbGxvd19kdXBsaWNhdGU6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9hbGxvd0R1cGxpY2F0ZSksXG4gICAgICBiaW5hcnlfYXNfdGV4dDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2JpbmFyeUFzVGV4dCksXG4gICAgICBiaW5hcnlfZm9ybWF0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9iaW5hcnlGb3JtYXQpLFxuICAgICAgY29tbWVudDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fY29tbWVudCksXG4gICAgICBjb21wcmVzc2lvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fY29tcHJlc3Npb24pLFxuICAgICAgZGF0YWJhc2U6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2RhdGFiYXNlKSxcbiAgICAgIGRhdGVfZm9ybWF0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9kYXRlRm9ybWF0KSxcbiAgICAgIGRpc2FibGVfYXV0b19jb252ZXJ0OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZGlzYWJsZUF1dG9Db252ZXJ0KSxcbiAgICAgIGRpc2FibGVfc25vd2ZsYWtlX2RhdGE6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9kaXNhYmxlU25vd2ZsYWtlRGF0YSksXG4gICAgICBlbXB0eV9maWVsZF9hc19udWxsOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZW1wdHlGaWVsZEFzTnVsbCksXG4gICAgICBlbmFibGVfb2N0YWw6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9lbmFibGVPY3RhbCksXG4gICAgICBlbmNvZGluZzogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZW5jb2RpbmcpLFxuICAgICAgZXJyb3Jfb25fY29sdW1uX2NvdW50X21pc21hdGNoOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZXJyb3JPbkNvbHVtbkNvdW50TWlzbWF0Y2gpLFxuICAgICAgZXNjYXBlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9lc2NhcGUpLFxuICAgICAgZXNjYXBlX3VuZW5jbG9zZWRfZmllbGQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2VzY2FwZVVuZW5jbG9zZWRGaWVsZCksXG4gICAgICBmaWVsZF9kZWxpbWl0ZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2ZpZWxkRGVsaW1pdGVyKSxcbiAgICAgIGZpZWxkX29wdGlvbmFsbHlfZW5jbG9zZWRfYnk6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2ZpZWxkT3B0aW9uYWxseUVuY2xvc2VkQnkpLFxuICAgICAgZmlsZV9leHRlbnNpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2ZpbGVFeHRlbnNpb24pLFxuICAgICAgZm9ybWF0X3R5cGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2Zvcm1hdFR5cGUpLFxuICAgICAgaWdub3JlX3V0ZjhfZXJyb3JzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5faWdub3JlVXRmOEVycm9ycyksXG4gICAgICBuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9uYW1lKSxcbiAgICAgIG51bGxfaWY6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0pKHRoaXMuX251bGxJZiksXG4gICAgICBwcmVzZXJ2ZV9zcGFjZTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3ByZXNlcnZlU3BhY2UpLFxuICAgICAgcmVjb3JkX2RlbGltaXRlcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fcmVjb3JkRGVsaW1pdGVyKSxcbiAgICAgIHJlcGxhY2VfaW52YWxpZF9jaGFyYWN0ZXJzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fcmVwbGFjZUludmFsaWRDaGFyYWN0ZXJzKSxcbiAgICAgIHNjaGVtYTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fc2NoZW1hKSxcbiAgICAgIHNraXBfYmxhbmtfbGluZXM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9za2lwQmxhbmtMaW5lcyksXG4gICAgICBza2lwX2J5dGVfb3JkZXJfbWFyazogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3NraXBCeXRlT3JkZXJNYXJrKSxcbiAgICAgIHNraXBfaGVhZGVyOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9za2lwSGVhZGVyKSxcbiAgICAgIHN0cmlwX251bGxfdmFsdWVzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fc3RyaXBOdWxsVmFsdWVzKSxcbiAgICAgIHN0cmlwX291dGVyX2FycmF5OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fc3RyaXBPdXRlckFycmF5KSxcbiAgICAgIHN0cmlwX291dGVyX2VsZW1lbnQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9zdHJpcE91dGVyRWxlbWVudCksXG4gICAgICB0aW1lX2Zvcm1hdDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdGltZUZvcm1hdCksXG4gICAgICB0aW1lc3RhbXBfZm9ybWF0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl90aW1lc3RhbXBGb3JtYXQpLFxuICAgICAgdHJpbV9zcGFjZTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3RyaW1TcGFjZSksXG4gICAgICB2YWxpZGF0ZV91dGY4OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fdmFsaWRhdGVVdGY4KSxcbiAgICB9O1xuICB9XG59XG4iXX0=