from .MDML_client import *
name = "MDML_Client"
__version__ = "1.1.85"
multipart_schema = {
    "$schema": "http://merf.egs.anl.gov/mdml-multipart-message-schema#",
    "title": "MultipartMessageSchema",
    "description": "Schema for Kafka MDML data messages that are split into multiple messages",
    "type": "object",
    "properties": {
        "chunk": {
            "description": "File chunk",
            "type": "string"
        },
        "part": {
            "description": "Message part description",
            "type": "string"
        },
        "filename": {
            "description": "Name of the file",
            "type": "string"
        },
        "encoding": {
            "description": "Encoding used",
            "type": "string"
        }
    },
    "required": [ "chunk", "part", "filename", "encoding" ]
}