# coding: utf-8

# (C) Copyright IBM Corp. 2020.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
No description provided (generated by Openapi Generator
https://github.com/openapitools/openapi-generator)
"""

from datetime import datetime
from enum import Enum
from typing import Dict, List
import json

from ibm_cloud_sdk_core import BaseService, DetailedResponse
from ibm_cloud_sdk_core.authenticators.authenticator import Authenticator
from ibm_cloud_sdk_core.get_authenticator import get_authenticator_from_environment
from ibm_cloud_sdk_core.utils import convert_model, datetime_to_string, string_to_datetime

from .common import get_sdk_headers

##############################################################################
# Service
##############################################################################

class TransitGatewayApisV1(BaseService):
    """The Transit Gateway Apis V1 service."""

    DEFAULT_SERVICE_URL = 'https://transit.cloud.ibm.com/v1'
    DEFAULT_SERVICE_NAME = 'transit_gateway_apis'

    @classmethod
    def new_instance(cls,
                     version: str,
                     service_name: str = DEFAULT_SERVICE_NAME,
                    ) -> 'TransitGatewayApisV1':
        """
        Return a new client for the Transit Gateway Apis service using the
               specified parameters and external configuration.

        :param str version: Requests the version of the API as of a date in the
               format `YYYY-MM-DD`. Any date up to the current date may be provided.
               Specify the current date to request the latest version.
        """
        if version is None:
            raise ValueError('version must be provided')

        authenticator = get_authenticator_from_environment(service_name)
        service = cls(
            version,
            authenticator
            )
        service.configure_service(service_name)
        return service

    def __init__(self,
                 version: str,
                 authenticator: Authenticator = None,
                ) -> None:
        """
        Construct a new client for the Transit Gateway Apis service.

        :param str version: Requests the version of the API as of a date in the
               format `YYYY-MM-DD`. Any date up to the current date may be provided.
               Specify the current date to request the latest version.

        :param Authenticator authenticator: The authenticator specifies the authentication mechanism.
               Get up to date information from https://github.com/IBM/python-sdk-core/blob/master/README.md
               about initializing the authenticator of your choice.
        """
        if version is None:
            raise ValueError('version must be provided')

        BaseService.__init__(self,
                             service_url=self.DEFAULT_SERVICE_URL,
                             authenticator=authenticator)
        self.version = version


    #########################
    # transitGateways
    #########################


    def list_transit_gateways(self,
        **kwargs
    ) -> DetailedResponse:
        """
        Retrieves all Transit Gateways.

        List all the Transit Gateways in the account. User will get a list of Transit
        Gateways they have access to 'view'.

        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayCollection` object
        """

        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_transit_gateways')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways'
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


    def create_transit_gateway(self,
        location: str,
        name: str,
        *,
        global_: bool = None,
        resource_group: 'ResourceGroupIdentity' = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Creates a Transit Gateway.

        Create a Transit Gateway based on the supplied input template.

        :param str location: Location of Transit Gateway Services.
        :param str name: Name Transit Gateway Services.
        :param bool global_: (optional) Allow global routing for a Transit Gateway.
               If unspecified, the default value is false.
        :param ResourceGroupIdentity resource_group: (optional) The resource group
               to use. If unspecified, the account's [default resource
               group](https://console.bluemix.net/apidocs/resource-manager#introduction)
               is used.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGateway` object
        """

        if location is None:
            raise ValueError('location must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if resource_group is not None:
            resource_group = convert_model(resource_group)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'location': location,
            'name': name,
            'global': global_,
            'resource_group': resource_group
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways'
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request)
        return response


    def delete_transit_gateway(self,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Deletes specified Transit Gateway.

        This request deletes a Transit Gateway. This operation cannot be reversed. For
        this request to succeed, the Transit Gateway must not contain connections.

        :param str id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}'.format(
            *self.encode_path_vars(id))
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


    def get_transit_gateway(self,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Retrieves specified Transit Gateway.

        This request retrieves a single Transit Gateway specified by the identifier in the
        URL.

        :param str id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGateway` object
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}'.format(
            *self.encode_path_vars(id))
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


    def update_transit_gateway(self,
        id: str,
        *,
        global_: bool = None,
        name: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Updates specified Transit Gateway.

        This request updates a Transit Gateway's name and/or global flag.

        :param str id: The Transit Gateway identifier.
        :param bool global_: (optional) Allow global routing for a Transit Gateway.
        :param str name: (optional) The user-defined name for this transit gateway.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGateway` object
        """

        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_transit_gateway')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'global': global_,
            'name': name
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}'.format(
            *self.encode_path_vars(id))
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request)
        return response

    #########################
    # transitGatewaysNetworkConnections
    #########################


    def list_transit_gateway_connections(self,
        transit_gateway_id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Retrieves all connections in a Transit Gateway.

        This request retrieves all connections in a Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCollection` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_transit_gateway_connections')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}/connections'.format(
            *self.encode_path_vars(transit_gateway_id))
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


    def create_transit_gateway_connection(self,
        transit_gateway_id: str,
        network_type: str,
        *,
        name: str = None,
        network_id: str = None,
        network_account_id: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Add connection to a Transit Gateway.

        Add a connection to Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str network_type: Defines what type of network is connected via this
               connection.
        :param str name: (optional) The user-defined name for this transit gateway.
               If unspecified, the name will be the network name (the name of the VPC in
               the case of network type 'vpc', and the word Classic, in the case of
               network type 'classic').
        :param str network_id: (optional) The ID of the network being connected via
               this connection. This field is required for some types, such as 'vpc'. For
               network type 'vpc' this is the CRN of the VPC to be connected. This field
               is required to be unspecified for network type 'classic'.
        :param str network_account_id: (optional) The ID of the account which owns
               the network that is being connected. Generally only used if the network is
               in a different account than the gateway.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if network_type is None:
            raise ValueError('network_type must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'network_type': network_type,
            'name': name,
            'network_id': network_id,
            'network_account_id': network_account_id
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}/connections'.format(
            *self.encode_path_vars(transit_gateway_id))
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request)
        return response


    def delete_transit_gateway_connection(self,
        transit_gateway_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Remove connection from Transit Gateway.

        After the specified connection is detached, entities still within the Transit
        Gateway will no longer be able to communicate directly to it through the IBM Cloud
        private backbone.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}/connections/{1}'.format(
            *self.encode_path_vars(transit_gateway_id, id))
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


    def get_transit_gateway_connection(self,
        transit_gateway_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Retrieves specified Transit Gateway connection.

        This request retrieves a connection from the Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}/connections/{1}'.format(
            *self.encode_path_vars(transit_gateway_id, id))
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


    def update_transit_gateway_connection(self,
        transit_gateway_id: str,
        id: str,
        *,
        name: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Updates specified Transit Gateway connection.

        Update the name of a connection to a Transit Gateway.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str name: (optional) The user-defined name for this transit gateway.
               If specified as empty string or nil,  the name will be the network name
               (the name of the VPC in the case of network type 'vpc',  and the word
               Classic, in the case of network type 'classic').
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TransitGatewayConnectionCust` object
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_transit_gateway_connection')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'name': name
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}/connections/{1}'.format(
            *self.encode_path_vars(transit_gateway_id, id))
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request)
        return response


    def create_transit_gateway_connection_actions(self,
        transit_gateway_id: str,
        id: str,
        action: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Perform actions on a connection for a Transit Gateway.

        Allow a network owner to approve or reject a cross-account connection request.

        :param str transit_gateway_id: The Transit Gateway identifier.
        :param str id: The connection identifier.
        :param str action: The action that is to be performed against the
               connection request.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if transit_gateway_id is None:
            raise ValueError('transit_gateway_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if action is None:
            raise ValueError('action must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_transit_gateway_connection_actions')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        data = {
            'action': action
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/transit_gateways/{0}/connections/{1}/actions'.format(
            *self.encode_path_vars(transit_gateway_id, id))
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       params=params,
                                       data=data)

        response = self.send(request)
        return response

    #########################
    # transitLocation
    #########################


    def list_gateway_locations(self,
        **kwargs
    ) -> DetailedResponse:
        """
        List all locations that support Transit Gateways.

        List all locations that support Transit Gateways.

        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TSCollection` object
        """

        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_gateway_locations')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/locations'
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


    def get_gateway_location(self,
        name: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Show the details of a given Transit Gateway location.

        Get the details of a Transit Gateway Location.

        :param str name: The Transit Gateway location Name.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TSLocation` object
        """

        if name is None:
            raise ValueError('name must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_gateway_location')
        headers.update(sdk_headers)

        params = {
            'version': self.version
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        url = '/locations/{0}'.format(
            *self.encode_path_vars(name))
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request)
        return response


##############################################################################
# Models
##############################################################################


class ResourceGroupIdentity():
    """
    The resource group to use. If unspecified, the account's [default resource
    group](https://console.bluemix.net/apidocs/resource-manager#introduction) is used.

    :attr str id: The unique identifier for this resource group.
    """

    def __init__(self,
                 id: str) -> None:
        """
        Initialize a ResourceGroupIdentity object.

        :param str id: The unique identifier for this resource group.
        """
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ResourceGroupIdentity':
        """Initialize a ResourceGroupIdentity object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in ResourceGroupIdentity JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ResourceGroupIdentity object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ResourceGroupIdentity object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ResourceGroupIdentity') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ResourceGroupIdentity') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class ResourceGroupReference():
    """
    The resource group to use. If unspecified, the account's [default resource
    group](https://console.bluemix.net/apidocs/resource-manager#introduction) is used.

    :attr str id: The unique identifier for this resource group.
    :attr str href: The URL for this resource group.
    """

    def __init__(self,
                 id: str,
                 href: str) -> None:
        """
        Initialize a ResourceGroupReference object.

        :param str id: The unique identifier for this resource group.
        :param str href: The URL for this resource group.
        """
        self.id = id
        self.href = href

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'ResourceGroupReference':
        """Initialize a ResourceGroupReference object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in ResourceGroupReference JSON')
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError('Required property \'href\' not present in ResourceGroupReference JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a ResourceGroupReference object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this ResourceGroupReference object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'ResourceGroupReference') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'ResourceGroupReference') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TSCollection():
    """
    A list of Transit Gateway locations.

    :attr List[TSLocationBasic] locations: Collection of Transit Gateway locations.
    """

    def __init__(self,
                 locations: List['TSLocationBasic']) -> None:
        """
        Initialize a TSCollection object.

        :param List[TSLocationBasic] locations: Collection of Transit Gateway
               locations.
        """
        self.locations = locations

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSCollection':
        """Initialize a TSCollection object from a json dictionary."""
        args = {}
        if 'locations' in _dict:
            args['locations'] = [TSLocationBasic.from_dict(x) for x in _dict.get('locations')]
        else:
            raise ValueError('Required property \'locations\' not present in TSCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'locations') and self.locations is not None:
            _dict['locations'] = [x.to_dict() for x in self.locations]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TSLocalLocation():
    """
    Details of a local connection location.

    :attr str display_name: A descriptive display name for the location.
    :attr str name: The name of the location.
    :attr str type: The type of the location, determining is this a multi-zone
          region, a single data center, or a point of presence.
    """

    def __init__(self,
                 display_name: str,
                 name: str,
                 type: str) -> None:
        """
        Initialize a TSLocalLocation object.

        :param str display_name: A descriptive display name for the location.
        :param str name: The name of the location.
        :param str type: The type of the location, determining is this a multi-zone
               region, a single data center, or a point of presence.
        """
        self.display_name = display_name
        self.name = name
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSLocalLocation':
        """Initialize a TSLocalLocation object from a json dictionary."""
        args = {}
        if 'display_name' in _dict:
            args['display_name'] = _dict.get('display_name')
        else:
            raise ValueError('Required property \'display_name\' not present in TSLocalLocation JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TSLocalLocation JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in TSLocalLocation JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSLocalLocation object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'display_name') and self.display_name is not None:
            _dict['display_name'] = self.display_name
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSLocalLocation object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSLocalLocation') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSLocalLocation') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        The type of the location, determining is this a multi-zone region, a single data
        center, or a point of presence.
        """
        REGION = 'region'


class TSLocation():
    """
    Details of a Transit Gateway location.

    :attr str billing_location: The geographical location of this location, used for
          billing purposes.
    :attr str name: Name of the Location.
    :attr str type: The type of the location, determining is this a multi-zone
          region, a single data center, or a point of presence.
    :attr List[TSLocalLocation] local_connection_locations: The set of network
          locations that are considered local for this Transit Gateway location.
    """

    def __init__(self,
                 billing_location: str,
                 name: str,
                 type: str,
                 local_connection_locations: List['TSLocalLocation']) -> None:
        """
        Initialize a TSLocation object.

        :param str billing_location: The geographical location of this location,
               used for billing purposes.
        :param str name: Name of the Location.
        :param str type: The type of the location, determining is this a multi-zone
               region, a single data center, or a point of presence.
        :param List[TSLocalLocation] local_connection_locations: The set of network
               locations that are considered local for this Transit Gateway location.
        """
        self.billing_location = billing_location
        self.name = name
        self.type = type
        self.local_connection_locations = local_connection_locations

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSLocation':
        """Initialize a TSLocation object from a json dictionary."""
        args = {}
        if 'billing_location' in _dict:
            args['billing_location'] = _dict.get('billing_location')
        else:
            raise ValueError('Required property \'billing_location\' not present in TSLocation JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TSLocation JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in TSLocation JSON')
        if 'local_connection_locations' in _dict:
            args['local_connection_locations'] = [TSLocalLocation.from_dict(x) for x in _dict.get('local_connection_locations')]
        else:
            raise ValueError('Required property \'local_connection_locations\' not present in TSLocation JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSLocation object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'billing_location') and self.billing_location is not None:
            _dict['billing_location'] = self.billing_location
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'local_connection_locations') and self.local_connection_locations is not None:
            _dict['local_connection_locations'] = [x.to_dict() for x in self.local_connection_locations]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSLocation object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSLocation') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSLocation') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TSLocationBasic():
    """
    Details of a Transit Gateway location.

    :attr str billing_location: The geographical location of this location, used for
          billing purposes.
    :attr str name: Name of the Location.
    :attr str type: The type of the location, determining is this a multi-zone
          region, a single data center, or a point of presence.
    """

    def __init__(self,
                 billing_location: str,
                 name: str,
                 type: str) -> None:
        """
        Initialize a TSLocationBasic object.

        :param str billing_location: The geographical location of this location,
               used for billing purposes.
        :param str name: Name of the Location.
        :param str type: The type of the location, determining is this a multi-zone
               region, a single data center, or a point of presence.
        """
        self.billing_location = billing_location
        self.name = name
        self.type = type

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TSLocationBasic':
        """Initialize a TSLocationBasic object from a json dictionary."""
        args = {}
        if 'billing_location' in _dict:
            args['billing_location'] = _dict.get('billing_location')
        else:
            raise ValueError('Required property \'billing_location\' not present in TSLocationBasic JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TSLocationBasic JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in TSLocationBasic JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TSLocationBasic object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'billing_location') and self.billing_location is not None:
            _dict['billing_location'] = self.billing_location
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TSLocationBasic object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TSLocationBasic') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TSLocationBasic') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TransitGateway():
    """
    Details of a Transit Gateway.

    :attr str id: The unique identifier for this Transit Gateway.
    :attr str crn: The CRN for this Transit Gateway.
    :attr str name: A human readable name for the transit gateway.
    :attr str location: Location of Transit Gateway Services.
    :attr datetime created_at: The date and time that this gateway was created.
    :attr bool global_: Allow global routing for a Transit Gateway.
    :attr ResourceGroupReference resource_group: (optional) The resource group to
          use. If unspecified, the account's [default resource
          group](https://console.bluemix.net/apidocs/resource-manager#introduction) is
          used.
    :attr str status: The status of the Transit Gateway.
    :attr datetime updated_at: (optional) The date and time that this gateway was
          last updated.
    """

    def __init__(self,
                 id: str,
                 crn: str,
                 name: str,
                 location: str,
                 created_at: datetime,
                 global_: bool,
                 status: str,
                 *,
                 resource_group: 'ResourceGroupReference' = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a TransitGateway object.

        :param str id: The unique identifier for this Transit Gateway.
        :param str crn: The CRN for this Transit Gateway.
        :param str name: A human readable name for the transit gateway.
        :param str location: Location of Transit Gateway Services.
        :param datetime created_at: The date and time that this gateway was
               created.
        :param bool global_: Allow global routing for a Transit Gateway.
        :param str status: The status of the Transit Gateway.
        :param ResourceGroupReference resource_group: (optional) The resource group
               to use. If unspecified, the account's [default resource
               group](https://console.bluemix.net/apidocs/resource-manager#introduction)
               is used.
        :param datetime updated_at: (optional) The date and time that this gateway
               was last updated.
        """
        self.id = id
        self.crn = crn
        self.name = name
        self.location = location
        self.created_at = created_at
        self.global_ = global_
        self.resource_group = resource_group
        self.status = status
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGateway':
        """Initialize a TransitGateway object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TransitGateway JSON')
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in TransitGateway JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TransitGateway JSON')
        if 'location' in _dict:
            args['location'] = _dict.get('location')
        else:
            raise ValueError('Required property \'location\' not present in TransitGateway JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in TransitGateway JSON')
        if 'global' in _dict:
            args['global_'] = _dict.get('global')
        else:
            raise ValueError('Required property \'global\' not present in TransitGateway JSON')
        if 'resource_group' in _dict:
            args['resource_group'] = ResourceGroupReference.from_dict(_dict.get('resource_group'))
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        else:
            raise ValueError('Required property \'status\' not present in TransitGateway JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGateway object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'location') and self.location is not None:
            _dict['location'] = self.location
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'global_') and self.global_ is not None:
            _dict['global'] = self.global_
        if hasattr(self, 'resource_group') and self.resource_group is not None:
            _dict['resource_group'] = self.resource_group.to_dict()
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGateway object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGateway') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGateway') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class StatusEnum(str, Enum):
        """
        The status of the Transit Gateway.
        """
        AVAILABLE = 'available'
        FAILED = 'failed'
        PENDING = 'pending'
        DELETING = 'deleting'


class TransitGatewayCollection():
    """
    A list of Transit Gateways.

    :attr List[TransitGateway] transit_gateways: Collection of Transit Services
          gateways.
    """

    def __init__(self,
                 transit_gateways: List['TransitGateway']) -> None:
        """
        Initialize a TransitGatewayCollection object.

        :param List[TransitGateway] transit_gateways: Collection of Transit
               Services gateways.
        """
        self.transit_gateways = transit_gateways

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayCollection':
        """Initialize a TransitGatewayCollection object from a json dictionary."""
        args = {}
        if 'transit_gateways' in _dict:
            args['transit_gateways'] = [TransitGateway.from_dict(x) for x in _dict.get('transit_gateways')]
        else:
            raise ValueError('Required property \'transit_gateways\' not present in TransitGatewayCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'transit_gateways') and self.transit_gateways is not None:
            _dict['transit_gateways'] = [x.to_dict() for x in self.transit_gateways]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TransitGatewayConnectionCollection():
    """
    A set of Transit Gateway network connections.

    :attr List[TransitGatewayConnectionCust] connections: Array of transit gateways
          network Connections.
    """

    def __init__(self,
                 connections: List['TransitGatewayConnectionCust']) -> None:
        """
        Initialize a TransitGatewayConnectionCollection object.

        :param List[TransitGatewayConnectionCust] connections: Array of transit
               gateways network Connections.
        """
        self.connections = connections

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayConnectionCollection':
        """Initialize a TransitGatewayConnectionCollection object from a json dictionary."""
        args = {}
        if 'connections' in _dict:
            args['connections'] = [TransitGatewayConnectionCust.from_dict(x) for x in _dict.get('connections')]
        else:
            raise ValueError('Required property \'connections\' not present in TransitGatewayConnectionCollection JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayConnectionCollection object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'connections') and self.connections is not None:
            _dict['connections'] = [x.to_dict() for x in self.connections]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayConnectionCollection object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayConnectionCollection') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayConnectionCollection') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TransitGatewayConnectionCust():
    """
    Connection included in transit gateway.

    :attr str name: (optional) The user-defined name for this transit gateway. If
          unspecified, the name will be the network name (the name of the VPC in the case
          of network type 'vpc', and the word Classic, in the case of network type
          'classic').
    :attr str network_id: (optional) The ID of the network being connected via this
          connection. This field is required for some types, such as 'vpc'. For network
          type 'vpc' this is the CRN of the VPC to be connected. This field is required to
          be unspecified for network type 'classic'.
    :attr str network_type: Defines what type of network is connected via this
          connection.
    :attr str network_account_id: (optional) The ID of the account which owns the
          network that is being connected. Generally only used if the network is in a
          different account than the gateway.
    :attr str id: The unique identifier for this Transit Gateway Connection to
          Network (vpc/classic).
    :attr datetime created_at: The date and time that this connection was created.
    :attr str request_status: (optional) Only visible for cross account connections,
          this field represents the status of the request to connect the given network
          between accounts.
    :attr str status: (optional) What is the current configuration state of this
          connection.
    :attr datetime updated_at: (optional) The date and time that this connection was
          last updated.
    """

    def __init__(self,
                 network_type: str,
                 id: str,
                 created_at: datetime,
                 *,
                 name: str = None,
                 network_id: str = None,
                 network_account_id: str = None,
                 request_status: str = None,
                 status: str = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a TransitGatewayConnectionCust object.

        :param str network_type: Defines what type of network is connected via this
               connection.
        :param str id: The unique identifier for this Transit Gateway Connection to
               Network (vpc/classic).
        :param datetime created_at: The date and time that this connection was
               created.
        :param str name: (optional) The user-defined name for this transit gateway.
               If unspecified, the name will be the network name (the name of the VPC in
               the case of network type 'vpc', and the word Classic, in the case of
               network type 'classic').
        :param str network_id: (optional) The ID of the network being connected via
               this connection. This field is required for some types, such as 'vpc'. For
               network type 'vpc' this is the CRN of the VPC to be connected. This field
               is required to be unspecified for network type 'classic'.
        :param str network_account_id: (optional) The ID of the account which owns
               the network that is being connected. Generally only used if the network is
               in a different account than the gateway.
        :param str request_status: (optional) Only visible for cross account
               connections, this field represents the status of the request to connect the
               given network between accounts.
        :param str status: (optional) What is the current configuration state of
               this connection.
        :param datetime updated_at: (optional) The date and time that this
               connection was last updated.
        """
        self.name = name
        self.network_id = network_id
        self.network_type = network_type
        self.network_account_id = network_account_id
        self.id = id
        self.created_at = created_at
        self.request_status = request_status
        self.status = status
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TransitGatewayConnectionCust':
        """Initialize a TransitGatewayConnectionCust object from a json dictionary."""
        args = {}
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        if 'network_id' in _dict:
            args['network_id'] = _dict.get('network_id')
        if 'network_type' in _dict:
            args['network_type'] = _dict.get('network_type')
        else:
            raise ValueError('Required property \'network_type\' not present in TransitGatewayConnectionCust JSON')
        if 'network_account_id' in _dict:
            args['network_account_id'] = _dict.get('network_account_id')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TransitGatewayConnectionCust JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in TransitGatewayConnectionCust JSON')
        if 'request_status' in _dict:
            args['request_status'] = _dict.get('request_status')
        if 'status' in _dict:
            args['status'] = _dict.get('status')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TransitGatewayConnectionCust object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'network_id') and self.network_id is not None:
            _dict['network_id'] = self.network_id
        if hasattr(self, 'network_type') and self.network_type is not None:
            _dict['network_type'] = self.network_type
        if hasattr(self, 'network_account_id') and self.network_account_id is not None:
            _dict['network_account_id'] = self.network_account_id
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'request_status') and self.request_status is not None:
            _dict['request_status'] = self.request_status
        if hasattr(self, 'status') and self.status is not None:
            _dict['status'] = self.status
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TransitGatewayConnectionCust object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TransitGatewayConnectionCust') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TransitGatewayConnectionCust') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class NetworkTypeEnum(str, Enum):
        """
        Defines what type of network is connected via this connection.
        """
        VPC = 'vpc'
        CLASSIC = 'classic'


    class RequestStatusEnum(str, Enum):
        """
        Only visible for cross account connections, this field represents the status of
        the request to connect the given network between accounts.
        """
        PENDING = 'pending'
        APPROVED = 'approved'
        REJECTED = 'rejected'
        EXPIRED = 'expired'
        DETACHED = 'detached'


    class StatusEnum(str, Enum):
        """
        What is the current configuration state of this connection.
        """
        ATTACHED = 'attached'
        FAILED = 'failed'
        PENDING = 'pending'
        DELETING = 'deleting'
        DETACHING = 'detaching'
        DETACHED = 'detached'

