# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['onepasswordconnectsdkopexe', 'onepasswordconnectsdkopexe.models']

package_data = \
{'': ['*'], 'onepasswordconnectsdkopexe': ['bin/*']}

install_requires = \
['onepasswordconnectsdk>=1.1.0,<2.0.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'six>=1.16.0,<2.0.0']

setup_kwargs = {
    'name': 'onepasswordconnectsdkopexe',
    'version': '0.1.1',
    'description': 'Python SDK for 1Password Connect with OP.exe ',
    'long_description': '# 1Password Connect Python SDK with OP.exe\n\nThe 1Password Connect SDK with OP.exe provides access to 1Password via [1Password command-line tool](https://support.1password.com/command-line-getting-started/) hosted in your infrastructure. The library is intended to be used by Python applications to simplify accessing items in 1Password vaults.\n\n## Installation\n\nTo install the 1Password Connect Python SDK:\n```bash\n$ pip install onepasswordconnectsdkopexe\n```\n\nTo install a specific release of the 1Password Connect Python SDK:\n```bash\n$ pip install onepasswordconnectsdkopexe==1.0.1\n```\n\n## Usage\n\n**Import 1Password Connect Python SDK**\n\n```python\nimport onepasswordconnectsdkopexe\n```\n\n**Environment Variables**\n\n- **OP_ACCOUNT** - Account 1Password\n- **OP_CONNECT_HOST** - The hostname of the 1Password Connect API.\n  Possible values include:\n    - `connect-api:8080` if the Connect server is running in the same Kubernetes cluster as your application.\n    - `localhost:8080` if the Connect server is running in Docker on the same host.\n    - `<ip>:8080` or `<hostname>:8080` if the Connect server is running on another host.\n- **OP_VAULT** - The default vault to fetch items from if not specified.\n- **OP_EMAIL_ADDRESS** - User login of 1Password\n- **OP_MASTER_PASSWORD** - Master password of previous login\n- **OP_SECRET_KEY** - Sercret key of previous login\n\n\n**Create a Client**\n\nThere are two methods available for creating a client:\n\n- `new_client_interactif`: Builds a new client for interacting with 1Password Connect. Accepts the hostname, the account, the email address of user, the master password and the secret key of the connection at 1Password if the values are not passed in parameter.\nBuilds a new client for interacting with 1Password Connect using the `OP_CONNECT_TOKEN` and `OP_CONNECT_HOST` *environment variables*.\n- `new_client`: Builds a new client to interact with 1Password without checking past parameter values.\n\n```python\nfrom onepasswordconnectsdk.client import (\n    Client,\n    new_client_interactif,\n    new_client\n)\n\n# creation client by asking him the different parameters\nclient_from_env: Client = new_client_interactif()\n\n# creates a client by supplying hostname and 1Password Connect API token\nclient_from_token: Client = new_client(\n    "{1Password_CONNECT_HOST}",\n    "{1Password_account}",\n    "{1Password_email}",\n    "{1Password_secret_key}",\n    "{1Password_master_password}")\n    \n```\n\n**Get Item**\n\nGet a specific item by item and vault ids:\n\n```python\nclient.get_item("{item_id}", "{vault_id}")\n```\n\n**Get Item By Title**\n\nGet a specific item by item title and vault id:\n\n```python\nclient.get_item_by_title("{item_title}", "{vault_id}")\n```\n\n**Get All Items**\n\nGet a summarized list of all items for a specified vault:\n\n```python\nclient.get_items("{vault_id}")\n```\n\n**Delete Item**\n\nDelete an item by item and vault ids:\n\n```python\nclient.delete_item("{item_id}", "{vault_id}")\n```\n\n**Create Item**\n\nCreate an item in a specified vault:\n\n```python\nfrom onepasswordconnectsdkopexe.models import OPItemVault as ItemVault\nfrom onepasswordconnectsdkopexe.models import OPField as Field\n\n# Example item creation. Create an item with your desired arguments. \nitem = onepasswordconnectsdk.models.Item(vault=ItemVault(id="av223f76ydutdngislnkbz6z5u"),\n                                      id="kp2td65r4wbuhocwhhijpdbfqq",\n                                      title="newtitle",\n                                      category="LOGIN",\n                                      tags=["1password-connect"],\n                                      fields=[Field(value="new_user",\n                                      purpose="USERNAME")],\n                                      )\nclient.create_item("{vault_id}", item)\n```\n\n**Update Item**\n\nUpdate the item identified by the specified item and vault ids. The existing item will be overwritten with the newly supplied item.\n\n```python\nfrom onepasswordconnectsdkopexe.models import OPItemVault as ItemVault\nfrom onepasswordconnectsdkopexe.models import OPField as Field\n\n# Example item creation. Create an item with your desired arguments. \nitem = onepasswordconnectsdk.models.Item(vault=ItemVault(id="av223f76ydutdngislnkbz6z5u"),\n                                      id="kp2td65r4wbuhocwhhijpdbfqq",\n                                      title="newtitle",\n                                      category="LOGIN",\n                                      tags=["1password-connect"],\n                                      fields=[Field(value="new_user",\n                                      purpose="USERNAME")],\n                                      )\nclient.update_item("{item_id}", "{vault_id}", item)\n```\n\n**Get Specific Vault**\n\nGet a vault by vault id:\n\n```python\nclient.get_vault("{vault_id}")\n```\n\n**Get Vaults**\n\nRetrieve all vaults available to the service account:\n\n```python\nclient.get_vaults()\n```\n\n**Load Configuration**\n\nUsers can create `classes` or `dicts` that describe fields they wish to get the values from in 1Password. Two convienience methods are provided that will handle the fetching of values for these fields:\n\n- **load_dict**: Takes a dictionary with keys specifying the user desired naming scheme of the values to return. Each key\'s value is a dictionary that includes information on where to find the item field value in 1Password. This returns a dictionary of user specified keys with values retrieved from 1Password\n- **load**: Takes an object with class attributes annotated with tags describing where to find desired fields in 1Password. Manipulates given object and fills attributes in with 1Password item field values.\n\n```python\n# example dict configuration for onepasswordconnectsdk.load_dict(CONFIG)\nCONFIG = {\n    "server": {\n        "opitem": "My database item",\n        "opfield": "specific_section.hostname",\n        "opvault": "some_vault_id",\n    },\n    "database": {\n        "opitem": "My database item",\n        "opfield": ".database",\n    },\n    "username": {\n        "opitem": "My database item",\n        "opfield": ".username",\n    },\n    "password": {\n        "opitem": "My database item",\n        "opfield": ".password",\n    },\n}\n\nvalues_dict = onepasswordconnectsdk.load_dict(CONFIG)\n```\n\n```python\n# example class configuration for onepasswordconnectsdk.load(CONFIG)\nclass Config:\n    server: \'opitem:"My database item" opvault:some_vault_id opfield:specific_section.hostname\' = None\n    database: \'opitem:"My database item" opfield:.database\' = None\n    username: \'opitem:"My database item" opfield:.username\' = None\n    password: \'opitem:"My database item" opfield:.password\' = None\n\nCONFIG = Config()\n\nvalues_object = onepasswordconnectsdk.load(CONFIG)\n```\n',
    'author': 'MSF-OCB',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/MSF-OCB/connect-sdk-python_opexe',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
