import * as cdk from 'aws-cdk-lib';
import { CustomResource } from 'aws-cdk-lib';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface MessagingResourceProps extends cdk.ResourceProps {
    readonly properties: {
        [propname: string]: any;
    };
    readonly resourceType: 'AppInstance' | 'ChannelFlow' | 'AppInstanceUser' | 'AppInstanceAdmin' | 'DataRetention' | 'StreamingConfig' | 'AppInstanceStreamingConfigurations';
    readonly uid: string;
}
export declare class MessagingResources extends Construct {
    readonly lambda: lambda.IFunction;
    readonly messagingCustomResource: CustomResource;
    constructor(scope: Construct, id: string, props: MessagingResourceProps);
    private ensureLambda;
}
