# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ecowitt2mqtt',
 'ecowitt2mqtt.backports',
 'ecowitt2mqtt.helpers',
 'ecowitt2mqtt.helpers.calculator',
 'ecowitt2mqtt.helpers.publisher',
 'ecowitt2mqtt.util']

package_data = \
{'': ['*']}

install_requires = \
['asyncio-mqtt>=0.12.1',
 'fastapi>=0.78.0,<0.79.0',
 'meteocalc>=1.1.0,<2.0.0',
 'python-multipart>=0.0.5,<0.0.6',
 'ruamel.yaml>=0.17.21,<0.18.0',
 'thefuzz[speedup]>=0.19.0,<0.20.0',
 'typer[all]>=0.4.1,<0.5.0',
 'uvicorn>=0.17.6,<0.18.0',
 'uvloop>=0.16.0,<0.17.0']

entry_points = \
{'console_scripts': ['ecowitt2mqtt = ecowitt2mqtt.cli:CLI_APP']}

setup_kwargs = {
    'name': 'ecowitt2mqtt',
    'version': '2022.6.1',
    'description': 'A small web server to send data from Ecowitt devices to an MQTT Broker',
    'long_description': '# 🔘 ecowitt2mqtt: Send Ecowitt device data to an MQTT broker\n\n[![PyPi](https://img.shields.io/pypi/v/ecowitt2mqtt.svg)](https://pypi.python.org/pypi/ecowitt2mqtt)\n[![Docker Hub](https://img.shields.io/docker/pulls/bachya/ecowitt2mqtt)](https://hub.docker.com/r/bachya/ecowitt2mqtt)\n[![Version](https://img.shields.io/pypi/pyversions/ecowitt2mqtt.svg)](https://pypi.python.org/pypi/ecowitt2mqtt)\n[![License](https://img.shields.io/pypi/l/ecowitt2mqtt.svg)](https://github.com/bachya/ecowitt2mqtt/blob/master/LICENSE)\n[![Code Coverage](https://codecov.io/gh/bachya/ecowitt2mqtt/branch/master/graph/badge.svg)](https://codecov.io/gh/bachya/ecowitt2mqtt)\n[![Maintainability](https://api.codeclimate.com/v1/badges/a03c9e96f19a3dc37f98/maintainability)](https://codeclimate.com/github/bachya/ecowitt2mqtt/maintainability)\n[![Say Thanks](https://img.shields.io/badge/SayThanks-!-1EAEDB.svg)](https://saythanks.io/to/bachya)\n\n`ecowitt2mqtt` is a small CLI/web server that allows [Ecowitt](http://www.ecowitt.com)\ndevice data to be sent to an MQTT broker.\n\n- [Installation](#installation)\n- [Python Versions](#python-versions)\n- [Quick Start](#quick-start)\n- [Configuration](#configuration)\n  * [Command Line Options](#command-line-options)\n  * [Environment Variables](#environment-variables)\n  * [Configuration File](#configuration-file)\n  * [Merging Configuration Options](#merging-configuration-options)\n- [Advanced Usage](#advanced-usage)\n  * [Battery Configurations](#battery-configurations)\n  * [Unit Systems](#unit-systems)\n  * [Raw Data](#raw-data)\n  * [Home Assistant](#home-assistant)\n  * [Running in the Background](#running-in-the-background)\n  * [Docker](#docker)\n- [Contributing](#contributing)\n\n# Installation\n\n```python\npip install ecowitt2mqtt\n```\n\n# Python Versions\n\n`ecowitt2mqtt` is currently supported on:\n\n* Python 3.8\n* Python 3.9\n* Python 3.10\n\n# Quick Start\n\nNote that this README assumes that:\n\n* you have access to an MQTT broker.\n* you have already paired your Ecowitt device with the WS View Android/iOS app from\n  Ecowitt.\n\nFirst, install `ecowitt2mqtt` via `pip`:\n\n```bash\n$ pip install ecowitt2mqtt\n```\n\nThen, shift over to the WS View app on your Android/iOS device. While viewing your\ndevice in the app, select `Weather Services`:\n\n![Select Weather Services](https://raw.githubusercontent.com/bachya/ecowitt2mqtt/dev/assets/1-weather-services.jpeg?raw=true)\n\nPress `Next` until you reach the `Customized` screen:\n\n![The Customized screen in the WS View app](https://raw.githubusercontent.com/bachya/ecowitt2mqtt/dev/assets/2-customized.jpeg?raw=true)\n\nFill out the form with these values and tap `Save`:\n\n* `Protocol Type Same As`: `Ecowitt`\n* `Server IP / Hostname`: the IP address/hostname of the device running `ecowitt2mqtt`\n* `Path`: `/data/report` (note that unlike the default in the WS View App, there shouldn\'t\n  be a trailing slash)\n* `Port`: `8080` (the default port on which `ecowitt2mqtt` is served)\n* `Upload Interval`: `60` (change this to alter the frequency with which data is published)\n\nThen, on the machine where you installed `ecowitt2mqtt`, run it:\n\n```bash\n$ ecowitt2mqtt \\\n    --mqtt-broker=192.168.1.101 \\\n    --mqtt-username=user \\\n    --mqtt-password=password \\\n    --mqtt-topic=ecowitt2mqtt/device_1\n```\n\nWithin the `Upload Interval`, data should begin to appear in the MQTT broker.\n\n# Configuration\n\n`ecowitt2mqtt` can be configured via command line options, environment variables, or a\n(YAML or JSON) config file.\n\n## Command Line Options\n\n```\nUsage: ecowitt2mqtt [OPTIONS] COMMAND [ARGS]...\n\n  ecowitt2mqtt sends Ecowitt device data to an MQTT broker.\n\nOptions:\n  --battery-override TEXT         A battery configuration override\n                                  (format: key,value)  [env var:\n                                  ECOWITT2MQTT_BATTERY_OVERRIDE]\n  -c, --config FILE               A path to a config file.  [env\n                                  var: ECOWITT2MQTT_CONFIG]\n  --default-battery-strategy TEXT\n                                  The default battery config\n                                  strategy to use.  [env var: ECOW\n                                  ITT2MQTT_DEFAULT_BATTERY_STRATEG\n                                  Y; default: boolean]\n  -e, --endpoint TEXT             The relative endpoint/path to\n                                  serve ecowitt2mqtt on.  [env\n                                  var: ECOWITT2MQTT_ENDPOINT,\n                                  ENDPOINT; default: /data/report]\n  --hass-discovery                Publish data in the Home\n                                  Assistant MQTT Discovery format.\n                                  [env var:\n                                  ECOWITT2MQTT_HASS_DISCOVERY,\n                                  HASS_DISCOVERY]\n  --hass-discovery-prefix TEXT    The Home Assistant discovery\n                                  prefix to use.  [env var: ECOWIT\n                                  T2MQTT_HASS_DISCOVERY_PREFIX,\n                                  HASS_DISCOVERY_PREFIX; default:\n                                  homeassistant]\n  --hass-entity-id-prefix TEXT    The prefix to use for Home\n                                  Assistant entity IDs.  [env var:\n                                  ECOWITT2MQTT_HASS_ENTITY_ID_PREF\n                                  IX, HASS_ENTITY_ID_PREFIX]\n  --input-unit-system TEXT        The input unit system used by\n                                  the device.  [env var:\n                                  ECOWITT2MQTT_INPUT_UNIT_SYSTEM,\n                                  INPUT_UNIT_SYSTEM; default:\n                                  imperial]\n  -b, --mqtt-broker TEXT          The hostname or IP address of an\n                                  MQTT broker.  [env var:\n                                  ECOWITT2MQTT_MQTT_BROKER,\n                                  MQTT_BROKER]\n  -p, --mqtt-password TEXT        A valid password for the MQTT\n                                  broker.  [env var:\n                                  ECOWITT2MQTT_MQTT_PASSWORD,\n                                  MQTT_PASSWORD]\n  --mqtt-port INTEGER             The listenting port of the MQTT\n                                  broker.  [env var:\n                                  ECOWITT2MQTT_MQTT_PORT,\n                                  MQTT_PORT; default: 1883]\n  -u, --mqtt-username TEXT        A valid username for the MQTT\n                                  broker.  [env var:\n                                  ECOWITT2MQTT_MQTT_USERNAME,\n                                  MQTT_USERNAME]\n  -t, --mqtt-topic TEXT           The MQTT topic to publish device\n                                  data to.  [env var:\n                                  ECOWITT2MQTT_MQTT_TOPIC,\n                                  MQTT_TOPIC]\n  --output-unit-system TEXT       The unit system to use in\n                                  output.  [env var:\n                                  ECOWITT2MQTT_OUTPUT_UNIT_SYSTEM,\n                                  OUTPUT_UNIT_SYSTEM; default:\n                                  imperial]\n  --port INTEGER                  The port to serve ecowitt2mqtt\n                                  on.  [env var:\n                                  ECOWITT2MQTT_PORT, PORT;\n                                  default: 8080]\n  --raw-data                      Return raw data (don\'t attempt\n                                  to translate any values).  [env\n                                  var: ECOWITT2MQTT_RAW_DATA,\n                                  RAW_DATA]\n  -v, --verbose                   Increase verbosity of logged\n                                  output.  [env var:\n                                  ECOWITT2MQTT_VERBOSE]\n  --install-completion            Install completion for the\n                                  current shell.\n  --show-completion               Show completion for the current\n                                  shell, to copy it or customize\n                                  the installation.\n  --help                          Show this message and exit.\n```\n\n## Environment Variables\n\n* `ECOWITT2MQTT_BATTERY_OVERRIDE`: a semicolon-delimited list of key=value battery overrides\n* `ECOWITT2MQTT_CONFIG`: a path to a YAML or JSON config file\n* `ECOWITT2MQTT_DEFAULT_BATTERY_STRATEGY`: The default battery config strategy to use (default: `boolean`)\n* `ECOWITT2MQTT_ENDPOINT`: the relative endpoint/path to serve ecowitt2mqtt on (default: `/data/report`)\n* `ECOWITT2MQTT_HASS_DISCOVERY`: publish data in the Home Assistant MQTT Discovery format Idefault: `false`)\n* `ECOWITT2MQTT_HASS_DISCOVERY_PREFIX`: the Home Assistant discovery prefix to use (default: `homeassistant`)\n* `ECOWITT2MQTT_HASS_ENTITY_ID_PREFIX`: the prefix to use for Home Assistant entity IDs\n* `ECOWITT2MQTT_INPUT_UNIT_SYSTEM`: the input unit system used by the device (default: `imperial`)\n* `ECOWITT2MQTT_MQTT_BROKER`: the hostname or IP address of an MQTT broker\n* `ECOWITT2MQTT_MQTT_PASSWORD`: a valid password for the MQTT broker\n* `ECOWITT2MQTT_MQTT_PORT`: the listenting port of the MQTT broker (default: `1883`)\n* `ECOWITT2MQTT_MQTT_TOPIC`: the MQTT topic to publish device data to\n* `ECOWITT2MQTT_MQTT_USERNAME`: a valid username for the MQTT broker\n* `ECOWITT2MQTT_OUTPUT_UNIT_SYSTEM`: the unit system to use in output (default: `imperial`)\n* `ECOWITT2MQTT_PORT`: the port to serve ecowitt2mqtt on (default: `8080`)\n* `ECOWITT2MQTT_RAW_DATA`: return raw data (don\'t attempt to translate any values)\n* `ECOWITT2MQTT_VERBOSE`: increase verbosity of logged output\n\n## Configuration File\n\nThe configuration file can be formatted as either YAML:\n\n```yaml\n---\nbattery_override:\n  battery_key1: boolean\ndefault_battery_strategy: numeric,\nendpoint: /data/report,\nhass_discovery: false,\nhass_discovery_prefix: homeassistant,\nhass_entity_id_prefix: test_prefix\ninput_unit_system: imperial,\nmqtt_broker: 127.0.0.1,\nmqtt_password: password,\nmqtt_port: 1883,\nmqtt_topic: Test,\nmqtt_username: user,\noutput_unit_system: imperial,\nport: 8080,\nraw_data: false,\nverbose: false\n```\n\n...or JSON\n\n\n```json\n{\n  "battery_override": {\n    "battery_key1": "boolean"\n  },\n  "default_battery_strategy": "numeric",\n  "endpoint": "/data/report",\n  "hass_discovery": false,\n  "hass_discovery_prefix": "homeassistant",\n  "hass_entity_id_prefix": "test_prefix"\n  "input_unit_system": "imperial",\n  "mqtt_broker": "127.0.0.1",\n  "mqtt_password": "password",\n  "mqtt_port": 1883,\n  "mqtt_topic": "Test",\n  "mqtt_username": "user",\n  "output_unit_system": "imperial",\n  "port": 8080,\n  "raw_data": false,\n  "verbose": false\n}\n```\n\n## Merging Configuration Options\n\nWhen parsing configuration options, `ecowitt2mqtt` looks at the configuration sources in\nthe following order:\n\n1. Configuration File\n2. Environment Variables\n3. CLI Options\n\nThis allows you to mix and match sources – for instance, you might have "defaults" in\nthe configuration file and override them via environment variables.\n\n# Advanced Usage\n\n## Battery Configurations\n\nEcowitt devices report battery levels in a very inconsistent manner, making it difficult\nto automatically parse their values into something meaningful. `ecowitt2mqtt` addresses\nthis via two mechanisms: a default battery "strategy" and battery overrides.\n\n### Default Battery Strategy\n\nBy using the `--default-battery-strategy` configuration parameter, users can specify how\nbatteries should be treated by default:\n\n* `boolean`: `0` represents `OFF` (i.e., the battery is in normal condition) and `1`\n   represents `ON` (i.e., the battery is low).\n* `numeric`: the raw numeric value is interpreted as the amount of voltage remaining in\n   the battery.\n\n### Battery Overrides\n\nIndividual batteries can be overridden and given a new strategy. This allows users to,\nsay, interpret all batteries as `boolean` by default, but interpret a specific battery\nas `numeric`. How this is accomplished differs slightly based on the configuration\nmethod used:\n\n* Command Line Options: provide one or more `--battery-override "batt1=boolean"` options\n* Environment Variables: provide a `ECOWITT2MQTT_BATTERY_OVERRIDE` variable that is a\n  semicolon-delimited pair of "key=value" strings (e.g.,\n  `ECOWITT2MQTT_BATTERY_OVERRIDE="batt1=boolean;batt2=numeric"`)\n* Config File: include a dictionary of key/value pairs in either YAML or JSON format\n\n### Example\n\nIn this example, a user mostly has batteries that should be treated as `boolean`, but\nalso has one – `wh60_batt1` – that should be treated as numeric.\n\n#### Command Line Options\n\n```\n$ ecowitt2mqtt --default-battery-strategy boolean --battery-override="wh60_batt1=numeric"\n```\n\n#### Environment Variables\n\n```\n$ ECOWITT2MQTT_DEFAULT_BATTERY_STRATEGY=boolean \\\n  ECOWITT2MQTT_BATTERY_OVERRIDE="wh60_batt1=numeric" \\\n  ecowitt2mqtt\n```\n\n#### Config File\n\nIn YAML:\n\n```yaml\n---\ndefault_battery_strategy: boolean\nbattery_override:\n  wh60_batt1: numeric\n```\n\n...or JSON\n\n```json\n{\n  "default_battery_strategy": "boolean",\n  "battery_override": {\n    "wh60_batt1": "numeric"\n  }\n}\n```\n\n## Unit Systems\n\n`ecowitt2mqtt` allows you to specify both the input and output unit systems for a device.\nThis is fairly self-explanatory, but take care to use an `--input-unit-system` that is\nconsistent with what your device provides (otherwise, your data will be very "off").\n\n## Raw Data\n\nIn some cases, it may be preferable to prevent `ecowitt2mqtt` from doing any data\ntranslation (converting values to a new unit system, changing binary values – such as\nmight be used by a battery – into "friendly" values, etc.). Passing the `--raw-data` flag\nwill accomplish this: data will flow directly from the Ecowitt device to the MQTT broker\nas-is.\n\nNote that the `--raw-data` flag supersedes any that might cause data translation (such as\n`--input-unit-system` or `--output-unit-system`).\n\n## Home Assistant\n\n### MQTT Discovery\n\n[Home Assistant](https://home-assistant.io) users can quickly add entities from an\nEcowitt device by using\n[MQTT Discovery](https://www.home-assistant.io/docs/mqtt/discovery/).\n\nOnce Home Assistant is configured to accept MQTT Discovery, `ecowitt2mqtt` simply needs\nthe `--hass-discovery` flag:\n\n```bash\n$ ecowitt2mqtt \\\n    --mqtt-broker=192.168.1.101 \\\n    --mqtt-username=user \\\n    --mqtt-password=password \\\n    --hass-discovery\n```\n\nNote that if both `--hass-discovery` and `--mqtt-topic` are provided, `--hass-discovery` will\nwin out.\n\n### Custom Entity ID Prefix\n\nYou can provide a custom prefix for all Home Assistant entities via the\n`--hass-entity-id-prefix` config parameter.\n\n## Running in the Background\n\n`ecowitt2mqtt` doesn\'t, itself, provide any sort of daemonization mechanism. The suggested\nroute is to use a different application.\n\n### `supervisord`\n\nAn example `supervisord` configuration file might look like this:\n\n```\n[supervisord]\nnodaemon=true\nloglevel=info\nuser=root\n\n[program:ecowitt2mqtt]\ncommand=ecowitt2mqtt --mqtt-broker=192.168.1.101 --mqtt-username=user --mqtt-password=password\nstdout_logfile=/dev/stdout\nstdout_logfile_maxbytes=0\nredirect_stderr=true\n```\n\n### `systemd`\n\nAn example `systemd` service file in `/etc/systemd/system` might look like this:\n\n```\n[Unit]\nDescription=ECOWITT2MQTT daemon\nAfter=network.target\n\n[Service]\nType=notify\nExecStart=ecowitt2mqtt --mqtt-broker=192.168.1.101 --mqtt-username=user --mqtt-password=password\nExecReload=kill -HUP $MAINPID\nKillMode=process\nRestart=on-failure\nRestartSec=5s\n\n[Install]\nWantedBy=multi-user.target\n```\n\nTo enable the service:\n\n```bash\n$ systemctl enable ecowitt2mqtt\n```\n\n## Docker\n\nThe library is available via a Docker image\n([`bachya/ecowitt2mqtt`](https://hub.docker.com/r/bachya/ecowitt2mqtt)). It is configured\nby using the same environment variables listed [above](#environment-variables).\n\nRunning the image is straightforward:\n\n```\ndocker run -it \\\n    -e MQTT_BROKER=192.168.1.101 \\\n    -e MQTT_USERNAME=user \\\n    -e MQTT_PASSWORD=password \\\n    -p 8080:8080 \\\n    bachya/ecowitt2mqtt:latest\n```\n\nNote the value of the `-p` flag: you must expose the port defined by the `PORT`\nenvironment variable. In the example above, the default port (`8080`) is used and is\nexposed via the same port on the host.\n\n[`docker-compose`](https://docs.docker.com/compose/) users can find an example\nconfiguration file at\n[`docker-compose.dev.yml`](https://github.com/bachya/ecowitt2mqtt/blob/dev/docker-compose.dev.yml).\nNote that this is intended to be a dev environment for quickly testing the repo itself;\nin production, you should refer to one of the\n[Docker Hub](https://hub.docker.com/r/bachya/ecowitt2mqtt) images.\n\n# Contributing\n\n1. [Check for open features/bugs](https://github.com/bachya/ecowitt2mqtt/issues)\n  or [initiate a discussion on one](https://github.com/bachya/ecowitt2mqtt/issues/new).\n2. [Fork the repository](https://github.com/bachya/ecowitt2mqtt/fork).\n3. (_optional, but highly recommended_) Create a virtual environment: `python3 -m venv .venv`\n4. (_optional, but highly recommended_) Enter the virtual environment: `source ./.venv/bin/activate`\n5. Install the dev environment: `script/setup`\n6. Code your new feature or bug fix.\n7. Write tests that cover your new functionality.\n8. Run tests and ensure 100% code coverage: `nox -rs coverage`\n9. Update `README.md` with any new documentation.\n10. Add yourself to `AUTHORS.md`.\n11. Submit a pull request!\n',
    'author': 'Aaron Bach',
    'author_email': 'bachya1208@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bachya/ecowitt2mqtt',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
