# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.assistant import Assistant
from ..core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.jsonable_encoder import jsonable_encoder
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.assistant_version import AssistantVersion
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AssistantsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_assistants(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[Assistant]:
        """
        List all assistants for the current user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Assistant]
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.list_assistants()
        """
        _response = self._client_wrapper.httpx_client.request(
            "assistants/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Assistant],
                    parse_obj_as(
                        type_=typing.List[Assistant],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_public_assistants(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Assistant]:
        """
        List all public assistants.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Assistant]
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.list_public_assistants()
        """
        _response = self._client_wrapper.httpx_client.request(
            "assistants/public/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Assistant],
                    parse_obj_as(
                        type_=typing.List[Assistant],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_assistant(self, aid: str, *, request_options: typing.Optional[RequestOptions] = None) -> Assistant:
        """
        Get an assistant by ID.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.get_assistant(
            aid="aid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upsert_assistant(
        self,
        aid: str,
        *,
        name: str,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        graph_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        public: typing.Optional[bool] = OMIT,
        annotations: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Assistant:
        """
        Create or update an assistant.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        name : str
            The name of the assistant.

        config : typing.Dict[str, typing.Optional[typing.Any]]
            The assistant config.

        graph_id : typing.Optional[str]
            The ID of the graph.

        description : typing.Optional[str]
            The description of the assistant.

        public : typing.Optional[bool]
            Whether the assistant is public.

        annotations : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The annotations of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.upsert_assistant(
            aid="aid",
            name="name",
            config={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}",
            method="PUT",
            json={
                "graph_id": graph_id,
                "name": name,
                "description": description,
                "config": config,
                "public": public,
                "annotations": annotations,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_assistant(
        self, aid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an assistant by ID.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.delete_assistant(
            aid="aid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_assistant_versions(
        self, aid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[AssistantVersion]:
        """
        Get all versions of an assistant.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AssistantVersion]
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.get_assistant_versions(
            aid="aid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}/versions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[AssistantVersion],
                    parse_obj_as(
                        type_=typing.List[AssistantVersion],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def set_latest_version(
        self, aid: str, *, version: int, request_options: typing.Optional[RequestOptions] = None
    ) -> Assistant:
        """
        Set the latest version of an assistant.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        version : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.set_latest_version(
            aid="aid",
            version=1,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}/latest",
            method="POST",
            params={
                "version": version,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_assistant(
        self,
        *,
        name: str,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        graph_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        public: typing.Optional[bool] = OMIT,
        annotations: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Assistant:
        """
        Create an assistant.

        Parameters
        ----------
        name : str
            The name of the assistant.

        config : typing.Dict[str, typing.Optional[typing.Any]]
            The assistant config.

        graph_id : typing.Optional[str]
            The ID of the graph.

        description : typing.Optional[str]
            The description of the assistant.

        public : typing.Optional[bool]
            Whether the assistant is public.

        annotations : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The annotations of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.assistants.create_assistant(
            name="name",
            config={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "assistants",
            method="POST",
            json={
                "graph_id": graph_id,
                "name": name,
                "description": description,
                "config": config,
                "public": public,
                "annotations": annotations,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncAssistantsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_assistants(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Assistant]:
        """
        List all assistants for the current user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Assistant]
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.list_assistants()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "assistants/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Assistant],
                    parse_obj_as(
                        type_=typing.List[Assistant],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_public_assistants(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Assistant]:
        """
        List all public assistants.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Assistant]
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.list_public_assistants()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "assistants/public/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Assistant],
                    parse_obj_as(
                        type_=typing.List[Assistant],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_assistant(self, aid: str, *, request_options: typing.Optional[RequestOptions] = None) -> Assistant:
        """
        Get an assistant by ID.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.get_assistant(
                aid="aid",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upsert_assistant(
        self,
        aid: str,
        *,
        name: str,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        graph_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        public: typing.Optional[bool] = OMIT,
        annotations: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Assistant:
        """
        Create or update an assistant.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        name : str
            The name of the assistant.

        config : typing.Dict[str, typing.Optional[typing.Any]]
            The assistant config.

        graph_id : typing.Optional[str]
            The ID of the graph.

        description : typing.Optional[str]
            The description of the assistant.

        public : typing.Optional[bool]
            Whether the assistant is public.

        annotations : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The annotations of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.upsert_assistant(
                aid="aid",
                name="name",
                config={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}",
            method="PUT",
            json={
                "graph_id": graph_id,
                "name": name,
                "description": description,
                "config": config,
                "public": public,
                "annotations": annotations,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_assistant(
        self, aid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an assistant by ID.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.delete_assistant(
                aid="aid",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_assistant_versions(
        self, aid: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[AssistantVersion]:
        """
        Get all versions of an assistant.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AssistantVersion]
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.get_assistant_versions(
                aid="aid",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}/versions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[AssistantVersion],
                    parse_obj_as(
                        type_=typing.List[AssistantVersion],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def set_latest_version(
        self, aid: str, *, version: int, request_options: typing.Optional[RequestOptions] = None
    ) -> Assistant:
        """
        Set the latest version of an assistant.

        Parameters
        ----------
        aid : str
            The ID of the assistant.

        version : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.set_latest_version(
                aid="aid",
                version=1,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"assistants/{jsonable_encoder(aid)}/latest",
            method="POST",
            params={
                "version": version,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_assistant(
        self,
        *,
        name: str,
        config: typing.Dict[str, typing.Optional[typing.Any]],
        graph_id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        public: typing.Optional[bool] = OMIT,
        annotations: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Assistant:
        """
        Create an assistant.

        Parameters
        ----------
        name : str
            The name of the assistant.

        config : typing.Dict[str, typing.Optional[typing.Any]]
            The assistant config.

        graph_id : typing.Optional[str]
            The ID of the graph.

        description : typing.Optional[str]
            The description of the assistant.

        public : typing.Optional[bool]
            Whether the assistant is public.

        annotations : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The annotations of the assistant.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Assistant
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.assistants.create_assistant(
                name="name",
                config={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "assistants",
            method="POST",
            json={
                "graph_id": graph_id,
                "name": name,
                "description": description,
                "config": config,
                "public": public,
                "annotations": annotations,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Assistant,
                    parse_obj_as(
                        type_=Assistant,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
