# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from ..types.tool_registry_base import ToolRegistryBase
from ..core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.model_provider import ModelProvider
from ..core.client_wrapper import AsyncClientWrapper


class ConfigsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_tools(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[ToolRegistryBase]:
        """
        List all tools.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ToolRegistryBase]
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.configs.list_tools()
        """
        _response = self._client_wrapper.httpx_client.request(
            "configs/tools",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ToolRegistryBase],
                    parse_obj_as(
                        type_=typing.List[ToolRegistryBase],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_providers(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[ModelProvider]:
        """
        List all AI Model Providers.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ModelProvider]
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.configs.list_providers()
        """
        _response = self._client_wrapper.httpx_client.request(
            "configs/providers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ModelProvider],
                    parse_obj_as(
                        type_=typing.List[ModelProvider],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_runbook_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        List all runbook templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response

        Examples
        --------
        from akili import AkiliApi

        client = AkiliApi(
            token="YOUR_TOKEN",
        )
        client.configs.list_runbook_templates()
        """
        _response = self._client_wrapper.httpx_client.request(
            "configs/runbooks/templates",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[typing.Dict[str, typing.Optional[typing.Any]]],
                    parse_obj_as(
                        type_=typing.List[typing.Dict[str, typing.Optional[typing.Any]]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncConfigsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_tools(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ToolRegistryBase]:
        """
        List all tools.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ToolRegistryBase]
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.configs.list_tools()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "configs/tools",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ToolRegistryBase],
                    parse_obj_as(
                        type_=typing.List[ToolRegistryBase],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_providers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ModelProvider]:
        """
        List all AI Model Providers.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ModelProvider]
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.configs.list_providers()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "configs/providers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ModelProvider],
                    parse_obj_as(
                        type_=typing.List[ModelProvider],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_runbook_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        List all runbook templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response

        Examples
        --------
        import asyncio

        from akili import AsyncAkiliApi

        client = AsyncAkiliApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.configs.list_runbook_templates()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "configs/runbooks/templates",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[typing.Dict[str, typing.Optional[typing.Any]]],
                    parse_obj_as(
                        type_=typing.List[typing.Dict[str, typing.Optional[typing.Any]]],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
