# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import datetime as dt
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class Assistant(UniversalBaseModel):
    """
    Represents an assistant entity.
    """

    assistant_id: str = pydantic.Field()
    """
    Unique identifier for the assistant.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the assistant was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the assistant was last updated.
    """

    version: typing.Optional[int] = pydantic.Field(default=None)
    """
    Version of the assistant.
    """

    user_id: str = pydantic.Field()
    """
    ID of the user that owns the assistant.
    """

    name: str = pydantic.Field()
    """
    Name of the assistant.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional description of the assistant.
    """

    annotations: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The annotations of the assistant.
    """

    config: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The assistant config.
    """

    public: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the assistant is public.
    """

    graph_id: str = pydantic.Field()
    """
    Graph ID of the assistant.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
