# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class AssistantPayload(UniversalBaseModel):
    """
    Payload for creating an assistant.
    """

    graph_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the graph.
    """

    name: str = pydantic.Field()
    """
    The name of the assistant.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the assistant.
    """

    config: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The assistant config.
    """

    public: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the assistant is public.
    """

    annotations: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The annotations of the assistant.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
