# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
from .content import Content
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic


class HumanMessage(UniversalBaseModel):
    """
    Message from a human.

    HumanMessages are messages that are passed in from a human to the model.

    Example:

        .. code-block:: python

            from langchain_core.messages import HumanMessage, SystemMessage

            messages = [
                SystemMessage(
                    content="You are a helpful assistant! Your name is Bob."
                ),
                HumanMessage(
                    content="What is your name?"
                )
            ]

            # Instantiate a chat model and invoke it with the messages
            model = ...
            print(model.invoke(messages))
    """

    content: Content
    additional_kwargs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    response_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    type: typing.Optional[typing.Literal["human"]] = None
    name: typing.Optional[str] = None
    id: typing.Optional[str] = None
    example: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
