# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ..core.pydantic_utilities import UniversalBaseModel
import typing
from .interrupt import Interrupt
from .checkpoint import Checkpoint
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from ..core.pydantic_utilities import update_forward_refs


class ThreadTask(UniversalBaseModel):
    """
    Represents a task within a thread.
    """

    id: str
    name: str
    error: typing.Optional[str] = None
    interrupts: typing.List[Interrupt]
    checkpoint: typing.Optional[Checkpoint] = None
    state: typing.Optional["ThreadState"] = None
    result: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .thread_state import ThreadState  # noqa: E402

update_forward_refs(ThreadState, ThreadTask=ThreadTask)
update_forward_refs(ThreadTask)
