# BentoML Project Governance Document

Welcome to the BentoML community. BentoML is an open, community-driven project for 
machine learning model serving. 

BentoML takes a meritocratic, consensus-based approach to its governance structure. 
Anyone with an interest in the project can join the community, contribute to the project
and participate in the decision making process. And this is a living document aiming to 
outline how that participation takes place.

* Contribution guidelines: https://github.com/bentoml/BentoML/blob/main/CONTRIBUTING.md
* Code of Conduct: https://github.com/bentoml/BentoML/blob/main/CODE_OF_CONDUCT.md
* Development guidelines: https://github.com/bentoml/BentoML/blob/main/DEVELOPMENT.md
* BentoML contributor mailing list: https://groups.google.com/forum/#!forum/bentoml
* BentoML contributor slack channel: https://bentoml.slack.com/archives/CKC2JP3TM


## Roles And Responsibilities

#### Contributors

Contributors are community members who contribute in concrete ways to the project. 
Anyone can become a contributor, and contributions can take many forms, as detailed in 
the [BentoML Contribution Guidelines](https://github.com/bentoml/BentoML/blob/main/CONTRIBUTING.md).
There is no expectation of commitment to the project, no specific skill requirements and
no selection process.

As a contributor, you may find yourself doing one or more of the following:

* Support new users by answering questions on the
    [github issue tracker](https://github.com/bentoml/BentoML/issues) and the 
    [#bentoml-users slack channel](https://join.slack.bentoml.org).
* Report issues you're facing and "Thumbs up" on issues and feature requests that are 
    relevant to you in BentoML's [issue tracker](https://github.com/bentoml/BentoML/issues).
* Investigate bugs and reviewing other developer's pull requests.
* Contribute code or documentation to the project by submitting a Github pull request.
* Create new example projects and contribute it to [bentoml/examples](https://github.com/bentoml/BentoML/tree/main/examples).


Contributors engage with the project through the issue tracker and mailing list. They 
submit code or documentation changes to the project via github pull request, which will 
be reviewed by the Core Team members (see next section). 

The [BentoML contributors mailing list](https://groups.google.com/forum/#!forum/bentoml) 
is the most appropriate place to ask for help or get feedback when making contributions.

As contributors gain experience and familiarity with the project, their profile within, 
and commitment to, the community will increase. At some stage, they may find themselves 
being nominated for the BentoML Core Team.


#### Core Team

The BentoML Core Team consist of contributors who have produced contributions that are
substantial in quality and quantity. The core team members has additional
responsibilities over those of a contributor. These responsibilities ensure the smooth 
running of the project:

* Managing the BentoML code and documentation
* Managing QA and new releases
* Maintaining a high-level technical direction and roadmap
* Project governance decisions and changes
* Coordination of core team, contributors and users
* Managing the membership of the core team
* Make final decisions when regular community discussion doesn’t produce consensus on 
    an issue in a reasonable time frame.


Members of the Core Team do not have significant authority over other members of the
community, although it is the Core Team that votes on new Core Team members. It also 
makes decisions when community consensus cannot be reached. 

A contributor who shows an above-average level of contribution to the project, 
particularly with respect to its strategic direction and long-term health, may be 
nominated to become a member of the Core Team, by existing Core Team members. A 
nomination will result in discussion and then a vote by the existing Core Team members.
Core Team membership votes are subject to consensus approval of the current Core Team
members.


#### Benevolent dictator (project lead)

The Project will have a BDFL (Benevolent Dictator for Life), who is currently Chaoyu 
Yang. As Dictator, the BDFL has the authority to make all final decisions for The 
Project. As Benevolent, the BDFL, in practice chooses to defer that authority to the 
consensus of the community discussion channels and the Core Team. It is expected that 
the BDFL will only rarely assert his/her final authority. Because it is rarely used, we
refer to BDFL’s final authority as a “special” or “overriding” vote. When it does occur,
the BDFL override typically happens in situations where there is a deadlock in the Core 
Team or if the Core Team asks the BDFL to make a decision on a specific matter. To 
ensure the benevolence of the BDFL, The Project encourages others to fork The Project if
they disagree with the overall direction the BDFL is taking. The BDFL is chair of the 
Core Team and may delegate his/her authority on a particular decision or set of 
decisions to any other Core Team Member at his/her discretion.

The BDFL can appoint his/her successor, but it is expected that the Core Team would be 
consulted on this decision. If the BDFL is unable to appoint a successor (e.g. due to 
death or illness), the Core Team will choose a successor by voting with at least 2/3 of
the Core Team members voting in favor of the chosen successor. At least 80% of the Core 
Team must participate in the vote.


#### Conflict of interest

It is expected that the BDFL and Core Team Members will be employed at a wide range of 
companies, universities and non-profit organizations. Because of this, it is possible 
that Members will have conflicts of interest. Such conflicts of interest include, but
are not limited to:

Financial interests, such as investments, employment or contracting work, outside of The
Project that may influence their work on The Project. Access to proprietary information
of their employer that could potentially leak into their work with the Project. All 
members of the Core Team, BDFL included, shall disclose to the rest of the Core Team any
conflict of interest they may have. Members with a conflict of interest in a particular
issue may participate in Core Team discussions on that issue, but must recuse themselves
from voting on the issue. If the BDFL has recused his/herself for a particular decision,
they will appoint a substitute BDFL for that decision.


#### Current Core Team Members

* Bo Jiang - [@bojiang](https://github.com/bojiang)
* Bozhao Yu - [@yubozhao](https://github.com/yubozhao), [🔗linkedin](https://www.linkedin.com/in/bozhaoyu/)
* Chaoyu Yang (BDFL) - [@parano](https://github.com/parano), [🔗linkedin](https://www.linkedin.com/in/parano/)
* Liang Sun - [@leonsim](https://github.com/leonsim), [🔗linkedin](https://www.linkedin.com/in/1e0ns/)
* Sungjun Kim - [@withsmilo](https://github.com/withsmilo), [🔗linkedin](https://www.linkedin.com/in/smilo/) 
* TBD
* TBD


## Contribution Process

Anyone can contribute to the project, regardless of their skills, as there are many ways
to contribute. For instance, a contributor might be active on the project mailing list 
and issue tracker, or might supply patches. The various ways of contributing are 
described in more detail in the [Contribution Guidelines](https://github.com/bentoml/BentoML/blob/main/CONTRIBUTING.md).

The [BentoML contributor mailing list](https://groups.google.com/forum/#!forum/bentoml) 
is the most appropriate place to ask for help or get feedback when making contributions.


## Decision Making Process

Decisions about the future of the project are made through discussion with all members 
of the community, from the newest user to the most experienced PMC member. All 
non-sensitive project management discussion takes place on the 
[BentoML contributors mailing list](https://groups.google.com/forum/#!forum/bentoml). 

In order to ensure that the project is not bogged down by endless discussion and 
continual voting, the project operates a policy of lazy consensus. This allows the 
majority of decisions to be made without resorting to a formal vote.


#### Lazy consensus

Decision making typically involves the following steps:

* Proposal
* Discussion
* Vote (if consensus is not reached through discussion)
* Decision

Any community member can make a proposal for consideration by the community. In order to
initiate a discussion about a new idea, they should send an email to the BentoML 
contributors’ list or create a github issue describing the idea. This will prompt a 
review and, if necessary, a discussion of the idea. The goal of this review and 
discussion is to gain approval for the contribution. Since most people in the project 
community have a shared vision, there is often little need for discussion in order to 
reach consensus.

In general, as long as nobody explicitly opposes a proposal or patch, it is recognised 
as having the support of the community. This is called lazy consensus - that is, those
who have not stated their opinion explicitly have implicitly agreed to the
implementation of the proposal.

Lazy consensus is a very important concept within the project. It is this process that
allows a large group of people to efficiently reach consensus, as someone with no 
objections to a proposal need not spend time stating their position, and others need
not spend time reading such mails.

For lazy consensus to be effective, it is necessary to allow at least 72 hours before
assuming that there are no objections to the proposal. This requirement ensures that 
everyone is given enough time to read, digest and respond to the proposal. This time 
period is chosen so as to be as inclusive as possible of all participants, regardless
of their location and time commitments.


#### Voting

Not all decisions can be made using lazy consensus. Issues such as those affecting the 
strategic direction or legal standing of the project must gain explicit approval from
the Core Team, which will adopt the 
[Apache Foundation voting process](https://www.apache.org/foundation/voting.html). 
Every member of the community is encouraged to express their opinions in
all discussion and all votes. However, only Core Team members have binding votes for the
purposes of decision making.
