import threading, typing
from types import TracebackType
from typing import IO, Optional, Text, Type
from .base import FS

if typing.TYPE_CHECKING: ...

class _Worker(threading.Thread):
    def __init__(self, copier) -> None: ...
    def run(self): ...

class _Task:
    def __call__(self) -> None: ...

class _CopyTask(_Task):
    def __init__(self, src_file: IO, dst_file: IO) -> None: ...
    def __call__(self) -> None: ...

class Copier:
    def __init__(self, num_workers: int = ...) -> None: ...
    def start(self): ...
    def stop(self): ...
    def add_error(self, error): ...
    def __enter__(self): ...
    def __exit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        traceback: Optional[TracebackType],
    ): ...
    def copy(self, src_fs: FS, src_path: Text, dst_fs: FS, dst_path: Text) -> None: ...
