import typing
from contextlib import contextmanager
from types import TracebackType
from typing import Iterator, Optional, Text, Type, Union

if typing.TYPE_CHECKING: ...
_WINDOWS_PLATFORM = ...

class _ConvertOSErrors:
    FILE_ERRORS = ...
    DIR_ERRORS = ...
    if _WINDOWS_PLATFORM: ...
    def __init__(self, opname: Text, path: Text, directory: bool = ...) -> None: ...
    def __enter__(self) -> _ConvertOSErrors: ...
    def __exit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc_value: Optional[BaseException],
        traceback: Optional[TracebackType],
    ) -> None: ...

convert_os_errors = _ConvertOSErrors

@contextmanager
def unwrap_errors(path_replace: Union[Text, Mapping[Text, Text]]) -> Iterator[None]: ...
