import array, io, mmap, typing
from io import RawIOBase
from typing import IO, Any, Iterable, Iterator, List, Optional, Text, Union

if typing.TYPE_CHECKING: ...

class RawWrapper(io.RawIOBase):
    def __init__(
        self, f: IO[bytes], mode: Optional[Text] = ..., name: Optional[Text] = ...
    ) -> None: ...
    def close(self) -> None: ...
    def fileno(self) -> int: ...
    def flush(self) -> None: ...
    def isatty(self) -> bool: ...
    def seek(self, offset: int, whence: int = ...) -> int: ...
    def readable(self) -> bool: ...
    def writable(self) -> bool: ...
    def seekable(self) -> bool: ...
    def tell(self) -> int: ...
    def truncate(self, size: Optional[int] = ...) -> int: ...
    def write(
        self, data: Union[bytes, memoryview, array.array[Any], mmap.mmap]
    ) -> int: ...
    @typing.no_type_check
    def read(self, n: int = ...) -> bytes: ...
    def read1(self, n: int = ...) -> bytes: ...
    @typing.no_type_check
    def readall(self) -> bytes: ...
    @typing.no_type_check
    def readinto(self, b: bytearray) -> int: ...
    @typing.no_type_check
    def readinto1(self, b: bytearray) -> int: ...
    def readline(self, limit: Optional[int] = ...) -> bytes: ...
    def readlines(self, hint: Optional[int] = ...) -> List[bytes]: ...
    def writelines(
        self, lines: Iterable[Union[bytes, memoryview, array.array[Any], mmap.mmap]]
    ) -> None: ...
    def __iter__(self) -> Iterator[bytes]: ...

@typing.no_type_check
def make_stream(
    name: Text,
    bin_file: RawIOBase,
    mode: Text = ...,
    buffering: int = ...,
    encoding: Optional[Text] = ...,
    errors: Optional[Text] = ...,
    newline: Optional[Text] = ...,
    line_buffering: bool = ...,
    **kwargs: Any
) -> IO: ...
def line_iterator(
    readable_file: IO[bytes], size: Optional[int] = ...
) -> Iterator[bytes]: ...
