import array, io, mmap, typing
from typing import (
    Any,
    BinaryIO,
    Collection,
    Dict,
    Iterable,
    Iterator,
    List,
    Optional,
    SupportsInt,
    Text,
    Tuple,
    Union,
)
import six
from ._typing import overload
from .base import FS, _OpendirFactory
from .enums import ResourceType
from .info import Info, RawInfo
from .permissions import Permissions
from .subfs import SubFS

if typing.TYPE_CHECKING:
    _M = ...

@six.python_2_unicode_compatible
class _MemoryFile(io.RawIOBase):
    def __init__(
        self, path: Text, memory_fs: MemoryFS, mode: Text, dir_entry: _DirEntry
    ) -> None: ...
    def __str__(self) -> str: ...
    @property
    def mode(self) -> Text: ...
    def on_modify(self) -> None: ...
    def on_access(self) -> None: ...
    def flush(self) -> None: ...
    def __iter__(self) -> typing.Iterator[bytes]: ...
    def next(self) -> bytes: ...
    __next__ = ...
    def readline(self, size: Optional[int] = ...) -> bytes: ...
    def close(self) -> None: ...
    def read(self, size: Optional[int] = ...) -> bytes: ...
    def readable(self) -> bool: ...
    def readinto(self, buffer): ...
    def readlines(self, hint: int = ...) -> List[bytes]: ...
    def seekable(self) -> bool: ...
    def seek(self, pos: int, whence: SupportsInt = ...) -> int: ...
    def tell(self) -> int: ...
    def truncate(self, size: Optional[int] = ...) -> int: ...
    def writable(self) -> bool: ...
    def write(
        self, data: Union[bytes, memoryview, array.array[Any], mmap.mmap]
    ) -> int: ...
    def writelines(
        self, sequence: Iterable[Union[bytes, memoryview, array.array[Any], mmap.mmap]]
    ) -> None: ...

class _DirEntry:
    def __init__(self, resource_type: ResourceType, name: Text) -> None: ...
    @property
    def bytes_file(self) -> Optional[io.BytesIO]: ...
    @property
    def is_dir(self) -> bool: ...
    @property
    def size(self) -> int: ...
    @overload
    def get_entry(self, name: Text, default: _DirEntry) -> _DirEntry: ...
    @overload
    def get_entry(self, name: Text) -> Optional[_DirEntry]: ...
    @overload
    def get_entry(self, name: Text, default: None) -> Optional[_DirEntry]: ...
    def get_entry(
        self, name: Text, default: Optional[_DirEntry] = ...
    ) -> Optional[_DirEntry]: ...
    def set_entry(self, name: Text, dir_entry: _DirEntry) -> None: ...
    def remove_entry(self, name: Text) -> None: ...
    def clear(self) -> None: ...
    def __contains__(self, name: object) -> bool: ...
    def __len__(self) -> int: ...
    def list(self) -> List[Text]: ...
    def add_open_file(self, memory_file: _MemoryFile) -> None: ...
    def remove_open_file(self, memory_file: _MemoryFile) -> None: ...
    def to_info(self, namespaces: Optional[Collection[Text]] = ...) -> Info: ...

@six.python_2_unicode_compatible
class MemoryFS(FS):
    _meta: Dict[Text, Union[Text, int, bool, None]] = ...
    def __init__(self) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    def close(self) -> None: ...
    def getinfo(
        self, path: Text, namespaces: Optional[Collection[Text]] = ...
    ) -> Info: ...
    def listdir(self, path: Text) -> List[Text]: ...
    if typing.TYPE_CHECKING:
        def opendir(
            self: _M, path: Text, factory: Optional[_OpendirFactory] = ...
        ) -> SubFS[_M]: ...

    def makedir(
        self: _M,
        path: Text,
        permissions: Optional[Permissions] = ...,
        recreate: bool = ...,
    ) -> SubFS[_M]: ...
    def move(self, src_path, dst_path, overwrite=...): ...
    def movedir(self, src_path, dst_path, create=...): ...
    def openbin(
        self, path: Text, mode: Text = ..., buffering: int = ..., **options: Any
    ) -> BinaryIO: ...
    def remove(self, path: Text) -> None: ...
    def removedir(self, path: Text) -> None: ...
    def removetree(self, path: Text) -> None: ...
    def scandir(
        self,
        path: Text,
        namespaces: Optional[Collection[Text]] = ...,
        page: Optional[Tuple[int, int]] = ...,
    ) -> Iterator[Info]: ...
    def setinfo(self, path: Text, info: RawInfo) -> None: ...
