import typing
from typing import Any, BinaryIO, Collection, List, Optional, Text, Tuple, Union
import six
from . import errors
from .base import FS
from .info import Info, RawInfo
from .permissions import Permissions
from .subfs import SubFS
from .wrapfs import WrapFS

if typing.TYPE_CHECKING:
    T = ...
__all__ = ["TarFS", "WriteTarFS", "ReadTarFS"]
if six.PY2: ...
else: ...

class TarFS(WrapFS):
    _compression_formats = ...
    def __new__(
        cls,
        file: Union[Text, BinaryIO],
        write: bool = ...,
        compression: Optional[Text] = ...,
        encoding: Text = ...,
        temp_fs: Union[Text, FS] = ...,
    ) -> FS: ...
    if typing.TYPE_CHECKING:
        def __init__(
            self,
            file: Union[Text, BinaryIO],
            write: bool = ...,
            compression: Optional[Text] = ...,
            encoding: Text = ...,
            temp_fs: Text = ...,
        ) -> None: ...

@six.python_2_unicode_compatible
class WriteTarFS(WrapFS):
    def __init__(
        self,
        file: Union[Text, BinaryIO],
        compression: Optional[Text] = ...,
        encoding: Text = ...,
        temp_fs: Union[Text, FS] = ...,
    ) -> None: ...
    def __repr__(self) -> Text: ...
    def __str__(self) -> Text: ...
    def delegate_path(self, path: Text) -> Tuple[FS, Text]: ...
    def delegate_fs(self) -> FS: ...
    def close(self) -> None: ...
    def write_tar(
        self,
        file: Union[Text, BinaryIO, None] = ...,
        compression: Optional[Text] = ...,
        encoding: Optional[Text] = ...,
    ) -> None: ...

@six.python_2_unicode_compatible
class ReadTarFS(FS):
    _meta = ...
    _typemap = ...
    @errors.CreateFailed.catch_all
    def __init__(self, file: Union[Text, BinaryIO], encoding: Text = ...) -> None: ...
    def __repr__(self) -> Text: ...
    def __str__(self) -> Text: ...
    if six.PY2: ...
    else: ...
    def getinfo(
        self, path: Text, namespaces: Optional[Collection[Text]] = ...
    ) -> Info: ...
    def isdir(self, path): ...
    def isfile(self, path): ...
    def setinfo(self, path: Text, info: RawInfo) -> None: ...
    def listdir(self, path: Text) -> List[Text]: ...
    def makedir(
        self: T,
        path: Text,
        permissions: Optional[Permissions] = ...,
        recreate: bool = ...,
    ) -> SubFS[T]: ...
    def openbin(
        self, path: Text, mode: Text = ..., buffering: int = ..., **options: Any
    ) -> BinaryIO: ...
    def remove(self, path: Text) -> None: ...
    def removedir(self, path: Text) -> None: ...
    def close(self) -> None: ...
    def isclosed(self) -> bool: ...
    def geturl(self, path: Text, purpose: Text = ...) -> Text: ...

if __name__ == "__main__": ...
