import abc, collections, csv, email, functools, itertools, operator, os, pathlib, posixpath, re, sys, textwrap, warnings
from contextlib import suppress
from importlib import import_module
from importlib.abc import MetaPathFinder
from itertools import starmap
from typing import Any, List, Mapping, Optional, Union
import zipp
from . import _adapters, _meta
from ._collections import FreezableDefaultDict, Pair
from ._compat import NullFinder, PyPy_repr, install
from ._functools import method_cache
from ._itertools import unique_everseen
from ._meta import PackageMetadata, SimplePath

__all__ = [
    "Distribution",
    "DistributionFinder",
    "PackageMetadata",
    "PackageNotFoundError",
    "distribution",
    "distributions",
    "entry_points",
    "files",
    "metadata",
    "packages_distributions",
    "requires",
    "version",
]

class PackageNotFoundError(ModuleNotFoundError):
    def __str__(self) -> str: ...
    @property
    def name(self): ...

class Sectioned:
    _sample = ...
    @classmethod
    def section_pairs(cls, text): ...
    @staticmethod
    def read(text, filter_=...): ...
    @staticmethod
    def valid(line): ...

class EntryPoint(
    PyPy_repr, collections.namedtuple("EntryPointBase", "name value group")
):
    pattern = ...
    dist: Optional[Distribution] = ...
    def load(self): ...
    @property
    def module(self): ...
    @property
    def attr(self): ...
    @property
    def extras(self): ...
    def __iter__(self): ...
    def __reduce__(self): ...
    def matches(self, **params): ...

class DeprecatedList(list):
    _warn = ...
    def __setitem__(self, *args, **kwargs): ...
    def __delitem__(self, *args, **kwargs): ...
    def append(self, *args, **kwargs): ...
    def reverse(self, *args, **kwargs): ...
    def extend(self, *args, **kwargs): ...
    def pop(self, *args, **kwargs): ...
    def remove(self, *args, **kwargs): ...
    def __iadd__(self, *args, **kwargs): ...
    def __add__(self, other): ...
    def insert(self, *args, **kwargs): ...
    def sort(self, *args, **kwargs): ...
    def __eq__(self, other) -> bool: ...

class EntryPoints(DeprecatedList):
    __slots__ = ...
    def __getitem__(self, name): ...
    def select(self, **params): ...
    @property
    def names(self): ...
    @property
    def groups(self): ...

class Deprecated:
    _warn = ...
    def __getitem__(self, name): ...
    def get(self, name, default=...): ...
    def __iter__(self): ...
    def __contains__(self, *args): ...
    def keys(self): ...
    def values(self): ...

class SelectableGroups(Deprecated, dict):
    @classmethod
    def load(cls, eps): ...
    @property
    def groups(self): ...
    @property
    def names(self): ...
    def select(self, **params): ...

class PackagePath(pathlib.PurePosixPath):
    def read_text(self, encoding=...): ...
    def read_binary(self): ...
    def locate(self): ...

class FileHash:
    def __init__(self, spec) -> None: ...
    def __repr__(self): ...

class Distribution:
    @abc.abstractmethod
    def read_text(self, filename): ...
    @abc.abstractmethod
    def locate_file(self, path): ...
    @classmethod
    def from_name(cls, name): ...
    @classmethod
    def discover(cls, **kwargs): ...
    @staticmethod
    def at(path): ...
    @property
    def metadata(self) -> _meta.PackageMetadata: ...
    @property
    def name(self): ...
    @property
    def version(self): ...
    @property
    def entry_points(self): ...
    @property
    def files(self): ...
    @property
    def requires(self): ...

class DistributionFinder(MetaPathFinder):
    class Context:
        name = ...
        def __init__(self, **kwargs) -> None: ...
        @property
        def path(self): ...

    @abc.abstractmethod
    def find_distributions(self, context=...): ...

class FastPath:
    @functools.lru_cache()
    def __new__(cls, root): ...
    def __init__(self, root) -> None: ...
    def joinpath(self, child): ...
    def children(self): ...
    def zip_children(self): ...
    def search(self, name): ...
    @property
    def mtime(self): ...
    @method_cache
    def lookup(self, mtime): ...

class Lookup:
    def __init__(self, path: FastPath) -> None: ...
    def search(self, prepared): ...

class Prepared:
    normalized = ...
    legacy_normalized = ...
    def __init__(self, name) -> None: ...
    @staticmethod
    def normalize(name): ...
    @staticmethod
    def legacy_normalize(name): ...
    def __bool__(self): ...

@install
class MetadataPathFinder(NullFinder, DistributionFinder):
    def find_distributions(self, context=...): ...
    def invalidate_caches(cls): ...

class PathDistribution(Distribution):
    def __init__(self, path: SimplePath) -> None: ...
    def read_text(self, filename): ...
    def locate_file(self, path): ...

def distribution(distribution_name): ...
def distributions(**kwargs): ...
def metadata(distribution_name) -> _meta.PackageMetadata: ...
def version(distribution_name: str) -> str: ...
def entry_points(**params) -> Union[EntryPoints, SelectableGroups]: ...
def files(distribution_name): ...
def requires(distribution_name): ...
def packages_distributions() -> Mapping[str, List[str]]: ...
