import os
from .pattern import Pattern

NORMALIZE_PATH_SEPS = ...
_registered_patterns = ...

def detailed_match_files(
    patterns: Iterable[Pattern],
    files: Iterable[Text],
    all_matches: Optional[bool] = ...,
) -> Dict[Text, MatchDetail]: ...
def iter_tree_entries(
    root: Text, on_error: Optional[Callable] = ..., follow_links: Optional[bool] = ...
) -> Iterator[TreeEntry]: ...
def iter_tree_files(
    root: Text, on_error: Optional[Callable] = ..., follow_links: Optional[bool] = ...
) -> Iterator[Text]: ...

iter_tree = ...

def lookup_pattern(name: Text) -> Callable[[AnyStr], Pattern]: ...
def match_file(patterns: Iterable[Pattern], file: Text) -> bool: ...
def match_files(patterns: Iterable[Pattern], files: Iterable[Text]) -> Set[Text]: ...
def normalize_file(
    file: Union[Text, PathLike], separators: Optional[Collection[Text]] = ...
) -> Text: ...
def normalize_files(
    files: Iterable[Union[str, PathLike]], separators: Optional[Collection[Text]] = ...
) -> Dict[Text, List[Union[str, PathLike]]]: ...
def register_pattern(
    name: Text,
    pattern_factory: Callable[[AnyStr], Pattern],
    override: Optional[bool] = ...,
) -> None: ...

class AlreadyRegisteredError(Exception):
    def __init__(
        self, name: Text, pattern_factory: Callable[[AnyStr], Pattern]
    ) -> None: ...
    @property
    def message(self) -> Text: ...
    @property
    def name(self) -> Text: ...
    @property
    def pattern_factory(self) -> Callable[[AnyStr], Pattern]: ...

class RecursionError(Exception):
    def __init__(
        self, real_path: Text, first_path: Text, second_path: Text
    ) -> None: ...
    @property
    def first_path(self) -> Text: ...
    @property
    def message(self) -> Text: ...
    @property
    def real_path(self) -> Text: ...
    @property
    def second_path(self) -> Text: ...

class MatchDetail:
    __slots__ = ...
    def __init__(self, patterns: Sequence[Pattern]) -> None: ...

class TreeEntry:
    __slots__ = ...
    def __init__(
        self, name: Text, path: Text, lstat: os.stat_result, stat: os.stat_result
    ) -> None: ...
    def is_dir(self, follow_links: Optional[bool] = ...) -> bool: ...
    def is_file(self, follow_links: Optional[bool] = ...) -> bool: ...
    def is_symlink(self) -> bool: ...
    def stat(self, follow_links: Optional[bool] = ...) -> os.stat_result: ...
