import typing
from starlette.requests import Request
from starlette.responses import Response
from starlette.types import Message, Receive, Scope, Send
from starlette.websockets import WebSocket

class HTTPEndpoint:
    def __init__(self, scope: Scope, receive: Receive, send: Send) -> None: ...
    def __await__(self) -> typing.Generator: ...
    async def dispatch(self) -> None: ...
    async def method_not_allowed(self, request: Request) -> Response: ...

class WebSocketEndpoint:
    encoding: typing.Optional[str] = ...
    def __init__(self, scope: Scope, receive: Receive, send: Send) -> None: ...
    def __await__(self) -> typing.Generator: ...
    async def dispatch(self) -> None: ...
    async def decode(self, websocket: WebSocket, message: Message) -> typing.Any: ...
    async def on_connect(self, websocket: WebSocket) -> None: ...
    async def on_receive(self, websocket: WebSocket, data: typing.Any) -> None: ...
    async def on_disconnect(self, websocket: WebSocket, close_code: int) -> None: ...
