import enum, sys, typing as t

if sys.version_info >= (3, 8):
    Literal = t.Literal
else:
    from typing_extensions import Literal
from starlette.datastructures import FormData, Headers

class FormMessage(enum.Enum):
    FIELD_START: Literal["1"] = ...
    FIELD_NAME: Literal["2"] = ...
    FIELD_DATA: Literal["3"] = ...
    FIELD_END: Literal["4"] = ...
    END: Literal["5"] = ...

class MultiPartMessage(enum.Enum):
    PART_BEGIN: Literal["1"] = ...
    PART_DATA: Literal["2"] = ...
    PART_END: Literal["3"] = ...
    HEADER_FIELD: Literal["4"] = ...
    HEADER_VALUE: Literal["5"] = ...
    HEADER_END: Literal["6"] = ...
    HEADERS_FINISHED: Literal["7"] = ...
    END: Literal["8"] = ...

class FormParser:
    def __init__(
        self, headers: Headers, stream: t.AsyncGenerator[bytes, None]
    ) -> None: ...
    def on_field_start(self) -> None: ...
    def on_field_name(self, data: bytes, start: int, end: int) -> None: ...
    def on_field_data(self, data: bytes, start: int, end: int) -> None: ...
    def on_field_end(self) -> None: ...
    def on_end(self) -> None: ...
    async def parse(self) -> FormData: ...

class MultiPartParser:
    def __init__(
        self, headers: Headers, stream: t.AsyncGenerator[bytes, None]
    ) -> None: ...
    def on_part_begin(self) -> None: ...
    def on_part_data(self, data: bytes, start: int, end: int) -> None: ...
    def on_part_end(self) -> None: ...
    def on_header_field(self, data: bytes, start: int, end: int) -> None: ...
    def on_header_value(self, data: bytes, start: int, end: int) -> None: ...
    def on_header_end(self) -> None: ...
    def on_headers_finished(self) -> None: ...
    def on_end(self) -> None: ...
    async def parse(self) -> FormData: ...
