from .session import Session
from .torrent_info import Torrent_info
from .downloader import Downloader
import libtorrent as lt

class Torrent_downloader():
    def __init__(self, file_path, save_path):
        self._file_path = file_path
        self._save_path = save_path
        self._lt = lt
        self._file = None
        self._add_torrent_params = None
        self._session = Session(self._lt)

    def start_download(self):
        if (self._file_path.startswith('magnet:')):
            self._add_torrent_params = self._lt.parse_magnet_uri(self._file_path)
            self._add_torrent_params.save_path = self._save_path
            self._downloader = Downloader(session = self._session(), torrent_info = self._add_torrent_params, save_path = self._save_path, libtorrent = lt, is_magnet=True)
        else:
            self._torrent_info = Torrent_info(self._file_path, self._lt)
            self._downloader = Downloader(session = self._session(), torrent_info = self._torrent_info(), save_path = self._save_path, libtorrent = None, is_magnet=False)
            
        self._file = self._downloader
        self._file.download()

    def __str__(self):
        pass

    def __repr__(self):
        pass

    def __call__(self):
        pass