"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import ...thirdparty.kfpbackend.pipeline_spec_pb2
import ...thirdparty.kfpbackend.resource_reference_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class CreateJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    JOB_FIELD_NUMBER: builtins.int
    @property
    def job(self) -> global___Job:
        """The job to be created"""
        pass
    def __init__(self,
        *,
        job: typing.Optional[global___Job] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["job",b"job"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["job",b"job"]) -> None: ...
global___CreateJobRequest = CreateJobRequest

class GetJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """The ID of the job to be retrieved"""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___GetJobRequest = GetJobRequest

class ListJobsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    SORT_BY_FIELD_NUMBER: builtins.int
    RESOURCE_REFERENCE_KEY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_token: typing.Text
    """A page token to request the next page of results. The token is acquried
    from the nextPageToken field of the response from the previous
    ListJobs call or can be omitted when fetching the first page.
    """

    page_size: builtins.int
    """The number of jobs to be listed per page. If there are more jobs than this
    number, the response message will contain a nextPageToken field you can use
    to fetch the next page.
    """

    sort_by: typing.Text
    """Can be format of "field_name", "field_name asc" or "field_name desc".
    Ascending by default.
    """

    @property
    def resource_reference_key(self) -> thirdparty.kfpbackend.resource_reference_pb2.ResourceKey:
        """What resource reference to filter on.
        E.g. If listing job for an experiment, the query string would be
        resource_reference_key.type=EXPERIMENT&resource_reference_key.id=123
        """
        pass
    filter: typing.Text
    """A url-encoded, JSON-serialized Filter protocol buffer (see
    [filter.proto](https://github.com/kubeflow/pipelines/blob/master/backend/api/filter.proto)).
    """

    def __init__(self,
        *,
        page_token: typing.Text = ...,
        page_size: builtins.int = ...,
        sort_by: typing.Text = ...,
        resource_reference_key: typing.Optional[thirdparty.kfpbackend.resource_reference_pb2.ResourceKey] = ...,
        filter: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resource_reference_key",b"resource_reference_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter",b"filter","page_size",b"page_size","page_token",b"page_token","resource_reference_key",b"resource_reference_key","sort_by",b"sort_by"]) -> None: ...
global___ListJobsRequest = ListJobsRequest

class ListJobsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    JOBS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def jobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Job]:
        """A list of jobs returned."""
        pass
    total_size: builtins.int
    """The total number of jobs for the given query."""

    next_page_token: typing.Text
    """The token to list the next page of jobs."""

    def __init__(self,
        *,
        jobs: typing.Optional[typing.Iterable[global___Job]] = ...,
        total_size: builtins.int = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["jobs",b"jobs","next_page_token",b"next_page_token","total_size",b"total_size"]) -> None: ...
global___ListJobsResponse = ListJobsResponse

class DeleteJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """The ID of the job to be deleted"""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___DeleteJobRequest = DeleteJobRequest

class EnableJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """The ID of the job to be enabled"""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___EnableJobRequest = EnableJobRequest

class DisableJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """The ID of the job to be disabled"""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___DisableJobRequest = DisableJobRequest

class CronSchedule(google.protobuf.message.Message):
    """CronSchedule allow scheduling the job with unix-like cron"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    CRON_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The start time of the cron job"""
        pass
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The end time of the cron job"""
        pass
    cron: typing.Text
    """The cron string. For details how to compose a cron, visit
    ttps://en.wikipedia.org/wiki/Cron
    """

    def __init__(self,
        *,
        start_time: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        end_time: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        cron: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end_time",b"end_time","start_time",b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cron",b"cron","end_time",b"end_time","start_time",b"start_time"]) -> None: ...
global___CronSchedule = CronSchedule

class PeriodicSchedule(google.protobuf.message.Message):
    """PeriodicSchedule allow scheduling the job periodically with certain interval"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    INTERVAL_SECOND_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The start time of the periodic job"""
        pass
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The end time of the periodic job"""
        pass
    interval_second: builtins.int
    """The time interval between the starting time of consecutive jobs"""

    def __init__(self,
        *,
        start_time: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        end_time: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        interval_second: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end_time",b"end_time","start_time",b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end_time",b"end_time","interval_second",b"interval_second","start_time",b"start_time"]) -> None: ...
global___PeriodicSchedule = PeriodicSchedule

class Trigger(google.protobuf.message.Message):
    """Trigger defines what starts a pipeline run."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CRON_SCHEDULE_FIELD_NUMBER: builtins.int
    PERIODIC_SCHEDULE_FIELD_NUMBER: builtins.int
    @property
    def cron_schedule(self) -> global___CronSchedule: ...
    @property
    def periodic_schedule(self) -> global___PeriodicSchedule: ...
    def __init__(self,
        *,
        cron_schedule: typing.Optional[global___CronSchedule] = ...,
        periodic_schedule: typing.Optional[global___PeriodicSchedule] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cron_schedule",b"cron_schedule","periodic_schedule",b"periodic_schedule","trigger",b"trigger"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cron_schedule",b"cron_schedule","periodic_schedule",b"periodic_schedule","trigger",b"trigger"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["trigger",b"trigger"]) -> typing.Optional[typing_extensions.Literal["cron_schedule","periodic_schedule"]]: ...
global___Trigger = Trigger

class Job(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Mode:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Job._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_MODE: Job._Mode.ValueType  # 0
        ENABLED: Job._Mode.ValueType  # 1
        DISABLED: Job._Mode.ValueType  # 2
        """The job won't schedule any run if disabled."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
        """Required input."""
        pass

    UNKNOWN_MODE: Job.Mode.ValueType  # 0
    ENABLED: Job.Mode.ValueType  # 1
    DISABLED: Job.Mode.ValueType  # 2
    """The job won't schedule any run if disabled."""


    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PIPELINE_SPEC_FIELD_NUMBER: builtins.int
    RESOURCE_REFERENCES_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_FIELD_NUMBER: builtins.int
    MAX_CONCURRENCY_FIELD_NUMBER: builtins.int
    TRIGGER_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    NO_CATCHUP_FIELD_NUMBER: builtins.int
    id: typing.Text
    """Output. Unique run ID. Generated by API server."""

    name: typing.Text
    """Required input field. Job name provided by user. Not unique."""

    description: typing.Text
    """Optional input field. Describing the purpose of the job"""

    @property
    def pipeline_spec(self) -> thirdparty.kfpbackend.pipeline_spec_pb2.PipelineSpec:
        """Required input field.
        Describing what the pipeline manifest and parameters to use
        for the scheduled job.
        """
        pass
    @property
    def resource_references(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[thirdparty.kfpbackend.resource_reference_pb2.ResourceReference]:
        """Optional input field. Specify which resource this job belongs to."""
        pass
    service_account: typing.Text
    """Optional input field. Specify which Kubernetes service account this job uses."""

    max_concurrency: builtins.int
    """Required input field.
    Specify how many runs can be executed concurrently. Rage [1-10]
    """

    @property
    def trigger(self) -> global___Trigger:
        """Required input field.
        Specify how a run is triggered. Support cron mode or periodic mode.
        """
        pass
    mode: global___Job.Mode.ValueType
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output. The time this job is created."""
        pass
    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output. The last time this job is updated."""
        pass
    status: typing.Text
    """Output. The status of the job.
    One of [Enable, Disable, Error]
    """

    error: typing.Text
    """In case any error happens retrieving a job field, only job ID
    and the error message is returned. Client has the flexibility of choosing
    how to handle error. This is especially useful during listing call.
    """

    enabled: builtins.bool
    """Input. Whether the job is enabled or not."""

    no_catchup: builtins.bool
    """Optional input field. Whether the job should catch up if behind schedule.
    If true, the job will only schedule the latest interval if behind schedule.
    If false, the job will catch up on each past interval.
    """

    def __init__(self,
        *,
        id: typing.Text = ...,
        name: typing.Text = ...,
        description: typing.Text = ...,
        pipeline_spec: typing.Optional[thirdparty.kfpbackend.pipeline_spec_pb2.PipelineSpec] = ...,
        resource_references: typing.Optional[typing.Iterable[thirdparty.kfpbackend.resource_reference_pb2.ResourceReference]] = ...,
        service_account: typing.Text = ...,
        max_concurrency: builtins.int = ...,
        trigger: typing.Optional[global___Trigger] = ...,
        mode: global___Job.Mode.ValueType = ...,
        created_at: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        updated_at: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        status: typing.Text = ...,
        error: typing.Text = ...,
        enabled: builtins.bool = ...,
        no_catchup: builtins.bool = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at",b"created_at","pipeline_spec",b"pipeline_spec","trigger",b"trigger","updated_at",b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at",b"created_at","description",b"description","enabled",b"enabled","error",b"error","id",b"id","max_concurrency",b"max_concurrency","mode",b"mode","name",b"name","no_catchup",b"no_catchup","pipeline_spec",b"pipeline_spec","resource_references",b"resource_references","service_account",b"service_account","status",b"status","trigger",b"trigger","updated_at",b"updated_at"]) -> None: ...
global___Job = Job
