"""String literals for common settings

It is highly recommended that developers use and update the constants in this file, which can
be used when accessing common dictionary entries. This improves readability.

"""

# value types for error propagation
DERIVATIVE = "derivative"
MONTE_CARLO = "monte-carlo"
MC_MEAN_AND_STD = "monte-carlo-mean-and-std"
MC_MODE_AND_CONFIDENCE = "monte-carlo-mode_and_confidence"
MC_CUSTOM = "monte-carlo-custom"
MONTE_CARLO_STRATEGY = "mc-strategy"
MONTE_CARLO_CONFIDENCE = "confidence"

# data fields
COVARIANCE = "covariance"
CORRELATION = "correlation"
VALUES = "values"

# settings
ERROR_METHOD = "error_method"
PRINT_STYLE = "print_style"
UNIT_STYLE = "unit_style"
SIG_FIGS = "significant_figures"
SIG_FIG_MODE = "mode"
SIG_FIG_VALUE = "value"
MONTE_CARLO_SAMPLE_SIZE = "monte_carlo_sample_size"

LATEX = "latex"
SCIENTIFIC = "scientific"
FRACTION = "fraction"
EXPONENTS = "exponents"
SET_TO_VALUE = "set_to_value"
SET_TO_ERROR = "set_to_error"

# operators
OPERATOR = "operator"
OPERANDS = "operands"
NEG = "neg"
ADD = "add"
SUB = "sub"
MUL = "mul"
DIV = "div"
SQRT = "sqrt"
SIN = "sin"
COS = "cos"
TAN = "tan"
SEC = "sec"
CSC = "csc"
COT = "cot"
POW = "pow"
EXP = "exp"
LOG = "log"
LOG10 = "log10"
LN = "ln"
ASIN = "asin"
ACOS = "acos"
ATAN = "atan"

# fitting
LIN = "linear"
QUAD = "quadratic"
POLY = "polynomial"
GAUSS = "gaussian"
EXPO = "exponential"

# plotting
TITLE = "title"
XNAME = "xname"
YNAME = "yname"
XUNIT = "xunit"
YUNIT = "yunit"
XRANGE = "xrange"

LEGEND = "legend"
ERROR_BAR = "error_bar"
RESIDUALS = "residuals"
PLOT_STYLE = "plot_style"
PLOT_DIMENSIONS = "plot_dimensions"

# miscellaneous
DEFAULT = "default"
AUTO = "auto"
