"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCloudFrontDisributionForMediaStoreProps = exports.DefaultCloudFrontWebDistributionForS3Props = exports.DefaultCloudFrontWebDistributionForApiGatewayProps = void 0;
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
const cdk = require("aws-cdk-lib");
function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint, loggingBucket, setHttpSecurityHeaders, cfFunction) {
    const apiEndPointUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split("://", apiEndPoint.url));
    const apiEndPointDomainName = cdk.Fn.select(0, cdk.Fn.split("/", apiEndPointUrlWithoutProtocol));
    return {
        defaultBehavior: {
            origin: new origins.HttpOrigin(apiEndPointDomainName, {
                originPath: `/${apiEndPoint.deploymentStage.stageName}`
            }),
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction),
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS
        },
        enableLogging: true,
        logBucket: loggingBucket,
    };
}
exports.DefaultCloudFrontWebDistributionForApiGatewayProps = DefaultCloudFrontWebDistributionForApiGatewayProps;
function DefaultCloudFrontWebDistributionForS3Props(sourceBucket, loggingBucket, setHttpSecurityHeaders, cfFunction) {
    return {
        defaultBehavior: {
            origin: new origins.S3Origin(sourceBucket),
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket,
        defaultRootObject: 'index.html'
    };
}
exports.DefaultCloudFrontWebDistributionForS3Props = DefaultCloudFrontWebDistributionForS3Props;
function DefaultCloudFrontDisributionForMediaStoreProps(mediastoreContainer, loggingBucket, originRequestPolicy, setHttpSecurityHeaders, customHeaders, cfFunction) {
    const mediaStoreContainerUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split('://', mediastoreContainer.attrEndpoint));
    const mediaStoreContainerDomainName = cdk.Fn.select(0, cdk.Fn.split('/', mediaStoreContainerUrlWithoutProtocol));
    const httpOrigin = customHeaders ?
        new origins.HttpOrigin(mediaStoreContainerDomainName, { customHeaders }) :
        new origins.HttpOrigin(mediaStoreContainerDomainName);
    return {
        defaultBehavior: {
            origin: httpOrigin,
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            allowedMethods: cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
            cachedMethods: cloudfront.CachedMethods.CACHE_GET_HEAD_OPTIONS,
            originRequestPolicy,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket
    };
}
exports.DefaultCloudFrontDisributionForMediaStoreProps = DefaultCloudFrontDisributionForMediaStoreProps;
function getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction) {
    return (setHttpSecurityHeaders && cfFunction) ? {
        functionAssociations: [
            {
                eventType: aws_cloudfront_1.FunctionEventType.VIEWER_RESPONSE,
                function: cfFunction
            }
        ]
    } : {};
}
//# sourceMappingURL=data:application/json;base64,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