"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPartitionKeyNameFromTable = exports.buildDynamoDBTableWithStream = exports.buildDynamoDBTable = void 0;
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const dynamodb_table_defaults_1 = require("./dynamodb-table-defaults");
const utils_1 = require("./utils");
function buildDynamoDBTable(scope, props) {
    // Conditional DynamoDB Table creation
    if (!props.existingTableObj) {
        // Set the default props for DynamoDB table
        if (props.dynamoTableProps) {
            const dynamoTableProps = utils_1.overrideProps(dynamodb_table_defaults_1.DefaultTableProps, props.dynamoTableProps);
            return new dynamodb.Table(scope, 'DynamoTable', dynamoTableProps);
        }
        else {
            return new dynamodb.Table(scope, 'DynamoTable', dynamodb_table_defaults_1.DefaultTableProps);
        }
    }
    else {
        return props.existingTableObj;
    }
}
exports.buildDynamoDBTable = buildDynamoDBTable;
function buildDynamoDBTableWithStream(scope, props) {
    // Conditional DynamoDB Table creation
    if (!props.existingTableInterface) {
        // Set the default props for DynamoDB table
        if (props.dynamoTableProps) {
            const dynamoTableProps = utils_1.overrideProps(dynamodb_table_defaults_1.DefaultTableWithStreamProps, props.dynamoTableProps);
            const dynamoTable = new dynamodb.Table(scope, 'DynamoTable', dynamoTableProps);
            return [dynamoTable, dynamoTable];
        }
        else {
            const dynamoTable = new dynamodb.Table(scope, 'DynamoTable', dynamodb_table_defaults_1.DefaultTableWithStreamProps);
            return [dynamoTable, dynamoTable];
        }
    }
    else {
        return [props.existingTableInterface, undefined];
    }
}
exports.buildDynamoDBTableWithStream = buildDynamoDBTableWithStream;
function getPartitionKeyNameFromTable(table) {
    const cfnTable = table.node.findChild('Resource');
    const keySchema = cfnTable.keySchema;
    const partitionKey = keySchema.find((keyPart) => keyPart.keyType === 'HASH');
    if (!partitionKey) {
        throw new Error('Partition key for table not defined');
    }
    return partitionKey.attributeName;
}
exports.getPartitionKeyNameFromTable = getPartitionKeyNameFromTable;
//# sourceMappingURL=data:application/json;base64,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