"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCfnDomainProps = void 0;
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
function DefaultCfnDomainProps(domainName, cognitoKibanaConfigureRole, options) {
    const roleARNs = [];
    roleARNs.push(new iam.ArnPrincipal(options.cognitoAuthorizedRoleARN));
    if (options.serviceRoleARN) {
        roleARNs.push(new iam.ArnPrincipal(options.serviceRoleARN));
    }
    return {
        domainName,
        elasticsearchVersion: '6.3',
        encryptionAtRestOptions: {
            enabled: true
        },
        nodeToNodeEncryptionOptions: {
            enabled: true
        },
        elasticsearchClusterConfig: {
            dedicatedMasterEnabled: true,
            dedicatedMasterCount: 3,
            instanceCount: 3,
            zoneAwarenessEnabled: true,
            zoneAwarenessConfig: {
                availabilityZoneCount: 3
            }
        },
        snapshotOptions: {
            automatedSnapshotStartHour: 1
        },
        ebsOptions: {
            ebsEnabled: true,
            volumeSize: 10
        },
        cognitoOptions: {
            enabled: true,
            identityPoolId: options.identitypool.ref,
            userPoolId: options.userpool.userPoolId,
            roleArn: cognitoKibanaConfigureRole.roleArn
        },
        accessPolicies: new iam.PolicyDocument({
            statements: [
                new iam.PolicyStatement({
                    principals: roleARNs,
                    actions: [
                        'es:ESHttp*'
                    ],
                    resources: [
                        `arn:aws:es:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:domain/${domainName}/*`
                    ]
                })
            ]
        })
    };
}
exports.DefaultCfnDomainProps = DefaultCfnDomainProps;
//# sourceMappingURL=data:application/json;base64,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