"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildEventBus = void 0;
const events = require("aws-cdk-lib/aws-events");
function buildEventBus(scope, props) {
    // Check whether existing EventBus is provided
    if (props.existingEventBusInterface) {
        return props.existingEventBusInterface;
    }
    else if (props.eventBusProps) {
        // eventBusProps is provided, create a new EventBus
        const _eventBusName = props.eventBusProps.eventBusName || 'CustomEventBus';
        return new events.EventBus(scope, _eventBusName, props.eventBusProps);
    }
    return;
}
exports.buildEventBus = buildEventBus;
//# sourceMappingURL=data:application/json;base64,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