"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueDatabaseProps = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Default database props
 */
function DefaultGlueDatabaseProps() {
    const _databaseProps = {
        catalogId: aws_cdk_lib_1.Aws.ACCOUNT_ID,
        databaseInput: {
            description: 'An AWS Glue database generated by AWS Solutions Construct'
        }
    };
    return _databaseProps;
}
exports.DefaultGlueDatabaseProps = DefaultGlueDatabaseProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2x1ZS1kYXRhYmFzZS1kZWZhdWx0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImdsdWUtZGF0YWJhc2UtZGVmYXVsdHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOzs7QUFHSCw2Q0FBa0M7QUFFbEM7O0dBRUc7QUFDSCxTQUFnQix3QkFBd0I7SUFDdEMsTUFBTSxjQUFjLEdBQXFCO1FBQ3ZDLFNBQVMsRUFBRSxpQkFBRyxDQUFDLFVBQVU7UUFDekIsYUFBYSxFQUFFO1lBQ2IsV0FBVyxFQUFFLDJEQUEyRDtTQUN6RTtLQUNGLENBQUM7SUFFRixPQUFPLGNBQWMsQ0FBQztBQUN4QixDQUFDO0FBVEQsNERBU0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCB7IENmbkRhdGFiYXNlUHJvcHMgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWdsdWVcIjtcbmltcG9ydCB7IEF3cyB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4vKipcbiAqIERlZmF1bHQgZGF0YWJhc2UgcHJvcHNcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIERlZmF1bHRHbHVlRGF0YWJhc2VQcm9wcygpOiBDZm5EYXRhYmFzZVByb3BzIHtcbiAgY29uc3QgX2RhdGFiYXNlUHJvcHM6IENmbkRhdGFiYXNlUHJvcHMgPSB7XG4gICAgY2F0YWxvZ0lkOiBBd3MuQUNDT1VOVF9JRCxcbiAgICBkYXRhYmFzZUlucHV0OiB7XG4gICAgICBkZXNjcmlwdGlvbjogJ0FuIEFXUyBHbHVlIGRhdGFiYXNlIGdlbmVyYXRlZCBieSBBV1MgU29sdXRpb25zIENvbnN0cnVjdCdcbiAgICB9XG4gIH07XG5cbiAgcmV0dXJuIF9kYXRhYmFzZVByb3BzO1xufSJdfQ==