"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueDatabase = void 0;
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * Create an AWS Glue database with the properties provided
 *
 * @param scope
 * @param databaseProps
 */
function DefaultGlueDatabase(scope, databaseProps) {
    return new aws_glue_1.CfnDatabase(scope, 'GlueDatabase', databaseProps);
}
exports.DefaultGlueDatabase = DefaultGlueDatabase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2x1ZS1kYXRhYmFzZS1oZWxwZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJnbHVlLWRhdGFiYXNlLWhlbHBlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7OztBQUVILG1EQUFxRTtBQUlyRTs7Ozs7R0FLRztBQUNILFNBQWdCLG1CQUFtQixDQUFDLEtBQWdCLEVBQUUsYUFBK0I7SUFDbkYsT0FBTyxJQUFJLHNCQUFXLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRSxhQUFhLENBQUMsQ0FBQztBQUMvRCxDQUFDO0FBRkQsa0RBRUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAyMSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCB7IENmbkRhdGFiYXNlLCBDZm5EYXRhYmFzZVByb3BzIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1nbHVlXCI7XG5pbXBvcnQgeyAgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIENyZWF0ZSBhbiBBV1MgR2x1ZSBkYXRhYmFzZSB3aXRoIHRoZSBwcm9wZXJ0aWVzIHByb3ZpZGVkXG4gKlxuICogQHBhcmFtIHNjb3BlXG4gKiBAcGFyYW0gZGF0YWJhc2VQcm9wc1xuICovXG5leHBvcnQgZnVuY3Rpb24gRGVmYXVsdEdsdWVEYXRhYmFzZShzY29wZTogQ29uc3RydWN0LCBkYXRhYmFzZVByb3BzOiBDZm5EYXRhYmFzZVByb3BzKTogQ2ZuRGF0YWJhc2Uge1xuICByZXR1cm4gbmV3IENmbkRhdGFiYXNlKHNjb3BlLCAnR2x1ZURhdGFiYXNlJywgZGF0YWJhc2VQcm9wcyk7XG59Il19