"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueJobProps = void 0;
function DefaultGlueJobProps(jobRole, userProvidedGlueJobProps, glueSecurityConfigName, defaultArguments) {
    const glueVersion = userProvidedGlueJobProps.glueVersion;
    // setting default to 2 to reduce cost
    const maxCapacity = glueVersion === "1.0" && !(userProvidedGlueJobProps.workerType
        || userProvidedGlueJobProps.numberOfWorkers) ? 2 : undefined;
    const defaultGlueJobProps = {
        command: userProvidedGlueJobProps.command,
        role: jobRole.roleArn,
        securityConfiguration: glueSecurityConfigName,
        defaultArguments,
        maxCapacity,
        numberOfWorkers: (!glueVersion || glueVersion === "2.0") ? 2 : undefined,
        workerType: (!glueVersion || glueVersion === "2.0") ? 'G.1X' : undefined,
        // glue version though optional is required for streaming etl jobs otherwise it throws an error that 'command not found'
        glueVersion: glueVersion ? glueVersion : '2.0'
    };
    return defaultGlueJobProps;
}
exports.DefaultGlueJobProps = DefaultGlueJobProps;
//# sourceMappingURL=data:application/json;base64,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