"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueTableProps = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
function DefaultGlueTableProps(database, fieldSchema, sourceType, parameters) {
    let _tableProps;
    if (sourceType === 'kinesis') {
        const kinesisStreamName = parameters.STREAM_NAME;
        const _paths = fieldSchema.map((item) => {
            return item.name;
        }).join(',');
        _tableProps = {
            catalogId: database.catalogId,
            databaseName: database.ref,
            tableInput: {
                storageDescriptor: {
                    columns: fieldSchema,
                    location: kinesisStreamName,
                    inputFormat: "org.apache.hadoop.mapred.TextInputFormat",
                    outputFormat: "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat",
                    compressed: false,
                    numberOfBuckets: -1,
                    serdeInfo: {
                        serializationLibrary: "org.openx.data.jsonserde.JsonSerDe",
                        parameters: {
                            paths: _paths
                        }
                    },
                    parameters: {
                        endpointUrl: `https://kinesis.${aws_cdk_lib_1.Aws.REGION}.amazonaws.com`,
                        streamName: kinesisStreamName,
                        typeOfData: sourceType
                    }
                },
                tableType: 'EXTERNAL_TABLE',
                parameters: {
                    classification: 'json'
                }
            }
        };
        return _tableProps;
    }
    else {
        throw Error('Source Type not Supported. Valid Source Type not provided');
    }
}
exports.DefaultGlueTableProps = DefaultGlueTableProps;
//# sourceMappingURL=data:application/json;base64,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