"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueTable = void 0;
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * Method to build the default table props
 *
 * @param scope
 * @param database
 * @param fieldSchema
 * @param sourceType
 * @param parameters - Key value pairs of parameters. If source type is 'Kinesis', pass Kinesis Data Stream name with key
 *  as 'STREAM_NAME'. Example: {STREAM_NAME: 'KinesisStreamConstrct.streamName'}
 */
function DefaultGlueTable(scope, tableProps) {
    return new aws_glue_1.CfnTable(scope, 'GlueTable', tableProps);
}
exports.DefaultGlueTable = DefaultGlueTable;
//# sourceMappingURL=data:application/json;base64,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