/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
import * as kinesis from 'aws-cdk-lib/aws-kinesis';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as sqs from 'aws-cdk-lib/aws-sqs';
import * as mediastore from 'aws-cdk-lib/aws-mediastore';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as elb from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import * as sns from 'aws-cdk-lib/aws-sns';
import * as glue from 'aws-cdk-lib/aws-glue';
import * as sagemaker from 'aws-cdk-lib/aws-sagemaker';
import * as secretsmanager from "aws-cdk-lib/aws-secretsmanager";
import * as kms from "aws-cdk-lib/aws-kms";
export interface VerifiedProps {
    readonly dynamoTableProps?: dynamodb.TableProps;
    readonly existingTableObj?: dynamodb.Table;
    readonly existingTableInterface?: dynamodb.ITable;
    readonly existingStreamObj?: kinesis.Stream;
    readonly kinesisStreamProps?: kinesis.StreamProps;
    readonly existingLambdaObj?: lambda.Function;
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    readonly existingQueueObj?: sqs.Queue;
    readonly queueProps?: sqs.QueueProps;
    readonly deployDeadLetterQueue?: boolean;
    readonly deadLetterQueueProps?: sqs.QueueProps;
    readonly existingMediaStoreContainerObj?: mediastore.CfnContainer;
    readonly mediaStoreContainerProps?: mediastore.CfnContainerProps;
    readonly existingBucketObj?: s3.Bucket;
    readonly existingBucketInterface?: s3.IBucket;
    readonly bucketProps?: s3.BucketProps;
    readonly topicProps?: sns.TopicProps;
    readonly existingTopicObj?: sns.Topic;
    readonly glueJobProps?: glue.CfnJobProps;
    readonly existingGlueJob?: glue.CfnJob;
    readonly existingSagemakerEndpointObj?: sagemaker.CfnEndpoint;
    readonly endpointProps?: sagemaker.CfnEndpointProps;
    readonly existingSecretObj?: secretsmanager.Secret;
    readonly secretProps?: secretsmanager.SecretProps;
    readonly existingVpc?: ec2.IVpc;
    readonly vpcProps?: ec2.VpcProps;
    readonly deployVpc?: boolean;
    readonly encryptionKey?: kms.Key;
    readonly encryptionKeyProps?: kms.KeyProps;
    readonly loadBalancerProps?: elb.ApplicationLoadBalancerProps;
    readonly existingLoadBalancerObj?: elb.ApplicationLoadBalancer;
    readonly logAlbAccessLogs?: boolean;
    readonly albLoggingBucketProps?: s3.BucketProps;
}
export declare function CheckProps(propsObject: VerifiedProps | any): void;
