"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisAnalyticsApp = void 0;
// Imports
const kinesisAnalytics = require("aws-cdk-lib/aws-kinesisanalytics");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("./kinesis-analytics-defaults");
const utils_1 = require("./utils");
function buildKinesisAnalyticsApp(scope, props) {
    // Setup the IAM role for Kinesis Analytics
    const analyticsRole = new iam.Role(scope, 'KinesisAnalyticsRole', {
        assumedBy: new iam.ServicePrincipal('kinesisanalytics.amazonaws.com'),
    });
    // Setup the IAM policy for Kinesis Analytics
    const analyticsPolicy = new iam.Policy(scope, 'KinesisAnalyticsPolicy', {
        statements: [
            new iam.PolicyStatement({
                actions: [
                    'firehose:DescribeDeliveryStream',
                    'firehose:Get*'
                ],
                resources: [props.kinesisFirehose.attrArn]
            })
        ]
    });
    // Attach policy to role
    analyticsPolicy.attachToRole(analyticsRole);
    // Setup the Kinesis application properties
    const kinesisAnalyticsProps = utils_1.overrideProps(defaults.DefaultCfnApplicationProps, props.kinesisAnalyticsProps);
    kinesisAnalyticsProps.inputs[0].kinesisFirehoseInput = {
        resourceArn: props.kinesisFirehose.attrArn,
        roleArn: analyticsRole.roleArn
    };
    // Setup the Kinesis application and add dependencies
    const kinesisAnalyticsApp = new kinesisAnalytics.CfnApplication(scope, 'KinesisAnalytics', kinesisAnalyticsProps);
    kinesisAnalyticsApp.addDependsOn(analyticsPolicy.node.findChild('Resource'));
    // Create the application and return
    return kinesisAnalyticsApp;
}
exports.buildKinesisAnalyticsApp = buildKinesisAnalyticsApp;
//# sourceMappingURL=data:application/json;base64,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