"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const utils_1 = require("./utils");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const s3 = require("aws-cdk-lib/aws-s3");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const sqs_helper_1 = require("./sqs-helper");
function DynamoEventSourceProps(scope, _dynamoEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_dynamoEventSourceProps === undefined || (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.deploySqsDlqQueue) === undefined
        || _dynamoEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultDynamoEventSourceProps = Object.assign(baseProps, extraProps);
    if (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.eventSourceProps) {
        return utils_1.overrideProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps.eventSourceProps);
    }
    else {
        return defaultDynamoEventSourceProps;
    }
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    if (_s3EventSourceProps) {
        return utils_1.overrideProps(defaultS3EventSourceProps, _s3EventSourceProps, false);
    }
    else {
        return defaultS3EventSourceProps;
    }
}
exports.S3EventSourceProps = S3EventSourceProps;
function KinesisEventSourceProps(scope, _kinesisEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: aws_cdk_lib_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_kinesisEventSourceProps === undefined || (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.deploySqsDlqQueue) === undefined
        || _kinesisEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultKinesisEventSourceProps = Object.assign(baseProps, extraProps);
    if (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.eventSourceProps) {
        return utils_1.overrideProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps.eventSourceProps);
    }
    else {
        return defaultKinesisEventSourceProps;
    }
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,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