"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainerProps = void 0;
const cdk = require("aws-cdk-lib");
function MediaStoreContainerProps() {
    return {
        containerName: cdk.Aws.STACK_NAME,
        accessLoggingEnabled: true,
        corsPolicy: [{
                allowedHeaders: ['*'],
                allowedMethods: ['GET'],
                allowedOrigins: ['*'],
                exposeHeaders: ['*'],
                maxAgeSeconds: 3000
            }],
        policy: JSON.stringify({
            Version: '2012-10-17',
            Statement: [{
                    Sid: 'MediaStoreDefaultPolicy',
                    Effect: 'Allow',
                    Principal: '*',
                    Action: [
                        'mediastore:GetObject',
                        'mediastore:DescribeObject'
                    ],
                    Resource: `arn:${cdk.Aws.PARTITION}:mediastore:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:container/${cdk.Aws.STACK_NAME}/*`,
                    Condition: {
                        Bool: {
                            'aws:SecureTransport': 'true'
                        }
                    }
                }]
        }),
        lifecyclePolicy: JSON.stringify({
            rules: [{
                    definition: {
                        path: [
                            { wildcard: '*' }
                        ],
                        days_since_create: [
                            { numeric: ['>', 30] }
                        ]
                    },
                    action: 'EXPIRE'
                }]
        }),
        metricPolicy: {
            containerLevelMetrics: 'ENABLED'
        }
    };
}
exports.MediaStoreContainerProps = MediaStoreContainerProps;
//# sourceMappingURL=data:application/json;base64,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