"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainer = void 0;
const cdk = require("aws-cdk-lib");
const mediastore = require("aws-cdk-lib/aws-mediastore");
const mediastore_defaults_1 = require("./mediastore-defaults");
const utils_1 = require("./utils");
function MediaStoreContainer(scope, mediaStoreContainerProps) {
    const defaultprops = mediastore_defaults_1.MediaStoreContainerProps();
    let mediaStoreProps;
    if (mediaStoreContainerProps) {
        mediaStoreProps = utils_1.overrideProps(defaultprops, mediaStoreContainerProps);
    }
    else {
        mediaStoreProps = defaultprops;
    }
    // Create the MediaStore Container
    const mediaStoreContainer = new mediastore.CfnContainer(scope, 'MediaStoreContainer', mediaStoreProps);
    // Add deletion policy to retain because it will fail to delete if the container is not empty.
    mediaStoreContainer.cfnOptions.deletionPolicy = cdk.CfnDeletionPolicy.RETAIN;
    return mediaStoreContainer;
}
exports.MediaStoreContainer = MediaStoreContainer;
//# sourceMappingURL=data:application/json;base64,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